/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.util;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.rm.BaseDataSourceResource;
import io.seata.rm.DefaultResourceManager;
import io.seata.sqlparser.util.DbTypeParser;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public final class JdbcUtils {
    private static volatile DbTypeParser dbTypeParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DbTypeParser getDbTypeParser() {
        if (dbTypeParser != null) return dbTypeParser;
        Class<JdbcUtils> clazz = JdbcUtils.class;
        synchronized (JdbcUtils.class) {
            if (dbTypeParser != null) return dbTypeParser;
            dbTypeParser = EnhancedServiceLoader.load(DbTypeParser.class, "druid");
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbTypeParser;
        }
    }

    private JdbcUtils() {
    }

    public static String getDbType(String jdbcUrl) {
        return JdbcUtils.getDbTypeParser().parseFromJdbcUrl(jdbcUrl).toLowerCase();
    }

    public static void initDataSourceResource(BaseDataSourceResource dataSourceResource, DataSource dataSource, String resourceGroupId) {
        dataSourceResource.setResourceGroupId(resourceGroupId);
        try (Connection connection = dataSource.getConnection();){
            String jdbcUrl = connection.getMetaData().getURL();
            dataSourceResource.setResourceId(JdbcUtils.buildResourceId(jdbcUrl));
            String driverClassName = com.alibaba.druid.util.JdbcUtils.getDriverClassName((String)jdbcUrl);
            dataSourceResource.setDriver(JdbcUtils.loadDriver(driverClassName));
            dataSourceResource.setDbType(com.alibaba.druid.util.JdbcUtils.getDbType((String)jdbcUrl, (String)driverClassName));
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init DataSourceResource with " + dataSource, e);
        }
        DefaultResourceManager.get().registerResource(dataSourceResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initXADataSourceResource(BaseDataSourceResource dataSourceResource, XADataSource dataSource, String resourceGroupId) {
        dataSourceResource.setResourceGroupId(resourceGroupId);
        try (XAConnection xaConnection = dataSource.getXAConnection();
             Connection connection = xaConnection.getConnection();){
            String jdbcUrl = connection.getMetaData().getURL();
            dataSourceResource.setResourceId(JdbcUtils.buildResourceId(jdbcUrl));
            String driverClassName = com.alibaba.druid.util.JdbcUtils.getDriverClassName((String)jdbcUrl);
            dataSourceResource.setDriver(JdbcUtils.loadDriver(driverClassName));
            dataSourceResource.setDbType(com.alibaba.druid.util.JdbcUtils.getDbType((String)jdbcUrl, (String)driverClassName));
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not get XAConnection from DataSourceResource with " + dataSource, e);
        }
        DefaultResourceManager.get().registerResource(dataSourceResource);
    }

    public static String buildResourceId(String jdbcUrl) {
        if (jdbcUrl.contains("?")) {
            return jdbcUrl.substring(0, jdbcUrl.indexOf(63));
        }
        return jdbcUrl;
    }

    public static Driver loadDriver(String driverClassName) throws SQLException {
        Class<?> clazz = null;
        try {
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (contextLoader != null) {
                clazz = contextLoader.loadClass(driverClassName);
            }
        }
        catch (ClassNotFoundException contextLoader) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
        try {
            return (Driver)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }
}

