/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static void init() {
        MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        MAPPER.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        MAPPER.registerModule((Module)new JavaTimeModule().addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(formatter)).addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(formatter)));
        MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        MAPPER.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        MAPPER.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        MAPPER.disableDefaultTyping();
        MAPPER.enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER});
        MAPPER.enable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
        MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
    }

    public static ObjectMapper getJson() {
        return MAPPER;
    }

    static {
        JsonUtil.init();
    }
}

