/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db.sql.log;

import io.seata.common.loader.LoadLevel;
import io.seata.core.store.db.sql.log.AbstractLogStoreSqls;

@LoadLevel(name="mysql")
public class MysqlLogStoreSqls
extends AbstractLogStoreSqls {
    public static final String INSERT_GLOBAL_TRANSACTION_MYSQL = "insert into  #global_table# (xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_GLOBAL_TRANSACTION_STATUS_MYSQL = "update  #global_table#    set status = ?,       gmt_modified = ?  where xid = ?";
    public static final String QUERY_GLOBAL_TRANSACTION_BY_STATUS_MYSQL = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified  from  #global_table#  where status in ( #PRAMETER_PLACEHOLD# ) order by gmt_modified limit ?";
    public static final String QUERY_GLOBAL_TRANSACTION_FOR_RECOVERY_MYSQL = "select xid, transaction_id, status, application_id, transaction_service_group, transaction_name, timeout, begin_time, application_data, gmt_create, gmt_modified  from  #global_table#  where status in (0, 2, 3, 4, 5, 6, 7, 8, 10 ,12, 14) order by gmt_modified limit ?";
    public static final String INSERT_BRANCH_TRANSACTION_MYSQL = "insert into  #branch_table# (xid, transaction_id, branch_id, resource_group_id, resource_id, branch_type, status, client_id, application_data, gmt_create, gmt_modified) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    public static final String UPDATE_BRANCH_TRANSACTION_STATUS_MYSQL = "update  #branch_table#    set status = ?,       gmt_modified = ?  where xid = ?   and branch_id = ?";
    public static final String UPDATE_BRANCH_STATUS_APPLICATION_DATA_MYSQL = "update  #branch_table#    set status = ?,       application_data = ?,       gmt_modified = ? where xid = ?   and branch_id = ?";

    @Override
    public String getInsertGlobalTransactionSQL(String globalTable) {
        return INSERT_GLOBAL_TRANSACTION_MYSQL.replace(" #global_table# ", globalTable);
    }

    @Override
    public String getUpdateGlobalTransactionStatusSQL(String globalTable) {
        return UPDATE_GLOBAL_TRANSACTION_STATUS_MYSQL.replace(" #global_table# ", globalTable);
    }

    @Override
    public String getQueryGlobalTransactionSQLByStatus(String globalTable, String paramsPlaceHolder) {
        return QUERY_GLOBAL_TRANSACTION_BY_STATUS_MYSQL.replace(" #global_table# ", globalTable).replace(" #PRAMETER_PLACEHOLD# ", paramsPlaceHolder);
    }

    @Override
    public String getQueryGlobalTransactionForRecoverySQL(String globalTable) {
        return QUERY_GLOBAL_TRANSACTION_FOR_RECOVERY_MYSQL.replace(" #global_table# ", globalTable);
    }

    @Override
    public String getInsertBranchTransactionSQL(String branchTable) {
        return INSERT_BRANCH_TRANSACTION_MYSQL.replace(" #branch_table# ", branchTable);
    }

    @Override
    public String getUpdateBranchTransactionStatusSQL(String branchTable) {
        return UPDATE_BRANCH_TRANSACTION_STATUS_MYSQL.replace(" #branch_table# ", branchTable);
    }

    @Override
    public String getUpdateBranchTransactionStatusAppDataSQL(String branchTable) {
        return UPDATE_BRANCH_STATUS_APPLICATION_DATA_MYSQL.replace(" #branch_table# ", branchTable);
    }
}

