/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import com.esotericsoftware.kryo.Serializer;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.EnhancedServiceNotFoundException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.undo.BranchUndoLog;
import io.seata.rm.datasource.undo.UndoLogParser;
import io.seata.rm.datasource.undo.parser.KryoSerializer;
import io.seata.rm.datasource.undo.parser.KryoSerializerFactory;
import io.seata.rm.datasource.undo.parser.spi.KryoTypeSerializer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="kryo")
public class KryoUndoLogParser
implements UndoLogParser,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(KryoUndoLogParser.class);
    public static final String NAME = "kryo";

    @Override
    public void init() {
        try {
            List<KryoTypeSerializer> serializers = EnhancedServiceLoader.loadAll(KryoTypeSerializer.class);
            if (CollectionUtils.isNotEmpty(serializers)) {
                for (KryoTypeSerializer typeSerializer : serializers) {
                    if (typeSerializer == null) continue;
                    Class type = typeSerializer.type();
                    Serializer ser = typeSerializer.serializer();
                    if (type == null) continue;
                    KryoSerializerFactory.getInstance().registerSerializer(type, ser);
                    LOGGER.info("kryo undo log parser load [{}].", (Object)typeSerializer.getClass().getName());
                }
            }
        }
        catch (EnhancedServiceNotFoundException e) {
            LOGGER.warn("KryoTypeSerializer not found children class.", (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        KryoSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            byte[] byArray = kryoSerializer.serialize(new BranchUndoLog());
            return byArray;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        KryoSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            byte[] byArray = kryoSerializer.serialize(branchUndoLog);
            return byArray;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BranchUndoLog decode(byte[] bytes) {
        KryoSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            BranchUndoLog branchUndoLog = (BranchUndoLog)kryoSerializer.deserialize(bytes);
            return branchUndoLog;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }
}

