/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol;

import io.seata.common.util.NetUtil;
import io.seata.core.protocol.AbstractIdentifyRequest;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class RegisterTMRequest
extends AbstractIdentifyRequest
implements Serializable {
    private static final long serialVersionUID = -5929081344190543690L;
    public static final String UDATA_VGROUP = "vgroup";
    public static final String UDATA_AK = "ak";
    public static final String UDATA_DIGEST = "digest";
    public static final String UDATA_IP = "ip";
    public static final String UDATA_TIMESTAMP = "timestamp";
    public static final String UDATA_AUTH_VERSION = "authVersion";

    public RegisterTMRequest() {
        this(null, null);
    }

    public RegisterTMRequest(String applicationId, String transactionServiceGroup, String extraData) {
        super(applicationId, transactionServiceGroup, extraData);
        StringBuilder sb = new StringBuilder();
        if (null != extraData) {
            sb.append(extraData);
            if (!extraData.endsWith("\n")) {
                sb.append("\n");
            }
        }
        if (transactionServiceGroup != null && !transactionServiceGroup.isEmpty()) {
            sb.append(String.format("%s=%s", UDATA_VGROUP, transactionServiceGroup));
            sb.append("\n");
            String clientIP = NetUtil.getLocalIp((String[])new String[0]);
            if (!StringUtils.isEmpty((CharSequence)clientIP)) {
                sb.append(String.format("%s=%s", UDATA_IP, clientIP));
                sb.append("\n");
            }
        }
        this.extraData = sb.toString();
    }

    public RegisterTMRequest(String applicationId, String transactionServiceGroup) {
        this(applicationId, transactionServiceGroup, null);
    }

    @Override
    public short getTypeCode() {
        return 101;
    }
}

