/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.JsonUtil;
import io.seata.core.context.RootContext;
import io.seata.integration.http.HttpExecutor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpExecutor
implements HttpExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpExecutor.class);

    @Override
    public <T, K> K executePost(String host, String path, T paramObject, Class<K> returnType) throws IOException {
        Args.notNull(returnType, (String)"returnType");
        HttpPost httpPost = new HttpPost(host + path);
        StringEntity entity = this.execute(host, path, paramObject);
        if (entity != null) {
            httpPost.setEntity((HttpEntity)entity);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.buildPostHeaders(headers, paramObject);
        CloseableHttpClient httpClient = this.initHttpClientInstance(paramObject);
        return this.wrapHttpExecute(returnType, httpClient, (HttpUriRequest)httpPost, headers);
    }

    @Override
    public <T, K> K executePut(String host, String path, T paramObject, Class<K> returnType) throws IOException {
        Args.notNull(returnType, (String)"returnType");
        HttpPut httpPut = new HttpPut(host + path);
        StringEntity entity = this.execute(host, path, paramObject);
        if (entity != null) {
            httpPut.setEntity((HttpEntity)entity);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.buildPostHeaders(headers, paramObject);
        CloseableHttpClient httpClient = this.initHttpClientInstance(paramObject);
        return this.wrapHttpExecute(returnType, httpClient, (HttpUriRequest)httpPut, headers);
    }

    private <T> StringEntity execute(String host, String path, T paramObject) {
        Args.notNull((Object)host, (String)"host");
        Args.notNull((Object)path, (String)"path");
        StringEntity entity = null;
        if (paramObject != null) {
            String content;
            if (paramObject instanceof String) {
                String sParam = (String)paramObject;
                try {
                    JsonNode jsonNode = JsonUtil.getJson().readTree(sParam);
                    content = JsonUtil.getJson().writeValueAsString((Object)jsonNode);
                }
                catch (JsonProcessingException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Failed to parse JSON: " + e.getMessage());
                    }
                    content = sParam;
                }
            } else {
                try {
                    content = JsonUtil.getJson().writeValueAsString(paramObject);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to serialize object to JSON", e);
                }
            }
            entity = new StringEntity(content, ContentType.APPLICATION_JSON);
        }
        return this.buildEntity(entity, paramObject);
    }

    @Override
    public <K> K executeGet(String host, String path, Map<String, String> paramObject, Class<K> returnType) throws IOException {
        Args.notNull(returnType, (String)"returnType");
        Args.notNull((Object)host, (String)"host");
        Args.notNull((Object)path, (String)"path");
        CloseableHttpClient httpClient = this.initHttpClientInstance(paramObject);
        HttpGet httpGet = new HttpGet(this.initGetUrl(host, path, paramObject));
        HashMap<String, String> headers = new HashMap<String, String>();
        this.buildGetHeaders(headers, paramObject);
        return this.wrapHttpExecute(returnType, httpClient, (HttpUriRequest)httpGet, headers);
    }

    private <T> CloseableHttpClient initHttpClientInstance(T paramObject) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        this.buildClientEntity(httpClient, paramObject);
        return httpClient;
    }

    protected abstract <T> void buildClientEntity(CloseableHttpClient var1, T var2);

    private <K> K wrapHttpExecute(Class<K> returnType, CloseableHttpClient httpClient, HttpUriRequest httpUriRequest, Map<String, String> headers) throws IOException {
        CloseableHttpResponse response;
        int statusCode;
        String xid = RootContext.getXID();
        if (xid != null) {
            headers.put("TX_XID", xid);
        }
        if (!headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)httpUriRequest).addHeader(arg_0, arg_1));
        }
        if ((statusCode = (response = httpClient.execute(httpUriRequest)).getStatusLine().getStatusCode()) < 200 || statusCode > 207) {
            throw new RuntimeException("Failed to invoke the http method " + httpUriRequest.getURI() + " in the service . return status by: " + response.getStatusLine().getStatusCode());
        }
        return this.convertResult((HttpResponse)response, returnType);
    }

    protected abstract <T> void buildGetHeaders(Map<String, String> var1, T var2);

    protected abstract String initGetUrl(String var1, String var2, Map<String, String> var3);

    protected abstract <T> void buildPostHeaders(Map<String, String> var1, T var2);

    protected abstract <T> StringEntity buildEntity(StringEntity var1, T var2);

    protected abstract <K> K convertResult(HttpResponse var1, Class<K> var2);

    public static Map<String, String> convertParamOfBean(Object sourceParam) throws JsonProcessingException {
        return CollectionUtils.toStringMap((Map)((Map)JsonUtil.getJson().readValue(JsonUtil.getJson().writeValueAsString(sourceParam), (TypeReference)new TypeReference<Map<String, Object>>(){})));
    }

    public static <T> Map<String, String> convertParamOfJsonString(String jsonStr, Class<T> returnType) {
        try {
            return AbstractHttpExecutor.convertParamOfBean(JsonUtil.getJson().readValue(jsonStr, returnType));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to parse JSON: " + e.getMessage());
        }
    }
}

