/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.AbstractDMLBaseExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLDeleteRecognizer;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.WhereRecognizer;
import io.seata.sqlparser.struct.TableMeta;
import io.seata.sqlparser.util.ColumnUtils;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class DeleteExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    public DeleteExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        SQLDeleteRecognizer visitor = (SQLDeleteRecognizer)this.sqlRecognizer;
        TableMeta tmeta = this.getTableMeta(visitor.getTableName());
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        String selectSQL = this.buildBeforeImageSQL(visitor, tmeta, paramAppenderList);
        return this.buildTableRecords(tmeta, selectSQL, paramAppenderList);
    }

    private String buildBeforeImageSQL(SQLDeleteRecognizer visitor, TableMeta tableMeta, ArrayList<List<Object>> paramAppenderList) {
        String whereCondition = this.buildWhereCondition((WhereRecognizer)visitor, paramAppenderList);
        String orderByCondition = this.buildOrderCondition((WhereRecognizer)visitor, paramAppenderList);
        String limitCondition = this.buildLimitCondition((WhereRecognizer)visitor, paramAppenderList);
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        if (StringUtils.isNotBlank((String)whereCondition)) {
            suffix.append(" WHERE ").append(whereCondition);
        }
        if (StringUtils.isNotBlank((String)orderByCondition)) {
            suffix.append(" ").append(orderByCondition);
        }
        if (StringUtils.isNotBlank((String)limitCondition)) {
            suffix.append(" ").append(limitCondition);
        }
        suffix.append(" FOR UPDATE");
        StringJoiner selectSQLAppender = new StringJoiner(", ", "SELECT ", suffix.toString());
        for (String column : tableMeta.getAllColumns().keySet()) {
            selectSQLAppender.add(this.getColumnNameInSQL(ColumnUtils.addEscape((String)column, (String)this.getDbType())));
        }
        return selectSQLAppender.toString();
    }

    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        return TableRecords.empty(this.getTableMeta());
    }
}

