/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.impl;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.evaluation.EvaluatorFactoryManager;
import io.seata.saga.engine.evaluation.exception.ExceptionMatchEvaluatorFactory;
import io.seata.saga.engine.evaluation.expression.ExpressionEvaluatorFactory;
import io.seata.saga.engine.expression.ExpressionFactoryManager;
import io.seata.saga.engine.expression.seq.SequenceExpressionFactory;
import io.seata.saga.engine.expression.spel.SpringELExpressionFactory;
import io.seata.saga.engine.invoker.ServiceInvokerManager;
import io.seata.saga.engine.invoker.impl.SpringBeanServiceInvoker;
import io.seata.saga.engine.pcext.InterceptableStateHandler;
import io.seata.saga.engine.pcext.InterceptableStateRouter;
import io.seata.saga.engine.pcext.StateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.engine.pcext.StateMachineProcessHandler;
import io.seata.saga.engine.pcext.StateMachineProcessRouter;
import io.seata.saga.engine.pcext.StateRouter;
import io.seata.saga.engine.pcext.StateRouterInterceptor;
import io.seata.saga.engine.repo.StateLogRepository;
import io.seata.saga.engine.repo.StateMachineRepository;
import io.seata.saga.engine.repo.impl.StateLogRepositoryImpl;
import io.seata.saga.engine.repo.impl.StateMachineRepositoryImpl;
import io.seata.saga.engine.sequence.SeqGenerator;
import io.seata.saga.engine.sequence.SpringJvmUUIDSeqGenerator;
import io.seata.saga.engine.store.StateLangStore;
import io.seata.saga.engine.store.StateLogStore;
import io.seata.saga.engine.strategy.StatusDecisionStrategy;
import io.seata.saga.engine.strategy.impl.DefaultStatusDecisionStrategy;
import io.seata.saga.proctrl.ProcessController;
import io.seata.saga.proctrl.ProcessType;
import io.seata.saga.proctrl.eventing.EventBus;
import io.seata.saga.proctrl.eventing.EventConsumer;
import io.seata.saga.proctrl.eventing.EventPublisher;
import io.seata.saga.proctrl.eventing.impl.AsyncEventBus;
import io.seata.saga.proctrl.eventing.impl.DirectEventBus;
import io.seata.saga.proctrl.eventing.impl.ProcessCtrlEventConsumer;
import io.seata.saga.proctrl.eventing.impl.ProcessCtrlEventPublisher;
import io.seata.saga.proctrl.handler.DefaultRouterHandler;
import io.seata.saga.proctrl.impl.ProcessControllerImpl;
import io.seata.saga.proctrl.process.BusinessProcessor;
import io.seata.saga.proctrl.process.impl.CustomizeBusinessProcessor;
import io.seata.saga.statelang.parser.utils.ResourceUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DefaultStateMachineConfig
implements StateMachineConfig,
ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStateMachineConfig.class);
    private static final int DEFAULT_TRANS_OPER_TIMEOUT = 1800000;
    private static final int DEFAULT_SERVICE_INVOKE_TIMEOUT = 300000;
    private int transOperationTimeout = 1800000;
    private int serviceInvokeTimeout = 300000;
    private StateLogRepository stateLogRepository;
    private StateLogStore stateLogStore;
    private StateLangStore stateLangStore;
    private ExpressionFactoryManager expressionFactoryManager;
    private EvaluatorFactoryManager evaluatorFactoryManager;
    private StateMachineRepository stateMachineRepository;
    private StatusDecisionStrategy statusDecisionStrategy;
    private SeqGenerator seqGenerator;
    private ProcessCtrlEventPublisher syncProcessCtrlEventPublisher;
    private ProcessCtrlEventPublisher asyncProcessCtrlEventPublisher;
    private ApplicationContext applicationContext;
    private ThreadPoolExecutor threadPoolExecutor;
    private boolean enableAsync = false;
    private ServiceInvokerManager serviceInvokerManager;
    private boolean autoRegisterResources = true;
    private String[] resources = new String[]{"classpath*:seata/saga/statelang/**/*.json"};
    private String charset = "UTF-8";
    private String defaultTenantId = "000001";
    private ScriptEngineManager scriptEngineManager;
    private String sagaJsonParser = "fastjson";
    private boolean sagaRetryPersistModeUpdate = false;
    private boolean sagaCompensatePersistModeUpdate = false;

    protected void init() throws Exception {
        ProcessCtrlEventConsumer processCtrlEventConsumer;
        ProcessControllerImpl processorController;
        if (this.expressionFactoryManager == null) {
            this.expressionFactoryManager = new ExpressionFactoryManager();
            SpringELExpressionFactory springELExpressionFactory = new SpringELExpressionFactory();
            springELExpressionFactory.setApplicationContext(this.getApplicationContext());
            this.expressionFactoryManager.putExpressionFactory("Default", springELExpressionFactory);
            SequenceExpressionFactory sequenceExpressionFactory = new SequenceExpressionFactory();
            sequenceExpressionFactory.setSeqGenerator(this.getSeqGenerator());
            this.expressionFactoryManager.putExpressionFactory("Sequence", sequenceExpressionFactory);
        }
        if (this.evaluatorFactoryManager == null) {
            this.evaluatorFactoryManager = new EvaluatorFactoryManager();
            ExpressionEvaluatorFactory expressionEvaluatorFactory = new ExpressionEvaluatorFactory();
            expressionEvaluatorFactory.setExpressionFactory(this.expressionFactoryManager.getExpressionFactory("Default"));
            this.evaluatorFactoryManager.putEvaluatorFactory("Default", expressionEvaluatorFactory);
            this.evaluatorFactoryManager.putEvaluatorFactory("Exception", new ExceptionMatchEvaluatorFactory());
        }
        if (this.stateMachineRepository == null) {
            StateMachineRepositoryImpl stateMachineRepository = new StateMachineRepositoryImpl();
            stateMachineRepository.setCharset(this.charset);
            stateMachineRepository.setSeqGenerator(this.seqGenerator);
            stateMachineRepository.setStateLangStore(this.stateLangStore);
            stateMachineRepository.setDefaultTenantId(this.defaultTenantId);
            stateMachineRepository.setJsonParserName(this.sagaJsonParser);
            this.stateMachineRepository = stateMachineRepository;
        }
        if (this.autoRegisterResources && ArrayUtils.isNotEmpty((Object[])this.resources)) {
            try {
                Resource[] resources = ResourceUtil.getResources((String[])this.resources);
                this.stateMachineRepository.registryByResources(resources, this.defaultTenantId);
            }
            catch (IOException e) {
                LOGGER.error("Load State Language Resources failed.", (Throwable)e);
            }
        }
        if (this.stateLogRepository == null) {
            StateLogRepositoryImpl stateLogRepositoryImpl = new StateLogRepositoryImpl();
            stateLogRepositoryImpl.setStateLogStore(this.stateLogStore);
            this.stateLogRepository = stateLogRepositoryImpl;
        }
        if (this.statusDecisionStrategy == null) {
            this.statusDecisionStrategy = new DefaultStatusDecisionStrategy();
        }
        if (this.syncProcessCtrlEventPublisher == null) {
            ProcessCtrlEventPublisher syncEventPublisher = new ProcessCtrlEventPublisher();
            processorController = this.createProcessorController(syncEventPublisher);
            processCtrlEventConsumer = new ProcessCtrlEventConsumer();
            processCtrlEventConsumer.setProcessController((ProcessController)processorController);
            DirectEventBus directEventBus = new DirectEventBus();
            syncEventPublisher.setEventBus((EventBus)directEventBus);
            directEventBus.registerEventConsumer((EventConsumer)processCtrlEventConsumer);
            this.syncProcessCtrlEventPublisher = syncEventPublisher;
        }
        if (this.enableAsync && this.asyncProcessCtrlEventPublisher == null) {
            ProcessCtrlEventPublisher asyncEventPublisher = new ProcessCtrlEventPublisher();
            processorController = this.createProcessorController(asyncEventPublisher);
            processCtrlEventConsumer = new ProcessCtrlEventConsumer();
            processCtrlEventConsumer.setProcessController((ProcessController)processorController);
            AsyncEventBus asyncEventBus = new AsyncEventBus();
            asyncEventBus.setThreadPoolExecutor(this.getThreadPoolExecutor());
            asyncEventPublisher.setEventBus((EventBus)asyncEventBus);
            asyncEventBus.registerEventConsumer((EventConsumer)processCtrlEventConsumer);
            this.asyncProcessCtrlEventPublisher = asyncEventPublisher;
        }
        if (this.serviceInvokerManager == null) {
            this.serviceInvokerManager = new ServiceInvokerManager();
            SpringBeanServiceInvoker springBeanServiceInvoker = new SpringBeanServiceInvoker();
            springBeanServiceInvoker.setApplicationContext(this.getApplicationContext());
            springBeanServiceInvoker.setThreadPoolExecutor(this.threadPoolExecutor);
            springBeanServiceInvoker.setSagaJsonParser(this.getSagaJsonParser());
            this.serviceInvokerManager.putServiceInvoker("SpringBean", springBeanServiceInvoker);
        }
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
        }
    }

    protected ProcessControllerImpl createProcessorController(ProcessCtrlEventPublisher eventPublisher) throws Exception {
        StateMachineProcessRouter stateMachineProcessRouter = new StateMachineProcessRouter();
        stateMachineProcessRouter.initDefaultStateRouters();
        this.loadStateRouterInterceptors(stateMachineProcessRouter.getStateRouters());
        StateMachineProcessHandler stateMachineProcessHandler = new StateMachineProcessHandler();
        stateMachineProcessHandler.initDefaultHandlers();
        this.loadStateHandlerInterceptors(stateMachineProcessHandler.getStateHandlers());
        DefaultRouterHandler defaultRouterHandler = new DefaultRouterHandler();
        defaultRouterHandler.setEventPublisher((EventPublisher)eventPublisher);
        HashMap<String, StateMachineProcessRouter> processRouterMap = new HashMap<String, StateMachineProcessRouter>(1);
        processRouterMap.put(ProcessType.STATE_LANG.getCode(), stateMachineProcessRouter);
        defaultRouterHandler.setProcessRouters(processRouterMap);
        CustomizeBusinessProcessor customizeBusinessProcessor = new CustomizeBusinessProcessor();
        HashMap<String, StateMachineProcessHandler> processHandlerMap = new HashMap<String, StateMachineProcessHandler>(1);
        processHandlerMap.put(ProcessType.STATE_LANG.getCode(), stateMachineProcessHandler);
        customizeBusinessProcessor.setProcessHandlers(processHandlerMap);
        HashMap<String, DefaultRouterHandler> routerHandlerMap = new HashMap<String, DefaultRouterHandler>(1);
        routerHandlerMap.put(ProcessType.STATE_LANG.getCode(), defaultRouterHandler);
        customizeBusinessProcessor.setRouterHandlers(routerHandlerMap);
        ProcessControllerImpl processorController = new ProcessControllerImpl();
        processorController.setBusinessProcessor((BusinessProcessor)customizeBusinessProcessor);
        return processorController;
    }

    protected void loadStateHandlerInterceptors(Map<String, StateHandler> stateHandlerMap) {
        for (StateHandler stateHandler : stateHandlerMap.values()) {
            if (!(stateHandler instanceof InterceptableStateHandler)) continue;
            InterceptableStateHandler interceptableStateHandler = (InterceptableStateHandler)stateHandler;
            List interceptorList = EnhancedServiceLoader.loadAll(StateHandlerInterceptor.class);
            for (StateHandlerInterceptor interceptor : interceptorList) {
                if (interceptor.match(interceptableStateHandler.getClass())) {
                    interceptableStateHandler.addInterceptor(interceptor);
                }
                if (!(interceptor instanceof ApplicationContextAware)) continue;
                ((ApplicationContextAware)interceptor).setApplicationContext(this.getApplicationContext());
            }
        }
    }

    protected void loadStateRouterInterceptors(Map<String, StateRouter> stateRouterMap) {
        for (StateRouter stateRouter : stateRouterMap.values()) {
            if (!(stateRouter instanceof InterceptableStateRouter)) continue;
            InterceptableStateRouter interceptableStateRouter = (InterceptableStateRouter)stateRouter;
            List interceptorList = EnhancedServiceLoader.loadAll(StateRouterInterceptor.class);
            for (StateRouterInterceptor interceptor : interceptorList) {
                if (interceptor.match(interceptableStateRouter.getClass())) {
                    interceptableStateRouter.addInterceptor(interceptor);
                }
                if (!(interceptor instanceof ApplicationContextAware)) continue;
                ((ApplicationContextAware)interceptor).setApplicationContext(this.getApplicationContext());
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    @Override
    public StateLogStore getStateLogStore() {
        return this.stateLogStore;
    }

    public void setStateLogStore(StateLogStore stateLogStore) {
        this.stateLogStore = stateLogStore;
    }

    @Override
    public StateLangStore getStateLangStore() {
        return this.stateLangStore;
    }

    public void setStateLangStore(StateLangStore stateLangStore) {
        this.stateLangStore = stateLangStore;
    }

    @Override
    public ExpressionFactoryManager getExpressionFactoryManager() {
        return this.expressionFactoryManager;
    }

    public void setExpressionFactoryManager(ExpressionFactoryManager expressionFactoryManager) {
        this.expressionFactoryManager = expressionFactoryManager;
    }

    @Override
    public EvaluatorFactoryManager getEvaluatorFactoryManager() {
        return this.evaluatorFactoryManager;
    }

    public void setEvaluatorFactoryManager(EvaluatorFactoryManager evaluatorFactoryManager) {
        this.evaluatorFactoryManager = evaluatorFactoryManager;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public StateMachineRepository getStateMachineRepository() {
        return this.stateMachineRepository;
    }

    public void setStateMachineRepository(StateMachineRepository stateMachineRepository) {
        this.stateMachineRepository = stateMachineRepository;
    }

    @Override
    public StatusDecisionStrategy getStatusDecisionStrategy() {
        return this.statusDecisionStrategy;
    }

    public void setStatusDecisionStrategy(StatusDecisionStrategy statusDecisionStrategy) {
        this.statusDecisionStrategy = statusDecisionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeqGenerator getSeqGenerator() {
        if (this.seqGenerator == null) {
            DefaultStateMachineConfig defaultStateMachineConfig = this;
            synchronized (defaultStateMachineConfig) {
                if (this.seqGenerator == null) {
                    this.seqGenerator = new SpringJvmUUIDSeqGenerator();
                }
            }
        }
        return this.seqGenerator;
    }

    public void setSeqGenerator(SeqGenerator seqGenerator) {
        this.seqGenerator = seqGenerator;
    }

    @Override
    public ProcessCtrlEventPublisher getProcessCtrlEventPublisher() {
        return this.syncProcessCtrlEventPublisher;
    }

    @Override
    public ProcessCtrlEventPublisher getAsyncProcessCtrlEventPublisher() {
        return this.asyncProcessCtrlEventPublisher;
    }

    public void setAsyncProcessCtrlEventPublisher(ProcessCtrlEventPublisher asyncProcessCtrlEventPublisher) {
        this.asyncProcessCtrlEventPublisher = asyncProcessCtrlEventPublisher;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public boolean isEnableAsync() {
        return this.enableAsync;
    }

    public void setEnableAsync(boolean enableAsync) {
        this.enableAsync = enableAsync;
    }

    @Override
    public StateLogRepository getStateLogRepository() {
        return this.stateLogRepository;
    }

    public void setStateLogRepository(StateLogRepository stateLogRepository) {
        this.stateLogRepository = stateLogRepository;
    }

    public void setSyncProcessCtrlEventPublisher(ProcessCtrlEventPublisher syncProcessCtrlEventPublisher) {
        this.syncProcessCtrlEventPublisher = syncProcessCtrlEventPublisher;
    }

    public void setAutoRegisterResources(boolean autoRegisterResources) {
        this.autoRegisterResources = autoRegisterResources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    @Override
    public ServiceInvokerManager getServiceInvokerManager() {
        return this.serviceInvokerManager;
    }

    public void setServiceInvokerManager(ServiceInvokerManager serviceInvokerManager) {
        this.serviceInvokerManager = serviceInvokerManager;
    }

    @Override
    public String getDefaultTenantId() {
        return this.defaultTenantId;
    }

    public void setDefaultTenantId(String defaultTenantId) {
        this.defaultTenantId = defaultTenantId;
    }

    @Override
    public int getTransOperationTimeout() {
        return this.transOperationTimeout;
    }

    public void setTransOperationTimeout(int transOperationTimeout) {
        this.transOperationTimeout = transOperationTimeout;
    }

    @Override
    public int getServiceInvokeTimeout() {
        return this.serviceInvokeTimeout;
    }

    public void setServiceInvokeTimeout(int serviceInvokeTimeout) {
        this.serviceInvokeTimeout = serviceInvokeTimeout;
    }

    @Override
    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }

    public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public String getSagaJsonParser() {
        return this.sagaJsonParser;
    }

    public void setSagaJsonParser(String sagaJsonParser) {
        this.sagaJsonParser = sagaJsonParser;
    }

    public boolean isSagaRetryPersistModeUpdate() {
        return this.sagaRetryPersistModeUpdate;
    }

    public void setSagaRetryPersistModeUpdate(boolean sagaRetryPersistModeUpdate) {
        this.sagaRetryPersistModeUpdate = sagaRetryPersistModeUpdate;
    }

    public boolean isSagaCompensatePersistModeUpdate() {
        return this.sagaCompensatePersistModeUpdate;
    }

    public void setSagaCompensatePersistModeUpdate(boolean sagaCompensatePersistModeUpdate) {
        this.sagaCompensatePersistModeUpdate = sagaCompensatePersistModeUpdate;
    }
}

