/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import io.seata.common.loader.LoadLevel;
import io.seata.saga.statelang.parser.JsonParser;

@LoadLevel(name="fastjson")
public class FastjsonParser
implements JsonParser {
    private static final JSONWriter.Feature[] SERIALIZER_FEATURES = new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName};
    private static final JSONWriter.Feature[] SERIALIZER_FEATURES_PRETTY = new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName, JSONWriter.Feature.PrettyFormat};
    private static final JSONWriter.Feature[] FEATURES_PRETTY = new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat};
    public static final String NAME = "fastjson";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean useAutoType(String json) {
        return json != null && json.contains("\"@type\"");
    }

    @Override
    public String toJsonString(Object o, boolean prettyPrint) {
        return this.toJsonString(o, false, prettyPrint);
    }

    @Override
    public String toJsonString(Object o, boolean ignoreAutoType, boolean prettyPrint) {
        if (prettyPrint) {
            if (ignoreAutoType) {
                return JSON.toJSONString((Object)o, (JSONWriter.Feature[])FEATURES_PRETTY);
            }
            return JSON.toJSONString((Object)o, (JSONWriter.Feature[])SERIALIZER_FEATURES_PRETTY);
        }
        if (ignoreAutoType) {
            return JSON.toJSONString((Object)o);
        }
        return JSON.toJSONString((Object)o, (JSONWriter.Feature[])SERIALIZER_FEATURES);
    }

    @Override
    public <T> T parse(String json, Class<T> type, boolean ignoreAutoType) {
        if (ignoreAutoType) {
            return (T)JSON.parseObject((String)json, type);
        }
        return (T)JSON.parseObject((String)json, type, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
    }
}

