/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.hessian;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SerializerFactory;
import io.seata.common.loader.LoadLevel;
import io.seata.serializer.hessian.HessianSerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="HESSIAN")
public class HessianSerializer
implements io.seata.core.serializer.Serializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HessianSerializer.class);

    public <T> byte[] serialize(T t) {
        byte[] stream = null;
        SerializerFactory hessian = HessianSerializerFactory.getInstance();
        try {
            Serializer serializer = hessian.getSerializer(t.getClass());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Hessian2Output output = new Hessian2Output((OutputStream)baos);
            serializer.writeObject(t, (AbstractHessianOutput)output);
            output.close();
            stream = baos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Hessian encode error:{}", (Object)e.getMessage(), (Object)e);
        }
        return stream;
    }

    public <T> T deserialize(byte[] bytes) {
        Object obj = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            Hessian2Input input = new Hessian2Input((InputStream)is);
            obj = input.readObject();
            input.close();
        }
        catch (IOException e) {
            LOGGER.error("Hessian decode error:{}", (Object)e.getMessage(), (Object)e);
        }
        return (T)obj;
    }
}

