/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.aot;

import io.seata.common.util.ReflectionUtil;
import io.seata.rm.tcc.api.LocalTCC;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.aot.AotUtils;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;

class SeataLocalTCCBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataLocalTCCBeanRegistrationAotProcessor.class);

    SeataLocalTCCBeanRegistrationAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        if (GlobalTransactionScanner.isTccAutoProxy((Class)beanClass)) {
            return new SeataTccBeanRegistrationAotContribution(beanClass);
        }
        return null;
    }

    private static class SeataTccBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private final Class<?> beanClass;

        public SeataTccBeanRegistrationAotContribution(Class<?> beanClass) {
            this.beanClass = beanClass;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ReflectionHints reflectionHints = generationContext.getRuntimeHints().reflection();
            this.registerClassAndItsInterfacesIfLocalTcc(reflectionHints, this.beanClass);
            Set interfaceClasses = ReflectionUtil.getInterfaces(this.beanClass);
            for (Class interClass : interfaceClasses) {
                this.registerClassAndItsInterfacesIfLocalTcc(reflectionHints, interClass);
            }
        }

        private void registerClassAndItsInterfacesIfLocalTcc(ReflectionHints reflectionHints, Class<?> clazz) {
            if (clazz.isAnnotationPresent(LocalTCC.class)) {
                reflectionHints.registerType(clazz, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
                LOGGER.info("TCC: Register reflection type '{}' (annotated `@LocalTCC`) with member categories {}", (Object)clazz.getName(), (Object)MemberCategory.INVOKE_PUBLIC_METHODS);
                AotUtils.registerAllOfClass((boolean)false, (ReflectionHints)reflectionHints, clazz, (MemberCategory[])AotUtils.ALL_MEMBER_CATEGORIES);
            }
        }
    }
}

