/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.provider;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.holder.ObjectHolder;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.ReflectionUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ExtConfigurationProvider;
import io.seata.spring.boot.autoconfigure.StarterConstants;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.Nullable;

public class SpringBootConfigurationProvider
implements ExtConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootConfigurationProvider.class);
    private static final String INTERCEPT_METHOD_PREFIX = "get";
    private static final Map<String, Object> PROPERTY_BEAN_INSTANCE_MAP = new ConcurrentHashMap<String, Object>(64);

    public Configuration provide(Configuration originalConfiguration) {
        return (Configuration)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Configuration.class}, (proxy, method, args) -> {
            if (method.getName().startsWith(INTERCEPT_METHOD_PREFIX) && args.length > 0) {
                String rawDataId = (String)args[0];
                Class dataType = ReflectionUtil.getWrappedClass(method.getReturnType());
                Object result = originalConfiguration.getConfigFromSys(rawDataId);
                if (result == null) {
                    String dataId = this.convertDataId(rawDataId);
                    result = this.getConfigFromEnvironment(dataId, dataType);
                    if (result != null) {
                        return result;
                    }
                    if (args.length > 1 && (result = args[1]) != null) {
                        if (dataType.isAssignableFrom(result.getClass())) {
                            return result;
                        }
                        result = null;
                    }
                    try {
                        result = this.getDefaultValueFromPropertyObject(dataId);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Get config '{}' default value from the property object failed:", (Object)dataId, (Object)t);
                    }
                }
                if (result != null) {
                    if (dataType.isAssignableFrom(result.getClass())) {
                        return result;
                    }
                    return this.convertType(result, dataType);
                }
            }
            return method.invoke((Object)originalConfiguration, args);
        });
    }

    private Object getDefaultValueFromPropertyObject(String dataId) throws IllegalAccessException, InvocationTargetException {
        String propertyPrefix = this.getPropertyPrefix(dataId);
        String propertySuffix = this.getPropertySuffix(dataId);
        Class<?> propertyClass = StarterConstants.PROPERTY_BEAN_MAP.get(propertyPrefix);
        if (propertyClass == null) {
            throw new ShouldNeverHappenException("PropertyClass for prefix: [" + propertyPrefix + "] should not be null.");
        }
        Object propertyObj = CollectionUtils.computeIfAbsent(PROPERTY_BEAN_INSTANCE_MAP, (Object)propertyPrefix, k -> {
            try {
                return propertyClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.warn("PropertyClass for prefix: [" + propertyPrefix + "] should not be null. error :" + e.getMessage(), (Throwable)e);
                return null;
            }
        });
        Objects.requireNonNull(propertyObj, () -> "Instantiate the property object fail: " + propertyClass.getName());
        return this.getDefaultValueFromPropertyObject(propertyObj, propertySuffix);
    }

    @Nullable
    private Object getDefaultValueFromPropertyObject(Object propertyObj, String fieldName) throws IllegalAccessException, InvocationTargetException {
        block7: {
            try {
                Field field = propertyObj.getClass().getDeclaredField(fieldName);
                if (!Map.class.isAssignableFrom(field.getType())) {
                    field.setAccessible(true);
                    return field.get(propertyObj);
                }
            }
            catch (NoSuchFieldException e) {
                Method method = null;
                try {
                    method = propertyObj.getClass().getMethod(INTERCEPT_METHOD_PREFIX + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        method = propertyObj.getClass().getMethod("is" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), new Class[0]);
                    }
                    catch (NoSuchMethodException exc) {
                        LOGGER.warn("The get method not found for the field '{}#{}'.", (Object)propertyObj.getClass().getSimpleName(), (Object)fieldName);
                    }
                }
                if (method == null || Map.class.isAssignableFrom(method.getReturnType())) break block7;
                method.setAccessible(true);
                return method.invoke(propertyObj, new Object[0]);
            }
        }
        return null;
    }

    private String convertDataId(String rawDataId) {
        if (rawDataId.endsWith("grouplist")) {
            String suffix = org.apache.commons.lang3.StringUtils.removeStart((String)org.apache.commons.lang3.StringUtils.removeEnd((String)rawDataId, (String)".grouplist"), (String)"service.");
            return "seata.service.grouplist." + suffix;
        }
        return "seata." + rawDataId;
    }

    private String getPropertyPrefix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "seata.service";
        }
        if (dataId.contains("grouplist")) {
            return "seata.service";
        }
        return org.apache.commons.lang3.StringUtils.substringBeforeLast((String)dataId, (String)String.valueOf('.'));
    }

    private String getPropertySuffix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "vgroupMapping";
        }
        if (dataId.contains("grouplist")) {
            return "grouplist";
        }
        return org.apache.commons.lang3.StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
    }

    @Nullable
    private Object getConfigFromEnvironment(String dataId, Class<?> dataType) {
        String grouplistPrefix;
        ConfigurableEnvironment environment = (ConfigurableEnvironment)ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment");
        Object value = environment.getProperty(dataId, dataType);
        if (value == null) {
            value = environment.getProperty(StringUtils.hump2Line((String)dataId), dataType);
        }
        if (value == null && dataId.startsWith(grouplistPrefix = "seata.service.grouplist.")) {
            String vgroup = org.apache.commons.lang3.StringUtils.removeStart((String)dataId, (String)grouplistPrefix);
            String oldGrouplistDataId = "seata.service." + vgroup + '.' + "grouplist";
            return this.getConfigFromEnvironment(oldGrouplistDataId, dataType);
        }
        return value;
    }

    private Object convertType(Object configValue, Class<?> dataType) {
        if (String.class.equals(dataType)) {
            return String.valueOf(configValue);
        }
        if (Long.class.equals(dataType)) {
            return Long.parseLong(String.valueOf(configValue));
        }
        if (Integer.class.equals(dataType)) {
            return Integer.parseInt(String.valueOf(configValue));
        }
        if (Short.class.equals(dataType)) {
            return Short.parseShort(String.valueOf(configValue));
        }
        if (Boolean.class.equals(dataType)) {
            return Boolean.parseBoolean(String.valueOf(configValue));
        }
        if (Duration.class.equals(dataType)) {
            return Duration.parse(String.valueOf(configValue));
        }
        return configValue;
    }
}

