/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation.scannercheckers;

import io.seata.common.loader.LoadLevel;
import io.seata.spring.annotation.GlobalLock;
import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.GlobalTransactional;
import io.seata.spring.annotation.ScannerChecker;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

@LoadLevel(name="ScopeBeans", order=200)
public class ScopeBeansScannerChecker
implements ScannerChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeBeansScannerChecker.class);
    private static final Set<String> EXCLUDE_SCOPE_SET = new HashSet<String>();
    private static final String SCOPE_NAME = "scopeName";
    public static final String REQUEST_SCOPE_NAME = "request";
    public static final String SESSION_SCOPE_NAME = "session";
    public static final String JOB_SCOPE_NAME = "job";
    public static final String STEP_SCOPE_NAME = "step";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExcludeScopes(String ... scopeNames) {
        if (ArrayUtils.isNotEmpty((Object[])scopeNames)) {
            Set<String> set = EXCLUDE_SCOPE_SET;
            synchronized (set) {
                for (String scopeName : scopeNames) {
                    if (!StringUtils.isNotBlank((CharSequence)scopeName)) continue;
                    EXCLUDE_SCOPE_SET.add(scopeName.trim().toLowerCase());
                }
            }
        }
    }

    @Override
    public boolean check(Object bean, String beanName, @Nullable ConfigurableListableBeanFactory beanFactory) throws Exception {
        BeanDefinition beanDefinition;
        if (beanFactory == null) {
            return true;
        }
        try {
        }
        catch (NoSuchBeanDefinitionException e) {
            return true;
        }
        for (beanDefinition = beanFactory.getBeanDefinition(beanName); beanDefinition != null && !(beanDefinition instanceof AnnotatedBeanDefinition); beanDefinition = beanDefinition.getOriginatingBeanDefinition()) {
        }
        if (beanDefinition != null) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition;
            if (annotatedBeanDefinition.getFactoryMethodMetadata() != null && this.hasExcludeScope(beanName, (AnnotatedTypeMetadata)annotatedBeanDefinition.getFactoryMethodMetadata())) {
                return false;
            }
            if (this.hasExcludeScope(beanName, (AnnotatedTypeMetadata)annotatedBeanDefinition.getMetadata())) {
                return false;
            }
        }
        return true;
    }

    private boolean hasExcludeScope(String beanName, AnnotatedTypeMetadata annotatedTypeMetadata) {
        Object scopeName;
        MultiValueMap scopeAttributes = annotatedTypeMetadata.getAllAnnotationAttributes(Scope.class.getName());
        if (scopeAttributes == null || scopeAttributes.isEmpty()) {
            return false;
        }
        if (scopeAttributes.containsKey((Object)SCOPE_NAME) && (scopeName = scopeAttributes.getFirst((Object)SCOPE_NAME)) != null && EXCLUDE_SCOPE_SET.contains(scopeName.toString().toLowerCase())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Exclude bean `{}` from the `{}`, cause of `@Scope(scopeName = \"{}\")`. `@{}` and `@{}` will be invalid in this bean. Please refactor the code if you want to continue using it.", new Object[]{beanName, GlobalTransactionScanner.class.getSimpleName(), scopeName.toString(), GlobalTransactional.class.getSimpleName(), GlobalLock.class.getSimpleName()});
            }
            return true;
        }
        return false;
    }

    static {
        EXCLUDE_SCOPE_SET.add(REQUEST_SCOPE_NAME);
        EXCLUDE_SCOPE_SET.add(SESSION_SCOPE_NAME);
        EXCLUDE_SCOPE_SET.add(JOB_SCOPE_NAME);
        EXCLUDE_SCOPE_SET.add(STEP_SCOPE_NAME);
    }
}

