/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.api;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.JsonUtil;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.tcc.api.BusinessActionContext;
import io.seata.rm.tcc.interceptor.ActionContextUtil;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BusinessActionContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessActionContextUtil.class);
    private static final ThreadLocal<BusinessActionContext> CONTEXT_HOLDER = new ThreadLocal();

    private BusinessActionContextUtil() {
    }

    public static boolean addContext(String key, Object value) {
        if (value == null) {
            return false;
        }
        Map<String, Object> newContext = Collections.singletonMap(key, value);
        return BusinessActionContextUtil.addContext(newContext);
    }

    public static boolean addContext(Map<String, Object> context) {
        if (CollectionUtils.isEmpty(context)) {
            return false;
        }
        BusinessActionContext actionContext = BusinessActionContextUtil.getContext();
        if (!ActionContextUtil.putActionContext(actionContext.getActionContext(), context)) {
            return false;
        }
        actionContext.setUpdated(true);
        if (Boolean.TRUE.equals(actionContext.getDelayReport())) {
            return false;
        }
        return BusinessActionContextUtil.reportContext(actionContext);
    }

    public static boolean reportContext(BusinessActionContext actionContext) {
        if (!Boolean.TRUE.equals(actionContext.getUpdated())) {
            return false;
        }
        try {
            DefaultResourceManager.get().branchReport(BranchType.TCC, actionContext.getXid(), actionContext.getBranchId(), BranchStatus.Registered, JsonUtil.getJson().writeValueAsString(Collections.singletonMap("actionContext", actionContext.getActionContext())));
            actionContext.setUpdated(null);
            return true;
        }
        catch (Exception e) {
            String msg = String.format("TCC branch update error, xid: %s", actionContext.getXid());
            LOGGER.error("{}, error: {}", (Object)msg, (Object)e.getMessage());
            throw new FrameworkException((Throwable)e, msg);
        }
    }

    public static BusinessActionContext getContext() {
        return CONTEXT_HOLDER.get();
    }

    public static void setContext(BusinessActionContext context) {
        CONTEXT_HOLDER.set(context);
    }

    public static void clear() {
        CONTEXT_HOLDER.remove();
    }
}

