/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.config;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.core.rpc.Disposable;
import io.seata.rm.tcc.TCCFenceHandler;
import io.seata.rm.tcc.exception.TCCFenceException;
import io.seata.rm.tcc.store.db.TCCFenceStoreDataBaseDAO;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TCCFenceConfig
implements InitializingBean,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCCFenceConfig.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final Duration MAX_PERIOD = Duration.ofSeconds(Integer.MAX_VALUE);
    private Duration cleanPeriod = Duration.ofDays(1L);
    private String logTableName = "tcc_fence_log";
    private final DataSource dataSource;
    private final PlatformTransactionManager transactionManager;
    private final ScheduledThreadPoolExecutor tccFenceClean = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("tccFenceClean", 1));

    public TCCFenceConfig(DataSource dataSource, PlatformTransactionManager transactionManager) {
        this.dataSource = dataSource;
        this.transactionManager = transactionManager;
    }

    public AtomicBoolean getInitialized() {
        return this.initialized;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setCleanPeriod(Duration cleanPeriod) {
        this.cleanPeriod = cleanPeriod;
    }

    public void setLogTableName(String logTableName) {
        this.logTableName = logTableName;
    }

    public void initCleanTask() {
        try {
            if (this.cleanPeriod.isZero() || this.cleanPeriod.isNegative()) {
                LOGGER.info("TCC fence log clean task is not started, cleanPeriod is:{}", (Object)this.cleanPeriod);
                return;
            }
            long periodSeconds = this.cleanPeriod.compareTo(MAX_PERIOD) >= 0 ? Integer.MAX_VALUE : this.cleanPeriod.toMillis() / 1000L;
            this.tccFenceClean.scheduleWithFixedDelay(() -> {
                Date timeBefore = null;
                try {
                    timeBefore = DateUtils.addSeconds((Date)new Date(), (int)(-((int)periodSeconds)));
                    int deletedRowCount = TCCFenceHandler.deleteFenceByDate(timeBefore);
                    if (deletedRowCount > 0) {
                        LOGGER.info("TCC fence clean task executed success, timeBefore: {}, deleted row count: {}", (Object)timeBefore, (Object)deletedRowCount);
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.error("Delete tcc fence log failed, timeBefore: {}", timeBefore, (Object)e);
                }
            }, 0L, periodSeconds, TimeUnit.SECONDS);
            LOGGER.info("TCC fence log clean task start success, cleanPeriod:{}", (Object)this.cleanPeriod);
        }
        catch (NumberFormatException e) {
            LOGGER.error("TCC fence log clean period only supports positive integers, clean task start failed");
        }
    }

    public void destroy() {
        this.tccFenceClean.shutdown();
    }

    public void afterPropertiesSet() {
        if (this.logTableName != null) {
            TCCFenceStoreDataBaseDAO.getInstance().setLogTableName(this.logTableName);
        }
        if (this.dataSource == null) {
            throw new TCCFenceException(FrameworkErrorCode.DateSourceNeedInjected);
        }
        TCCFenceHandler.setDataSource(this.dataSource);
        if (this.transactionManager == null) {
            throw new TCCFenceException(FrameworkErrorCode.TransactionManagerNeedInjected);
        }
        TCCFenceHandler.setTransactionTemplate(new TransactionTemplate(this.transactionManager));
    }
}

