/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.interceptor;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.seata.common.exception.FrameworkException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.JsonUtil;
import io.seata.common.util.ReflectionUtil;
import io.seata.common.util.StringUtils;
import io.seata.rm.tcc.api.BusinessActionContextParameter;
import io.seata.rm.tcc.api.ParamType;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionContextUtil.class);

    private ActionContextUtil() {
    }

    public static Map<String, Object> fetchContextFromObject(@Nonnull Object targetParam) {
        try {
            Object[] fields = ReflectionUtil.getAllFields(targetParam.getClass());
            if (CollectionUtils.isEmpty((Object[])fields)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("The param of type `{}` has no field, please don't use `@{}(isParamInProperty = true)` on it", (Object)targetParam.getClass().getName(), (Object)BusinessActionContextParameter.class.getSimpleName());
                }
                return Collections.emptyMap();
            }
            HashMap<String, Object> context = new HashMap<String, Object>(8);
            for (Object f : fields) {
                BusinessActionContextParameter annotation = ((Field)f).getAnnotation(BusinessActionContextParameter.class);
                if (annotation == null) continue;
                ((Field)f).setAccessible(true);
                Object fieldValue = ((Field)f).get(targetParam);
                String fieldName = ((Field)f).getName();
                ActionContextUtil.loadParamByAnnotationAndPutToContext(ParamType.FIELD, fieldName, fieldValue, annotation, context);
            }
            return context;
        }
        catch (Exception e) {
            throw new FrameworkException((Throwable)e, "fetchContextFromObject failover");
        }
    }

    public static void loadParamByAnnotationAndPutToContext(@Nonnull ParamType paramType, @Nonnull String paramName, Object paramValue, @Nonnull BusinessActionContextParameter annotation, @Nonnull Map<String, Object> actionContext) {
        if (paramValue == null) {
            return;
        }
        int index = annotation.index();
        if (index >= 0 && (paramValue = ActionContextUtil.getByIndex(paramType, paramName, paramValue, index)) == null) {
            return;
        }
        if (annotation.isParamInProperty()) {
            Map<String, Object> paramContext = ActionContextUtil.fetchContextFromObject(paramValue);
            if (CollectionUtils.isNotEmpty(paramContext)) {
                actionContext.putAll(paramContext);
            }
        } else {
            String paramNameFromAnnotation = ActionContextUtil.getParamNameFromAnnotation(annotation);
            if (StringUtils.isNotBlank((String)paramNameFromAnnotation)) {
                paramName = paramNameFromAnnotation;
            }
            ActionContextUtil.putActionContextWithoutHandle(actionContext, paramName, paramValue);
        }
    }

    @Nullable
    private static Object getByIndex(@Nonnull ParamType paramType, @Nonnull String paramName, @Nonnull Object paramValue, int index) {
        if (paramValue instanceof List) {
            List list = (List)paramValue;
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() <= index) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The index '{}' is out of bounds for the list {} named '{}', whose size is '{}', so pass this {}", new Object[]{index, paramType.getCode(), paramName, list.size(), paramType.getCode()});
                }
                return null;
            }
            paramValue = list.get(index);
        } else {
            LOGGER.warn("the {} named '{}' is not a `List`, so the 'index' field of '@{}' cannot be used on it", new Object[]{paramType.getCode(), paramName, BusinessActionContextParameter.class.getSimpleName()});
        }
        return paramValue;
    }

    public static String getParamNameFromAnnotation(@Nonnull BusinessActionContextParameter annotation) {
        String paramName = annotation.paramName();
        if (StringUtils.isBlank((String)paramName)) {
            paramName = annotation.value();
        }
        return paramName;
    }

    public static boolean putActionContext(Map<String, Object> actionContext, String key, Object value) {
        Object previousValue;
        if (value == null) {
            return false;
        }
        return !(value = ActionContextUtil.handleActionContext(value)).equals(previousValue = actionContext.put(key, value));
    }

    public static boolean putActionContext(Map<String, Object> actionContext, @Nonnull Map<String, Object> actionContextMap) {
        boolean isChanged = false;
        for (Map.Entry<String, Object> entry : actionContextMap.entrySet()) {
            if (!ActionContextUtil.putActionContext(actionContext, entry.getKey(), entry.getValue())) continue;
            isChanged = true;
        }
        return isChanged;
    }

    public static boolean putActionContextWithoutHandle(@Nonnull Map<String, Object> actionContext, String key, Object value) {
        if (value == null) {
            return false;
        }
        Object previousValue = actionContext.put(key, value);
        return !value.equals(previousValue);
    }

    public static boolean putActionContextWithoutHandle(Map<String, Object> actionContext, @Nonnull Map<String, Object> actionContextMap) {
        boolean isChanged = false;
        for (Map.Entry<String, Object> entry : actionContextMap.entrySet()) {
            if (!ActionContextUtil.putActionContextWithoutHandle(actionContext, entry.getKey(), entry.getValue())) continue;
            isChanged = true;
        }
        return isChanged;
    }

    public static Object handleActionContext(@Nonnull Object actionContext) {
        if (actionContext instanceof CharSequence || actionContext instanceof Number || actionContext instanceof Boolean || actionContext instanceof Character) {
            return actionContext;
        }
        try {
            return JsonUtil.getJson().writeValueAsString(actionContext);
        }
        catch (JsonProcessingException e) {
            throw new FrameworkException((Throwable)e);
        }
    }

    public static <T> T convertActionContext(String key, @Nullable Object value, @Nonnull Class<T> targetClazz) {
        if (targetClazz.isPrimitive()) {
            throw new IllegalArgumentException("The targetClazz cannot be a primitive type, because the value may be null. Please use the wrapped type.");
        }
        if (value == null) {
            return null;
        }
        if (targetClazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (String.class.equals(targetClazz)) {
            return (T)value.toString();
        }
        try {
            if (value instanceof CharSequence || value instanceof Character) {
                return (T)JsonUtil.getJson().readValue(value.toString(), targetClazz);
            }
            return (T)JsonUtil.getJson().readValue(JsonUtil.getJson().writeValueAsString(value), targetClazz);
        }
        catch (Exception e) {
            String errorMsg = String.format("Failed to convert the action context with key '%s' from '%s' to '%s'.", key, value.getClass().getName(), targetClazz.getName());
            throw new FrameworkException((Throwable)e, errorMsg);
        }
    }
}

