/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.store.db;

import io.seata.common.exception.DataAccessException;
import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.StoreException;
import io.seata.common.util.IOUtil;
import io.seata.rm.tcc.exception.TCCFenceException;
import io.seata.rm.tcc.store.TCCFenceDO;
import io.seata.rm.tcc.store.TCCFenceStore;
import io.seata.rm.tcc.store.db.sql.TCCFenceStoreSqls;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TCCFenceStoreDataBaseDAO
implements TCCFenceStore {
    private String logTableName = "tcc_fence_log";
    private static volatile TCCFenceStoreDataBaseDAO instance = null;

    private TCCFenceStoreDataBaseDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TCCFenceStore getInstance() {
        if (instance != null) return instance;
        Class<TCCFenceStore> clazz = TCCFenceStore.class;
        synchronized (TCCFenceStore.class) {
            if (instance != null) return instance;
            instance = new TCCFenceStoreDataBaseDAO();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public TCCFenceDO queryTCCFenceDO(Connection conn, String xid, Long branchId) {
        TCCFenceDO tCCFenceDO;
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            ps = null;
            rs = null;
            String sql = TCCFenceStoreSqls.getQuerySQLByBranchIdAndXid(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            ps.setLong(2, branchId);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            TCCFenceDO tccFenceDO = new TCCFenceDO();
            tccFenceDO.setXid(rs.getString("xid"));
            tccFenceDO.setBranchId(rs.getLong("branch_id"));
            tccFenceDO.setStatus(rs.getInt("status"));
            TCCFenceDO tCCFenceDO2 = tccFenceDO;
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
            return tCCFenceDO2;
        }
        try {
            tCCFenceDO = null;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
        return tCCFenceDO;
    }

    @Override
    public Set<String> queryEndStatusXidsByDate(Connection conn, Date datetime, int limit) {
        HashSet<String> hashSet;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = TCCFenceStoreSqls.getQueryEndStatusSQLByDate(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setTimestamp(1, new Timestamp(datetime.getTime()));
            ps.setInt(2, limit);
            rs = ps.executeQuery();
            HashSet<String> xids = new HashSet<String>(limit);
            while (rs.next()) {
                xids.add(rs.getString("xid"));
            }
            hashSet = xids;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
        return hashSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean insertTCCFenceDO(Connection conn, TCCFenceDO tccFenceDO) {
        boolean bl;
        PreparedStatement ps = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String sql = TCCFenceStoreSqls.getInsertLocalTCCLogSQL(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setString(1, tccFenceDO.getXid());
            ps.setLong(2, tccFenceDO.getBranchId());
            ps.setString(3, tccFenceDO.getActionName());
            ps.setInt(4, tccFenceDO.getStatus());
            ps.setTimestamp(5, now);
            ps.setTimestamp(6, now);
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new TCCFenceException(String.format("Insert tcc fence record duplicate key exception. xid= %s, branchId= %s", tccFenceDO.getXid(), tccFenceDO.getBranchId()), FrameworkErrorCode.DuplicateKeyException);
                catch (SQLException e2) {
                    throw new StoreException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    @Override
    public boolean updateTCCFenceDO(Connection conn, String xid, Long branchId, int newStatus, int oldStatus) {
        boolean bl;
        PreparedStatement ps = null;
        try {
            String sql = TCCFenceStoreSqls.getUpdateStatusSQLByBranchIdAndXid(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setInt(1, newStatus);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, xid);
            ps.setLong(4, branchId);
            ps.setInt(5, oldStatus);
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    @Override
    public boolean deleteTCCFenceDO(Connection conn, String xid, Long branchId) {
        boolean bl;
        PreparedStatement ps = null;
        try {
            String sql = TCCFenceStoreSqls.getDeleteSQLByBranchIdAndXid(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setString(1, xid);
            ps.setLong(2, branchId);
            ps.executeUpdate();
            bl = true;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    @Override
    public int deleteTCCFenceDO(Connection conn, List<String> xids) {
        int n;
        PreparedStatement ps = null;
        try {
            String paramsPlaceHolder = StringUtils.repeat((String)"?", (String)",", (int)xids.size());
            String sql = TCCFenceStoreSqls.getDeleteSQLByXids(this.logTableName, paramsPlaceHolder);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < xids.size(); ++i) {
                ps.setString(i + 1, xids.get(i));
            }
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return n;
    }

    @Override
    public int deleteTCCFenceDOByDate(Connection conn, Date datetime) {
        int n;
        PreparedStatement ps = null;
        try {
            String sql = TCCFenceStoreSqls.getDeleteSQLByDateAndStatus(this.logTableName);
            ps = conn.prepareStatement(sql);
            ps.setTimestamp(1, new Timestamp(datetime.getTime()));
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return n;
    }

    @Override
    public void setLogTableName(String logTableName) {
        this.logTableName = logTableName;
    }
}

