/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.JsonSchemaValidator;
import org.apache.johnzon.jsonschema.JsonSchemaValidatorFactory;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class ContainsValidation
implements ValidationExtension {
    private final JsonSchemaValidatorFactory factory;

    public ContainsValidation(JsonSchemaValidatorFactory factory) {
        this.factory = factory;
    }

    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        return Optional.ofNullable((JsonValue)model.getSchema().get((Object)"contains")).filter(it -> it.getValueType() == JsonValue.ValueType.OBJECT).map(it -> new ItemsValidator(model.toPointer(), model.getValueProvider(), this.factory.newInstance(it.asJsonObject())));
    }

    private static class ItemsValidator
    extends BaseValidation {
        private final JsonSchemaValidator validator;

        private ItemsValidator(String pointer, Function<JsonValue, JsonValue> extractor, JsonSchemaValidator validator) {
            super(pointer, extractor, JsonValue.ValueType.ARRAY);
            this.validator = validator;
        }

        @Override
        protected Stream<ValidationResult.ValidationError> onArray(JsonArray array) {
            for (JsonValue value : array) {
                Collection<ValidationResult.ValidationError> itemErrors = this.validator.apply(value).getErrors();
                if (!itemErrors.isEmpty()) continue;
                return Stream.empty();
            }
            return Stream.of(new ValidationResult.ValidationError(this.pointer, "No item matching the expected schema"));
        }

        public String toString() {
            return "Contains{validator=" + this.validator + ", pointer='" + this.pointer + '\'' + '}';
        }
    }
}

