/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonNumber;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class MaxLengthValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        if (model.getSchema().getString("type", "object").equals("string")) {
            return Optional.ofNullable((JsonValue)model.getSchema().get((Object)"maxLength")).filter(v -> v.getValueType() == JsonValue.ValueType.NUMBER).map(m -> new Impl(model.toPointer(), model.getValueProvider(), ((JsonNumber)JsonNumber.class.cast(m)).intValue()));
        }
        return Optional.empty();
    }

    private static class Impl
    extends BaseValidation {
        private final int bound;

        private Impl(String pointer, Function<JsonValue, JsonValue> valueProvider, int bound) {
            super(pointer, valueProvider, JsonValue.ValueType.STRING);
            this.bound = bound;
        }

        @Override
        protected Stream<ValidationResult.ValidationError> onString(JsonString val) {
            if (val.getString().length() > this.bound) {
                return Stream.of(new ValidationResult.ValidationError(this.pointer, val + " length is more than " + this.bound));
            }
            return Stream.empty();
        }

        public String toString() {
            return "MaxLength{factor=" + this.bound + ", pointer='" + this.pointer + '\'' + '}';
        }
    }
}

