/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.connect.mirror.ReplicationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReplicationPolicy
implements ReplicationPolicy,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(DefaultReplicationPolicy.class);
    public static final String SEPARATOR_CONFIG = "replication.policy.separator";
    public static final String SEPARATOR_DEFAULT = ".";
    private String separator = ".";
    private Pattern separatorPattern = Pattern.compile(Pattern.quote("."));

    public void configure(Map<String, ?> props) {
        if (props.containsKey(SEPARATOR_CONFIG)) {
            this.separator = (String)props.get(SEPARATOR_CONFIG);
            log.info("Using custom remote topic separator: '{}'", (Object)this.separator);
            this.separatorPattern = Pattern.compile(Pattern.quote(this.separator));
        }
    }

    @Override
    public String formatRemoteTopic(String sourceClusterAlias, String topic) {
        return sourceClusterAlias + this.separator + topic;
    }

    @Override
    public String topicSource(String topic) {
        String[] parts = this.separatorPattern.split(topic);
        if (parts.length < 2) {
            return null;
        }
        return parts[0];
    }

    @Override
    public String upstreamTopic(String topic) {
        String source = this.topicSource(topic);
        if (source == null) {
            return null;
        }
        return topic.substring(source.length() + this.separator.length());
    }
}

