/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.MirrorConnectorConfig;
import org.apache.kafka.connect.mirror.MirrorMetrics;
import org.apache.kafka.connect.mirror.MirrorUtils;

public class MirrorTaskConfig
extends MirrorConnectorConfig {
    private static final String TASK_TOPIC_PARTITIONS_DOC = "Topic-partitions assigned to this task to replicate.";
    private static final String TASK_CONSUMER_GROUPS_DOC = "Consumer groups assigned to this task to replicate.";
    protected static final ConfigDef TASK_CONFIG_DEF = new ConfigDef(CONNECTOR_CONFIG_DEF).define("task.assigned.partitions", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "Topic-partitions assigned to this task to replicate.").define("task.assigned.groups", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "Consumer groups assigned to this task to replicate.");

    public MirrorTaskConfig(Map<String, String> props) {
        super(TASK_CONFIG_DEF, props);
    }

    Set<TopicPartition> taskTopicPartitions() {
        List fields = this.getList("task.assigned.partitions");
        if (fields == null || fields.isEmpty()) {
            return Collections.emptySet();
        }
        return fields.stream().map(MirrorUtils::decodeTopicPartition).collect(Collectors.toSet());
    }

    Set<String> taskConsumerGroups() {
        List fields = this.getList("task.assigned.groups");
        if (fields == null || fields.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(fields);
    }

    MirrorMetrics metrics() {
        MirrorMetrics metrics = new MirrorMetrics(this);
        this.metricsReporters().forEach(metrics::addReporter);
        return metrics;
    }
}

