/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Scheduler
implements AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(Scheduler.class);
    private final String name;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Duration timeout;
    private boolean closed = false;

    Scheduler(String name, Duration timeout) {
        this.name = name;
        this.timeout = timeout;
    }

    Scheduler(Class<?> clazz, Duration timeout) {
        this("Scheduler for " + clazz.getSimpleName(), timeout);
    }

    void scheduleRepeating(Task task, Duration interval, String description) {
        if (interval.toMillis() < 0L) {
            return;
        }
        this.executor.scheduleAtFixedRate(() -> this.executeThread(task, description), 0L, interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    void scheduleRepeatingDelayed(Task task, Duration interval, String description) {
        if (interval.toMillis() < 0L) {
            return;
        }
        this.executor.scheduleAtFixedRate(() -> this.executeThread(task, description), interval.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    void execute(Task task, String description) {
        try {
            this.executor.submit(() -> this.executeThread(task, description)).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("{} was interrupted running task: {}", (Object)this.name, (Object)description);
        }
        catch (TimeoutException e) {
            log.error("{} timed out running task: {}", (Object)this.name, (Object)description);
        }
        catch (Throwable e) {
            log.error("{} caught exception in task: {}", new Object[]{this.name, description, e});
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.executor.shutdown();
        try {
            boolean terminated = this.executor.awaitTermination(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!terminated) {
                log.error("{} timed out during shutdown of internal scheduler.", (Object)this.name);
            }
        }
        catch (InterruptedException e) {
            log.warn("{} was interrupted during shutdown of internal scheduler.", (Object)this.name);
        }
    }

    private void run(Task task, String description) {
        try {
            long start = System.currentTimeMillis();
            task.run();
            long elapsed = System.currentTimeMillis() - start;
            log.info("{} took {} ms", (Object)description, (Object)elapsed);
            if (elapsed > this.timeout.toMillis()) {
                log.warn("{} took too long ({} ms) running task: {}", new Object[]{this.name, elapsed, description});
            }
        }
        catch (InterruptedException e) {
            log.warn("{} was interrupted running task: {}", (Object)this.name, (Object)description);
        }
        catch (Throwable e) {
            log.error("{} caught exception in scheduled task: {}", new Object[]{this.name, description, e});
        }
    }

    private void executeThread(Task task, String description) {
        Thread.currentThread().setName(this.name + "-" + description);
        if (this.closed) {
            log.info("{} skipping task due to shutdown: {}", (Object)this.name, (Object)description);
            return;
        }
        this.run(task, description);
    }

    static interface Task {
        public void run() throws InterruptedException, ExecutionException;
    }
}

