/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.message.CodeBuffer;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.FieldType;
import org.apache.kafka.message.HeaderGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.StructRegistry;
import org.apache.kafka.message.StructSpec;
import org.apache.kafka.message.Versions;

final class SchemaGenerator {
    private final HeaderGenerator headerGenerator;
    private final StructRegistry structRegistry;
    private final Map<String, MessageInfo> messages;
    private Versions messageFlexibleVersions;

    SchemaGenerator(HeaderGenerator headerGenerator, StructRegistry structRegistry) {
        this.headerGenerator = headerGenerator;
        this.structRegistry = structRegistry;
        this.messages = new HashMap<String, MessageInfo>();
    }

    void generateSchemas(MessageSpec message) throws Exception {
        this.messageFlexibleVersions = message.flexibleVersions();
        Iterator<StructSpec> iter = this.structRegistry.commonStructs();
        while (iter.hasNext()) {
            StructSpec struct = iter.next();
            this.generateSchemas(struct.name(), struct, message.struct().versions());
        }
        this.generateSchemas(message.dataClassName(), message.struct(), message.struct().versions());
    }

    void generateSchemas(String className, StructSpec struct, Versions parentVersions) throws Exception {
        Versions versions = parentVersions.intersect(struct.versions());
        MessageInfo messageInfo = this.messages.get(className);
        if (messageInfo != null) {
            return;
        }
        messageInfo = new MessageInfo(versions);
        this.messages.put(className, messageInfo);
        for (FieldSpec field : struct.fields()) {
            if (field.type().isStructArray()) {
                FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
                this.generateSchemas(arrayType.elementType().toString(), this.structRegistry.findStruct(field), versions);
                continue;
            }
            if (!field.type().isStruct()) continue;
            this.generateSchemas(field.type().toString(), this.structRegistry.findStruct(field), versions);
        }
        CodeBuffer prev = null;
        for (short v = versions.lowest(); v <= versions.highest(); v = (short)(v + 1)) {
            CodeBuffer cur = new CodeBuffer();
            this.generateSchemaForVersion(struct, v, cur);
            if (!cur.equals(prev)) {
                messageInfo.schemaForVersion.put(v, cur);
            }
            prev = cur;
        }
    }

    private void generateSchemaForVersion(StructSpec struct, short version, CodeBuffer buffer) throws Exception {
        FieldSpec field;
        int lastValidIndex;
        for (lastValidIndex = struct.fields().size() - 1; lastValidIndex >= 0 && ((field = struct.fields().get(lastValidIndex)).taggedVersions().contains(version) || !field.versions().contains(version)); --lastValidIndex) {
        }
        int finalLine = lastValidIndex;
        if (this.messageFlexibleVersions.contains(version)) {
            ++finalLine;
        }
        this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Schema");
        buffer.printf("new Schema(%n", new Object[0]);
        buffer.incrementIndent();
        for (int i = 0; i <= lastValidIndex; ++i) {
            FieldSpec field2 = struct.fields().get(i);
            if (!field2.versions().contains(version) || field2.taggedVersions().contains(version)) continue;
            Versions fieldFlexibleVersions = field2.flexibleVersions().orElse(this.messageFlexibleVersions);
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Field");
            buffer.printf("new Field(\"%s\", %s, \"%s\")%s%n", field2.snakeCaseName(), this.fieldTypeToSchemaType(field2, version, fieldFlexibleVersions), field2.about(), i == finalLine ? "" : ",");
        }
        if (this.messageFlexibleVersions.contains(version)) {
            this.generateTaggedFieldsSchemaForVersion(struct, version, buffer);
        }
        buffer.decrementIndent();
        buffer.printf(");%n", new Object[0]);
    }

    private void generateTaggedFieldsSchemaForVersion(StructSpec struct, short version, CodeBuffer buffer) throws Exception {
        FieldSpec field;
        int lastValidIndex;
        this.headerGenerator.addStaticImport("org.apache.kafka.common.protocol.types.Field.TaggedFieldsSection");
        for (lastValidIndex = struct.fields().size() - 1; !(lastValidIndex < 0 || (field = struct.fields().get(lastValidIndex)).taggedVersions().contains(version) && field.versions().contains(version)); --lastValidIndex) {
        }
        buffer.printf("TaggedFieldsSection.of(%n", new Object[0]);
        buffer.incrementIndent();
        for (int i = 0; i <= lastValidIndex; ++i) {
            FieldSpec field2 = struct.fields().get(i);
            if (!field2.versions().contains(version) || !field2.taggedVersions().contains(version)) continue;
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Field");
            Versions fieldFlexibleVersions = field2.flexibleVersions().orElse(this.messageFlexibleVersions);
            buffer.printf("%d, new Field(\"%s\", %s, \"%s\")%s%n", field2.tag().get(), field2.snakeCaseName(), this.fieldTypeToSchemaType(field2, version, fieldFlexibleVersions), field2.about(), i == lastValidIndex ? "" : ",");
        }
        buffer.decrementIndent();
        buffer.printf(")%n", new Object[0]);
    }

    private String fieldTypeToSchemaType(FieldSpec field, short version, Versions fieldFlexibleVersions) {
        return this.fieldTypeToSchemaType(field.type(), field.nullableVersions().contains(version), version, fieldFlexibleVersions, field.zeroCopy());
    }

    private String fieldTypeToSchemaType(FieldType type, boolean nullable, short version, Versions fieldFlexibleVersions, boolean zeroCopy) {
        if (type instanceof FieldType.BoolFieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return "Type.BOOLEAN";
        }
        if (type instanceof FieldType.Int8FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return "Type.INT8";
        }
        if (type instanceof FieldType.Int16FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return "Type.INT16";
        }
        if (type instanceof FieldType.Uint16FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return "Type.UINT16";
        }
        if (type instanceof FieldType.Int32FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return "Type.INT32";
        }
        if (type instanceof FieldType.Int64FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return "Type.INT64";
        }
        if (type instanceof FieldType.UUIDFieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return "Type.UUID";
        }
        if (type instanceof FieldType.Float64FieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return "Type.FLOAT64";
        }
        if (type instanceof FieldType.StringFieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (fieldFlexibleVersions.contains(version)) {
                return nullable ? "Type.COMPACT_NULLABLE_STRING" : "Type.COMPACT_STRING";
            }
            return nullable ? "Type.NULLABLE_STRING" : "Type.STRING";
        }
        if (type instanceof FieldType.BytesFieldType) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (fieldFlexibleVersions.contains(version)) {
                return nullable ? "Type.COMPACT_NULLABLE_BYTES" : "Type.COMPACT_BYTES";
            }
            return nullable ? "Type.NULLABLE_BYTES" : "Type.BYTES";
        }
        if (type.isRecords()) {
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.Type");
            if (fieldFlexibleVersions.contains(version)) {
                return "Type.COMPACT_RECORDS";
            }
            return "Type.RECORDS";
        }
        if (type.isArray()) {
            if (fieldFlexibleVersions.contains(version)) {
                this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.CompactArrayOf");
                FieldType.ArrayType arrayType = (FieldType.ArrayType)type;
                String prefix = nullable ? "CompactArrayOf.nullable" : "new CompactArrayOf";
                return String.format("%s(%s)", prefix, this.fieldTypeToSchemaType(arrayType.elementType(), false, version, fieldFlexibleVersions, false));
            }
            this.headerGenerator.addImport("org.apache.kafka.common.protocol.types.ArrayOf");
            FieldType.ArrayType arrayType = (FieldType.ArrayType)type;
            String prefix = nullable ? "ArrayOf.nullable" : "new ArrayOf";
            return String.format("%s(%s)", prefix, this.fieldTypeToSchemaType(arrayType.elementType(), false, version, fieldFlexibleVersions, false));
        }
        if (type.isStruct()) {
            if (nullable) {
                throw new RuntimeException("Type " + type + " cannot be nullable.");
            }
            return String.format("%s.SCHEMA_%d", type.toString(), this.floorVersion(type.toString(), version));
        }
        throw new RuntimeException("Unsupported type " + type);
    }

    private short floorVersion(String className, short v) {
        MessageInfo message = this.messages.get(className);
        return message.schemaForVersion.floorKey(v);
    }

    void writeSchema(String className, CodeBuffer buffer) throws Exception {
        short v;
        MessageInfo messageInfo = this.messages.get(className);
        Versions versions = messageInfo.versions;
        for (v = versions.lowest(); v <= versions.highest(); v = (short)(v + 1)) {
            CodeBuffer declaration = (CodeBuffer)messageInfo.schemaForVersion.get(v);
            if (declaration == null) {
                buffer.printf("public static final Schema SCHEMA_%d = SCHEMA_%d;%n", v, v - 1);
            } else {
                buffer.printf("public static final Schema SCHEMA_%d =%n", v);
                buffer.incrementIndent();
                declaration.write(buffer);
                buffer.decrementIndent();
            }
            buffer.printf("%n", new Object[0]);
        }
        buffer.printf("public static final Schema[] SCHEMAS = new Schema[] {%n", new Object[0]);
        buffer.incrementIndent();
        for (v = 0; v < versions.lowest(); v = (short)(v + 1)) {
            buffer.printf("null%s%n", v == versions.highest() ? "" : ",");
        }
        for (v = versions.lowest(); v <= versions.highest(); v = (short)(v + 1)) {
            buffer.printf("SCHEMA_%d%s%n", v, v == versions.highest() ? "" : ",");
        }
        buffer.decrementIndent();
        buffer.printf("};%n", new Object[0]);
        buffer.printf("%n", new Object[0]);
        buffer.printf("public static final short LOWEST_SUPPORTED_VERSION = %d;%n", versions.lowest());
        buffer.printf("public static final short HIGHEST_SUPPORTED_VERSION = %d;%n", versions.highest());
        buffer.printf("%n", new Object[0]);
    }

    static class MessageInfo {
        private final Versions versions;
        private final TreeMap<Short, CodeBuffer> schemaForVersion;

        MessageInfo(Versions versions) {
            this.versions = versions;
            this.schemaForVersion = new TreeMap();
        }
    }
}

