/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.nio.ByteBuffer;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.metadata.MetadataParseException;

public class MetadataParser {
    public static final int MAX_SERIALIZED_EVENT_SIZE = 0x2000000;

    private static short unsignedIntToShort(int val, String entity) {
        if (val > Short.MAX_VALUE) {
            throw new MetadataParseException("Value for " + entity + " was too large.");
        }
        return (short)val;
    }

    public static ApiMessage read(ByteBuffer buffer) {
        short version;
        short type;
        try {
            type = MetadataParser.unsignedIntToShort(ByteUtils.readUnsignedVarint((ByteBuffer)buffer), "type");
        }
        catch (Exception e) {
            throw new MetadataParseException("Failed to read variable-length type number: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        try {
            version = MetadataParser.unsignedIntToShort(ByteUtils.readUnsignedVarint((ByteBuffer)buffer), "version");
        }
        catch (Exception e) {
            throw new MetadataParseException("Failed to read variable-length version number: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        MetadataRecordType recordType = MetadataRecordType.fromId(type);
        ApiMessage message = recordType.newMetadataRecord();
        try {
            message.read((Readable)new ByteBufferAccessor(buffer), version);
        }
        catch (Exception e) {
            throw new MetadataParseException((Object)((Object)recordType) + "#parse failed: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        if (buffer.hasRemaining()) {
            throw new MetadataParseException("Found " + buffer.remaining() + " byte(s) of garbage after " + (Object)((Object)recordType));
        }
        return message;
    }

    public static int size(ApiMessage message, short version, ObjectSerializationCache cache) {
        long messageSize = message.size(cache, version);
        long totalSize = messageSize + (long)ByteUtils.sizeOfUnsignedVarint((int)message.apiKey()) + (long)ByteUtils.sizeOfUnsignedVarint((int)version);
        if (totalSize > 0x2000000L) {
            throw new RuntimeException("Event size would be " + totalSize + ", but the maximum serialized event size is " + 0x2000000);
        }
        return (int)totalSize;
    }

    public static void write(ApiMessage message, short version, ObjectSerializationCache cache, ByteBuffer buf) {
        ByteUtils.writeUnsignedVarint((int)message.apiKey(), (ByteBuffer)buf);
        ByteUtils.writeUnsignedVarint((int)version, (ByteBuffer)buf);
        message.write((Writable)new ByteBufferAccessor(buf), cache, version);
    }
}

