/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;

public class KafkaConfigSchema {
    public static final KafkaConfigSchema EMPTY = new KafkaConfigSchema(Collections.emptyMap());
    private final Map<ConfigResource.Type, ConfigDef> configDefs;

    public KafkaConfigSchema(Map<ConfigResource.Type, ConfigDef> configDefs) {
        this.configDefs = configDefs;
    }

    public boolean isSplittable(ConfigResource.Type type, String key) {
        ConfigDef configDef = this.configDefs.get(type);
        if (configDef == null) {
            return false;
        }
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(key);
        if (configKey == null) {
            return false;
        }
        return configKey.type == ConfigDef.Type.LIST;
    }

    public boolean isSensitive(ConfigRecord record) {
        ConfigResource.Type type = ConfigResource.Type.forId((byte)record.resourceType());
        return this.isSensitive(type, record.name());
    }

    public boolean isSensitive(ConfigResource.Type type, String key) {
        ConfigDef configDef = this.configDefs.get(type);
        if (configDef == null) {
            return true;
        }
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(key);
        if (configKey == null) {
            return true;
        }
        return configKey.type.isSensitive();
    }

    public String getDefault(ConfigResource.Type type, String key) {
        ConfigDef configDef = this.configDefs.get(type);
        if (configDef == null) {
            return null;
        }
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(key);
        if (configKey == null || !configKey.hasDefault()) {
            return null;
        }
        return ConfigDef.convertToString((Object)configKey.defaultValue, (ConfigDef.Type)configKey.type);
    }
}

