/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.BrokerEndPoint$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.zk.BrokerIdZNode$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005q3AAD\b\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)\u0011\u0007\u0001C\u0001A!)1\u0007\u0001C\u0001A!)Q\u0007\u0001C\u0001A!)q\u0007\u0001C\u0001A!)\u0011\b\u0001C\u0001A!)1\b\u0001C\u0001A!)Q\b\u0001C\u0001A!)q\b\u0001C\u0001A!)\u0011\t\u0001C\u0001A!)1\t\u0001C\u0001A!)Q\t\u0001C\u0005\r\n\u0011\"I]8lKJ,e\u000e\u001a)pS:$H+Z:u\u0015\t\u0001\u0012#A\u0004dYV\u001cH/\u001a:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\b\u0002#Q,7\u000f\u001e%bg\"\fe\u000eZ#rk\u0006d7\u000fF\u0001\"!\t1\"%\u0003\u0002$/\t!QK\\5uQ\t\u0011Q\u0005\u0005\u0002'_5\tqE\u0003\u0002)S\u0005\u0019\u0011\r]5\u000b\u0005)Z\u0013a\u00026va&$XM\u001d\u0006\u0003Y5\nQA[;oSRT\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019(\u0005\u0011!Vm\u001d;\u00023Q,7\u000f\u001e$s_6T5o\u001c8GkR,(/\u001a,feNLwN\u001c\u0015\u0003\u0007\u0015\na\u0002^3ti\u001a\u0013x.\u001c&t_:4&\u0007\u000b\u0002\u0005K\u0005qA/Z:u\rJ|WNS:p]Z\u000b\u0004FA\u0003&\u00039!Xm\u001d;Ge>l'j]8o-NB#AB\u0013\u00025Q,7\u000f\u001e$s_6T5o\u001c8Wi]KG\u000f\u001b(vY2\u0014\u0016mY6)\u0005\u001d)\u0013\u0001\u0007;fgR4%o\\7Kg>tg\u000bN,ji\"tuNU1dW\"\u0012\u0001\"J\u0001\u001di\u0016\u001cHO\u0012:p[*\u001bxN\u001c,5/&$\bNT8GK\u0006$XO]3tQ\tIQ%\u0001\buKN$hI]8n\u0015N|gNV\u001b)\u0005))\u0013!\u0007;fgR\u0014%o\\6fe\u0016sG\r]8j]R4%o\\7Ve&D#aC\u0013\u0002'Q,7\u000f^#oIB|\u0017N\u001c;Ge>lWK]5)\u00051)\u0013a\u00049beN,'I]8lKJT5o\u001c8\u0015\u0007\u001dSu\n\u0005\u0002\u001f\u0011&\u0011\u0011j\u0004\u0002\u0007\u0005J|7.\u001a:\t\u000b-k\u0001\u0019\u0001'\u0002\u0005%$\u0007C\u0001\fN\u0013\tquCA\u0002J]RDQ\u0001U\u0007A\u0002E\u000b!B[:p]N#(/\u001b8h!\t\u0011\u0016L\u0004\u0002T/B\u0011AkF\u0007\u0002+*\u0011akE\u0001\u0007yI|w\u000e\u001e \n\u0005a;\u0012A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001W\f")
public class BrokerEndPointTest {
    @Test
    public void testHashAndEquals() {
        BrokerEndPoint broker1 = new BrokerEndPoint(1, "myhost", 9092);
        BrokerEndPoint broker2 = new BrokerEndPoint(1, "myhost", 9092);
        BrokerEndPoint broker3 = new BrokerEndPoint(2, "myhost", 1111);
        BrokerEndPoint broker4 = new BrokerEndPoint(1, "other", 1111);
        Assertions.assertEquals((Object)broker1, (Object)broker2);
        Assertions.assertNotEquals((Object)broker1, (Object)broker3);
        Assertions.assertNotEquals((Object)broker1, (Object)broker4);
        Assertions.assertEquals((int)broker1.hashCode(), (int)broker2.hashCode());
        Assertions.assertNotEquals((int)broker1.hashCode(), (int)broker3.hashCode());
        Assertions.assertNotEquals((int)broker1.hashCode(), (int)broker4.hashCode());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker1), (Object)BoxesRunTime.boxToInteger((int)1))}))).get((Object)broker1));
    }

    @Test
    public void testFromJsonFutureVersion() {
        String brokerInfoStr = "{\n      \"foo\":\"bar\",\n      \"version\":100,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"SSL://localhost:9093\"]\n    }";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        Assertions.assertEquals((Object)"localhost", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9093, (int)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV2() {
        String brokerInfoStr = "{\n      \"version\":2,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"PLAINTEXT://localhost:9092\"]\n    }";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        Assertions.assertEquals((Object)"localhost", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV1() {
        String brokerInfoStr = "{\"jmx_port\":-1,\"timestamp\":\"1420485325400\",\"host\":\"172.16.8.243\",\"version\":1,\"port\":9091}";
        Broker broker = this.parseBrokerJson(1, brokerInfoStr);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        Assertions.assertEquals((Object)"172.16.8.243", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9091, (int)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV3() {
        String json = "{\n      \"version\":3,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"PLAINTEXT://host1:9092\", \"SSL://host1:9093\"],\n      \"rack\":\"dc1\"\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9093, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)new Some((Object)"dc1"), (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNullRack() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"},\n      \"rack\":null\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNoRack() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"}\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNoFeatures() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"},\n      \"rack\":\"dc1\"\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)new Some((Object)"dc1"), (Object)broker.rack());
        Assertions.assertEquals((Object)Features.emptySupportedFeatures(), (Object)broker.features());
    }

    @Test
    public void testFromJsonV5() {
        String json = "{\n      \"version\":5,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"},\n      \"rack\":\"dc1\",\n      \"features\": {\"feature1\": {\"min_version\": 1, \"max_version\": 2}, \"feature2\": {\"min_version\": 2, \"max_version\": 4}}\n    }";
        Broker broker = this.parseBrokerJson(1, json);
        Assertions.assertEquals((int)1, (int)broker.id());
        BrokerEndPoint brokerEndPoint = broker.brokerEndPoint(new ListenerName("CLIENT"));
        Assertions.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assertions.assertEquals((int)9092, (int)brokerEndPoint.port());
        Assertions.assertEquals((Object)new Some((Object)"dc1"), (Object)broker.rack());
        Assertions.assertEquals((Object)Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature1"), (Object)new SupportedVersionRange(1, 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature2"), (Object)new SupportedVersionRange(2, 4))}))).asJava()), (Object)broker.features());
    }

    @Test
    public void testBrokerEndpointFromUri() {
        String connectionString = "localhost:9092";
        BrokerEndPoint endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assertions.assertEquals((Object)"localhost", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        connectionString = "local_host:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assertions.assertEquals((Object)"local_host", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        connectionString = "[::1]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assertions.assertEquals((Object)"::1", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        connectionString = "[fe80::b1da:69ca:57f7:63d8%3]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assertions.assertEquals((Object)"fe80::b1da:69ca:57f7:63d8%3", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        connectionString = "MyHostname:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assertions.assertEquals((Object)"MyHostname", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
    }

    @Test
    public void testEndpointFromUri() {
        String connectionString = "PLAINTEXT://localhost:9092";
        EndPoint endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)"localhost", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        Assertions.assertEquals((Object)"PLAINTEXT://localhost:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://local_host:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)"local_host", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        Assertions.assertEquals((Object)"PLAINTEXT://local_host:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assertions.assertNull((Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        Assertions.assertEquals((Object)"PLAINTEXT://:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://[::1]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)"::1", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        Assertions.assertEquals((Object)"PLAINTEXT://[::1]:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)"fe80::b1da:69ca:57f7:63d8%3", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        Assertions.assertEquals((Object)"PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://MyHostname:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)"MyHostname", (Object)endpoint.host());
        Assertions.assertEquals((int)9092, (int)endpoint.port());
        Assertions.assertEquals((Object)"PLAINTEXT://MyHostname:9092", (Object)endpoint.connectionString());
    }

    private Broker parseBrokerJson(int id, String jsonString) {
        return BrokerIdZNode$.MODULE$.decode(id, jsonString.getBytes(StandardCharsets.UTF_8)).broker();
    }
}

