/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.BrokerMetadata;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.ZkMetadataCache$MetadataSnapshot$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011Ma\u0001\u0002$H\u00011C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\u0006C\u0002!\tA\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019\u0019\b\u0001)A\u0005O\"9A\u000f\u0001a\u0001\n\u0013)\b\"\u0003B.\u0001\u0001\u0007I\u0011\u0002B/\u0011\u001d\u00119\u0007\u0001Q!\nYD\u0011B!\u001d\u0001\u0005\u0004%IAa\u001d\t\u0011\t\u0005\u0005\u0001)A\u0005\u0005kBqAa!\u0001\t\u0013\u0011)\tC\u0004\u0003&\u0002!IAa*\t\u000f\t=\u0007\u0001\"\u0003\u0003R\"9!\u0011\u001c\u0001\u0005\n\tm\u0007b\u0002Bs\u0001\u0011\u0005!q\u001d\u0005\n\u0007\u000b\u0001\u0011\u0013!C\u0001\u0007\u000fA\u0011ba\u0003\u0001#\u0003%\taa\u0002\t\u000f\r5\u0001\u0001\"\u0011\u0004\u0010!91\u0011\u0003\u0001\u0005B\rM\u0001bBB\u0007\u0001\u0011%1\u0011\u0005\u0005\b\u0007K\u0001A\u0011BB\u0014\u0011\u001d\u0019i\u0003\u0001C\u0001\u0007_Aqaa\r\u0001\t\u0003\u001a)\u0004C\u0004\u0004:\u0001!\tea\u000f\t\u000f\r-\u0003\u0001\"\u0011\u0004N!911\u000b\u0001\u0005B\rU\u0003bBB.\u0001\u0011%1Q\f\u0005\b\u0007W\u0002A\u0011AB7\u0011\u001d\u0019)\b\u0001C\u0001\u0007oBqaa\u001f\u0001\t\u0003\u0019i\bC\u0004\u0004\u0006\u0002!\taa\"\t\u000f\rE\u0005\u0001\"\u0001\u0002\n\"911\u0013\u0001\u0005\u0002\rU\u0005bBBR\u0001\u0011\u00051Q\u0015\u0005\b\u0007{\u0003A\u0011AB`\u0011\u001d\u0019i\f\u0001C\u0001\u0007\u0007Dqaa2\u0001\t\u0013\u0019IM\u0002\u0003y\u0001\u0001K\bBCA\nK\tU\r\u0011\"\u0001\u0002\u0016!Q\u0011\u0011O\u0013\u0003\u0012\u0003\u0006I!a\u0006\t\u0015\u0005MTE!f\u0001\n\u0003\t)\b\u0003\u0006\u0002\u0006\u0016\u0012\t\u0012)A\u0005\u0003oB!\"a\"&\u0005+\u0007I\u0011AAE\u0011)\t\t*\nB\tB\u0003%\u00111\u0012\u0005\u000b\u0003'+#Q3A\u0005\u0002\u0005U\u0005BCASK\tE\t\u0015!\u0003\u0002\u0018\"Q\u0011qU\u0013\u0003\u0016\u0004%\t!!+\t\u0015\u0005\u0015WE!E!\u0002\u0013\tY\u000b\u0003\u0004bK\u0011\u0005\u0011q\u0019\u0005\n\u0003',\u0013\u0011!C\u0001\u0003+D\u0011\"!9&#\u0003%\t!a9\t\u0013\u0005eX%%A\u0005\u0002\u0005m\b\"CA\u0000KE\u0005I\u0011\u0001B\u0001\u0011%\u0011)!JI\u0001\n\u0003\u00119\u0001C\u0005\u0003\f\u0015\n\n\u0011\"\u0001\u0003\u000e!I!\u0011C\u0013\u0002\u0002\u0013\u0005#1\u0003\u0005\n\u0005?)\u0013\u0011!C\u0001\u0005CA\u0011Ba\t&\u0003\u0003%\tA!\n\t\u0013\tER%!A\u0005B\tM\u0002\"\u0003B\u001eK\u0005\u0005I\u0011\u0001B\u001f\u0011%\u00119%JA\u0001\n\u0003\u0012I\u0005C\u0005\u0003N\u0015\n\t\u0011\"\u0011\u0003P!I!\u0011K\u0013\u0002\u0002\u0013\u0005#1\u000b\u0005\n\u0005+*\u0013\u0011!C!\u0005/:\u0011ba6\u0001\u0003\u0003E\ta!7\u0007\u0011a\u0004\u0011\u0011!E\u0001\u00077Da!Y!\u0005\u0002\rM\b\"\u0003B)\u0003\u0006\u0005IQ\tB*\u0011%\u0019)0QA\u0001\n\u0003\u001b9\u0010C\u0005\u0005\u0004\u0005\u000b\t\u0011\"!\u0005\u0006\ty!l['fi\u0006$\u0017\r^1DC\u000eDWM\u0003\u0002I\u0013\u000611/\u001a:wKJT\u0011AS\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001QjU,\u0011\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\r\u0005s\u0017PU3g!\t!V+D\u0001H\u0013\t1vIA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u00031nk\u0011!\u0017\u0006\u00035&\u000bQ!\u001e;jYNL!\u0001X-\u0003\u000f1{wmZ5oO\u0006A!M]8lKJLE\r\u0005\u0002O?&\u0011\u0001m\u0014\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002dIB\u0011A\u000b\u0001\u0005\u0006;\n\u0001\rAX\u0001\u0016a\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGj\\2l+\u00059\u0007C\u00015r\u001b\u0005I'B\u00016l\u0003\u0015awnY6t\u0015\taW.\u0001\u0006d_:\u001cWO\u001d:f]RT!A\\8\u0002\tU$\u0018\u000e\u001c\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u0011\u0018N\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003Y\u0001\u0018M\u001d;ji&|g.T3uC\u0012\fG/\u0019'pG.\u0004\u0013\u0001E7fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u+\u00051\bCA<&\u001b\u0005\u0001!\u0001E'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u'\u0011)SJ_?\u0011\u00059[\u0018B\u0001?P\u0005\u001d\u0001&o\u001c3vGR\u00042A`A\u0007\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA&\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0016bAA\u0006\u001f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1!a\u0003P\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001cXCAA\f!!\tI\"a\t\u0002(\u0005]RBAA\u000e\u0015\u0011\ti\"a\b\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011E(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002&\u0005m!!C!osJ+g-T1q!\u0011\tI#!\r\u000f\t\u0005-\u0012Q\u0006\t\u0004\u0003\u0003y\u0015bAA\u0018\u001f\u00061\u0001K]3eK\u001aLA!a\r\u00026\t11\u000b\u001e:j]\u001eT1!a\fP!\u0019\tI\"!\u000f\u0002>%!\u00111HA\u000e\u0005\u001dauN\\4NCB\u0004B!a\u0010\u0002l9!\u0011\u0011IA3\u001d\u0011\t\u0019%a\u0018\u000f\t\u0005\u0015\u0013\u0011\f\b\u0005\u0003\u000f\n)F\u0004\u0003\u0002J\u0005=c\u0002BA\u0001\u0003\u0017J!!!\u0014\u0002\u0007=\u0014x-\u0003\u0003\u0002R\u0005M\u0013AB1qC\u000eDWM\u0003\u0002\u0002N%\u0019!*a\u0016\u000b\t\u0005E\u00131K\u0005\u0005\u00037\ni&\u0001\u0004d_6lwN\u001c\u0006\u0004\u0015\u0006]\u0013\u0002BA1\u0003G\nq!\\3tg\u0006<WM\u0003\u0003\u0002\\\u0005u\u0013\u0002BA4\u0003S\n\u0011$\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR1uC*!\u0011\u0011MA2\u0013\u0011\ti'a\u001c\u00039U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000b^1uK*!\u0011qMA5\u0003A\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001c\b%\u0001\u0005u_BL7-\u00133t+\t\t9\b\u0005\u0005\u0002*\u0005e\u0014qEA?\u0013\u0011\tY(!\u000e\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0000\u0005\u0005UBAA2\u0013\u0011\t\u0019)a\u0019\u0003\tU+\u0018\u000eZ\u0001\ni>\u0004\u0018nY%eg\u0002\nAbY8oiJ|G\u000e\\3s\u0013\u0012,\"!a#\u0011\t9\u000biIX\u0005\u0004\u0003\u001f{%AB(qi&|g.A\u0007d_:$(o\u001c7mKJLE\rI\u0001\rC2Lg/\u001a\"s_.,'o]\u000b\u0003\u0003/\u0003b!!\u0007\u0002:\u0005e\u0005\u0003BAN\u0003Ck!!!(\u000b\u0007\u0005}\u0015*A\u0004dYV\u001cH/\u001a:\n\t\u0005\r\u0016Q\u0014\u0002\u0007\u0005J|7.\u001a:\u0002\u001b\u0005d\u0017N^3Ce>\\WM]:!\u0003)\tG.\u001b<f\u001d>$Wm]\u000b\u0003\u0003W\u0003b!!\u0007\u0002:\u00055\u0006\u0003CAX\u0003c\u000b\u0019,a0\u000e\u0005\u0005}\u0011\u0002BA>\u0003?\u0001B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000b\u0019'A\u0004oKR<xN]6\n\t\u0005u\u0016q\u0017\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0003\u007f\n\t-\u0003\u0003\u0002D\u0006\r$\u0001\u0002(pI\u0016\f1\"\u00197jm\u0016tu\u000eZ3tAQYa/!3\u0002L\u00065\u0017qZAi\u0011\u001d\t\u0019\u0002\ra\u0001\u0003/Aq!a\u001d1\u0001\u0004\t9\bC\u0004\u0002\bB\u0002\r!a#\t\u000f\u0005M\u0005\u00071\u0001\u0002\u0018\"9\u0011q\u0015\u0019A\u0002\u0005-\u0016\u0001B2paf$2B^Al\u00033\fY.!8\u0002`\"I\u00111C\u0019\u0011\u0002\u0003\u0007\u0011q\u0003\u0005\n\u0003g\n\u0004\u0013!a\u0001\u0003oB\u0011\"a\"2!\u0003\u0005\r!a#\t\u0013\u0005M\u0015\u0007%AA\u0002\u0005]\u0005\"CATcA\u0005\t\u0019AAV\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!:+\t\u0005]\u0011q]\u0016\u0003\u0003S\u0004B!a;\u0002v6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0A\u0005v]\u000eDWmY6fI*\u0019\u00111_(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002x\u00065(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u007fU\u0011\t9(a:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0001\u0016\u0005\u0003\u0017\u000b9/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t%!\u0006BAL\u0003O\fabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003\u0010)\"\u00111VAt\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0003\t\u0005\u0005/\u0011i\"\u0004\u0002\u0003\u001a)\u0019!1D8\u0002\t1\fgnZ\u0005\u0005\u0003g\u0011I\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001_\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\n\u0003.A\u0019aJ!\u000b\n\u0007\t-rJA\u0002B]fD\u0001Ba\f:\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tU\u0002CBAX\u0005o\u00119#\u0003\u0003\u0003:\u0005}!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0010\u0003FA\u0019aJ!\u0011\n\u0007\t\rsJA\u0004C_>dW-\u00198\t\u0013\t=2(!AA\u0002\t\u001d\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u0006\u0003L!A!q\u0006\u001f\u0002\u0002\u0003\u0007a,\u0001\u0005iCND7i\u001c3f)\u0005q\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tU\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0003@\te\u0003\"\u0003B\u0018\u007f\u0005\u0005\t\u0019\u0001B\u0014\u0003QiW\r^1eCR\f7K\\1qg\"|Go\u0018\u0013fcR!!q\fB3!\rq%\u0011M\u0005\u0004\u0005Gz%\u0001B+oSRD\u0001Ba\f\u0007\u0003\u0003\u0005\rA^\u0001\u0012[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R\u0004\u0003fA\u0004\u0003lA\u0019aJ!\u001c\n\u0007\t=tJ\u0001\u0005w_2\fG/\u001b7f\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0003\u0005k\u0002BAa\u001e\u0003~5\u0011!\u0011\u0010\u0006\u0004\u0005wJ\u0015AC2p]R\u0014x\u000e\u001c7fe&!!q\u0010B=\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b%\u0001\rnCf\u0014WMR5mi\u0016\u0014\u0018\t\\5wKJ+\u0007\u000f\\5dCN$\"Ba\"\u0003\u0016\ne%Q\u0014BQ!\u0019\u0011IIa#\u0003\u00106\tQ.C\u0002\u0003\u000e6\u0014A\u0001T5tiB!!q\u0003BI\u0013\u0011\u0011\u0019J!\u0007\u0003\u000f%sG/Z4fe\"1!q\u0013\u0006A\u0002Y\f\u0001b\u001d8baNDw\u000e\u001e\u0005\b\u00057S\u0001\u0019\u0001BD\u0003\u001d\u0011'o\\6feNDqAa(\u000b\u0001\u0004\t\u0019,\u0001\u0007mSN$XM\\3s\u001d\u0006lW\rC\u0004\u0003$*\u0001\rAa\u0010\u00025\u0019LG\u000e^3s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\u0002)\u001d,G\u000fU1si&$\u0018n\u001c8NKR\fG-\u0019;b)1\u0011IKa0\u0003B\n\u0015'q\u0019Bf!\u0015q\u0015Q\u0012BV!\u0015q(Q\u0016BY\u0013\u0011\u0011y+!\u0005\u0003\u0011%#XM]1cY\u0016\u0004BAa-\u0003::!\u0011\u0011\tB[\u0013\u0011\u00119,!\u001b\u0002)5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011YL!0\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0005o\u000bI\u0007\u0003\u0004\u0003\u0018.\u0001\rA\u001e\u0005\b\u0005\u0007\\\u0001\u0019AA\u0014\u0003\u0015!x\u000e]5d\u0011\u001d\u0011yj\u0003a\u0001\u0003gCqA!3\f\u0001\u0004\u0011y$A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bb\u0002Bg\u0017\u0001\u0007!qH\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\tiCN\fE.\u001b<f\u000b:$\u0007o\\5oiRA!q\bBj\u0005+\u00149\u000e\u0003\u0004\u0003\u00182\u0001\rA\u001e\u0005\u0006;2\u0001\rA\u0018\u0005\b\u0005?c\u0001\u0019AAZ\u0003A9W\r^!mSZ,WI\u001c3q_&tG\u000f\u0006\u0005\u0003^\n}'\u0011\u001dBr!\u0015q\u0015QRA`\u0011\u0019\u00119*\u0004a\u0001m\")Q,\u0004a\u0001=\"9!qT\u0007A\u0002\u0005M\u0016\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\u0011IO!>\u0003\u0000\u000e\u000511\u0001\t\u0007\u0003_\u0013YOa<\n\t\t5\u0018q\u0004\u0002\u0004'\u0016\f\b\u0003\u0002BZ\u0005cLAAa=\u0003>\n)R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a+pa&\u001c\u0007b\u0002B|\u001d\u0001\u0007!\u0011`\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005=&1`A\u0014\u0013\u0011\u0011i0a\b\u0003\u0007M+G\u000fC\u0004\u0003 :\u0001\r!a-\t\u0013\t%g\u0002%AA\u0002\t}\u0002\"\u0003Bg\u001dA\u0005\t\u0019\u0001B \u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019IA\u000b\u0003\u0003@\u0005\u001d\u0018AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\"\u0014\u0001D4fi\u0006cG\u000eV8qS\u000e\u001cHC\u0001B}\u0003I9W\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\t\rU1Q\u0004\t\u0007\u0003_\u0013Ypa\u0006\u0011\t\u0005}4\u0011D\u0005\u0005\u00077\t\u0019G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\r}!\u00031\u0001\u0002(\u0005IAo\u001c9jG:\u000bW.\u001a\u000b\u0005\u0005s\u001c\u0019\u0003\u0003\u0004\u0003\u0018N\u0001\rA^\u0001\u0011O\u0016$\u0018\t\u001c7QCJ$\u0018\u000e^5p]N$Ba!\u000b\u0004,AA\u0011\u0011FA=\u0007/\ti\u0004\u0003\u0004\u0003\u0018R\u0001\rA^\u0001\u0015O\u0016$hj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY:\u0015\t\te8\u0011\u0007\u0005\b\u0005o,\u0002\u0019\u0001B}\u00039A\u0017m]!mSZ,'I]8lKJ$BAa\u0010\u00048!)QL\u0006a\u0001=\u0006yq-\u001a;BY&4XM\u0011:pW\u0016\u00148\u000f\u0006\u0002\u0004>A)aP!,\u0004@A!1\u0011IB$\u001b\t\u0019\u0019EC\u0002\u0004F%\u000bQ!\u00193nS:LAa!\u0013\u0004D\tq!I]8lKJlU\r^1eCR\f\u0017AE4fi\u0006c\u0017N^3Ce>\\WM\u001d(pI\u0016$bA!8\u0004P\rE\u0003\"B/\u0019\u0001\u0004q\u0006b\u0002BP1\u0001\u0007\u00111W\u0001\u0014O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$Wm\u001d\u000b\u0005\u0007/\u001aI\u0006E\u0003\u007f\u0005[\u000by\fC\u0004\u0003 f\u0001\r!a-\u00021\u0005$Gm\u0014:Va\u0012\fG/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0006\u0003`\r}3\u0011MB2\u0007OBq!a\u0005\u001b\u0001\u0004\t9\u0002C\u0004\u0003Dj\u0001\r!a\n\t\r\r\u0015$\u00041\u0001_\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\r%$\u00041\u0001\u0002>\u0005I1\u000f^1uK&sgm\\\u0001\u0011O\u0016$\b+\u0019:uSRLwN\\%oM>$baa\u001c\u0004r\rM\u0004#\u0002(\u0002\u000e\u0006u\u0002b\u0002Bb7\u0001\u0007\u0011q\u0005\u0005\u0007\u0007KZ\u0002\u0019\u00010\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t)\u0011\tYi!\u001f\t\u000f\t\rG\u00041\u0001\u0002(\u0005Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA!Q\\B@\u0007\u0003\u001b\u0019\tC\u0004\u0003Dv\u0001\r!a\n\t\r\r\u0015T\u00041\u0001_\u0011\u001d\u0011y*\ba\u0001\u0003g\u000bAdZ3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000f\u0006\u0004\u0004\n\u000e-5q\u0012\t\b\u0003S\tIHXA`\u0011\u001d\u0019iI\ba\u0001\u0007/\t!\u0001\u001e9\t\u000f\t}e\u00041\u0001\u00024\u0006yq-\u001a;D_:$(o\u001c7mKJLE-\u0001\nhKR\u001cE.^:uKJlU\r^1eCR\fGCBBL\u0007;\u001b\t\u000b\u0005\u0003\u0002\u0000\re\u0015\u0002BBN\u0003G\u0012qa\u00117vgR,'\u000fC\u0004\u0004 \u0002\u0002\r!a\n\u0002\u0013\rdWo\u001d;fe&#\u0007b\u0002BPA\u0001\u0007\u00111W\u0001\u000fkB$\u0017\r^3NKR\fG-\u0019;b)\u0019\u00199k!+\u0004.B1\u0011q\u0016Bv\u0007/Aaaa+\"\u0001\u0004q\u0016!D2peJ,G.\u0019;j_:LE\rC\u0004\u00040\u0006\u0002\ra!-\u0002+U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiB!11WB]\u001b\t\u0019)L\u0003\u0003\u00048\u0006\r\u0014\u0001\u0003:fcV,7\u000f^:\n\t\rm6Q\u0017\u0002\u0016+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0003!\u0019wN\u001c;bS:\u001cH\u0003\u0002B \u0007\u0003DqAa1#\u0001\u0004\t9\u0003\u0006\u0003\u0003@\r\u0015\u0007bBBGG\u0001\u00071qC\u0001\u0014e\u0016lwN^3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u000b\u0005\u007f\u0019Ym!4\u0004T\u000eU\u0007bBA\nI\u0001\u0007\u0011q\u0003\u0005\b\u0003g\"\u0003\u0019ABh!!\tIb!5\u0002(\u0005u\u0014\u0002BA>\u00037AqAa1%\u0001\u0004\t9\u0003\u0003\u0004\u0004f\u0011\u0002\rAX\u0001\u0011\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R\u0004\"a^!\u0014\u000b\u0005\u001bin!;\u0011\u001f\r}7Q]A\f\u0003o\nY)a&\u0002,Zl!a!9\u000b\u0007\r\rx*A\u0004sk:$\u0018.\\3\n\t\r\u001d8\u0011\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,\u0004\u0003BBv\u0007cl!a!<\u000b\u0007\r=x.\u0001\u0002j_&!\u0011qBBw)\t\u0019I.A\u0003baBd\u0017\u0010F\u0006w\u0007s\u001cYp!@\u0004\u0000\u0012\u0005\u0001bBA\n\t\u0002\u0007\u0011q\u0003\u0005\b\u0003g\"\u0005\u0019AA<\u0011\u001d\t9\t\u0012a\u0001\u0003\u0017Cq!a%E\u0001\u0004\t9\nC\u0004\u0002(\u0012\u0003\r!a+\u0002\u000fUt\u0017\r\u001d9msR!Aq\u0001C\b!\u0015q\u0015Q\u0012C\u0005!5qE1BA\f\u0003o\nY)a&\u0002,&\u0019AQB(\u0003\rQ+\b\u000f\\36\u0011!!\t\"RA\u0001\u0002\u00041\u0018a\u0001=%a\u0001")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        CollectionConverters$.MODULE$.ListHasAsScala(brokers).asScala().foreach((Function1 & Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable)partitions -> (scala.collection.mutable.Iterable)partitions.map((Function1 & Serializable)x0$1 -> {
            Errors errors;
            if (x0$1 == null) throw new MatchError(null);
            long partitionId = x0$1._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            List replicas = partitionState.replicas();
            List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
            List isr = partitionState.isr();
            List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
            List offlineReplicas = partitionState.offlineReplicas();
            if (None$.MODULE$.equals(maybeLeader)) {
                Errors errors2;
                if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors2 = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").toString()).append(new StringBuilder(20).append("not found on leader ").append(leaderBrokerId).toString()).toString());
                    errors2 = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors2;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
            }
            if (!(maybeLeader instanceof Some)) throw new MatchError(maybeLeader);
            if (filteredReplicas.size() < replicas.size()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(74).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").toString()).append(new StringBuilder(18).append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString()).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else if (filteredIsr.size() < isr.size()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(82).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").toString()).append(new StringBuilder(18).append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(isr).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString()).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else {
                errors = Errors.NONE;
            }
            Errors error = errors;
            return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
        }));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return ((IterableOnceOps)((MapOps)this.metadataSnapshot().partitionStates().getOrElse((Object)topicName, (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).values().map((Function1 & Serializable)p -> new TopicPartition(topicName, p.partitionIndex()))).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                long partition = x0$2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple2;
            });
            return map;
        }, DummyImplicit$.MODULE$.dummyImplicit()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.diff(this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).flatMap((Function1 & Serializable)x$4 -> x$4.getNode(listenerName));
    }

    @Override
    public Iterable<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().flatMap((Function1 & Serializable)x$5 -> x$5.getNode(listenerName));
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$6 -> x$6.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$8 -> x$8.get((long)partitionId)).map((Function1 & Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                node = (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable)x$9 -> x$9.get((long)tp.partition())).map((Function1 & Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicaIds).asScala().map((Function1 & Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = snapshot.aliveNodes().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long id = x0$1._1$mcJ$sp();
            Option option = ((Map)x0$1._2()).get((Object)listenerName).map((Function1 & Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node));
            return option;
        });
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((IterableOps)this.getAllPartitions(snapshot).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1 & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$3._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.replicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.isr()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(state.offlineReplicas()).asScala().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        });
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = CollectionConverters$.MODULE$.SetHasAsJava((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$9(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.BufferHasAsJava(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        Lock inWriteLock_inLock_lock = this.partitionMetadataLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, topicIds, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair == null) {
            throw new MatchError(null);
        }
        boolean bl = !((Node)pair._2()).isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$9(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$5(listeners, x$10)))) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Tuple2 x$11) {
        Object object = x$11._2();
        Uuid uuid = Uuid.ZERO_UUID;
        return object == null ? uuid != null : !object.equals(uuid);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$9(AnyRefMap partitionStates$1, String topic, LongMap oldPartitionStates) {
        LongMap copy = new LongMap(oldPartitionStates.size());
        copy.$plus$plus$eq((IterableOnce)oldPartitionStates);
        partitionStates$1.update((Object)topic, (Object)copy);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port()));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
            aliveNodes.update((long)broker.id(), (Object)CollectionConverters$.MODULE$.MapHasAsScala(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$4($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map newTopicIds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(updateMetadataRequest$1.topicStates()).asScala().map((Function1 & Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()))).filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$8(x$11)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map topicIds = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        topicIds.$plus$plus$eq((IterableOnce)newTopicIds);
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, $this.metadataSnapshot().partitionStates(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            $this.metadataSnapshot().partitionStates().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(topic, oldPartitionStates) -> {
                ZkMetadataCache.$anonfun$updateMetadata$9(partitionStates, topic, oldPartitionStates);
                return BoxedUnit.UNIT;
            }, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable newStates = CollectionConverters$.MODULE$.IterableHasAsScala(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    $this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(69).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").toString()).append(new StringBuilder(55).append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString()).toString());
                    }
                    return deletedPartitions.$plus$eq((Object)tp);
                }
                $this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                if (traceEnabled) {
                    $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(50).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").toString()).append(new StringBuilder(70).append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString()).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(60).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").toString()).append(new StringBuilder(85).append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString()).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
        }
        return true;
    }

    public ZkMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ ZkMetadataCache $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$2() {
            return this.topicIds();
        }

        public Option<Object> copy$default$3() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$4() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$5() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicIds();
                }
                case 2: {
                    return this.controllerId();
                }
                case 3: {
                    return this.aliveBrokers();
                }
                case 4: {
                    return this.aliveNodes();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "partitionStates";
                }
                case 1: {
                    return "topicIds";
                }
                case 2: {
                    return "controllerId";
                }
                case 3: {
                    return "aliveBrokers";
                }
                case 4: {
                    return "aliveNodes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)x$1).kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
            scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

