/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\tMd\u0001\u0002!B\u0001\u0019CQa\u0016\u0001\u0005\u0002aCQA\u0017\u0001\u0005BmCqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004q\u0001\u0001\u0006I\u0001\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u00191\b\u0001)A\u0005g\"Iq\u000f\u0001a\u0001\u0002\u0004%I\u0001\u001f\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0002\u0003\u0006\u0002\u001e\u0001\u0001\r\u0011!Q!\neD1\"a\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"!Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0011-\t\t\u0005\u0001a\u0001\u0002\u0003\u0006K!a\t\t\u0017\u0005\r\u0003\u00011AA\u0002\u0013%\u0011Q\t\u0005\f\u0003/\u0002\u0001\u0019!a\u0001\n\u0013\tI\u0006C\u0006\u0002^\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0003\u0002CA0\u0001\u0001&I!!\u0019\t\u0011\u00055\u0004\u0001)C\u0005\u0003_B\u0011\"!\u001f\u0001#\u0003%I!a\u001f\t\u000f\u0005E\u0005\u0001\"\u0011\u0002\u0014\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBAa\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003\u0017\u0004A\u0011AA\\\u0011\u001d\ty\r\u0001C\u0001\u0003oCq!a5\u0001\t\u0003\t9\fC\u0004\u0002X\u0002!\t!a.\t\u000f\u0005m\u0007\u0001\"\u0001\u00028\"9\u0011q\u001c\u0001\u0005\u0002\u0005]\u0006bBAr\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003O\u0004A\u0011AA\\\u0011\u001d\tY\u000f\u0001C\u0001\u0003oCq!a<\u0001\t\u0003\t9\fC\u0004\u0002t\u0002!\t!a.\t\u000f\u0005]\b\u0001\"\u0001\u00028\"9\u00111 \u0001\u0005\u0002\u0005]\u0006bBA\u0000\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0005\u0007\u0001A\u0011AA\\\u0011\u001d\u00119\u0001\u0001C\u0001\u0003oCqAa\u0003\u0001\t\u0003\t9\fC\u0004\u0003\u0010\u0001!\t!a.\t\u000f\tM\u0001\u0001\"\u0001\u00028\"9!q\u0003\u0001\u0005\u0002\u0005]\u0006b\u0002B\u000e\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0005?\u0001A\u0011AA\\\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003oCqAa\n\u0001\t\u0003\t9\fC\u0004\u0003,\u0001!\t!a.\t\u000f\t=\u0002\u0001\"\u0001\u00028\"9!1\u0007\u0001\u0005\u0002\u0005]\u0006b\u0002B\u001c\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0005w\u0001A\u0011AA\\\u0011\u001d\u0011y\u0004\u0001C\u0001\u0003oCqAa\u0011\u0001\t\u0003\t9\fC\u0004\u0003H\u0001!\t!a.\t\u000f\t-\u0003\u0001\"\u0001\u00028\"9!q\n\u0001\u0005\u0002\u0005]\u0006b\u0002B*\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0005/\u0002A\u0011AA\\\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0003oCqAa\u0018\u0001\t\u0003\t9\fC\u0004\u0003d\u0001!\t!a.\t\u000f\t\u001d\u0004\u0001\"\u0001\u00028\"9!1\u000e\u0001\u0005\u0002\u0005]\u0006b\u0002B8\u0001\u0011\u0005\u0011q\u0017\u0002\u001c)>\u0004\u0018nY\"p[6\fg\u000eZ%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\t\u001b\u0015!B1e[&t'\"\u0001#\u0002\u000b-\fgm[1\u0004\u0001M!\u0001aR'T!\tA5*D\u0001J\u0015\tQ5)A\u0006j]R,wM]1uS>t\u0017B\u0001'J\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\bC\u0001(R\u001b\u0005y%B\u0001)D\u0003\u0015)H/\u001b7t\u0013\t\u0011vJA\u0004M_\u001e<\u0017N\\4\u0011\u0005Q+V\"A!\n\u0005Y\u000b%!\u0004*bG.\fu/\u0019:f)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00023B\u0011A\u000bA\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tA\fE\u0002^E\u0012l\u0011A\u0018\u0006\u0003?\u0002\f!bY8mY\u0016\u001cG/[8o\u0015\u0005\t\u0017!B:dC2\f\u0017BA2_\u0005\r\u0019V-\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003O\u000e\u000baa]3sm\u0016\u0014\u0018BA5g\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u0005a\u0007CA7o\u001b\u0005\u0001\u0017BA8a\u0005\rIe\u000e^\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003a!WMZ1vYR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u000b\u0002gB\u0011Q\u000e^\u0005\u0003k\u0002\u0014Qa\u00155peR\f\u0011\u0004Z3gCVdGOU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005aAo\u001c9jGN+'O^5dKV\t\u0011\u0010E\u0002{\u0003\u0013q1a_A\u0003\u001d\ra\u00181\u0001\b\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005},\u0015A\u0002\u001fs_>$h(C\u0001E\u0013\t\u00115)C\u0002\u0002\b\u0005\u000bA\u0002V8qS\u000e\u001cu.\\7b]\u0012LA!a\u0003\u0002\u000e\taAk\u001c9jGN+'O^5dK*\u0019\u0011qA!\u0002!Q|\u0007/[2TKJ4\u0018nY3`I\u0015\fH\u0003BA\n\u00033\u00012!\\A\u000b\u0013\r\t9\u0002\u0019\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u001c!\t\t\u00111\u0001z\u0003\rAH%M\u0001\u000ei>\u0004\u0018nY*feZL7-\u001a\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0003\u0003G\u0001B!!\n\u000285\u0011\u0011q\u0005\u0006\u0004\u0005\u0006%\"\u0002BA\u0016\u0003[\tqa\u00197jK:$8OC\u0002E\u0003_QA!!\r\u00024\u00051\u0011\r]1dQ\u0016T!!!\u000e\u0002\u0007=\u0014x-\u0003\u0003\u0002:\u0005\u001d\"!B!e[&t\u0017aD1e[&t7\t\\5f]R|F%Z9\u0015\t\u0005M\u0011q\b\u0005\n\u00037Y\u0011\u0011!a\u0001\u0003G\tA\"\u00193nS:\u001cE.[3oi\u0002\nQ\u0002^3tiR{\u0007/[2OC6,WCAA$!\u0011\tI%!\u0015\u000f\t\u0005-\u0013Q\n\t\u0003{\u0002L1!a\u0014a\u0003\u0019\u0001&/\u001a3fM&!\u00111KA+\u0005\u0019\u0019FO]5oO*\u0019\u0011q\n1\u0002#Q,7\u000f\u001e+pa&\u001cg*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005m\u0003\"CA\u000e\u001d\u0005\u0005\t\u0019AA$\u00039!Xm\u001d;U_BL7MT1nK\u0002\n!c\u0019:fCR,\u0017I\u001c3XC&$Hk\u001c9jGR!\u00111CA2\u0011\u001d\t)\u0007\u0005a\u0001\u0003O\nAa\u001c9ugB\u0019!0!\u001b\n\t\u0005-\u0014Q\u0002\u0002\u0014)>\u0004\u0018nY\"p[6\fg\u000eZ(qi&|gn]\u0001\u0014o\u0006LGOR8s)>\u0004\u0018nY\"sK\u0006$X\r\u001a\u000b\u0007\u0003'\t\t(!\u001e\t\u000f\u0005M\u0014\u00031\u0001\u0002H\u0005IAo\u001c9jG:\u000bW.\u001a\u0005\t\u0003o\n\u0002\u0013!a\u0001Y\u00069A/[7f_V$\u0018!H<bSR4uN\u001d+pa&\u001c7I]3bi\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u$f\u00017\u0002\u0000-\u0012\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003%)hn\u00195fG.,GMC\u0002\u0002\f\u0002\f!\"\u00198o_R\fG/[8o\u0013\u0011\ty)!\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0003tKR,\u0006\u000f\u0006\u0003\u0002\u0014\u0005U\u0005bBAL'\u0001\u0007\u0011\u0011T\u0001\u0005S:4w\u000e\u0005\u0003\u0002\u001c\u0006%VBAAO\u0015\u0011\ty*!)\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002$\u0006\u0015\u0016a\u00026va&$XM\u001d\u0006\u0005\u0003O\u000b\u0019$A\u0003kk:LG/\u0003\u0003\u0002,\u0006u%\u0001\u0003+fgRLeNZ8)\u0007M\ty\u000b\u0005\u0003\u0002\u001c\u0006E\u0016\u0002BAZ\u0003;\u0013!BQ3g_J,W)Y2i\u0003\u0015\u0019Gn\\:f)\t\t\u0019\u0002K\u0002\u0015\u0003w\u0003B!a'\u0002>&!\u0011qXAO\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0006uKN$8I]3bi\u0016D3!FAc!\u0011\tY*a2\n\t\u0005%\u0017Q\u0014\u0002\u0005)\u0016\u001cH/\u0001\fuKN$8I]3bi\u0016<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;tQ\r1\u0012QY\u0001!i\u0016\u001cHo\u0011:fCR,w+\u001b;i\t\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|g\u000eK\u0002\u0018\u0003\u000b\fq\u0004^3ti\u000e\u0013X-\u0019;f/&$\b\u000eR3gCVdG\u000fU1si&$\u0018n\u001c8tQ\rA\u0012QY\u0001\u0016i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0007>tg-[4tQ\rI\u0012QY\u0001\u001ci\u0016\u001cHo\u0011:fCR,w\u000b[3o\u00032\u0014X-\u00193z\u000bbL7\u000f^:)\u0007i\t)-\u0001\u0016uKN$8I]3bi\u0016<\u0006.\u001a8BYJ,\u0017\rZ=Fq&\u001cHo],ji\"LeMT8u\u000bbL7\u000f^:)\u0007m\t)-A\u0010uKN$8I]3bi\u0016<\u0016\u000e\u001e5SKBd\u0017nY1BgNLwM\\7f]RD3\u0001HAc\u0003\u0019\"Xm\u001d;De\u0016\fG/Z,ji\"LeN^1mS\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0015\u0004;\u0005\u0015\u0017a\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3SKBd\u0017nY1uS>tg)Y2u_JD3AHAc\u0003\u0011\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,\u0007+\u0019:uSRLwN\\\"pk:$\bfA\u0010\u0002F\u0006YB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019'fm\u0016d7i\u001c8gS\u001eD3\u0001IAc\u00039!Xm\u001d;MSN$Hk\u001c9jGND3!IAc\u0003u!Xm\u001d;MSN$Hk\u001c9jGN<\u0016\u000e\u001e5J]\u000edW\u000fZ3MSN$\bf\u0001\u0012\u0002F\u0006\tC/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i\u000bb\u001cG.\u001e3f\u0013:$XM\u001d8bY\"\u001a1%!2\u0002/Q,7\u000f^!mi\u0016\u0014\b+\u0019:uSRLwN\\\"pk:$\bf\u0001\u0013\u0002F\u0006\u0019B/Z:u\u00032$XM]!tg&<g.\\3oi\"\u001aQ%!2\u0002gQ,7\u000f^!mi\u0016\u0014\u0018i]:jO:lWM\u001c;XSRDWj\u001c:f\u0003N\u001c\u0018n\u001a8nK:$H\u000b[1o!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u0014\u0002F\u0006\u0019D/Z:u\u00032$XM]!tg&<g.\\3oi^KG\u000f['pe\u0016\u0004\u0016M\u001d;ji&|gn\u001d+iC:\f5o]5h]6,g\u000e\u001e\u0015\u0004O\u0005\u0015\u0017A\t;fgR\fE\u000e^3s/&$\b.\u00138wC2LG\rU1si&$\u0018n\u001c8D_VtG\u000fK\u0002)\u0003\u000b\fQ\u0004^3ti\u0006cG/\u001a:XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u0004S\u0005\u0015\u0017!\u000b;fgR\fE\u000e^3s/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000fK\u0002+\u0003\u000b\f\u0011\u0005^3ti\u000e\u0013X-\u0019;f\u00032$XM\u001d+pa&\u001cw+\u001b;i%\u0006\u001c7.Q<be\u0016D3aKAc\u0003=\"Xm\u001d;D_:4\u0017n\u001a)sKN,'O^1uS>t\u0017i\u0019:pgN\u0004\u0016M\u001d;ji&|g.\u00117uKJ\fG/[8oQ\ra\u0013QY\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e$U\r\\3uS>t\u0007fA\u0017\u0002F\u00069B/Z:u\t\u0016dW\r^3J]R,'O\\1m)>\u0004\u0018n\u0019\u0015\u0004]\u0005\u0015\u0017A\b;fgR$U\r\\3uK^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:uQ\ry\u0013QY\u0001+i\u0016\u001cH\u000fR3mKR,w\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgR<\u0016\u000e\u001e5JM\u0016C\u0018n\u001d;tQ\r\u0001\u0014QY\u0001\ri\u0016\u001cH\u000fR3tGJL'-\u001a\u0015\u0004c\u0005\u0015\u0017\u0001\t;fgR$Um]2sS\n,w\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgRD3AMAc\u00031\"Xm\u001d;EKN\u001c'/\u001b2f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000fK\u00024\u0003\u000b\f\u0011\u0005^3ti\u0012+7o\u0019:jE\u0016,f.\u0019<bS2\f'\r\\3QCJ$\u0018\u000e^5p]ND3\u0001NAc\u0003\u0015\"Xm\u001d;EKN\u001c'/\u001b2f+:$WM\u001d*fa2L7-\u0019;fIB\u000b'\u000f^5uS>t7\u000fK\u00026\u0003\u000b\f\u0011\u0005^3ti\u0012+7o\u0019:jE\u0016,f\u000eZ3s\u001b&t\u0017j\u001d:QCJ$\u0018\u000e^5p]ND3ANAc\u0003\u0005#Xm\u001d;EKN\u001c'/\u001b2f+:$WM\u001d*fa2L7-\u0019;fIB\u000b'\u000f^5uS>t7o\u00165f]J+\u0017m]:jO:lWM\u001c;Jg&s\u0007K]8he\u0016\u001c8\u000fK\u00028\u0003\u000b\fa\u0004^3ti\u0012+7o\u0019:jE\u0016\fE/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:)\u0007a\n)-\u0001\u0014uKN$H)Z:de&\u0014W-\u00168eKJl\u0015N\\%teB\u000b'\u000f^5uS>t7/T5yK\u0012D3!OAc\u0003\r\"Xm\u001d;EKN\u001c'/\u001b2f%\u0016\u0004xN\u001d;Pm\u0016\u0014(/\u001b3eK:\u001cuN\u001c4jOND3AOAc\u00039\"Xm\u001d;EKN\u001c'/\u001b2f\u0003:$G*[:u)>\u0004\u0018nY:XSRDw.\u001e;J]R,'O\\1m)>\u0004\u0018nY:)\u0007m\n)-\u0001\u001fuKN$H)Z:de&\u0014W\rR8fg:{GOR1jY^CWM\u001c'jgRLgn\u001a*fCN\u001c\u0018n\u001a8nK:$\u0018j]+oCV$\bn\u001c:ju\u0016$\u0007f\u0001\u001f\u0002F\u0006YD/Z:u\u0007J,\u0017\r^3U_BL7\rR8fg:{GOU3uef$\u0006N]8ui2LgnZ)v_R\fW\t_2fK\u0012,G-\u0012=dKB$\u0018n\u001c8)\u0007u\n)-A\u001euKN$H)\u001a7fi\u0016$v\u000e]5d\t>,7OT8u%\u0016$(/\u001f+ie>$H\u000f\\5oOF+x\u000e^1Fq\u000e,W\rZ3e\u000bb\u001cW\r\u001d;j_:D3APAc\u0003\u0001#Xm\u001d;De\u0016\fG/\u001a)beRLG/[8og\u0012{Wm\u001d(piJ+GO]=UQJ|G\u000f\u001e7j]\u001e\fVo\u001c;b\u000bb\u001cW-\u001a3fI\u0016C8-\u001a9uS>t\u0007fA \u0002F\u0002")
public class TopicCommandIntegrationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor = (short)1;
    private TopicCommand.TopicService topicService;
    private Admin adminClient;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        String x$2 = this.zkConnect();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$6;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 1;
        boolean bl7 = false;
        int n2 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(6, x$2, bl, bl2, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl3, bl4, bl5, bl6, (Map<Object, String>)x$3, n, bl7, x$4, x$5, n2).map((Function1 & Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        });
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.TopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.TopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), 10000);
    }

    private void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), topicName, 0, timeout);
    }

    private int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        super.setUp(info);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.adminClient_$eq(Admin.create((Properties)props));
        Admin apply_adminClient = this.adminClient();
        Object var3_3 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)2);
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)2);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"}));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateWhenAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
    }

    @Test
    public void testCreateWhenAlreadyExistsWithIfNotExists() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-not-exists"});
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()})));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var1_1 = null;
        Object var2_2 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithIncludeList() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic(topic2, 2, (short)2), new NewTopic(topic3, 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, 10000);
        this.waitForTopicCreated(topic2, 10000);
        this.waitForTopicCreated(topic3, 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_4 = null;
        Object var6_5 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1));
        Assertions.assertTrue((boolean)output.contains(topic2));
        Assertions.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic("__consumer_offsets", 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1));
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        Assertions.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get();
        Assertions.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id())));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicService topicService;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Admin apply_adminClient = this.adminClient();
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(apply_adminClient);
        Object var3_2 = null;
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        Assertions.assertThrows(IllegalArgumentException.class, () -> topicService3.alterTopic(alterOpts));
    }

    @Test
    public void testAlterWhenTopicDoesntExistWithIfExists() {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple2;
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple2;
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertTrue((boolean)props.containsKey(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertTrue((boolean)props.getProperty(cleanupKey).equals(cleanupVal), (String)"Properties after creation have incorrect value");
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertTrue((boolean)newProps.containsKey(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertTrue((boolean)newProps.getProperty(cleanupKey).equals(cleanupVal), (String)"Updated properties have incorrect value");
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, this.servers());
    }

    @Test
    public void testDeleteWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
    }

    @Test
    public void testDeleteWhenTopicDoesntExistWithIfExists() {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_1 = null;
        Object var3_2 = null;
        Object[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)3, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)));
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @Test
    public void testDescribeWhenTopicDoesntExist() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})));
    }

    @Test
    public void testDescribeWhenTopicDoesntExistWithIfExists() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            TopicDescription testTopicDescription = (TopicDescription)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).asScala().apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDescription.partitions()).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$1(x$8))).get()).partition();
            this.killBroker(0);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$7(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var7_6 = null;
            Object var8_7 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$12)));
            TestUtils$.MODULE$.waitForPartitionMetadata(aliveServers, this.testTopicName(), 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var3_2 = null;
            Object var4_3 = null;
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$13)));
            TestUtils$.MODULE$.waitForPartitionMetadata(aliveServers, this.testTopicName(), 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_3 = null;
            Object var5_4 = null;
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress() {
        String string;
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.servers().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$14)));
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).allTopicNames().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDesc.partitions()).asScala().head();
        Buffer replicasOfFirstPartition = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(firstPartition.replicas()).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()));
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableOps)brokerIds.diff((Seq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica)))))).all().get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Reassignment didn't add the second node");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var15_13 = null;
        Object var16_14 = null;
        Object[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(simpleDescribeOutputRows)));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out2.toString();
        Object var18_17 = null;
        Object var19_18 = null;
        string = null;
        String underReplicatedOutput = string2;
        Assertions.assertEquals((Object)"", (Object)underReplicatedOutput, (String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(underReplicatedOutput).append("'").toString());
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Assertions.assertFalse((boolean)Option$.MODULE$.apply((Object)reassignments).forall((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$16))));
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
    }

    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            this.killBroker(1);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--at-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_2 = null;
            Object var5_3 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertEquals((int)1, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList(new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get();
        this.waitForTopicCreated(underMinIsrTopic, 10000);
        this.waitForTopicCreated(notUnderMinIsrTopic, 10000);
        this.waitForTopicCreated(offlineTopic, 10000);
        this.waitForTopicCreated(fullyReplicatedTopic, 10000);
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$17)));
            TestUtils$.MODULE$.waitForPartitionMetadata(aliveServers, underMinIsrTopic, 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var9_7 = null;
            Object var10_8 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assertions.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assertions.assertEquals((int)2, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_2 = null;
        Object var3_3 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config), (String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString());
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_1 = null;
        Object var3_2 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()), (String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString());
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_5 = null;
        Object var6_6 = null;
        output = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized() {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        Admin apply_adminClient = this.adminClient();
        Object var5_1 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)}))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_2 = null;
        Object var3_3 = null;
        Object[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)));
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @Test
    public void testCreateTopicDoesNotRetryThrottlingQuotaExceededException() {
        TopicCommand.TopicService topicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(adminClient);
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        CreateTopicsResult result = AdminClientTestUtils.createTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertThrows(ThrottlingQuotaExceededException.class, () -> topicService3.createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})));
        NewTopic expectedNewTopic = new NewTopic(this.testTopicName(), Optional.empty(), Optional.empty()).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{expectedNewTopic}))).asJava()), (CreateTopicsOptions)ArgumentMatchers.argThat(x$18 -> !x$18.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testDeleteTopicDoesNotRetryThrottlingQuotaExceededException() {
        TopicCommand.TopicService topicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(adminClient);
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        DeleteTopicsResult result = AdminClientTestUtils.deleteTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.deleteTopics((Collection)ArgumentMatchers.any(), (DeleteTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService3.deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).deleteTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)this.testTopicName(), (List)Nil$.MODULE$)).asJavaCollection()), (DeleteTopicsOptions)ArgumentMatchers.argThat(x$19 -> !x$19.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testCreatePartitionsDoesNotRetryThrottlingQuotaExceededException() {
        TopicCommand.TopicService topicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(adminClient);
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(0, new Node(0, "", 0), Collections.emptyList(), Collections.emptyList());
        DescribeTopicsResult describeResult = AdminClientTestUtils.describeTopicsResult((String)this.testTopicName(), (TopicDescription)new TopicDescription(this.testTopicName(), false, Collections.singletonList(topicPartitionInfo)));
        Mockito.when((Object)adminClient.describeTopics((Collection)ArgumentMatchers.any(Collection.class))).thenReturn((Object)describeResult);
        CreatePartitionsResult result = AdminClientTestUtils.createPartitionsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createPartitions((java.util.Map)ArgumentMatchers.any(), (CreatePartitionsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService3.alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"})))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createPartitions((java.util.Map)ArgumentMatchers.argThat(x$20 -> ((NewPartitions)x$20.get(this.testTopicName())).totalCount() == 3), (CreatePartitionsOptions)ArgumentMatchers.argThat(x$21 -> !x$21.shouldRetryOnQuotaViolation()));
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$8) {
        return x$8.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandIntegrationTest $this, MetadataResponseData.MetadataResponseTopic x$10) {
        return x$10.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$11) {
        return x$11.partitionIndex() == partitionOnBroker0$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandIntegrationTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        scala.collection.immutable.Set x$1;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)(x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}))), x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$10))).get()).partitions()).asScala().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$11)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw new AssertionError((Object)"Partition metadata is not found in metadata cache");
        }
        if (!(testPartitionMetadata instanceof Some)) {
            throw new MatchError((Object)testPartitionMetadata);
        }
        MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
        boolean bl = result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandIntegrationTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.servers().filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$3(x$9)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandIntegrationTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$12) {
        return x$12.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$13) {
        return x$13.config().brokerId() == 0;
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaServer x$14) {
        return x$14.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandIntegrationTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$16) {
        return x$16.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$17) {
        return x$17.config().brokerId() == 0;
    }

    public TopicCommandIntegrationTest() {
        this.numPartitions = 1;
    }
}

