/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.network.ConnectionQuotas;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ZkConfigManager;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0005\u0002\u001dBQ!\u000e\u0001\u0005\u0002YBQA\u0019\u0001\u0005\u0002\rDQ\u0001\u001b\u0001\u0005\u0002%DQA\u001c\u0001\u0005\n=Dq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u00111\u0012\u0001\u0005\u0002\u00055\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\ty\u000b\u0001C\u0005\u0003c\u0013q\u0003R=oC6L7mQ8oM&<7\t[1oO\u0016$Vm\u001d;\u000b\u0005]A\u0012AB:feZ,'OC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}A\u0012aC5oi\u0016<'/\u0019;j_:L!!\t\u0010\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\f\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012\u0001\u000b\t\u0004SA\u0012T\"\u0001\u0016\u000b\u0005-b\u0013!C5n[V$\u0018M\u00197f\u0015\tic&\u0001\u0006d_2dWm\u0019;j_:T\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c)\u0012A\u0001T5tiB\u0011QeM\u0005\u0003iY\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006\u0001B/Z:u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0003om\u0002\"\u0001O\u001d\u000e\u00039J!A\u000f\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006y\r\u0001\r!P\u0001\u0007cV|'/^7\u0011\u0005y*eBA D!\t\u0001e&D\u0001B\u0015\t\u0011%$\u0001\u0004=e>|GOP\u0005\u0003\t:\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011AI\f\u0015\u0005\u0007%;\u0006\f\u0005\u0002K+6\t1J\u0003\u0002M\u001b\u0006A\u0001O]8wS\u0012,'O\u0003\u0002O\u001f\u00061\u0001/\u0019:b[NT!\u0001U)\u0002\u000f),\b/\u001b;fe*\u0011!kU\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002)\u0006\u0019qN]4\n\u0005Y[%a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002Z7\u0006\n!,\u0001\u0002{W\u0006\nA,A\u0003le\u00064G\u000f\u000b\u0002\u0004=B\u0011q\fY\u0007\u0002\u001b&\u0011\u0011-\u0014\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\b;fgR$\u0015P\\1nS\u000e$v\u000e]5d\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0003o\u0011DQ\u0001\u0010\u0003A\u0002uBC\u0001B%XM2\u0012\u0011l\u0017\u0015\u0003\ty\u000ba\u0004^3ti6+7o]1hK\u001a{'/\\1u-\u0016\u00148/[8o\u0007\"\fgnZ3\u0015\u0005]R\u0007\"\u0002\u001f\u0006\u0001\u0004i\u0004\u0006B\u0003J/2d\u0013!\u0017\u0015\u0003\u000by\u000bQ\u0003^3tiF+x\u000e^1D_:4\u0017nZ\"iC:<W\rF\u00038av\fy\u0001C\u0003r\r\u0001\u0007!/\u0001\u0004f]RLG/\u001f\t\u0003gnl\u0011\u0001\u001e\u0006\u0003kZ\fQ!];pi\u0006T!a\u001e=\u0002\r\r|W.\\8o\u0015\tI\u0012P\u0003\u0002{'\u00061\u0011\r]1dQ\u0016L!\u0001 ;\u0003#\rc\u0017.\u001a8u#V|G/Y#oi&$\u0018\u0010C\u0003\u007f\r\u0001\u0007q0\u0001\u0003vg\u0016\u0014\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005CV$\bNC\u0002\u0002\nY\f\u0001b]3dkJLG/_\u0005\u0005\u0003\u001b\t\u0019A\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\r\u0005Ea\u00011\u0001>\u0003!\u0019G.[3oi&#\u0017!\b;fgR\u001cE.[3oi&#\u0017+^8uC\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007]\n9\u0002C\u0003=\u000f\u0001\u0007Q\bK\u0003\b\u0013^\u000bY\u0002\f\u0002Z7\"\u0012qAX\u0001\u001ai\u0016\u001cH/V:feF+x\u000e^1D_:4\u0017nZ\"iC:<W\rF\u00028\u0003GAQ\u0001\u0010\u0005A\u0002uBS\u0001C%X\u0003Oa#!W.)\u0005!q\u0016a\u0007;fgR,6/\u001a:DY&,g\u000e^%e#V|G/Y\"iC:<W\rF\u00028\u0003_AQ\u0001P\u0005A\u0002uBS!C%X\u0003ga#!W.)\u0005%q\u0016\u0001\n;fgR$UMZ1vYR\u001cE.[3oi&#\u0017+^8uC\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007]\nY\u0004C\u0003=\u0015\u0001\u0007Q\bK\u0003\u000b\u0013^\u000by\u0004\f\u0002Z7\"\u0012!BX\u0001!i\u0016\u001cH\u000fR3gCVdG/V:feF+x\u000e^1D_:4\u0017nZ\"iC:<W\rF\u00028\u0003\u000fBQ\u0001P\u0006A\u0002uBSaC%X\u0003\u0017b#!W.)\u0005-q\u0016\u0001\u000b;fgR$UMZ1vYR,6/\u001a:DY&,g\u000e^%e#V|G/Y\"p]\u001aLwm\u00115b]\u001e,GcA\u001c\u0002T!)A\b\u0004a\u0001{!*A\"S,\u0002X1\u0012\u0011l\u0017\u0015\u0003\u0019y\u000bq\u0003^3tiF+x\u000e^1J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8\u0015\u0007]\ny\u0006C\u0003=\u001b\u0001\u0007Q\bK\u0003\u000e\u0013^\u000b\u0019\u0007L\u0001ZQ\tia,A\ruKN$\u0018\n])v_R\f\u0017J\\5uS\u0006d\u0017N_1uS>tGcA\u001c\u0002l!)AH\u0004a\u0001{!*a\"S,\u0002p1\u0012\u0011l\u0017\u0015\u0003\u001dy\u000bq\u0003^3ti&\u0003\u0018+^8uC\u000e{gNZ5h\u0007\"\fgnZ3\u0015\u0007]\n9\bC\u0003=\u001f\u0001\u0007Q\bK\u0003\u0010\u0013^\u000bY\b\f\u0002Z7\"\u0012qBX\u0001#i\u0016\u001cHoQ8oM&<7\t[1oO\u0016|eNT8o\u000bbL7\u000f^5oOR{\u0007/[2\u0015\u0007]\n\u0019\tC\u0003=!\u0001\u0007Q\bK\u0003\u0011\u0013^\u000b9\tL\u0001ZQ\t\u0001b,A\u0019uKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hK>sgj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY,ji\"\fE-\\5o\u00072LWM\u001c;\u0015\u0007]\ny\tC\u0003=#\u0001\u0007Q\bK\u0003\u0012\u0013^\u000b\u0019\n\f\u0002Z7\"\u0012\u0011CX\u0001\u0018i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8OT8uS\u001aL7-\u0019;j_:$2aNAN\u0011\u0015a$\u00031\u0001>Q\u0015\u0011\u0012jVAPY\u0005I\u0006F\u0001\n_\u0003e!Xm\u001d;D_:4\u0017nZ;sK\u0012+g-Y;miR{\u0007/[2\u0015\u0007]\n9\u000bC\u0003='\u0001\u0007Q\bK\u0003\u0014\u0013^\u000bY\u000b\f\u0002Z7\"\u00121CX\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HCAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000bQ!\u00193nS:T1!!0y\u0003\u001d\u0019G.[3oiNLA!!1\u00028\n)\u0011\tZ7j]\u0002")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        Object[] objectArray = new KafkaConfig[1];
        objectArray[0] = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnectOrNull(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChange(String quorum) {
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()), (String)"Should contain a ConfigHandler for topics");
        }
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var23_12 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var11_7 = null;
        Object var16_11 = null;
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString()), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{op}))).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.setProperty(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var24_24 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDynamicTopicConfigChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var26_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var14_6 = null;
        Object var19_10 = null;
        int newSegmentSize = 2000;
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(newSegmentSize)), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{op}))).asJavaCollection())}))).asJava()).all().get();
            }
        } else {
            Properties newProps = new Properties();
            newProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(newSegmentSize));
            this.adminZkClient().changeTopicConfig(tp.topic(), newProps);
        }
        LogManager qual$2 = ((KafkaBroker)this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        long l3 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        long l4 = 1L;
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var27_28 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l4);
                l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                continue;
            }
            break;
        }
        Object var20_23 = null;
        Object var25_27 = null;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> TestUtils$.MODULE$.produceMessage(this.brokers(), tp.topic(), Integer.toString(i), (Long)null, 30000, 20000));
        Assertions.assertTrue((boolean)log.logSegments().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$4(x$1))), (String)"Log segment size change not applied");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testMessageFormatVersionChange(String quorum) {
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5());
        KafkaServer server = (KafkaServer)this.servers().head();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$1(server, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Topic metadata propagation failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        LogManager qual$2 = server.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$, (Object)log.config().messageFormatVersion());
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
        String compressionType = CompressionType.LZ4.name;
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.11.0");
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), compressionType);
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$3(server, tp, compressionType)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Topic config change propagation failed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$, (Object)log.config().messageFormatVersion());
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(ClientQuotaEntity entity, KafkaPrincipal user, String clientId) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(2000.0)))));
            admin.alterClientQuotas(alterations).all().get();
            QuotaFactory.QuotaManagers quotaManagers = ((KafkaBroker)this.brokers().head()).dataPlaneRequestProcessor().quotas();
            long l = 10000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String string;
                        String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        string = null;
                        String msgWithLogIdent_msg = string2;
                        Object var25_13 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var13_8 = null;
            Object var18_12 = null;
            double defaultProducerQuota = Long.MAX_VALUE;
            double defaultConsumerQuota = Long.MAX_VALUE;
            java.util.List<ClientQuotaAlteration> removals = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", null), new ClientQuotaAlteration.Op("consumer_byte_rate", null))));
            admin.alterClientQuotas(removals).all().get();
            long l3 = 10000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            long l4 = 1L;
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String string;
                        String string3 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                        string = null;
                        String msgWithLogIdent_msg = string3;
                        Object var26_24 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l4);
                    l4 += scala.math.package$.MODULE$.min(l4, 1000L);
                    continue;
                }
                break;
            }
            Object var19_19 = null;
            Object var24_23 = null;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClientIdQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUserQuotaConfigChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUserClientIdQuotaChange(String quorum) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testDefaultUserClientIdQuotaConfigChange(String quorum) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testQuotaInitialization(String quorum) {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put("producer_byte_rate", "1000");
        clientIdProps.put("consumer_byte_rate", "2000");
        Properties userProps = new Properties();
        userProps.put("producer_byte_rate", "10000");
        userProps.put("consumer_byte_rate", "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put("producer_byte_rate", "100000");
        userClientIdProps.put("consumer_byte_rate", "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("overriddenUser", userProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        double upperBound_upperBound3 = 10000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound3, true), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound4 = 20000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound4, true), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        double upperBound_upperBound5 = 100000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound5, true), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        double upperBound_upperBound6 = 200000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound6, true), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaInitialization(String quorum) {
        KafkaBroker broker = (KafkaBroker)this.brokers().head();
        if (this.isKRaftTest()) {
            try (Admin admin = this.createAdminClient();){
                java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
                admin.alterClientQuotas(alterations).all().get();
            }
        } else {
            broker.shutdown();
            Properties ipDefaultProps = new Properties();
            ipDefaultProps.put("connection_creation_rate", "20");
            this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
            Properties ipOverrideProps = new Properties();
            ipOverrideProps.put("connection_creation_rate", "10");
            this.adminZkClient().changeIpConfig("1.2.3.4", ipOverrideProps);
            this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable)p -> {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(this, p);
                return BoxedUnit.UNIT;
            });
            broker.startup();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$2(broker);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var14_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIpQuotaConfigChange(String quorum) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
            admin.alterClientQuotas(alterations).all().get();
            InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10));
            InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
            this.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<ClientQuotaAlteration> deletions1 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions1).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<ClientQuotaAlteration> deletions2 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions2).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testConfigChangeOnNonExistingTopic(String quorum) {
        String topic = TestUtils$.MODULE$.tempTopic();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().changeTopicConfig(topic, logProps));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigChangeOnNonExistingTopicWithAdminClient(String quorum) {
        String topic = TestUtils$.MODULE$.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMessagesProp(), "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{op}))).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testProcessNotification(String quorum) {
        new Properties().put("a.b", "10");
        ConfigHandler handler = (ConfigHandler)Mockito.mock(ConfigHandler.class);
        ZkConfigManager configManager = new ZkConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})));
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        ObjectRef jsonMap = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)jsonMap.elem).asJava()));
        ((ConfigHandler)Mockito.verify((Object)handler)).processConfigChanges(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigureDefaultTopic(String quorum) {
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMessagesProp(), "200000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{op}))).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with InvalidRequestException for topic doesn't exist");
            }
            catch (ExecutionException e) {
                Assertions.assertEquals(InvalidRequestException.class, e.getCause().getClass());
            }
        }
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (Long)((UnifiedLog)logOpt.get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (Long)((UnifiedLog)qual$2.getLog(tp$1, x$4).get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (Integer)((UnifiedLog)logOpt.get()).config().segmentSize());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, UnifiedLog log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (Integer)log$1.config().segmentSize());
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicTopicConfigChange$4(LogSegment x$1) {
        return x$1.size() > 1000;
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$1(KafkaServer server$1, TopicPartition tp$3) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$2() {
        return "Topic metadata propagation failed";
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$3(KafkaServer server$1, TopicPartition tp$3, String compressionType$1) {
        LogManager qual$3 = server$1.logManager();
        boolean x$6 = qual$3.getLog$default$2();
        String string = ((UnifiedLog)qual$3.getLog(tp$3, x$6).get()).config().compressionType();
        return !(string != null ? !string.equals(compressionType$1) : compressionType$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$4() {
        return "Topic config change propagation failed";
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString());
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)new Quota(defaultProducerQuota$1, true), (Object)producerQuota, (String)new StringBuilder(0).append(new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").toString()).append(defaultProducerQuota$1).toString());
        Assertions.assertEquals((Object)new Quota(defaultConsumerQuota$1, true), (Object)consumerQuota, (String)new StringBuilder(0).append(new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").toString()).append(defaultConsumerQuota$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$2(KafkaBroker broker$1) {
        ConnectionQuotas connectionQuotas = broker$1.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)new StringBuilder(24).append("Unexpected quota for IP ").append(ip$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota) {
        ConnectionQuotas connectionQuotas = ((KafkaBroker)this.brokers().head()).socketServer().connectionQuotas();
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var10_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }
}

