/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.cluster.Broker;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UpdateFeaturesResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.feature.BaseVersionRange;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001\u0002\u000f\u001e\u0001\tBQa\n\u0001\u0005\u0002!BQA\u000b\u0001\u0005B-BQA\r\u0001\u0005BMBQ!\u0011\u0001\u0005\n\tCQa\u0015\u0001\u0005\nQCQ!\u0017\u0001\u0005\niCQ!\u001c\u0001\u0005\n9DQ\u0001\u001d\u0001\u0005\nEDQa\u001d\u0001\u0005\nQDQa\u001f\u0001\u0005\nqDq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBAa\u0001\u0011\u0005\u00111\u0019\u0005\b\u00037\u0004A\u0011AAb\u0011\u001d\ty\u000e\u0001C\u0001\u0003\u0007Dq!a9\u0001\t\u0003\t\u0019\rC\u0004\u0002h\u0002!\t!a1\t\u000f\u0005-\b\u0001\"\u0001\u0002D\"9\u0011q\u001e\u0001\u0005\n\u0005E\bb\u0002B\u0003\u0001\u0011\u0005\u00111\u0019\u0005\b\u0005\u0013\u0001A\u0011AAb\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003\u0007DqA!\u0005\u0001\t\u0003\t\u0019\rC\u0004\u0003\u0016\u0001!\t!a1\t\u000f\te\u0001\u0001\"\u0001\u0002D\n\u0011R\u000b\u001d3bi\u00164U-\u0019;ve\u0016\u001cH+Z:u\u0015\tqr$\u0001\u0004tKJ4XM\u001d\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001$!\t!S%D\u0001\u001e\u0013\t1SDA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002%\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#aA%oi\u00069\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003i]\u0002\"!L\u001b\n\u0005Yr#\u0001B+oSRDQ\u0001O\u0002A\u0002e\nQ\u0001\u001d:paN\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001\u0004Z3gCVdGoU;qa>\u0014H/\u001a3GK\u0006$XO]3t)\u0005\u0019\u0005c\u0001#O!6\tQI\u0003\u0002G\u000f\u00069a-Z1ukJ,'B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011\u0001E\u0013\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014x-\u0003\u0002P\u000b\nAa)Z1ukJ,7\u000f\u0005\u0002E#&\u0011!+\u0012\u0002\u0016'V\u0004\bo\u001c:uK\u00124VM]:j_:\u0014\u0016M\\4f\u0003a!WMZ1vYR4\u0015N\\1mSj,GMR3biV\u0014Xm\u001d\u000b\u0002+B\u0019AI\u0014,\u0011\u0005\u0011;\u0016B\u0001-F\u0005U1\u0015N\\1mSj,GMV3sg&|gNU1oO\u0016\fq#\u001e9eCR,7+\u001e9q_J$X\r\u001a$fCR,(/Z:\u0015\u0007QZV\fC\u0003]\r\u0001\u00071)\u0001\u0005gK\u0006$XO]3t\u0011\u0015qf\u00011\u0001`\u00035!\u0018M]4fiN+'O^3sgB\u0019\u0001m\u001a6\u000f\u0005\u0005,\u0007C\u00012/\u001b\u0005\u0019'B\u00013\"\u0003\u0019a$o\\8u}%\u0011aML\u0001\u0007!J,G-\u001a4\n\u0005!L'aA*fi*\u0011aM\f\t\u0003I-L!\u0001\\\u000f\u0003\u0017-\u000bgm[1TKJ4XM]\u0001$kB$\u0017\r^3TkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKNLe.\u00117m\u0005J|7.\u001a:t)\t!t\u000eC\u0003]\u000f\u0001\u00071)\u0001\nva\u0012\fG/\u001a$fCR,(/\u001a.O_\u0012,GC\u0001\u0017s\u0011\u0015a\u0006\u00021\u0001V\u0003=9W\r\u001e$fCR,(/\u001a.O_\u0012,G#A;\u0011\u0005YLX\"A<\u000b\u0005a|\u0012A\u0001>l\u0013\tQxO\u0001\u0007GK\u0006$XO]3[\u001d>$W-A\tgS:\fG.\u001b>fI\u001a+\u0017\r^;sKN$\"!V?\t\u000bqS\u0001\u0019\u0001@\u0011\riz\u00181AA\u0005\u0013\r\t\ta\u000f\u0002\u0004\u001b\u0006\u0004\bc\u00011\u0002\u0006%\u0019\u0011qA5\u0003\rM#(/\u001b8h!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tQ!\u00193nS:T1!a\u0005J\u0003\u001d\u0019G.[3oiNL1\u0001WA\u0007\u0003E\u0019X\u000f\u001d9peR,GMR3biV\u0014Xm\u001d\u000b\u0004\u0007\u0006m\u0001B\u0002/\f\u0001\u0004\ti\u0002\u0005\u0004;\u007f\u0006\r\u0011q\u0004\t\u0005\u0003\u0017\t\t#C\u0002S\u0003\u001b\tQb\u00195fG.4U-\u0019;ve\u0016\u001cHc\u0003\u001b\u0002(\u0005E\u0012QGA\u001d\u0003\u0007Bq!!\u000b\r\u0001\u0004\tY#\u0001\u0004dY&,g\u000e\u001e\t\u0005\u0003\u0017\ti#\u0003\u0003\u00020\u00055!!B!e[&t\u0007BBA\u001a\u0019\u0001\u0007Q/\u0001\u0007fqB,7\r^3e\u001d>$W\r\u0003\u0004\u000281\u0001\r!V\u0001\u001aKb\u0004Xm\u0019;fI\u001aKg.\u00197ju\u0016$g)Z1ukJ,7\u000fC\u0004\u0002<1\u0001\r!!\u0010\u0002=\u0015D\b/Z2uK\u00124\u0015N\\1mSj,GMR3biV\u0014Xm]#q_\u000eD\u0007cA\u0017\u0002@%\u0019\u0011\u0011\t\u0018\u0003\t1{gn\u001a\u0005\u0007\u0003\u000bb\u0001\u0019A\"\u00023\u0015D\b/Z2uK\u0012\u001cV\u000f\u001d9peR,GMR3biV\u0014Xm]\u0001\u000fG\",7m[#yG\u0016\u0004H/[8o+\u0011\tY%a\u0019\u0015\r\u00055\u0013\u0011QAF)\r!\u0014q\n\u0005\b\u0003#j\u00019AA*\u0003\r!\u0018m\u001a\t\u0007\u0003+\nY&a\u0018\u000e\u0005\u0005]#bAA-]\u00059!/\u001a4mK\u000e$\u0018\u0002BA/\u0003/\u0012\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0003C\n\u0019\u0007\u0004\u0001\u0005\u000f\u0005\u0015TB1\u0001\u0002h\tiQ\t_2faRLwN\u001c+za\u0016\fB!!\u001b\u0002pA\u0019Q&a\u001b\n\u0007\u00055dFA\u0004O_RD\u0017N\\4\u0011\t\u0005E\u00141\u0010\b\u0005\u0003g\n9HD\u0002c\u0003kJ\u0011aL\u0005\u0004\u0003sr\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003{\nyHA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011\u0010\u0018\t\u000f\u0005\rU\u00021\u0001\u0002\u0006\u00061!/Z:vYR\u0004B!a\u0003\u0002\b&!\u0011\u0011RA\u0007\u0005Q)\u0006\u000fZ1uK\u001a+\u0017\r^;sKN\u0014Vm];mi\"9\u0011QR\u0007A\u0002\u0005=\u0015a\u00074fCR,(/Z#yG\u0016\u0004H/[8o\u001bN<\u0007+\u0019;uKJt7\u000fE\u0004a\u0003#\u000b\u0019!a%\n\u0007\u0005\u0005\u0011\u000e\u0005\u0003\u0002\u0016\u0006uUBAAL\u0015\u0011\tI*a'\u0002\u00115\fGo\u00195j]\u001eT!\u0001\u0010\u0018\n\t\u0005}\u0015q\u0013\u0002\u0006%\u0016<W\r_\u0001\u001di\u0016\u001cHoV5uQ&sg/\u00197jI\u001a+\u0017\r^;sKV\u0003H-\u0019;f+\u0011\t)+a,\u0015\u0011\u0005\u001d\u0016\u0011WAZ\u0003{#2\u0001NAU\u0011\u001d\t\tF\u0004a\u0002\u0003W\u0003b!!\u0016\u0002\\\u00055\u0006\u0003BA1\u0003_#q!!\u001a\u000f\u0005\u0004\t9\u0007\u0003\u0004G\u001d\u0001\u0007\u00111\u0001\u0005\b\u0003ks\u0001\u0019AA\\\u00035IgN^1mS\u0012,\u0006\u000fZ1uKB!\u00111BA]\u0013\u0011\tY,!\u0004\u0003\u001b\u0019+\u0017\r^;sKV\u0003H-\u0019;f\u0011\u001d\tyL\u0004a\u0001\u0003'\u000b1#\u001a=dKB$\u0018n\u001c8Ng\u001e\u0004\u0016\r\u001e;fe:\fA\u0005^3tiNCw.\u001e7e\r\u0006LGNU3rk\u0016\u001cH/\u00134O_R\u001cuN\u001c;s_2dWM\u001d\u000b\u0002i!\u001aq\"a2\u0011\t\u0005%\u0017q[\u0007\u0003\u0003\u0017TA!!4\u0002P\u0006\u0019\u0011\r]5\u000b\t\u0005E\u00171[\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t)\u000eT\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00033\fYM\u0001\u0003UKN$\u0018!\u0010;fgR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\u001c*fcV,7\u000f^,iK:$un\u001e8he\u0006$WM\u00127bO&\u001bhj\u001c;TKR$UO]5oO\u0012{wO\\4sC\u0012,\u0007f\u0001\t\u0002H\u0006\tE/Z:u'\"|W\u000f\u001c3GC&d'+Z9vKN$x\u000b[3o\t><hn\u001a:bI\u0016$v\u000eS5hQ\u0016\u0014h+\u001a:tS>tG*\u001a<fY&\u001b\u0018\t\u001e;f[B$X\r\u001a\u0015\u0004#\u0005\u001d\u0017\u0001\u0012;fgR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\u001c*fcV,7\u000f^%o'\u0016\u0014h/\u001a:XQ\u0016tGi\\<oOJ\fG-\u001a$mC\u001eL5OT8u'\u0016$H)\u001e:j]\u001e$U\r\\3uS>t\u0007f\u0001\n\u0002H\u00069D/Z:u'\"|W\u000f\u001c3GC&d'+Z9vKN$H)\u001e:j]\u001e$U\r\\3uS>twJ\u001a(p]\u0016C\u0018n\u001d;j]\u001e4U-\u0019;ve\u0016D3aEAd\u0003Q\"Xm\u001d;TQ>,H\u000e\u001a$bS2\u0014V-];fgR<\u0006.\u001a8Va\u001e\u0014\u0018\rZ5oOR{7+Y7f-\u0016\u00148/[8o\u0019\u00164X\r\u001c\u0015\u0004)\u0005\u001d\u0017a\u0010;fgR\u001c\u0006n\\;mI\u001a\u000b\u0017\u000e\u001c*fcV,7\u000f\u001e#ve&twM\u0011:pW\u0016\u0014X*\u0019=WKJ\u001c\u0018n\u001c8MKZ,G.\u00138d_6\u0004\u0018\r^5cS2LG/\u001f\u000b\bi\u0005M\u0018q_A~\u0011\u001d\t)0\u0006a\u0001\u0003\u0007\t1BZ3biV\u0014XMT1nK\"1\u0011\u0011`\u000bA\u0002A\u000bQc];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8SC:<W\rC\u0004\u0002~V\u0001\r!a@\u00029%t\u0017\u000e^5bY\u001aKg.\u00197ju\u0016$g+\u001a:tS>t'+\u00198hKB!QF!\u0001W\u0013\r\u0011\u0019A\f\u0002\u0007\u001fB$\u0018n\u001c8\u00025R,7\u000f^*i_VdGMR1jYJ+\u0017/^3ti\u0012+(/\u001b8h\u0005J|7.\u001a:NCb4VM]:j_:dUM^3m\u0013:\u001cw.\u001c9bi&\u0014\u0017\u000e\\5us\u001a{'/\u0012=jgRLgn\u001a$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:fQ\r1\u0012qY\u0001^i\u0016\u001cHo\u00155pk2$g)Y5m%\u0016\fX/Z:u\tV\u0014\u0018N\\4Ce>\\WM]'bqZ+'o]5p]2+g/\u001a7J]\u000e|W\u000e]1uS\nLG.\u001b;z/&$\bNT8Fq&\u001cH/\u001b8h\r&t\u0017\r\\5{K\u00124U-\u0019;ve\u0016D3aFAd\u0003y\"Xm\u001d;Tk\u000e\u001cWm]:gk24U-\u0019;ve\u0016,\u0006o\u001a:bI\u0016\fe\u000eZ,ji\"tu.\u0012=jgRLgn\u001a$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:fg\"\u001a\u0001$a2\u0002QQ,7\u000f^*vG\u000e,7o\u001d4vY\u001a+\u0017\r^;sKV\u0003xM]1eK\u0006sG\rR8x]\u001e\u0014\u0018\rZ3)\u0007e\t9-\u0001 uKN$\b+\u0019:uS\u0006d7+^2dKN\u001cH)\u001e:j]\u001e4\u0016\r\\5e\r\u0016\fG/\u001e:f+B<'/\u00193f\u0003:$\u0017J\u001c<bY&$Gi\\<oOJ\fG-\u001a\u0015\u00045\u0005\u001d\u0017A\u0010;fgR\u0004\u0016M\u001d;jC2\u001cVoY2fgN$UO]5oO&sg/\u00197jI\u001a+\u0017\r^;sKV\u0003xM]1eK\u0006sGMV1mS\u0012$un\u001e8he\u0006$W\rK\u0002\u001c\u0003\u000f\u0004")
public class UpdateFeaturesTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ApiVersion.toString$((ApiVersion)KAFKA_2_7_IV0$.MODULE$));
    }

    private Features<SupportedVersionRange> defaultSupportedFeatures() {
        Map.Entry[] entryArray = new Map.Entry[1];
        SupportedVersionRange mkEntry_v = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var1_2 = null;
        Object var2_1 = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, SupportedVersionRange>(mkEntry_k, mkEntry_v);
        return Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray));
    }

    private Features<org.apache.kafka.common.feature.FinalizedVersionRange> defaultFinalizedFeatures() {
        Map.Entry[] entryArray = new Map.Entry[1];
        org.apache.kafka.common.feature.FinalizedVersionRange mkEntry_v = new org.apache.kafka.common.feature.FinalizedVersionRange(1, 2);
        String mkEntry_k = "feature_1";
        Object var1_2 = null;
        Object var2_1 = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, org.apache.kafka.common.feature.FinalizedVersionRange>(mkEntry_k, mkEntry_v);
        return Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray));
    }

    private void updateSupportedFeatures(Features<SupportedVersionRange> features, Set<KafkaServer> targetServers) {
        targetServers.foreach((Function1 & Serializable)s -> {
            UpdateFeaturesTest.$anonfun$updateSupportedFeatures$1(features, s);
            return BoxedUnit.UNIT;
        });
        Set brokerIds = (Set)targetServers.map((Function1 & Serializable)s -> BoxesRunTime.boxToInteger((int)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$2(s)));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UpdateFeaturesTest.$anonfun$updateSupportedFeatures$3(this, brokerIds, features)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Controller did not get broker updates");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private void updateSupportedFeaturesInAllBrokers(Features<SupportedVersionRange> features) {
        this.updateSupportedFeatures(features, (Set<KafkaServer>)((Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus(this.servers())));
    }

    private int updateFeatureZNode(Features<org.apache.kafka.common.feature.FinalizedVersionRange> features) {
        KafkaServer server = (KafkaServer)this.serverForId(0).get();
        FeatureZNode newNode = new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, features);
        int newVersion = server.zkClient().updateFeatureZNode(newNode);
        this.servers().foreach((Function1 & Serializable)s -> {
            UpdateFeaturesTest.$anonfun$updateFeatureZNode$1(newVersion, s);
            return BoxedUnit.UNIT;
        });
        return newVersion;
    }

    /*
     * WARNING - void declaration
     */
    private FeatureZNode getFeatureZNode() {
        void var2_2;
        Tuple2 tuple2 = ((KafkaServer)this.serverForId(0).get()).zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        return FeatureZNode$.MODULE$.decode((byte[])var2_2.get());
    }

    private Features<org.apache.kafka.common.feature.FinalizedVersionRange> finalizedFeatures(Map<String, FinalizedVersionRange> features) {
        return Features.finalizedFeatures((Map)CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(features).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            FinalizedVersionRange versionRange = (FinalizedVersionRange)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)new org.apache.kafka.common.feature.FinalizedVersionRange(versionRange.minVersionLevel(), versionRange.maxVersionLevel()));
            return tuple2;
        })).asJava());
    }

    private Features<SupportedVersionRange> supportedFeatures(Map<String, org.apache.kafka.clients.admin.SupportedVersionRange> features) {
        return Features.supportedFeatures((Map)CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(features).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            org.apache.kafka.clients.admin.SupportedVersionRange versionRange = (org.apache.kafka.clients.admin.SupportedVersionRange)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)new SupportedVersionRange(versionRange.minVersion(), versionRange.maxVersion()));
            return tuple2;
        })).asJava());
    }

    private void checkFeatures(Admin client, FeatureZNode expectedNode, Features<org.apache.kafka.common.feature.FinalizedVersionRange> expectedFinalizedFeatures, long expectedFinalizedFeaturesEpoch, Features<SupportedVersionRange> expectedSupportedFeatures) {
        Assertions.assertEquals((Object)expectedNode, (Object)this.getFeatureZNode());
        FeatureMetadata featureMetadata = (FeatureMetadata)client.describeFeatures().featureMetadata().get();
        Assertions.assertEquals(expectedFinalizedFeatures, this.finalizedFeatures(featureMetadata.finalizedFeatures()));
        Assertions.assertEquals(expectedSupportedFeatures, this.supportedFeatures(featureMetadata.supportedFeatures()));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)expectedFinalizedFeaturesEpoch)), (Object)featureMetadata.finalizedFeaturesEpoch());
    }

    private <ExceptionType extends Throwable> void checkException(UpdateFeaturesResult result, scala.collection.immutable.Map<String, Regex> featureExceptionMsgPatterns, ClassTag<ExceptionType> tag) {
        featureExceptionMsgPatterns.foreach((Function1 & Serializable)x0$1 -> {
            UpdateFeaturesTest.$anonfun$checkException$1(result, tag, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private <ExceptionType extends Throwable> void testWithInvalidFeatureUpdate(String feature, FeatureUpdate invalidUpdate, Regex exceptionMsgPattern, ClassTag<ExceptionType> tag) {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, FeatureUpdate>(feature, invalidUpdate)}), new UpdateFeaturesOptions());
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)feature), (Object)exceptionMsgPattern)}))), tag);
        this.checkFeatures(adminClient, nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestIfNotController() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection validUpdates = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        UpdateFeaturesRequestData.FeatureUpdateKey validUpdate = new UpdateFeaturesRequestData.FeatureUpdateKey();
        validUpdate.setFeature("feature_1");
        validUpdate.setMaxVersionLevel(((SupportedVersionRange)this.defaultSupportedFeatures().get("feature_1")).max());
        validUpdate.setAllowDowngrade(false);
        validUpdates.add((ImplicitLinkedHashCollection.Element)validUpdate);
        UpdateFeaturesResponse response = (UpdateFeaturesResponse)this.connectAndReceive(new UpdateFeaturesRequest.Builder(new UpdateFeaturesRequestData().setFeatureUpdates(validUpdates)).build(), this.notControllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(UpdateFeaturesResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)response.data().errorCode()));
        Assertions.assertNotNull((Object)response.data().errorMessage());
        Assertions.assertEquals((int)0, (int)response.data().results().size());
        this.checkFeatures(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestWhenDowngradeFlagIsNotSetDuringDowngrade() {
        short targetMaxVersionLevel = (short)(((org.apache.kafka.common.feature.FinalizedVersionRange)this.defaultFinalizedFeatures().get("feature_1")).max() - 1);
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, false), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Can not downgrade finalized feature.*allowDowngrade.*")), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestWhenDowngradeToHigherVersionLevelIsAttempted() {
        short targetMaxVersionLevel = (short)(((org.apache.kafka.common.feature.FinalizedVersionRange)this.defaultFinalizedFeatures().get("feature_1")).max() + 1);
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, true), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*When the allowDowngrade flag set in the request, the provided maxVersionLevel:3.*existing maxVersionLevel:2.*")), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestInServerWhenDowngradeFlagIsNotSetDuringDeletion() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        int versionBefore = this.updateFeatureZNode(this.defaultFinalizedFeatures());
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        FeatureZNode nodeBefore = this.getFeatureZNode();
        UpdateFeaturesRequestData.FeatureUpdateKeyCollection invalidUpdates = new UpdateFeaturesRequestData.FeatureUpdateKeyCollection();
        UpdateFeaturesRequestData.FeatureUpdateKey invalidUpdate = new UpdateFeaturesRequestData.FeatureUpdateKey();
        invalidUpdate.setFeature("feature_1");
        invalidUpdate.setMaxVersionLevel((short)0);
        invalidUpdate.setAllowDowngrade(false);
        invalidUpdates.add((ImplicitLinkedHashCollection.Element)invalidUpdate);
        new UpdateFeaturesRequestData().setFeatureUpdates(invalidUpdates);
        UpdateFeaturesResponse response = (UpdateFeaturesResponse)this.connectAndReceive(new UpdateFeaturesRequest.Builder(new UpdateFeaturesRequestData().setFeatureUpdates(invalidUpdates)).build(), this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(UpdateFeaturesResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((int)1, (int)response.data().results().size());
        UpdateFeaturesResponseData.UpdatableFeatureResult result = (UpdateFeaturesResponseData.UpdatableFeatureResult)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().results()).asScala().head();
        Assertions.assertEquals((Object)"feature_1", (Object)result.feature());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)Errors.forCode((short)result.errorCode()));
        Assertions.assertNotNull((Object)result.errorMessage());
        Assertions.assertFalse((boolean)result.errorMessage().isEmpty());
        Assertions.assertTrue((boolean)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Can not provide maxVersionLevel: 0 less than 1.*allowDowngrade.*")).findFirstIn((CharSequence)result.errorMessage()).isDefined(), (String)result.errorMessage());
        this.checkFeatures(adminClient, nodeBefore, this.defaultFinalizedFeatures(), versionBefore, this.defaultSupportedFeatures());
    }

    @Test
    public void testShouldFailRequestDuringDeletionOfNonExistingFeature() {
        this.testWithInvalidFeatureUpdate("feature_non_existing", new FeatureUpdate(3, true), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Could not apply finalized feature update because the provided feature is not supported.*")), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    @Test
    public void testShouldFailRequestWhenUpgradingToSameVersionLevel() {
        short targetMaxVersionLevel = ((org.apache.kafka.common.feature.FinalizedVersionRange)this.defaultFinalizedFeatures().get("feature_1")).max();
        this.testWithInvalidFeatureUpdate("feature_1", new FeatureUpdate(targetMaxVersionLevel, false), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Can not upgrade a finalized feature.*to the same value.*")), ClassTag$.MODULE$.apply(InvalidRequestException.class));
    }

    /*
     * WARNING - void declaration
     */
    private void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(String featureName, SupportedVersionRange supportedVersionRange, Option<org.apache.kafka.common.feature.FinalizedVersionRange> initialFinalizedVersionRange) {
        void mkEntry_v;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer controller = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$1(server)))).head();
        Buffer nonControllerServers = (Buffer)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$2(server)));
        Set brokersWithVersionIncompatibility = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.head()}));
        Set versionCompatibleBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.apply(1), controller}));
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, SupportedVersionRange>(featureName, supportedVersionRange)}));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeatures, (Set<KafkaServer>)versionCompatibleBrokers);
        short unsupportedMaxVersion = (short)(supportedVersionRange.max() - 1);
        Map.Entry[] entryArray = new Map.Entry[1];
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(supportedVersionRange.min(), unsupportedMaxVersion);
        String mkEntry_k = "feature_1";
        Object var17_11 = null;
        supportedVersionRange2 = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v);
        Features supportedFeaturesWithVersionIncompatibility = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeaturesWithVersionIncompatibility, (Set<KafkaServer>)brokersWithVersionIncompatibility);
        Features initialFinalizedFeatures = (Features)initialFinalizedVersionRange.map((Function1 & Serializable)versionRange -> Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{new AbstractMap.SimpleEntry<String, org.apache.kafka.common.feature.FinalizedVersionRange>(featureName, (org.apache.kafka.common.feature.FinalizedVersionRange)versionRange)}))).getOrElse((Function0 & Serializable)() -> Features.emptyFinalizedFeatures());
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures);
        FeatureUpdate invalidUpdate = new FeatureUpdate(supportedVersionRange.max(), false);
        FeatureZNode nodeBefore = this.getFeatureZNode();
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray2 = new Map.Entry[1];
        String mkEntry_k2 = "feature_1";
        Object var19_18 = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k2, invalidUpdate);
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray2), new UpdateFeaturesOptions());
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*brokers.*incompatible.*")))}))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        this.checkFeatures(adminClient, nodeBefore, (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures, versionBefore, (Features<SupportedVersionRange>)supportedFeatures);
    }

    @Test
    public void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibilityForExistingFinalizedFeature() {
        String feature = "feature_1";
        this.testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(feature, (SupportedVersionRange)this.defaultSupportedFeatures().get(feature), (Option<org.apache.kafka.common.feature.FinalizedVersionRange>)new Some((Object)this.defaultFinalizedFeatures().get(feature)));
    }

    @Test
    public void testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibilityWithNoExistingFinalizedFeature() {
        String feature = "feature_1";
        this.testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility(feature, (SupportedVersionRange)this.defaultSupportedFeatures().get(feature), (Option<org.apache.kafka.common.feature.FinalizedVersionRange>)Option$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulFeatureUpgradeAndWithNoExistingFinalizedFeatures() {
        void mkEntry_v;
        void mkEntry_v2;
        void mkEntry_v3;
        void mkEntry_v4;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        Map.Entry[] entryArray = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var7_2 = null;
        supportedVersionRange = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v4);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(2, 5);
        String mkEntry_k2 = "feature_2";
        Object var9_4 = null;
        supportedVersionRange2 = null;
        entryArray[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k2, mkEntry_v3);
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)Features.emptyFinalizedFeatures());
        Map.Entry[] entryArray2 = new Map.Entry[2];
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange = new org.apache.kafka.common.feature.FinalizedVersionRange(1, 3);
        String mkEntry_k3 = "feature_1";
        Object var11_8 = null;
        finalizedVersionRange = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k3, mkEntry_v2);
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange2 = new org.apache.kafka.common.feature.FinalizedVersionRange(2, 3);
        String mkEntry_k4 = "feature_2";
        Object var13_10 = null;
        finalizedVersionRange2 = null;
        entryArray2[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k4, mkEntry_v);
        Features targetFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray2));
        FeatureUpdate update1 = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_1")).max(), false);
        FeatureUpdate update2 = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_2")).max(), false);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray3 = new Map.Entry[2];
        String mkEntry_k5 = "feature_1";
        Object var15_15 = null;
        entryArray3[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k5, update1);
        String mkEntry_k6 = "feature_2";
        Object var16_16 = null;
        entryArray3[1] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k6, update2);
        adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray3), new UpdateFeaturesOptions()).all().get();
        this.checkFeatures(adminClient, new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, targetFinalizedFeatures), (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)targetFinalizedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulFeatureUpgradeAndDowngrade() {
        void mkEntry_v;
        void mkEntry_v2;
        void mkEntry_v3;
        void mkEntry_v4;
        void mkEntry_v5;
        void mkEntry_v6;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        Map.Entry[] entryArray = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var8_2 = null;
        supportedVersionRange = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v6);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(2, 5);
        String mkEntry_k2 = "feature_2";
        Object var10_4 = null;
        supportedVersionRange2 = null;
        entryArray[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k2, mkEntry_v5);
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        Map.Entry[] entryArray2 = new Map.Entry[2];
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange = new org.apache.kafka.common.feature.FinalizedVersionRange(1, 2);
        String mkEntry_k3 = "feature_1";
        Object var12_7 = null;
        finalizedVersionRange = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k3, mkEntry_v4);
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange2 = new org.apache.kafka.common.feature.FinalizedVersionRange(2, 4);
        String mkEntry_k4 = "feature_2";
        Object var14_9 = null;
        finalizedVersionRange2 = null;
        entryArray2[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k4, mkEntry_v3);
        Features initialFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray2));
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures);
        Map.Entry[] entryArray3 = new Map.Entry[2];
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange3 = new org.apache.kafka.common.feature.FinalizedVersionRange(1, 3);
        String mkEntry_k5 = "feature_1";
        Object var16_13 = null;
        finalizedVersionRange3 = null;
        entryArray3[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k5, mkEntry_v2);
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange4 = new org.apache.kafka.common.feature.FinalizedVersionRange(2, 3);
        String mkEntry_k6 = "feature_2";
        Object var18_15 = null;
        finalizedVersionRange4 = null;
        entryArray3[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k6, mkEntry_v);
        Features targetFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray3));
        FeatureUpdate update1 = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_1")).max(), false);
        FeatureUpdate update2 = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_2")).max(), true);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray4 = new Map.Entry[2];
        String mkEntry_k7 = "feature_1";
        Object var20_20 = null;
        entryArray4[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k7, update1);
        String mkEntry_k8 = "feature_2";
        Object var21_21 = null;
        entryArray4[1] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k8, update2);
        adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray4), new UpdateFeaturesOptions()).all().get();
        this.checkFeatures(adminClient, new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, targetFinalizedFeatures), (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)targetFinalizedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartialSuccessDuringValidFeatureUpgradeAndInvalidDowngrade() {
        void mkEntry_v;
        void mkEntry_v2;
        void mkEntry_v3;
        void mkEntry_v4;
        void mkEntry_v5;
        void mkEntry_v6;
        void mkEntry_v7;
        void mkEntry_v8;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        Map.Entry[] entryArray = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var10_2 = null;
        supportedVersionRange = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v8);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(2, 5);
        String mkEntry_k2 = "feature_2";
        Object var12_4 = null;
        supportedVersionRange2 = null;
        entryArray[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k2, mkEntry_v7);
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)supportedFeatures);
        Map.Entry[] entryArray2 = new Map.Entry[2];
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange = new org.apache.kafka.common.feature.FinalizedVersionRange(1, 2);
        String mkEntry_k3 = "feature_1";
        Object var14_7 = null;
        finalizedVersionRange = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k3, mkEntry_v6);
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange2 = new org.apache.kafka.common.feature.FinalizedVersionRange(2, 4);
        String mkEntry_k4 = "feature_2";
        Object var16_9 = null;
        finalizedVersionRange2 = null;
        entryArray2[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k4, mkEntry_v5);
        Features initialFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray2));
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures);
        Map.Entry[] entryArray3 = new Map.Entry[2];
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange3 = new org.apache.kafka.common.feature.FinalizedVersionRange(1, 3);
        String mkEntry_k5 = "feature_1";
        Object var18_13 = null;
        finalizedVersionRange3 = null;
        entryArray3[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k5, mkEntry_v4);
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange4 = new org.apache.kafka.common.feature.FinalizedVersionRange(2, 3);
        String mkEntry_k6 = "feature_2";
        Object var20_15 = null;
        finalizedVersionRange4 = null;
        entryArray3[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k6, mkEntry_v3);
        Features targetFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray3));
        FeatureUpdate validUpdate = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_1")).max(), false);
        FeatureUpdate invalidUpdate = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_2")).max(), false);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray4 = new Map.Entry[2];
        String mkEntry_k7 = "feature_1";
        Object var22_20 = null;
        entryArray4[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k7, validUpdate);
        String mkEntry_k8 = "feature_2";
        Object var23_21 = null;
        entryArray4[1] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k8, invalidUpdate);
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray4), new UpdateFeaturesOptions());
        ((KafkaFuture)result.values().get("feature_1")).get();
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*Can not downgrade finalized feature.*allowDowngrade.*")))}))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        Map.Entry[] entryArray5 = new Map.Entry[2];
        BaseVersionRange baseVersionRange = targetFinalizedFeatures.get("feature_1");
        String mkEntry_k9 = "feature_1";
        Object var24_24 = null;
        baseVersionRange = null;
        entryArray5[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k9, mkEntry_v2);
        BaseVersionRange baseVersionRange2 = initialFinalizedFeatures.get("feature_2");
        String mkEntry_k10 = "feature_2";
        Object var26_26 = null;
        baseVersionRange2 = null;
        entryArray5[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k10, mkEntry_v);
        Features expectedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray5));
        this.checkFeatures(adminClient, new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, expectedFeatures), (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)expectedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade() {
        void mkEntry_v;
        void mkEntry_v2;
        void mkEntry_v3;
        void mkEntry_v4;
        void mkEntry_v5;
        void mkEntry_v6;
        void mkEntry_v7;
        void mkEntry_v8;
        void mkEntry_v9;
        void mkEntry_v10;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        KafkaServer controller = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$1(server)))).head();
        Buffer nonControllerServers = (Buffer)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$2(server)));
        Set brokersWithVersionIncompatibility = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.head()}));
        Set versionCompatibleBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)nonControllerServers.apply(1), controller}));
        Map.Entry[] entryArray = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange = new SupportedVersionRange(1, 3);
        String mkEntry_k = "feature_1";
        Object var15_6 = null;
        supportedVersionRange = null;
        entryArray[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k, mkEntry_v10);
        SupportedVersionRange supportedVersionRange2 = new SupportedVersionRange(2, 5);
        String mkEntry_k2 = "feature_2";
        Object var17_8 = null;
        supportedVersionRange2 = null;
        entryArray[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k2, mkEntry_v9);
        Features supportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeatures, (Set<KafkaServer>)versionCompatibleBrokers);
        Map.Entry[] entryArray2 = new Map.Entry[2];
        SupportedVersionRange supportedVersionRange3 = new SupportedVersionRange(1, 2);
        String mkEntry_k3 = "feature_1";
        Object var19_11 = null;
        supportedVersionRange3 = null;
        entryArray2[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k3, mkEntry_v8);
        BaseVersionRange baseVersionRange = supportedFeatures.get("feature_2");
        String mkEntry_k4 = "feature_2";
        Object var21_13 = null;
        baseVersionRange = null;
        entryArray2[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k4, mkEntry_v7);
        Features supportedFeaturesWithVersionIncompatibility = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray2));
        this.updateSupportedFeatures((Features<SupportedVersionRange>)supportedFeaturesWithVersionIncompatibility, (Set<KafkaServer>)brokersWithVersionIncompatibility);
        Map.Entry[] entryArray3 = new Map.Entry[2];
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange = new org.apache.kafka.common.feature.FinalizedVersionRange(1, 2);
        String mkEntry_k5 = "feature_1";
        Object var23_16 = null;
        finalizedVersionRange = null;
        entryArray3[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k5, mkEntry_v6);
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange2 = new org.apache.kafka.common.feature.FinalizedVersionRange(2, 4);
        String mkEntry_k6 = "feature_2";
        Object var25_18 = null;
        finalizedVersionRange2 = null;
        entryArray3[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k6, mkEntry_v5);
        Features initialFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray3));
        int versionBefore = this.updateFeatureZNode((Features<org.apache.kafka.common.feature.FinalizedVersionRange>)initialFinalizedFeatures);
        Map.Entry[] entryArray4 = new Map.Entry[2];
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange3 = new org.apache.kafka.common.feature.FinalizedVersionRange(1, 3);
        String mkEntry_k7 = "feature_1";
        Object var27_22 = null;
        finalizedVersionRange3 = null;
        entryArray4[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k7, mkEntry_v4);
        org.apache.kafka.common.feature.FinalizedVersionRange finalizedVersionRange4 = new org.apache.kafka.common.feature.FinalizedVersionRange(2, 3);
        String mkEntry_k8 = "feature_2";
        Object var29_24 = null;
        finalizedVersionRange4 = null;
        entryArray4[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k8, mkEntry_v3);
        Features targetFinalizedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray4));
        FeatureUpdate invalidUpdate = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_1")).max(), false);
        FeatureUpdate validUpdate = new FeatureUpdate(((org.apache.kafka.common.feature.FinalizedVersionRange)targetFinalizedFeatures.get("feature_2")).max(), true);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Map.Entry[] entryArray5 = new Map.Entry[2];
        String mkEntry_k9 = "feature_1";
        Object var31_29 = null;
        entryArray5[0] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k9, invalidUpdate);
        String mkEntry_k10 = "feature_2";
        Object var32_30 = null;
        entryArray5[1] = new AbstractMap.SimpleEntry<String, FeatureUpdate>(mkEntry_k10, validUpdate);
        UpdateFeaturesResult result = adminClient.updateFeatures(Utils.mkMap((Map.Entry[])entryArray5), new UpdateFeaturesOptions());
        ((KafkaFuture)result.values().get("feature_2")).get();
        this.checkException(result, (scala.collection.immutable.Map<String, Regex>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*brokers.*incompatible.*")))}))), ClassTag$.MODULE$.apply(InvalidRequestException.class));
        Map.Entry[] entryArray6 = new Map.Entry[2];
        BaseVersionRange baseVersionRange2 = initialFinalizedFeatures.get("feature_1");
        String mkEntry_k11 = "feature_1";
        Object var33_33 = null;
        baseVersionRange2 = null;
        entryArray6[0] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k11, mkEntry_v2);
        BaseVersionRange baseVersionRange3 = targetFinalizedFeatures.get("feature_2");
        String mkEntry_k12 = "feature_2";
        Object var35_35 = null;
        baseVersionRange3 = null;
        entryArray6[1] = new AbstractMap.SimpleEntry<String, void>(mkEntry_k12, mkEntry_v);
        Features expectedFeatures = Features.finalizedFeatures((Map)Utils.mkMap((Map.Entry[])entryArray6));
        this.checkFeatures(adminClient, new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, expectedFeatures), (Features<org.apache.kafka.common.feature.FinalizedVersionRange>)expectedFeatures, versionBefore + 1, (Features<SupportedVersionRange>)supportedFeatures);
    }

    public static final /* synthetic */ void $anonfun$updateSupportedFeatures$1(Features features$1, KafkaServer s) {
        s.brokerFeatures().setSupportedFeatures(features$1);
        s.zkClient().updateBrokerInfo(s.createBrokerInfo());
    }

    public static final /* synthetic */ int $anonfun$updateSupportedFeatures$2(KafkaServer s) {
        return s.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$6(Features features$1, Broker b) {
        return b.features().equals((Object)features$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$4(Set brokerIds$1, Features features$1, KafkaServer s) {
        if (s.kafkaController().isActive()) {
            return ((IterableOnceOps)s.kafkaController().controllerContext().liveOrShuttingDownBrokers().filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).forall((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$6(features$1, b)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$3(UpdateFeaturesTest $this, Set brokerIds$1, Features features$1) {
        return $this.servers().exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UpdateFeaturesTest.$anonfun$updateSupportedFeatures$4(brokerIds$1, features$1, s)));
    }

    public static final /* synthetic */ String $anonfun$updateSupportedFeatures$7() {
        return "Controller did not get broker updates";
    }

    public static final /* synthetic */ void $anonfun$updateFeatureZNode$1(int newVersion$1, KafkaServer s) {
        s.featureCache().waitUntilEpochOrThrow((long)newVersion$1, (long)s.config().zkConnectionTimeoutMs());
    }

    public static final /* synthetic */ void $anonfun$checkException$1(UpdateFeaturesResult result$1, ClassTag tag$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String feature = (String)x0$1._1();
            Regex exceptionMsgPattern = (Regex)x0$1._2();
            Throwable cause = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)result$1.values().get(feature)).get())).getCause();
            Assertions.assertNotNull((Object)cause);
            Assertions.assertEquals(cause.getClass(), (Object)tag$1.runtimeClass());
            Assertions.assertTrue((boolean)exceptionMsgPattern.findFirstIn((CharSequence)cause.getMessage()).isDefined(), (String)new StringBuilder(35).append("Received unexpected error message: ").append(cause.getMessage()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$1(KafkaServer server) {
        return server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testShouldFailRequestDuringBrokerMaxVersionLevelIncompatibility$2(KafkaServer server) {
        return !server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$1(KafkaServer server) {
        return server.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testPartialSuccessDuringInvalidFeatureUpgradeAndValidDowngrade$2(KafkaServer server) {
        return !server.kafkaController().isActive();
    }
}

