/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.metadata.BrokerMetadataListener;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001\u0002\u0015*\u0001ABQa\u000e\u0001\u0005\u0002aBQa\u000f\u0001\u0005\nqBq!\u0014\u0001\u0012\u0002\u0013%a\nC\u0004Z\u0001E\u0005I\u0011\u0002.\t\u000bq\u0003A\u0011A/\t\u000b9\u0004A\u0011A/\u0007\tA\u0004\u0001!\u001d\u0005\u0006o\u001d!\tA\u001d\u0005\bk\u001e\u0001\r\u0011\"\u0001w\u0011!yx\u00011A\u0005\u0002\u0005\u0005\u0001bBA\u0004\u000f\u0001\u0006Ka\u001e\u0005\n\u0003\u00139!\u0019!C\u0001\u0003\u0017A\u0001\"!\u0010\bA\u0003%\u0011Q\u0002\u0005\n\u0003\u007f9\u0001\u0019!C\u0001\u0003\u0003B\u0011\"a\u0011\b\u0001\u0004%\t!!\u0012\t\u000f\u0005%s\u0001)Q\u0005\u0015\"I\u00111J\u0004A\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003\u001b:\u0001\u0019!C\u0001\u0003\u001fBq!a\u0015\bA\u0003&!\nC\u0005\u0002V\u001d\u0001\r\u0011\"\u0001\u0002X!I\u0011qL\u0004A\u0002\u0013\u0005\u0011\u0011\r\u0005\t\u0003K:\u0001\u0015)\u0003\u0002Z!I\u0011qM\u0004A\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003S:\u0001\u0019!C\u0001\u0003WBq!a\u001c\bA\u0003&!\nC\u0004\u0002r\u001d!\t%a\u001d\u0007\r\u0005\r\u0005\u0001AAC\u0011\u001994\u0004\"\u0001\u0002\u000e\"9Qo\u0007a\u0001\n\u00031\b\u0002C@\u001c\u0001\u0004%\t!!%\t\u000f\u0005\u001d1\u0004)Q\u0005o\"9\u0011QS\u000e\u0005B\u0005]\u0005\"CAS\u0001\t\u0007I\u0011BAT\u0011!\t)\f\u0001Q\u0001\n\u0005%\u0006bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\u0007\u0003\u0007\u0004A\u0011A/\t\r\u0005\u001d\u0007\u0001\"\u0001^\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!!8\u0001\t\u0013\tyN\u0001\u000eCe>\\WM]'fi\u0006$\u0017\r^1MSN$XM\\3s)\u0016\u001cHO\u0003\u0002+W\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002-[\u000511/\u001a:wKJT\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003%\n\u0011D\\3x\u0005J|7.\u001a:NKR\fG-\u0019;b\u0019&\u001cH/\u001a8feR\u0019Q\b\u0011%\u0011\u0005ir\u0014BA *\u0005Y\u0011%o\\6fe6+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014\bbB!\u0003!\u0003\u0005\rAQ\u0001\fg:\f\u0007o\u001d5piR,'\u000fE\u00023\u0007\u0016K!\u0001R\u001a\u0003\r=\u0003H/[8o!\tQd)\u0003\u0002HS\t\u0019R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e;fe\"9\u0011J\u0001I\u0001\u0002\u0004Q\u0015\u0001G7bq\nKH/Z:CKR<X-\u001a8T]\u0006\u00048\u000f[8ugB\u0011!gS\u0005\u0003\u0019N\u0012A\u0001T8oO\u0006\u0019c.Z<Ce>\\WM]'fi\u0006$\u0017\r^1MSN$XM\\3sI\u0011,g-Y;mi\u0012\nT#A(+\u0005\t\u00036&A)\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016!C;oG\",7m[3e\u0015\t16'\u0001\u0006b]:|G/\u0019;j_:L!\u0001W*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0012oK^\u0014%o\\6fe6+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003mS#A\u0013)\u0002%Q,7\u000f^\"sK\u0006$X-\u00118e\u00072|7/\u001a\u000b\u0002=B\u0011!gX\u0005\u0003AN\u0012A!\u00168ji\"\u0012QA\u0019\t\u0003G2l\u0011\u0001\u001a\u0006\u0003K\u001a\f1!\u00199j\u0015\t9\u0007.A\u0004kkBLG/\u001a:\u000b\u0005%T\u0017!\u00026v]&$(\"A6\u0002\u0007=\u0014x-\u0003\u0002nI\n!A+Z:u\u0003-!Xm\u001d;Qk\nd\u0017n\u001d5)\u0005\u0019\u0011'aF'pG.lU\r^1eCR\f7K\\1qg\"|G\u000f^3s'\r9\u0011'\u0012\u000b\u0002gB\u0011AoB\u0007\u0002\u0001\u0005)\u0011.\\1hKV\tq\u000f\u0005\u0002y{6\t\u0011P\u0003\u0002vu*\u0011af\u001f\u0006\u0003y*\fa!\u00199bG\",\u0017B\u0001@z\u00055iU\r^1eCR\f\u0017*\\1hK\u0006I\u0011.\\1hK~#S-\u001d\u000b\u0004=\u0006\r\u0001\u0002CA\u0003\u0015\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'\u0001\u0004j[\u0006<W\rI\u0001\bM\u0006LG.\u001e:f+\t\ti\u0001\u0005\u0004\u0002\u0010\u0005\u0005\u0012QE\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u00051\u0011\r^8nS\u000eTA!a\u0006\u0002\u001a\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005m\u0011QD\u0001\u0005kRLGN\u0003\u0002\u0002 \u0005!!.\u0019<b\u0013\u0011\t\u0019#!\u0005\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004B!a\n\u000289!\u0011\u0011FA\u001a\u001d\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018_\u00051AH]8pizJ\u0011\u0001N\u0005\u0004\u0003k\u0019\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003s\tYDA\u0005UQJ|w/\u00192mK*\u0019\u0011QG\u001a\u0002\u0011\u0019\f\u0017\u000e\\;sK\u0002\nA#Y2uSZ,7K\\1qg\"|Go\u00144gg\u0016$X#\u0001&\u00021\u0005\u001cG/\u001b<f':\f\u0007o\u001d5pi>3gm]3u?\u0012*\u0017\u000fF\u0002_\u0003\u000fB\u0001\"!\u0002\u0010\u0003\u0003\u0005\rAS\u0001\u0016C\u000e$\u0018N^3T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;!\u0003M\u0001(/\u001a<D_6l\u0017\u000e\u001e;fI>3gm]3u\u0003]\u0001(/\u001a<D_6l\u0017\u000e\u001e;fI>3gm]3u?\u0012*\u0017\u000fF\u0002_\u0003#B\u0001\"!\u0002\u0013\u0003\u0003\u0005\rAS\u0001\u0015aJ,goQ8n[&$H/\u001a3PM\u001a\u001cX\r\u001e\u0011\u0002%A\u0014XM^\"p[6LG\u000f^3e\u000bB|7\r[\u000b\u0003\u00033\u00022AMA.\u0013\r\tif\r\u0002\u0004\u0013:$\u0018A\u00069sKZ\u001cu.\\7jiR,G-\u00129pG\"|F%Z9\u0015\u0007y\u000b\u0019\u0007C\u0005\u0002\u0006U\t\t\u00111\u0001\u0002Z\u0005\u0019\u0002O]3w\u0007>lW.\u001b;uK\u0012,\u0005o\\2iA\u0005A\u0002O]3w\u0019\u0006\u001cHoQ8oi\u0006Lg.\u001a3M_\u001e$\u0016.\\3\u00029A\u0014XM\u001e'bgR\u001cuN\u001c;bS:,G\rT8h)&lWm\u0018\u0013fcR\u0019a,!\u001c\t\u0011\u0005\u0015\u0001$!AA\u0002)\u000b\u0011\u0004\u001d:fm2\u000b7\u000f^\"p]R\f\u0017N\\3e\u0019><G+[7fA\u0005\u0011R.Y=cKN#\u0018M\u001d;T]\u0006\u00048\u000f[8u)\u0019\t)(a\u001f\u0002\u0000A\u0019!'a\u001e\n\u0007\u0005e4GA\u0004C_>dW-\u00198\t\r\u0005u$\u00041\u0001K\u0003Qa\u0017m\u001d;D_:$\u0018-\u001b8fI2{w\rV5nK\"1\u0011\u0011\u0011\u000eA\u0002]\f\u0001B\\3x\u00136\fw-\u001a\u0002\u0016\u001b>\u001c7.T3uC\u0012\fG/\u0019)vE2L7\u000f[3s'\u0011Y\u0012'a\"\u0011\u0007i\nI)C\u0002\u0002\f&\u0012\u0011#T3uC\u0012\fG/\u0019)vE2L7\u000f[3s)\t\ty\t\u0005\u0002u7Q\u0019a,a%\t\u0011\u0005\u0015a$!AA\u0002]\fq\u0001];cY&\u001c\b\u000eF\u0003_\u00033\u000b\u0019\u000bC\u0004\u0002\u001c\u0002\u0002\r!!(\u0002\u000b\u0011,G\u000e^1\u0011\u0007a\fy*C\u0002\u0002\"f\u0014Q\"T3uC\u0012\fG/\u0019#fYR\f\u0007BBAAA\u0001\u0007q/\u0001\u0004G\u001f>{\u0016\nR\u000b\u0003\u0003S\u0003B!a+\u000226\u0011\u0011Q\u0016\u0006\u0004\u0003_S\u0018AB2p[6|g.\u0003\u0003\u00024\u00065&\u0001B+vS\u0012\fqAR(P?&#\u0005%A\nhK:,'/\u0019;f\u001b\u0006t\u0017PU3d_J$7\u000fF\u0003_\u0003w\u000by\f\u0003\u0004\u0002>\u000e\u0002\r!P\u0001\tY&\u001cH/\u001a8fe\"1\u0011\u0011Y\u0012A\u0002)\u000b\u0011\"\u001a8e\u001f\u001a47/\u001a;\u0002SQ,7\u000f\u001e%b]\u0012dWmQ8n[&$8oV5uQ:{7K\\1qg\"|G\u000f^3s\t\u00164\u0017N\\3eQ\t!#-\u0001\nuKN$8I]3bi\u0016\u001cf.\u00199tQ>$\bFA\u0013c\u0003=\u0011XmZ5ti\u0016\u0014(I]8lKJ\u001cHc\u00020\u0002P\u0006E\u00171\u001c\u0005\u0007\u0003{3\u0003\u0019A\u001f\t\u000f\u0005Mg\u00051\u0001\u0002V\u0006I!M]8lKJLEm\u001d\t\u0007\u0003O\t9.!\u0017\n\t\u0005e\u00171\b\u0002\t\u0013R,'/\u00192mK\"1\u0011\u0011\u0019\u0014A\u0002)\u000b1d\u0019:fCR,Gk\u001c9jG^KG\u000f[(oKB\u000b'\u000f^5uS>tGc\u00020\u0002b\u0006\r\u0018Q\u001e\u0005\u0007\u0003{;\u0003\u0019A\u001f\t\u000f\u0005\u0015x\u00051\u0001\u0002h\u0006A!/\u001a9mS\u000e\f7\u000f\u0005\u0004\u0002(\u0005%\u0018\u0011L\u0005\u0005\u0003W\fYDA\u0002TKFDa!!1(\u0001\u0004Q\u0005")
public class BrokerMetadataListenerTest {
    private final Uuid FOO_ID = Uuid.fromString((String)"jj1G9utnTuCegi_gpnRgYw");

    private BrokerMetadataListener newBrokerMetadataListener(Option<MetadataSnapshotter> snapshotter, long maxBytesBetweenSnapshots) {
        return new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, maxBytesBetweenSnapshots, snapshotter);
    }

    private Option<MetadataSnapshotter> newBrokerMetadataListener$default$1() {
        return None$.MODULE$;
    }

    private long newBrokerMetadataListener$default$2() {
        return 1000000L;
    }

    @Test
    public void testCreateAndClose() {
        long l = 1000000L;
        None$ newBrokerMetadataListener_snapshotter = None$.MODULE$;
        Object var1_2 = null;
        new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, l, (Option)newBrokerMetadataListener_snapshotter).close();
    }

    @Test
    public void testPublish() {
        long l = 1000000L;
        None$ newBrokerMetadataListener_snapshotter = None$.MODULE$;
        Object var4_2 = null;
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, l, (Option)newBrokerMetadataListener_snapshotter);){
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)100L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg")), (short)0))));
            List imageRecords = (List)listener.getImageRecords().get();
            Assertions.assertEquals((int)0, (int)imageRecords.size());
            Assertions.assertEquals((long)100L, (long)listener.highestMetadataOffset());
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)200L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(200L).setFenced(true).setRack(null).setIncarnationId(Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg")), (short)0))));
            listener.startPublishing(new MetadataPublisher(null){

                public void publish(MetadataDelta delta, MetadataImage newImage) {
                    Assertions.assertEquals((long)200L, (long)newImage.highestOffsetAndEpoch().offset);
                    Assertions.assertEquals((Object)new BrokerRegistration(0, 100L, Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false), (Object)delta.clusterDelta().broker(0));
                    Assertions.assertEquals((Object)new BrokerRegistration(1, 200L, Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true), (Object)delta.clusterDelta().broker(1));
                }
            }).get();
        }
    }

    private Uuid FOO_ID() {
        return this.FOO_ID;
    }

    private void generateManyRecords(BrokerMetadataListener listener, long endOffset) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.emptyList()), (short)0)))));
        listener.getImageRecords().get();
    }

    @Test
    public void testHandleCommitsWithNoSnapshotterDefined() {
        BrokerMetadataListener brokerMetadataListener;
        None$ none$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$2 = none$2;
        long newBrokerMetadataListener_maxBytesBetweenSnapshots = 1000L;
        BrokerMetadataListener brokerMetadataListener2 = brokerMetadataListener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)x$2);
        brokerMetadataListener = null;
        try (BrokerMetadataListener listener = brokerMetadataListener2;){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)listener.highestMetadataOffset());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateSnapshot() {
        void newBrokerMetadataListener_maxBytesBetweenSnapshots;
        BrokerMetadataListener brokerMetadataListener;
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        long l = 1000L;
        Some newBrokerMetadataListener_snapshotter = new Some((Object)snapshotter);
        BrokerMetadataListener brokerMetadataListener2 = brokerMetadataListener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, (long)newBrokerMetadataListener_maxBytesBetweenSnapshots, (Option)newBrokerMetadataListener_snapshotter);
        Object var6_3 = null;
        brokerMetadataListener = null;
        try (BrokerMetadataListener listener = brokerMetadataListener2;){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)1000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.startPublishing((MetadataPublisher)publisher).get();
            this.generateManyRecords(listener, 2000L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals((long)2000L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 3000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 4000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            this.generateManyRecords(listener, 5000L);
            Assertions.assertEquals((long)5000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals(null, (Object)snapshotter.failure().get());
        }
    }

    private void registerBrokers(BrokerMetadataListener listener, Iterable<Object> brokerIds, long endOffset) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)new StringBuilder(21).append("GFBwlTcpQUuLYQ2ig05CS").append(brokerId).toString())), (short)0)))));
    }

    private void createTopicWithOnePartition(BrokerMetadataListener listener, scala.collection.immutable.Seq<Object> replicas, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(this.FOO_ID()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setLeader(0).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()), (short)0))));
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public class MockMetadataPublisher
    implements MetadataPublisher {
        private MetadataImage image;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public void publish(MetadataDelta delta, MetadataImage newImage) {
            this.image_$eq(newImage);
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataPublisher$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataPublisher() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
        }
    }

    public class MockMetadataSnapshotter
    implements MetadataSnapshotter {
        private MetadataImage image;
        private final AtomicReference<Throwable> failure;
        private long activeSnapshotOffset;
        private long prevCommittedOffset;
        private int prevCommittedEpoch;
        private long prevLastContainedLogTime;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public AtomicReference<Throwable> failure() {
            return this.failure;
        }

        public long activeSnapshotOffset() {
            return this.activeSnapshotOffset;
        }

        public void activeSnapshotOffset_$eq(long x$1) {
            this.activeSnapshotOffset = x$1;
        }

        public long prevCommittedOffset() {
            return this.prevCommittedOffset;
        }

        public void prevCommittedOffset_$eq(long x$1) {
            this.prevCommittedOffset = x$1;
        }

        public int prevCommittedEpoch() {
            return this.prevCommittedEpoch;
        }

        public void prevCommittedEpoch_$eq(int x$1) {
            this.prevCommittedEpoch = x$1;
        }

        public long prevLastContainedLogTime() {
            return this.prevLastContainedLogTime;
        }

        public void prevLastContainedLogTime_$eq(long x$1) {
            this.prevLastContainedLogTime = x$1;
        }

        public boolean maybeStartSnapshot(long lastContainedLogTime, MetadataImage newImage) {
            boolean bl;
            try {
                if (this.activeSnapshotOffset() != -1L) {
                    return false;
                }
                Assertions.assertTrue((this.prevCommittedOffset() <= newImage.highestOffsetAndEpoch().offset ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevCommittedEpoch() <= newImage.highestOffsetAndEpoch().epoch ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevLastContainedLogTime() <= lastContainedLogTime ? 1 : 0) != 0);
                this.prevCommittedOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                this.prevCommittedEpoch_$eq(newImage.highestOffsetAndEpoch().epoch);
                this.prevLastContainedLogTime_$eq(lastContainedLogTime);
                this.image_$eq(newImage);
                this.activeSnapshotOffset_$eq(newImage.highestOffsetAndEpoch().offset);
                bl = true;
            }
            catch (Throwable t) {
                bl = this.failure().compareAndSet(null, t);
            }
            return bl;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataSnapshotter$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataSnapshotter() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.failure = new AtomicReference<Object>(null);
            this.activeSnapshotOffset = -1L;
            this.prevCommittedOffset = -1L;
            this.prevCommittedEpoch = -1;
            this.prevLastContainedLogTime = -1L;
        }
    }
}

