/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.helix.model.Message;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class SegmentReloadMessage
extends Message {
    public static final String RELOAD_SEGMENT_MSG_SUB_TYPE = "RELOAD_SEGMENT";
    private static final String FORCE_DOWNLOAD_KEY = "forceDownload";

    public SegmentReloadMessage(@Nonnull String tableNameWithType, @Nullable String segmentName, boolean forceDownload) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setResourceName(tableNameWithType);
        if (segmentName != null) {
            this.setPartitionName(segmentName);
        }
        this.setMsgSubType(RELOAD_SEGMENT_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setBooleanField(FORCE_DOWNLOAD_KEY, forceDownload);
    }

    public SegmentReloadMessage(Message message) {
        super(message.getRecord());
        String msgSubType = message.getMsgSubType();
        Preconditions.checkArgument((boolean)msgSubType.equals(RELOAD_SEGMENT_MSG_SUB_TYPE), (Object)("Invalid message sub type: " + msgSubType + " for SegmentReloadMessage"));
    }

    public boolean shouldForceDownload() {
        return this.getRecord().getBooleanField(FORCE_DOWNLOAD_KEY, false);
    }
}

