/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.UUID;
import org.apache.helix.model.Message;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class TableConfigRefreshMessage
extends Message {
    public static final String REFRESH_TABLE_CONFIG_MSG_SUB_TYPE = "REFRESH_TABLE_CONFIG";
    private static final String TABLE_NAME_KEY = "tableName";

    public TableConfigRefreshMessage(String tableNameWithType) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setMsgSubType(REFRESH_TABLE_CONFIG_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setSimpleField(TABLE_NAME_KEY, tableNameWithType);
    }

    public TableConfigRefreshMessage(Message message) {
        super(message.getRecord());
        if (!message.getMsgSubType().equals(REFRESH_TABLE_CONFIG_MSG_SUB_TYPE)) {
            throw new IllegalArgumentException("Invalid message subtype:" + message.getMsgSubType());
        }
    }

    public String getTableNameWithType() {
        return this.getRecord().getSimpleField(TABLE_NAME_KEY);
    }
}

