/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.segment;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentZKMetadata
implements ZKMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentZKMetadata.class);
    private static final String NULL = "null";
    private final ZNRecord _znRecord;
    private Map<String, String> _simpleFields;
    private boolean _startTimeMsCached;
    private long _startTimeMs;
    private boolean _endTimeMsCached;
    private long _endTimeMs;

    public SegmentZKMetadata(String segmentName) {
        this._znRecord = new ZNRecord(segmentName);
        this._simpleFields = this._znRecord.getSimpleFields();
    }

    public SegmentZKMetadata(ZNRecord znRecord) {
        this._znRecord = znRecord;
        this._simpleFields = znRecord.getSimpleFields();
    }

    public String getSegmentName() {
        return this._znRecord.getId();
    }

    public long getStartTimeMs() {
        if (!this._startTimeMsCached) {
            long startTime;
            long startTimeMs = -1L;
            String startTimeString = this._simpleFields.get("segment.start.time");
            if (startTimeString != null && (startTime = Long.parseLong(startTimeString)) > 0L) {
                startTimeMs = TimeUnit.valueOf(this._simpleFields.get("segment.time.unit")).toMillis(startTime);
            }
            this._startTimeMs = startTimeMs;
            this._startTimeMsCached = true;
        }
        return this._startTimeMs;
    }

    public long getEndTimeMs() {
        if (!this._endTimeMsCached) {
            long endTime;
            long endTimeMs = -1L;
            String endTimeString = this._simpleFields.get("segment.end.time");
            if (endTimeString != null && (endTime = Long.parseLong(endTimeString)) > 0L) {
                endTimeMs = TimeUnit.valueOf(this._simpleFields.get("segment.time.unit")).toMillis(endTime);
            }
            this._endTimeMs = endTimeMs;
            this._endTimeMsCached = true;
        }
        return this._endTimeMs;
    }

    public void setStartTime(long startTime) {
        this.setNonNegativeValue("segment.start.time", startTime);
        this._startTimeMsCached = false;
    }

    public void setEndTime(long endTime) {
        this.setNonNegativeValue("segment.end.time", endTime);
        this._endTimeMsCached = false;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.setValue("segment.time.unit", (Object)timeUnit);
        this._startTimeMsCached = false;
        this._endTimeMsCached = false;
    }

    public String getIndexVersion() {
        return this._simpleFields.get("segment.index.version");
    }

    public void setIndexVersion(String indexVersion) {
        this.setValue("segment.index.version", indexVersion);
    }

    public long getTotalDocs() {
        return this._znRecord.getLongField("segment.total.docs", -1L);
    }

    public void setTotalDocs(long totalDocs) {
        this.setNonNegativeValue("segment.total.docs", totalDocs);
    }

    public void setSizeInBytes(long sizeInBytes) {
        this.setNonNegativeValue("segment.size.in.bytes", sizeInBytes);
    }

    public long getSizeInBytes() {
        return this._znRecord.getLongField("segment.size.in.bytes", -1L);
    }

    public long getCrc() {
        return this._znRecord.getLongField("segment.crc", -1L);
    }

    public void setCrc(long crc) {
        this.setNonNegativeValue("segment.crc", crc);
    }

    public long getCreationTime() {
        return this._znRecord.getLongField("segment.creation.time", -1L);
    }

    public void setCreationTime(long creationTime) {
        this.setNonNegativeValue("segment.creation.time", creationTime);
    }

    public long getPushTime() {
        String pushTimeString = this._simpleFields.get("segment.push.time");
        if (pushTimeString == null) {
            pushTimeString = this._simpleFields.get("segment.offline.push.time");
        }
        return pushTimeString != null ? Long.parseLong(pushTimeString) : Long.MIN_VALUE;
    }

    public void setPushTime(long pushTime) {
        this.setNonNegativeValue("segment.push.time", pushTime);
    }

    public long getRefreshTime() {
        String refreshTimeString = this._simpleFields.get("segment.refresh.time");
        if (refreshTimeString == null) {
            refreshTimeString = this._simpleFields.get("segment.offline.refresh.time");
        }
        return refreshTimeString != null ? Long.parseLong(refreshTimeString) : Long.MIN_VALUE;
    }

    public void setRefreshTime(long pushTime) {
        this.setNonNegativeValue("segment.refresh.time", pushTime);
    }

    public String getDownloadUrl() {
        String downloadUrl = this._simpleFields.get("segment.download.url");
        if (downloadUrl == null && (downloadUrl = this._simpleFields.get("segment.offline.download.url")) == null) {
            downloadUrl = this._simpleFields.get("segment.realtime.download.url");
        }
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.setValue("segment.download.url", downloadUrl);
    }

    public String getCrypterName() {
        return this._simpleFields.get("segment.crypter");
    }

    public void setCrypterName(String crypterName) {
        this.setValue("segment.crypter", crypterName);
    }

    public SegmentPartitionMetadata getPartitionMetadata() {
        String partitionMetadataJson = this._simpleFields.get("segment.partition.metadata");
        if (partitionMetadataJson != null) {
            try {
                return SegmentPartitionMetadata.fromJsonString(partitionMetadataJson);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while reading partition metadata for segment: {}", (Object)this.getSegmentName(), (Object)e);
            }
        }
        return null;
    }

    public void setPartitionMetadata(SegmentPartitionMetadata partitionMetadata) {
        if (partitionMetadata != null) {
            try {
                this._simpleFields.put("segment.partition.metadata", partitionMetadata.toJsonString());
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while writing partition metadata for segment: {}", (Object)this.getSegmentName(), (Object)e);
            }
        } else {
            this._simpleFields.remove("segment.partition.metadata");
        }
    }

    public Map<String, String> getCustomMap() {
        return this._znRecord.getMapField("custom.map");
    }

    public void setCustomMap(Map<String, String> customMap) {
        Map mapFields = this._znRecord.getMapFields();
        if (MapUtils.isNotEmpty(customMap)) {
            mapFields.put("custom.map", customMap);
        } else {
            mapFields.remove("custom.map");
        }
    }

    public CommonConstants.Segment.Realtime.Status getStatus() {
        return (CommonConstants.Segment.Realtime.Status)this._znRecord.getEnumField("segment.realtime.status", CommonConstants.Segment.Realtime.Status.class, (Enum)CommonConstants.Segment.Realtime.Status.UPLOADED);
    }

    public void setStatus(CommonConstants.Segment.Realtime.Status status) {
        this.setValue("segment.realtime.status", status);
    }

    public int getSizeThresholdToFlushSegment() {
        return this._znRecord.getIntField("segment.flush.threshold.size", -1);
    }

    public void setSizeThresholdToFlushSegment(int flushThresholdSize) {
        this.setNonNegativeValue("segment.flush.threshold.size", flushThresholdSize);
    }

    public String getTimeThresholdToFlushSegment() {
        String flushThresholdTime = this._simpleFields.get("segment.flush.threshold.time");
        if (flushThresholdTime != null && !flushThresholdTime.equals(NULL)) {
            return flushThresholdTime;
        }
        return null;
    }

    public void setTimeThresholdToFlushSegment(String flushThresholdTime) {
        this.setValue("segment.flush.threshold.time", flushThresholdTime);
    }

    public String getStartOffset() {
        return this._simpleFields.get("segment.realtime.startOffset");
    }

    public void setStartOffset(String startOffset) {
        this.setValue("segment.realtime.startOffset", startOffset);
    }

    public String getEndOffset() {
        return this._simpleFields.get("segment.realtime.endOffset");
    }

    public void setEndOffset(String endOffset) {
        this.setValue("segment.realtime.endOffset", endOffset);
    }

    public int getNumReplicas() {
        return this._znRecord.getIntField("segment.realtime.numReplicas", -1);
    }

    public void setNumReplicas(int numReplicas) {
        this.setNonNegativeValue("segment.realtime.numReplicas", numReplicas);
    }

    public long getSegmentUploadStartTime() {
        return this._znRecord.getLongField("segment.upload.start.time", -1L);
    }

    public void setSegmentUploadStartTime(long segmentUploadStartTime) {
        this.setNonNegativeValue("segment.upload.start.time", segmentUploadStartTime);
    }

    private void setValue(String key, Object value) {
        if (value != null) {
            this._simpleFields.put(key, value.toString());
        } else {
            this._simpleFields.remove(key);
        }
    }

    private void setNonNegativeValue(String key, long value) {
        if (value >= 0L) {
            this._simpleFields.put(key, Long.toString(value));
        } else {
            this._simpleFields.remove(key);
        }
    }

    public Map<String, String> toMap() {
        TreeMap<String, String> metadataMap = new TreeMap<String, String>(this._simpleFields);
        Map<String, String> customMap = this.getCustomMap();
        if (customMap != null) {
            try {
                metadataMap.put("custom.map", JsonUtils.objectToString(customMap));
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while writing custom map for segment: {}", (Object)this.getSegmentName(), (Object)e);
            }
        }
        return metadataMap;
    }

    @Override
    public ZNRecord toZNRecord() {
        if (!(this._simpleFields instanceof TreeMap)) {
            this._simpleFields = new TreeMap<String, String>(this._simpleFields);
            this._znRecord.setSimpleFields(this._simpleFields);
        }
        return this._znRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.toMap().equals(((SegmentZKMetadata)o).toMap());
    }

    public int hashCode() {
        return this.toMap().hashCode();
    }
}

