/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.pinot.common.minion.BaseTaskGeneratorInfo;

@JsonPropertyOrder(value={"tableNameWithType", "taskType", "mostRecentSuccessRunTS", "mostRecentErrorRunMessages"})
public class TaskGeneratorMostRecentRunInfo
extends BaseTaskGeneratorInfo {
    @VisibleForTesting
    static final int MAX_NUM_OF_HISTORY_TO_KEEP = 5;
    private final String _taskType;
    private final String _tableNameWithType;
    private final TreeMap<Long, String> _mostRecentErrorRunMessages;
    private final List<Long> _mostRecentSuccessRunTS;

    private TaskGeneratorMostRecentRunInfo(String tableNameWithType, String taskType) {
        this._tableNameWithType = tableNameWithType;
        this._taskType = taskType;
        this._mostRecentErrorRunMessages = new TreeMap();
        this._mostRecentSuccessRunTS = new ArrayList<Long>();
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    @Override
    public String getTaskType() {
        return this._taskType;
    }

    public TreeMap<String, String> getMostRecentErrorRunMessages() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        this._mostRecentErrorRunMessages.forEach((timestamp, error) -> result.put(OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC).toString(), (String)error));
        return result;
    }

    public void addErrorRunMessage(long ts, String message) {
        this._mostRecentErrorRunMessages.put(ts, message);
        if (this._mostRecentErrorRunMessages.size() > 5) {
            this._mostRecentErrorRunMessages.remove(this._mostRecentErrorRunMessages.firstKey());
        }
    }

    public List<String> getMostRecentSuccessRunTS() {
        return this._mostRecentSuccessRunTS.stream().map(timestamp -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC).toString()).collect(Collectors.toList());
    }

    public void addSuccessRunTs(long ts) {
        this._mostRecentSuccessRunTS.add(ts);
        if (this._mostRecentSuccessRunTS.size() > 5) {
            Collections.sort(this._mostRecentSuccessRunTS);
            this._mostRecentSuccessRunTS.remove(0);
        }
    }

    public static TaskGeneratorMostRecentRunInfo newInstance(String tableNameWithType, String taskType) {
        return new TaskGeneratorMostRecentRunInfo(tableNameWithType, taskType);
    }
}

