/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PinotConnectionMetaData;
import org.apache.pinot.client.PinotPreparedStatement;
import org.apache.pinot.client.PinotStatement;
import org.apache.pinot.client.base.AbstractBaseConnection;
import org.apache.pinot.client.controller.PinotControllerTransport;
import org.apache.pinot.client.controller.PinotControllerTransportFactory;
import org.apache.pinot.client.controller.response.ControllerTenantBrokerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotConnection
extends AbstractBaseConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(java.sql.Connection.class);
    private Connection _session;
    private boolean _closed = false;
    private String _controllerURL;
    private PinotControllerTransport _controllerTransport;
    public static final String BROKER_LIST = "brokers";

    PinotConnection(String controllerURL, PinotClientTransport transport, String tenant, PinotControllerTransport controllerTransport) {
        this(new Properties(), controllerURL, transport, tenant, controllerTransport);
    }

    PinotConnection(Properties properties, String controllerURL, PinotClientTransport transport, String tenant, PinotControllerTransport controllerTransport) {
        this._controllerURL = controllerURL;
        this._controllerTransport = controllerTransport == null ? new PinotControllerTransportFactory().buildTransport() : controllerTransport;
        List<String> brokers = properties.containsKey(BROKER_LIST) ? Arrays.asList(properties.getProperty(BROKER_LIST).split(";")) : this.getBrokerList(controllerURL, tenant);
        this._session = new Connection(properties, brokers, transport);
    }

    public Connection getSession() {
        return this._session;
    }

    private List<String> getBrokerList(String controllerURL, String tenant) {
        ControllerTenantBrokerResponse controllerTenantBrokerResponse = this._controllerTransport.getBrokersFromController(controllerURL, tenant);
        return controllerTenantBrokerResponse.getBrokers();
    }

    @Override
    protected void validateState() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is already closed!");
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this._session.close();
            this._controllerTransport.close();
        }
        this._controllerTransport = null;
        this._session = null;
        this._closed = true;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.validateState();
        return new PinotStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateState();
        return new PinotPreparedStatement(this, sql);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new PinotConnectionMetaData(this, this._controllerURL, this._controllerTransport);
    }
}

