/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.client.base.AbstractBaseResultSetMetadata;
import org.apache.pinot.client.utils.DriverUtils;

public class PinotResultMetadata
extends AbstractBaseResultSetMetadata {
    private int _totalColumns;
    private Map<Integer, String> _columns = new HashMap<Integer, String>();
    private Map<Integer, String> _columnDataTypes = new HashMap<Integer, String>();

    public PinotResultMetadata(int totalColumns, Map<String, Integer> columnsNameToIndex, Map<Integer, String> columnDataTypes) {
        this._totalColumns = totalColumns;
        this._columnDataTypes = columnDataTypes;
        for (Map.Entry<String, Integer> entry : columnsNameToIndex.entrySet()) {
            this._columns.put(entry.getValue(), entry.getKey());
        }
    }

    private void validateState(int column) throws SQLException {
        if (column > this._totalColumns) {
            throw new SQLException("Column Index " + column + "is greater than total columns " + this._totalColumns);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._totalColumns;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.validateState(column);
        return this._columns.getOrDefault(column, "");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String columnTypeName = this.getColumnTypeName(column);
        return DriverUtils.getJavaClassName(columnTypeName);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        String columnTypeName = this.getColumnTypeName(column);
        return DriverUtils.getSQLDataType(columnTypeName);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.validateState(column);
        return this._columnDataTypes.get(column);
    }
}

