/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.controller.response;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.client.controller.response.ControllerResponseFuture;
import org.apache.pinot.spi.utils.JsonUtils;
import org.asynchttpclient.Response;

public class TableResponse {
    private JsonNode _tables;

    private TableResponse() {
    }

    private TableResponse(JsonNode tableResponse) {
        this._tables = tableResponse.get("tables");
    }

    public static TableResponse fromJson(JsonNode tableResponse) {
        return new TableResponse(tableResponse);
    }

    public static TableResponse empty() {
        return new TableResponse();
    }

    public List<String> getAllTables() {
        ArrayList<String> allTables = new ArrayList<String>();
        if (this._tables == null) {
            return allTables;
        }
        if (this._tables.isArray()) {
            for (JsonNode table : this._tables) {
                allTables.add(table.textValue());
            }
        }
        return allTables;
    }

    public int getNumTables() {
        if (this._tables == null) {
            return 0;
        }
        return this._tables.size();
    }

    public static class TableResponseFuture
    extends ControllerResponseFuture<TableResponse> {
        public TableResponseFuture(Future<Response> response, String url) {
            super(response, url);
        }

        @Override
        public TableResponse get(long timeout, TimeUnit unit) throws ExecutionException {
            String response = this.getStringResponse(timeout, unit);
            try {
                JsonNode jsonResponse = JsonUtils.stringToJsonNode((String)response);
                TableResponse tableResponse = TableResponse.fromJson(jsonResponse);
                return tableResponse;
            }
            catch (IOException e) {
                new ExecutionException(e);
                return null;
            }
        }
    }
}

