/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.utils;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtils {
    private static final String TIMESTAMP_FORMAT_STR = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT_STR = "yyyy-MM-dd";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DateTimeUtils() {
    }

    public static java.sql.Date getDateFromString(String value, Calendar cal) throws ParseException {
        DATE_FORMAT.setTimeZone(cal.getTimeZone());
        Date date = DATE_FORMAT.parse(value);
        java.sql.Date sqlDate = new java.sql.Date(date.getTime());
        return sqlDate;
    }

    public static Time getTimeFromString(String value, Calendar cal) throws ParseException {
        TIMESTAMP_FORMAT.setTimeZone(cal.getTimeZone());
        Date date = TIMESTAMP_FORMAT.parse(value);
        Time sqlTime = new Time(date.getTime());
        return sqlTime;
    }

    public static Timestamp getTimestampFromString(String value, Calendar cal) throws ParseException {
        TIMESTAMP_FORMAT.setTimeZone(cal.getTimeZone());
        Date date = TIMESTAMP_FORMAT.parse(value);
        Timestamp sqlTime = new Timestamp(date.getTime());
        return sqlTime;
    }

    public static Timestamp getTimestampFromLong(Long value) {
        Timestamp sqlTime = new Timestamp(value);
        return sqlTime;
    }

    public static String dateToString(java.sql.Date date) {
        return DATE_FORMAT.format(date.getTime());
    }

    public static String timeToString(Time time) {
        return TIMESTAMP_FORMAT.format(time.getTime());
    }

    public static String timeStampToString(Timestamp timestamp) {
        return TIMESTAMP_FORMAT.format(timestamp.getTime());
    }

    public static long timeStampToLong(Timestamp timestamp) {
        return timestamp.getTime();
    }
}

