/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.annotation.Nullable;
import org.apache.pinot.spi.utils.JsonUtils;

public class ColumnStats {
    public static final String CARDINALITY = "cardinality";
    public static final String PRIMARY_KEY_SIZE = "primaryKeySize";
    public static final String NUM_PARTITIONS = "numPartitions";
    private long _cardinality;
    private int _primaryKeySize = 8;
    private int _numPartitions = 0;

    public ColumnStats(long cardinality) {
        this._cardinality = cardinality;
    }

    @JsonCreator
    public ColumnStats(@JsonProperty(value="cardinality", required=true) long cardinality, @JsonProperty(value="primaryKeySize") int primaryKeySize, @JsonProperty(value="numPartitions") int numPartitions) {
        this._cardinality = cardinality;
        this._primaryKeySize = primaryKeySize;
        this._numPartitions = numPartitions;
    }

    @JsonProperty(value="cardinality")
    public long getCardinality() {
        return this._cardinality;
    }

    @Nullable
    @JsonProperty(value="primaryKeySize")
    public int getPrimaryKeySize() {
        return this._primaryKeySize;
    }

    @JsonProperty(value="numPartitions")
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public void setCardinality(long cardinality) {
        this._cardinality = cardinality;
    }

    public void setPrimaryKeySize(int primaryKeySize) {
        this._primaryKeySize = primaryKeySize;
    }

    public void setNumPartitions(int numPartitions) {
        this._numPartitions = numPartitions;
    }

    public String toJsonString() {
        try {
            return JsonUtils.objectToString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

