/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils.builder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.utils.StringUtil;

public class ControllerRequestURLBuilder {
    private final String _baseUrl;

    private ControllerRequestURLBuilder(String baseUrl) {
        int length = baseUrl.length();
        this._baseUrl = baseUrl.charAt(length - 1) == '/' ? baseUrl.substring(0, length - 1) : baseUrl;
    }

    public static ControllerRequestURLBuilder baseUrl(String baseUrl) {
        return new ControllerRequestURLBuilder(baseUrl);
    }

    public String getBaseUrl() {
        return this._baseUrl;
    }

    public String forDataFileUpload() {
        return StringUtil.join("/", this._baseUrl, "segments");
    }

    public String forInstanceCreate() {
        return StringUtil.join("/", this._baseUrl, "instances");
    }

    public String forInstanceState(String instanceName) {
        return StringUtil.join("/", this._baseUrl, "instances", instanceName, "state");
    }

    public String forInstance(String instanceName) {
        return StringUtil.join("/", this._baseUrl, "instances", instanceName);
    }

    public String forInstanceUpdateTags(String instanceName, List<String> tags) {
        return this.forInstanceUpdateTags(instanceName, tags, false);
    }

    public String forInstanceUpdateTags(String instanceName, List<String> tags, boolean updateBrokerResource) {
        return StringUtil.join("/", this._baseUrl, "instances", instanceName, "updateTags?tags=" + StringUtils.join(tags, (String)",") + "&updateBrokerResource=" + updateBrokerResource);
    }

    public String forInstanceList() {
        return StringUtil.join("/", this._baseUrl, "instances");
    }

    public String forTablesFromTenant(String tenantName) {
        return StringUtil.join("/", this._baseUrl, "tenants", tenantName, "tables");
    }

    public String forTenantCreate() {
        return StringUtil.join("/", this._baseUrl, "tenants");
    }

    public String forUserCreate() {
        return StringUtil.join("/", this._baseUrl, "users");
    }

    public String forTenantGet() {
        return StringUtil.join("/", this._baseUrl, "tenants");
    }

    public String forUserGet(String username, String componentTypeStr) {
        StringBuilder params = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            params.append("?component=" + componentTypeStr);
        }
        return StringUtil.join("/", this._baseUrl, "users", username, params.toString());
    }

    public String forUpdateUserConfig(String username, String componentTypeStr, boolean passwordChanged) {
        StringBuilder params = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            params.append("?component=" + componentTypeStr);
        }
        params.append(String.format("&&passwordChanged=%s", passwordChanged));
        return StringUtil.join("/", this._baseUrl, "users", username, params.toString());
    }

    public String forTenantGet(String tenantName) {
        return StringUtil.join("/", this._baseUrl, "tenants", tenantName);
    }

    public String forBrokerTenantGet(String tenantName) {
        return StringUtil.join("/", this._baseUrl, "tenants", tenantName, "?type=broker");
    }

    public String forServerTenantGet(String tenantName) {
        return StringUtil.join("/", this._baseUrl, "tenants", tenantName, "?type=server");
    }

    public String forBrokerTenantDelete(String tenantName) {
        return StringUtil.join("/", this._baseUrl, "tenants", tenantName, "?type=broker");
    }

    public String forServerTenantDelete(String tenantName) {
        return StringUtil.join("/", this._baseUrl, "tenants", tenantName, "?type=server");
    }

    public String forBrokersGet(String state) {
        if (state == null) {
            return StringUtil.join("/", this._baseUrl, "brokers");
        }
        return StringUtil.join("/", this._baseUrl, "brokers", "?state=" + state);
    }

    public String forBrokerTenantsGet(String state) {
        if (state == null) {
            return StringUtil.join("/", this._baseUrl, "brokers", "tenants");
        }
        return StringUtil.join("/", this._baseUrl, "brokers", "tenants", "?state=" + state);
    }

    public String forBrokerTenantGet(String tenant, String state) {
        if (state == null) {
            return StringUtil.join("/", this._baseUrl, "brokers", "tenants", tenant);
        }
        return StringUtil.join("/", this._baseUrl, "brokers", "tenants", tenant, "?state=" + state);
    }

    public String forBrokerTablesGet(String state) {
        if (state == null) {
            return StringUtil.join("/", this._baseUrl, "brokers", "tables");
        }
        return StringUtil.join("/", this._baseUrl, "brokers", "tables", "?state=" + state);
    }

    public String forLiveBrokerTablesGet() {
        return StringUtil.join("/", this._baseUrl, "tables", "livebrokers");
    }

    public String forBrokerTableGet(String table, String tableType, String state) {
        StringBuilder params = new StringBuilder();
        if (tableType != null) {
            params.append("?type=" + tableType);
        }
        if (state != null) {
            if (params.length() > 0) {
                params.append("&");
            }
            params.append("?state=" + state);
        }
        return StringUtil.join("/", this._baseUrl, "brokers", "tables", table, params.toString());
    }

    public String forTableCreate() {
        return StringUtil.join("/", this._baseUrl, "tables");
    }

    public String forUpdateTableConfig(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName);
    }

    public String forTableRebalance(String tableName, String tableType) {
        return this.forTableRebalance(tableName, tableType, false, false, false, false, 1);
    }

    public String forTableRebalance(String tableName, String tableType, boolean dryRun, boolean reassignInstances, boolean includeConsuming, boolean downtime, int minAvailableReplicas) {
        StringBuilder stringBuilder = new StringBuilder(StringUtil.join("/", this._baseUrl, "tables", tableName, "rebalance?type=" + tableType));
        if (dryRun) {
            stringBuilder.append("&dryRun=").append(dryRun);
        }
        if (reassignInstances) {
            stringBuilder.append("&reassignInstances=").append(reassignInstances);
        }
        if (includeConsuming) {
            stringBuilder.append("&includeConsuming=").append(includeConsuming);
        }
        if (downtime) {
            stringBuilder.append("&downtime=").append(downtime);
        }
        if (minAvailableReplicas != 1) {
            stringBuilder.append("&minAvailableReplicas=").append(minAvailableReplicas);
        }
        return stringBuilder.toString();
    }

    public String forTableReload(String tableName, TableType tableType, boolean forceDownload) {
        String query = String.format("reload?type=%s&forceDownload=%s", tableType.name(), forceDownload);
        return StringUtil.join("/", this._baseUrl, "segments", tableName, query);
    }

    public String forTableReset(String tableNameWithType, @Nullable String targetInstance) {
        String query = targetInstance == null ? "reset" : String.format("reset?targetInstance=%s", targetInstance);
        return StringUtil.join("/", this._baseUrl, "segments", tableNameWithType, query);
    }

    public String forControllerJobStatus(String jobId) {
        return StringUtil.join("/", this._baseUrl, "segments", "segmentReloadStatus", jobId);
    }

    public String forTableSize(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "size");
    }

    public String forTableUpdateIndexingConfigs(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "indexingConfigs");
    }

    public String forTableGetServerInstances(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "instances?type=server");
    }

    public String forTableGetBrokerInstances(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "instances?type=broker");
    }

    public String forTableGet(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName);
    }

    public String forTableDelete(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName);
    }

    public String forTableView(String tableName, String view, @Nullable String tableType) {
        Object url = StringUtil.join("/", this._baseUrl, "tables", tableName, view);
        if (tableType != null) {
            url = (String)url + "?tableType=" + tableType;
        }
        return url;
    }

    public String forTableSchemaGet(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "schema");
    }

    public String forTableExternalView(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "externalview");
    }

    public String forSchemaValidate() {
        return StringUtil.join("/", this._baseUrl, "schemas", "validate");
    }

    public String forSchemaCreate() {
        return StringUtil.join("/", this._baseUrl, "schemas");
    }

    public String forSchemaUpdate(String schemaName) {
        return StringUtil.join("/", this._baseUrl, "schemas", schemaName);
    }

    public String forSchemaGet(String schemaName) {
        return StringUtil.join("/", this._baseUrl, "schemas", schemaName);
    }

    public String forSchemaDelete(String schemaName) {
        return StringUtil.join("/", this._baseUrl, "schemas", schemaName);
    }

    public String forTableConfigsCreate() {
        return StringUtil.join("/", this._baseUrl, "tableConfigs");
    }

    public String forTableConfigsGet(String configName) {
        return StringUtil.join("/", this._baseUrl, "tableConfigs", configName);
    }

    public String forTableConfigsList() {
        return StringUtil.join("/", this._baseUrl, "tableConfigs");
    }

    public String forTableConfigsUpdate(String configName) {
        return StringUtil.join("/", this._baseUrl, "tableConfigs", configName);
    }

    public String forTableConfigsDelete(String configName) {
        return StringUtil.join("/", this._baseUrl, "tableConfigs", configName);
    }

    public String forTableConfigsValidate() {
        return StringUtil.join("/", this._baseUrl, "tableConfigs", "validate");
    }

    public String forSegmentReload(String tableName, String segmentName, boolean forceDownload) {
        return StringUtil.join("/", this._baseUrl, "segments", tableName, ControllerRequestURLBuilder.encode(segmentName), "reload?forceDownload=" + forceDownload);
    }

    public String forSegmentReset(String tableNameWithType, String segmentName, String targetInstance) {
        String query = targetInstance == null ? "reset" : String.format("reset?targetInstance=%s", targetInstance);
        return StringUtil.join("/", this._baseUrl, "segments", tableNameWithType, ControllerRequestURLBuilder.encode(segmentName), query);
    }

    public String forSegmentDownload(String tableName, String segmentName) {
        return StringUtil.join("/", this._baseUrl, "segments", tableName, ControllerRequestURLBuilder.encode(segmentName));
    }

    public String forSegmentDelete(String tableName, String segmentName) {
        return StringUtil.join("/", this._baseUrl, "segments", tableName, ControllerRequestURLBuilder.encode(segmentName));
    }

    public String forSegmentDeleteAll(String tableName, String tableType) {
        return StringUtil.join("/", this._baseUrl, "segments", tableName + "?type=" + tableType);
    }

    public String forListAllSegments(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "segments");
    }

    public String forSegmentsMetadataFromServer(String tableName) {
        return this.forSegmentsMetadataFromServer(tableName, null);
    }

    public String forSegmentsMetadataFromServer(String tableName, @Nullable String columns) {
        Object url = StringUtil.join("/", this._baseUrl, "segments", tableName, "metadata");
        if (columns != null) {
            url = (String)url + "?columns=" + columns;
        }
        return url;
    }

    public String forSegmentMetadata(String tableName, String segmentName) {
        return StringUtil.join("/", this._baseUrl, "segments", tableName, ControllerRequestURLBuilder.encode(segmentName), "metadata");
    }

    public String forListAllSegmentLineages(String tableName, String tableType) {
        return StringUtil.join("/", this._baseUrl, "segments", tableName, "lineage?type=" + tableType);
    }

    public String forListAllCrcInformationForTable(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "segments", "crc");
    }

    public String forDeleteTableWithType(String tableName, String tableType) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName + "?type=" + tableType);
    }

    public String forSegmentListAPIWithTableType(String tableName, String tableType) {
        return StringUtil.join("/", this._baseUrl, "segments", tableName + "?type=" + tableType);
    }

    public String forSegmentListAPI(String tableName) {
        return StringUtil.join("/", this._baseUrl, "segments", tableName);
    }

    public String forInstancePartitions(String tableName, @Nullable InstancePartitionsType instancePartitionsType) {
        Object url = StringUtil.join("/", this._baseUrl, "tables", tableName, "instancePartitions");
        if (instancePartitionsType != null) {
            url = (String)url + "?type=" + instancePartitionsType;
        }
        return url;
    }

    public String forInstanceAssign(String tableName, @Nullable InstancePartitionsType instancePartitionsType, boolean dryRun) {
        Object url = StringUtil.join("/", this._baseUrl, "tables", tableName, "assignInstances");
        if (instancePartitionsType != null) {
            url = (String)url + "?type=" + instancePartitionsType;
            if (dryRun) {
                url = (String)url + "&dryRun=true";
            }
        } else if (dryRun) {
            url = (String)url + "?dryRun=true";
        }
        return url;
    }

    public String forInstanceReplace(String tableName, @Nullable InstancePartitionsType instancePartitionsType, String oldInstanceId, String newInstanceId) {
        String url = StringUtil.join("/", this._baseUrl, "tables", tableName, "replaceInstance") + "?oldInstanceId=" + oldInstanceId + "&newInstanceId=" + newInstanceId;
        if (instancePartitionsType != null) {
            url = url + "&type=" + instancePartitionsType;
        }
        return url;
    }

    public String forIngestFromFile(String tableNameWithType, String batchConfigMapStr) throws UnsupportedEncodingException {
        return String.format("%s?tableNameWithType=%s&batchConfigMapStr=%s", StringUtil.join("/", this._baseUrl, "ingestFromFile"), tableNameWithType, URLEncoder.encode(batchConfigMapStr, StandardCharsets.UTF_8.toString()));
    }

    public String forIngestFromFile(String tableNameWithType, Map<String, String> batchConfigMap) throws UnsupportedEncodingException {
        String batchConfigMapStr = batchConfigMap.entrySet().stream().map(e -> String.format("\"%s\":\"%s\"", e.getKey(), e.getValue())).collect(Collectors.joining(",", "{", "}"));
        return this.forIngestFromFile(tableNameWithType, batchConfigMapStr);
    }

    public String forIngestFromURI(String tableNameWithType, String batchConfigMapStr, String sourceURIStr) throws UnsupportedEncodingException {
        return String.format("%s?tableNameWithType=%s&batchConfigMapStr=%s&sourceURIStr=%s", StringUtil.join("/", this._baseUrl, "ingestFromURI"), tableNameWithType, URLEncoder.encode(batchConfigMapStr, StandardCharsets.UTF_8.toString()), URLEncoder.encode(sourceURIStr, StandardCharsets.UTF_8.toString()));
    }

    public String forIngestFromURI(String tableNameWithType, Map<String, String> batchConfigMap, String sourceURIStr) throws UnsupportedEncodingException {
        String batchConfigMapStr = batchConfigMap.entrySet().stream().map(e -> String.format("\"%s\":\"%s\"", e.getKey(), e.getValue())).collect(Collectors.joining(",", "{", "}"));
        return this.forIngestFromURI(tableNameWithType, batchConfigMapStr, sourceURIStr);
    }

    public String forClusterConfigs() {
        return StringUtil.join("/", this._baseUrl, "cluster/configs");
    }

    public String forAppConfigs() {
        return StringUtil.join("/", this._baseUrl, "appconfigs");
    }

    public String forZkPut() {
        return StringUtil.join("/", this._baseUrl, "zk/put");
    }

    public String forZkPutChildren(String path) {
        return StringUtil.join("/", this._baseUrl, "zk/putChildren", "?path=" + path);
    }

    public String forZkGet(String path) {
        return StringUtil.join("/", this._baseUrl, "zk/get", "?path=" + path);
    }

    public String forZkGetChildren(String path) {
        return StringUtil.join("/", this._baseUrl, "zk/getChildren", "?path=" + path);
    }

    public String forUpsertTableHeapEstimation(long cardinality, int primaryKeySize, int numPartitions) {
        return StringUtil.join("/", this._baseUrl, "upsert/estimateHeapUsage", "?cardinality=" + cardinality + "&primaryKeySize=" + primaryKeySize + "&numPartitions=" + numPartitions);
    }

    public String forPauseConsumption(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "pauseConsumption");
    }

    public String forResumeConsumption(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "resumeConsumption");
    }

    public String forPauseStatus(String tableName) {
        return StringUtil.join("/", this._baseUrl, "tables", tableName, "pauseStatus");
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

