/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.autoconfigure;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.spring.annotation.ExtRocketMQConsumerConfiguration;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.SelectorType;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
public class ExtConsumerResetConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(ExtConsumerResetConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private StandardEnvironment environment;
    private RocketMQProperties rocketMQProperties;
    private RocketMQMessageConverter rocketMQMessageConverter;

    public ExtConsumerResetConfiguration(RocketMQMessageConverter rocketMQMessageConverter, StandardEnvironment environment, RocketMQProperties rocketMQProperties) {
        this.rocketMQMessageConverter = rocketMQMessageConverter;
        this.environment = environment;
        this.rocketMQProperties = rocketMQProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map<String, Object> beans = this.applicationContext.getBeansWithAnnotation(ExtRocketMQConsumerConfiguration.class).entrySet().stream().filter(entry -> !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        beans.forEach(this::registerTemplate);
    }

    private void registerTemplate(String beanName, Object bean) {
        Class clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!RocketMQTemplate.class.isAssignableFrom(bean.getClass())) {
            throw new IllegalStateException(clazz + " is not instance of " + RocketMQTemplate.class.getName());
        }
        ExtRocketMQConsumerConfiguration annotation = clazz.getAnnotation(ExtRocketMQConsumerConfiguration.class);
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        this.validate(annotation, genericApplicationContext);
        DefaultLitePullConsumer consumer = null;
        try {
            consumer = this.createConsumer(annotation);
            consumer.setInstanceName(beanName);
            consumer.start();
        }
        catch (Exception e) {
            log.error("Failed to startup PullConsumer for RocketMQTemplate {}", (Object)beanName, (Object)e);
        }
        RocketMQTemplate rocketMQTemplate = (RocketMQTemplate)((Object)bean);
        rocketMQTemplate.setConsumer(consumer);
        rocketMQTemplate.setMessageConverter(this.rocketMQMessageConverter.getMessageConverter());
        log.info("Set real consumer to :{} {}", (Object)beanName, (Object)annotation.value());
    }

    private DefaultLitePullConsumer createConsumer(ExtRocketMQConsumerConfiguration annotation) throws MQClientException {
        RocketMQProperties.Consumer consumerConfig = this.rocketMQProperties.getConsumer();
        if (consumerConfig == null) {
            consumerConfig = new RocketMQProperties.Consumer();
        }
        String nameServer = this.resolvePlaceholders(annotation.nameServer(), this.rocketMQProperties.getNameServer());
        String groupName = this.resolvePlaceholders(annotation.group(), consumerConfig.getGroup());
        String topicName = this.resolvePlaceholders(annotation.topic(), consumerConfig.getTopic());
        Assert.hasText((String)nameServer, (String)"[nameServer] must not be null");
        Assert.hasText((String)groupName, (String)"[group] must not be null");
        Assert.hasText((String)topicName, (String)"[topic] must not be null");
        String accessChannel = this.resolvePlaceholders(annotation.accessChannel(), this.rocketMQProperties.getAccessChannel());
        MessageModel messageModel = annotation.messageModel();
        SelectorType selectorType = annotation.selectorType();
        String selectorExpression = this.resolvePlaceholders(annotation.selectorExpression(), consumerConfig.getSelectorExpression());
        String ak = this.resolvePlaceholders(annotation.accessKey(), consumerConfig.getAccessKey());
        String sk = this.resolvePlaceholders(annotation.secretKey(), consumerConfig.getSecretKey());
        int pullBatchSize = annotation.pullBatchSize();
        boolean useTLS = new Boolean(this.environment.resolvePlaceholders(annotation.tlsEnable()));
        DefaultLitePullConsumer litePullConsumer = RocketMQUtil.createDefaultLitePullConsumer(nameServer, accessChannel, groupName, topicName, messageModel, selectorType, selectorExpression, ak, sk, pullBatchSize, useTLS);
        litePullConsumer.setEnableMsgTrace(annotation.enableMsgTrace());
        litePullConsumer.setCustomizedTraceTopic(this.resolvePlaceholders(annotation.customizedTraceTopic(), consumerConfig.getCustomizedTraceTopic()));
        litePullConsumer.setNamespace(annotation.namespace());
        return litePullConsumer;
    }

    private String resolvePlaceholders(String text, String defaultValue) {
        String value = this.environment.resolvePlaceholders(text);
        return StringUtils.isEmpty((Object)value) ? defaultValue : value;
    }

    private void validate(ExtRocketMQConsumerConfiguration annotation, GenericApplicationContext genericApplicationContext) {
        if (genericApplicationContext.isBeanNameInUse(annotation.value())) {
            throw new BeanDefinitionValidationException(String.format("Bean {} has been used in Spring Application Context, please check the @ExtRocketMQConsumerConfiguration", annotation.value()));
        }
    }
}

