/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import lombok.Generated;

public final class SQLHintUtils {
    private static final String SQL_COMMENT_SUFFIX = "*/";
    private static final String SQL_HINT_TOKEN = "shardingsphere hint:";
    private static final String SQL_HINT_SPLIT = ",";
    private static final String SQL_HINT_VALUE_SPLIT = "=";
    private static final String SQL_HINT_VALUE_COLLECTION_SPLIT = " ";
    private static final int SQL_HINT_VALUE_SIZE = 2;

    public static Properties getSQLHintProps(String comment) {
        Properties result = new Properties();
        int startIndex = comment.toLowerCase().indexOf(SQL_HINT_TOKEN);
        if (startIndex < 0) {
            return result;
        }
        int endIndex = comment.endsWith(SQL_COMMENT_SUFFIX) ? comment.indexOf(SQL_COMMENT_SUFFIX) : comment.length();
        List sqlHints = Splitter.on((String)SQL_HINT_SPLIT).trimResults().splitToList((CharSequence)comment.substring(startIndex += SQL_HINT_TOKEN.length(), endIndex).trim());
        for (String each : sqlHints) {
            List hintValues = Splitter.on((String)SQL_HINT_VALUE_SPLIT).trimResults().splitToList((CharSequence)each);
            if (2 != hintValues.size()) continue;
            result.put(hintValues.get(0), hintValues.get(1));
        }
        return result;
    }

    public static Collection<String> getSplitterSQLHintValue(String value) {
        return value.isEmpty() ? Collections.emptySet() : new HashSet(Splitter.on((String)SQL_HINT_VALUE_COLLECTION_SPLIT).omitEmptyStrings().trimResults().splitToList((CharSequence)value));
    }

    @Generated
    private SQLHintUtils() {
    }
}

