// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.global;

import org.bytedeco.ffmpeg.avformat.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;

public class avformat extends org.bytedeco.ffmpeg.presets.avformat {
    static { Loader.load(); }

// Parsed from <libavformat/avio.h>

/*
 * copyright (c) 2001 Fabrice Bellard
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
// #ifndef AVFORMAT_AVIO_H
// #define AVFORMAT_AVIO_H

/**
 * \file
 * \ingroup lavf_io
 * Buffered I/O operations
 */

// #include <stdint.h>
// #include <stdio.h>

// #include "libavutil/attributes.h"
// #include "libavutil/dict.h"
// #include "libavutil/log.h"

// #include "libavformat/version_major.h"

/**
 * Seeking works like for a local file.
 */
public static final int AVIO_SEEKABLE_NORMAL = (1 << 0);

/**
 * Seeking by timestamp with avio_seek_time() is possible.
 */
public static final int AVIO_SEEKABLE_TIME =   (1 << 1);
// Targeting ..\avformat\AVIOInterruptCB.java



/**
 * Directory entry types.
 */
/** enum AVIODirEntryType */
public static final int
    AVIO_ENTRY_UNKNOWN = 0,
    AVIO_ENTRY_BLOCK_DEVICE = 1,
    AVIO_ENTRY_CHARACTER_DEVICE = 2,
    AVIO_ENTRY_DIRECTORY = 3,
    AVIO_ENTRY_NAMED_PIPE = 4,
    AVIO_ENTRY_SYMBOLIC_LINK = 5,
    AVIO_ENTRY_SOCKET = 6,
    AVIO_ENTRY_FILE = 7,
    AVIO_ENTRY_SERVER = 8,
    AVIO_ENTRY_SHARE = 9,
    AVIO_ENTRY_WORKGROUP = 10;
// Targeting ..\avformat\AVIODirEntry.java


// Targeting ..\avformat\AVIODirContext.java


// #else
// #endif

/**
 * Different data types that can be returned via the AVIO
 * write_data_type callback.
 */
/** enum AVIODataMarkerType */
public static final int
    /**
     * Header data; this needs to be present for the stream to be decodeable.
     */
    AVIO_DATA_MARKER_HEADER = 0,
    /**
     * A point in the output bytestream where a decoder can start decoding
     * (i.e. a keyframe). A demuxer/decoder given the data flagged with
     * AVIO_DATA_MARKER_HEADER, followed by any AVIO_DATA_MARKER_SYNC_POINT,
     * should give decodeable results.
     */
    AVIO_DATA_MARKER_SYNC_POINT = 1,
    /**
     * A point in the output bytestream where a demuxer can start parsing
     * (for non self synchronizing bytestream formats). That is, any
     * non-keyframe packet start point.
     */
    AVIO_DATA_MARKER_BOUNDARY_POINT = 2,
    /**
     * This is any, unlabelled data. It can either be a muxer not marking
     * any positions at all, it can be an actual boundary/sync point
     * that the muxer chooses not to mark, or a later part of a packet/fragment
     * that is cut into multiple write callbacks due to limited IO buffer size.
     */
    AVIO_DATA_MARKER_UNKNOWN = 3,
    /**
     * Trailer data, which doesn't contain actual content, but only for
     * finalizing the output file.
     */
    AVIO_DATA_MARKER_TRAILER = 4,
    /**
     * A point in the output bytestream where the underlying AVIOContext might
     * flush the buffer depending on latency or buffering requirements. Typically
     * means the end of a packet.
     */
    AVIO_DATA_MARKER_FLUSH_POINT = 5;
// Targeting ..\avformat\AVIOContext.java



/**
 * Return the name of the protocol that will handle the passed URL.
 *
 * NULL is returned if no protocol could be found for the given URL.
 *
 * @return Name of the protocol or NULL.
 */
@NoException public static native @Cast("const char*") BytePointer avio_find_protocol_name(@Cast("const char*") BytePointer url);
@NoException public static native String avio_find_protocol_name(String url);

/**
 * Return AVIO_FLAG_* access flags corresponding to the access permissions
 * of the resource in url, or a negative value corresponding to an
 * AVERROR code in case of failure. The returned access flags are
 * masked by the value in flags.
 *
 * \note This function is intrinsically unsafe, in the sense that the
 * checked resource may change its existence or permission status from
 * one call to another. Thus you should not trust the returned value,
 * unless you are sure that no other processes are accessing the
 * checked resource.
 */
@NoException public static native int avio_check(@Cast("const char*") BytePointer url, int flags);
@NoException public static native int avio_check(String url, int flags);

/**
 * Open directory for reading.
 *
 * @param s       directory read context. Pointer to a NULL pointer must be passed.
 * @param url     directory to be listed.
 * @param options A dictionary filled with protocol-private options. On return
 *                this parameter will be destroyed and replaced with a dictionary
 *                containing options that were not found. May be NULL.
 * @return >=0 on success or negative on error.
 */
@NoException public static native int avio_open_dir(@Cast("AVIODirContext**") PointerPointer s, @Cast("const char*") BytePointer url, @Cast("AVDictionary**") PointerPointer options);
@NoException public static native int avio_open_dir(@ByPtrPtr AVIODirContext s, @Cast("const char*") BytePointer url, @ByPtrPtr AVDictionary options);
@NoException public static native int avio_open_dir(@ByPtrPtr AVIODirContext s, String url, @ByPtrPtr AVDictionary options);

/**
 * Get next directory entry.
 *
 * Returned entry must be freed with avio_free_directory_entry(). In particular
 * it may outlive AVIODirContext.
 *
 * @param s         directory read context.
 * @param next [out] next entry or NULL when no more entries.
 * @return >=0 on success or negative on error. End of list is not considered an
 *             error.
 */
@NoException public static native int avio_read_dir(AVIODirContext s, @Cast("AVIODirEntry**") PointerPointer next);
@NoException public static native int avio_read_dir(AVIODirContext s, @ByPtrPtr AVIODirEntry next);

/**
 * Close directory.
 *
 * \note Entries created using avio_read_dir() are not deleted and must be
 * freeded with avio_free_directory_entry().
 *
 * @param s         directory read context.
 * @return >=0 on success or negative on error.
 */
@NoException public static native int avio_close_dir(@Cast("AVIODirContext**") PointerPointer s);
@NoException public static native int avio_close_dir(@ByPtrPtr AVIODirContext s);

/**
 * Free entry allocated by avio_read_dir().
 *
 * @param entry entry to be freed.
 */
@NoException public static native void avio_free_directory_entry(@Cast("AVIODirEntry**") PointerPointer entry);
@NoException public static native void avio_free_directory_entry(@ByPtrPtr AVIODirEntry entry);
// Targeting ..\avformat\Read_packet_Pointer_BytePointer_int.java


// Targeting ..\avformat\Write_packet_Pointer_BytePointer_int.java


// Targeting ..\avformat\Seek_Pointer_long_int.java


@NoException public static native AVIOContext avio_alloc_context(
                  @Cast("unsigned char*") BytePointer buffer,
                  int buffer_size,
                  int write_flag,
                  Pointer opaque,
                  Read_packet_Pointer_BytePointer_int read_packet,
                  Write_packet_Pointer_BytePointer_int write_packet,
                  Seek_Pointer_long_int seek);
// Targeting ..\avformat\Read_packet_Pointer_ByteBuffer_int.java


// Targeting ..\avformat\Write_packet_Pointer_ByteBuffer_int.java


@NoException public static native AVIOContext avio_alloc_context(
                  @Cast("unsigned char*") ByteBuffer buffer,
                  int buffer_size,
                  int write_flag,
                  Pointer opaque,
                  Read_packet_Pointer_ByteBuffer_int read_packet,
                  Write_packet_Pointer_ByteBuffer_int write_packet,
                  Seek_Pointer_long_int seek);
// Targeting ..\avformat\Read_packet_Pointer_byte___int.java


// Targeting ..\avformat\Write_packet_Pointer_byte___int.java


@NoException public static native AVIOContext avio_alloc_context(
                  @Cast("unsigned char*") byte[] buffer,
                  int buffer_size,
                  int write_flag,
                  Pointer opaque,
                  Read_packet_Pointer_byte___int read_packet,
                  Write_packet_Pointer_byte___int write_packet,
                  Seek_Pointer_long_int seek);

/**
 * Free the supplied IO context and everything associated with it.
 *
 * @param s Double pointer to the IO context. This function will write NULL
 * into s.
 */
@NoException public static native void avio_context_free(@Cast("AVIOContext**") PointerPointer s);
@NoException public static native void avio_context_free(@ByPtrPtr AVIOContext s);

@NoException public static native void avio_w8(AVIOContext s, int b);
@NoException public static native void avio_write(AVIOContext s, @Cast("const unsigned char*") BytePointer buf, int size);
@NoException public static native void avio_write(AVIOContext s, @Cast("const unsigned char*") ByteBuffer buf, int size);
@NoException public static native void avio_write(AVIOContext s, @Cast("const unsigned char*") byte[] buf, int size);
@NoException public static native void avio_wl64(AVIOContext s, @Cast("uint64_t") long val);
@NoException public static native void avio_wb64(AVIOContext s, @Cast("uint64_t") long val);
@NoException public static native void avio_wl32(AVIOContext s, @Cast("unsigned int") int val);
@NoException public static native void avio_wb32(AVIOContext s, @Cast("unsigned int") int val);
@NoException public static native void avio_wl24(AVIOContext s, @Cast("unsigned int") int val);
@NoException public static native void avio_wb24(AVIOContext s, @Cast("unsigned int") int val);
@NoException public static native void avio_wl16(AVIOContext s, @Cast("unsigned int") int val);
@NoException public static native void avio_wb16(AVIOContext s, @Cast("unsigned int") int val);

/**
 * Write a NULL-terminated string.
 * @return number of bytes written.
 */
@NoException public static native int avio_put_str(AVIOContext s, @Cast("const char*") BytePointer str);
@NoException public static native int avio_put_str(AVIOContext s, String str);

/**
 * Convert an UTF-8 string to UTF-16LE and write it.
 * @param s the AVIOContext
 * @param str NULL-terminated UTF-8 string
 *
 * @return number of bytes written.
 */
@NoException public static native int avio_put_str16le(AVIOContext s, @Cast("const char*") BytePointer str);
@NoException public static native int avio_put_str16le(AVIOContext s, String str);

/**
 * Convert an UTF-8 string to UTF-16BE and write it.
 * @param s the AVIOContext
 * @param str NULL-terminated UTF-8 string
 *
 * @return number of bytes written.
 */
@NoException public static native int avio_put_str16be(AVIOContext s, @Cast("const char*") BytePointer str);
@NoException public static native int avio_put_str16be(AVIOContext s, String str);

/**
 * Mark the written bytestream as a specific type.
 *
 * Zero-length ranges are omitted from the output.
 *
 * @param s    the AVIOContext
 * @param time the stream time the current bytestream pos corresponds to
 *             (in AV_TIME_BASE units), or AV_NOPTS_VALUE if unknown or not
 *             applicable
 * @param type the kind of data written starting at the current pos
 */
@NoException public static native void avio_write_marker(AVIOContext s, @Cast("int64_t") long time, @Cast("AVIODataMarkerType") int type);

/**
 * ORing this as the "whence" parameter to a seek function causes it to
 * return the filesize without seeking anywhere. Supporting this is optional.
 * If it is not supported then the seek function will return <0.
 */
public static final int AVSEEK_SIZE = 0x10000;

/**
 * Passing this flag as the "whence" parameter to a seek function causes it to
 * seek by any means (like reopening and linear reading) or other normally unreasonable
 * means that can be extremely slow.
 * This may be ignored by the seek code.
 */
public static final int AVSEEK_FORCE = 0x20000;

/**
 * fseek() equivalent for AVIOContext.
 * @return new position or AVERROR.
 */
@NoException public static native @Cast("int64_t") long avio_seek(AVIOContext s, @Cast("int64_t") long offset, int whence);

/**
 * Skip given number of bytes forward
 * @return new position or AVERROR.
 */
@NoException public static native @Cast("int64_t") long avio_skip(AVIOContext s, @Cast("int64_t") long offset);

/**
 * ftell() equivalent for AVIOContext.
 * @return position or AVERROR.
 */
@NoException public static native @Cast("int64_t") long avio_tell(AVIOContext s);

/**
 * Get the filesize.
 * @return filesize or AVERROR
 */
@NoException public static native @Cast("int64_t") long avio_size(AVIOContext s);

/**
 * Similar to feof() but also returns nonzero on read errors.
 * @return non zero if and only if at end of file or a read error happened when reading.
 */
@NoException public static native int avio_feof(AVIOContext s);

/**
 * Writes a formatted string to the context taking a va_list.
 * @return number of bytes written, < 0 on error.
 */
@NoException public static native int avio_vprintf(AVIOContext s, @Cast("const char*") BytePointer fmt, @ByVal @Cast("va_list*") Pointer ap);
@NoException public static native int avio_vprintf(AVIOContext s, String fmt, @ByVal @Cast("va_list*") Pointer ap);

/**
 * Writes a formatted string to the context.
 * @return number of bytes written, < 0 on error.
 */
@NoException public static native int avio_printf(AVIOContext s, @Cast("const char*") BytePointer fmt);
@NoException public static native int avio_printf(AVIOContext s, String fmt);

/**
 * Write a NULL terminated array of strings to the context.
 * Usually you don't need to use this function directly but its macro wrapper,
 * avio_print.
 */
@NoException public static native void avio_print_string_array(AVIOContext s, @Cast("const char**") PointerPointer strings);
@NoException public static native void avio_print_string_array(AVIOContext s, @Cast("const char**") @ByPtrPtr BytePointer strings);
@NoException public static native void avio_print_string_array(AVIOContext s, @Cast("const char**") @ByPtrPtr ByteBuffer strings);
@NoException public static native void avio_print_string_array(AVIOContext s, @Cast("const char**") @ByPtrPtr byte[] strings);

/**
 * Write strings (const char *) to the context.
 * This is a convenience macro around avio_print_string_array and it
 * automatically creates the string array from the variable argument list.
 * For simple string concatenations this function is more performant than using
 * avio_printf since it does not need a temporary buffer.
 */
// #define avio_print(s, ...)
//     avio_print_string_array(s, (const char*[]){__VA_ARGS__, NULL})

/**
 * Force flushing of buffered data.
 *
 * For write streams, force the buffered data to be immediately written to the output,
 * without to wait to fill the internal buffer.
 *
 * For read streams, discard all currently buffered data, and advance the
 * reported file position to that of the underlying stream. This does not
 * read new data, and does not perform any seeks.
 */
@NoException public static native void avio_flush(AVIOContext s);

/**
 * Read size bytes from AVIOContext into buf.
 * @return number of bytes read or AVERROR
 */
@NoException public static native int avio_read(AVIOContext s, @Cast("unsigned char*") BytePointer buf, int size);
@NoException public static native int avio_read(AVIOContext s, @Cast("unsigned char*") ByteBuffer buf, int size);
@NoException public static native int avio_read(AVIOContext s, @Cast("unsigned char*") byte[] buf, int size);

/**
 * Read size bytes from AVIOContext into buf. Unlike avio_read(), this is allowed
 * to read fewer bytes than requested. The missing bytes can be read in the next
 * call. This always tries to read at least 1 byte.
 * Useful to reduce latency in certain cases.
 * @return number of bytes read or AVERROR
 */
@NoException public static native int avio_read_partial(AVIOContext s, @Cast("unsigned char*") BytePointer buf, int size);
@NoException public static native int avio_read_partial(AVIOContext s, @Cast("unsigned char*") ByteBuffer buf, int size);
@NoException public static native int avio_read_partial(AVIOContext s, @Cast("unsigned char*") byte[] buf, int size);

/**
 * \name Functions for reading from AVIOContext
 * \{
 *
 * \note return 0 if EOF, so you cannot use it if EOF handling is
 *       necessary
 */
@NoException public static native int avio_r8(AVIOContext s);
@NoException public static native @Cast("unsigned int") int avio_rl16(AVIOContext s);
@NoException public static native @Cast("unsigned int") int avio_rl24(AVIOContext s);
@NoException public static native @Cast("unsigned int") int avio_rl32(AVIOContext s);
@NoException public static native @Cast("uint64_t") long avio_rl64(AVIOContext s);
@NoException public static native @Cast("unsigned int") int avio_rb16(AVIOContext s);
@NoException public static native @Cast("unsigned int") int avio_rb24(AVIOContext s);
@NoException public static native @Cast("unsigned int") int avio_rb32(AVIOContext s);
@NoException public static native @Cast("uint64_t") long avio_rb64(AVIOContext s);
/**
 * \}
 */

/**
 * Read a string from pb into buf. The reading will terminate when either
 * a NULL character was encountered, maxlen bytes have been read, or nothing
 * more can be read from pb. The result is guaranteed to be NULL-terminated, it
 * will be truncated if buf is too small.
 * Note that the string is not interpreted or validated in any way, it
 * might get truncated in the middle of a sequence for multi-byte encodings.
 *
 * @return number of bytes read (is always <= maxlen).
 * If reading ends on EOF or error, the return value will be one more than
 * bytes actually read.
 */
@NoException public static native int avio_get_str(AVIOContext pb, int maxlen, @Cast("char*") BytePointer buf, int buflen);
@NoException public static native int avio_get_str(AVIOContext pb, int maxlen, @Cast("char*") ByteBuffer buf, int buflen);
@NoException public static native int avio_get_str(AVIOContext pb, int maxlen, @Cast("char*") byte[] buf, int buflen);

/**
 * Read a UTF-16 string from pb and convert it to UTF-8.
 * The reading will terminate when either a null or invalid character was
 * encountered or maxlen bytes have been read.
 * @return number of bytes read (is always <= maxlen)
 */
@NoException public static native int avio_get_str16le(AVIOContext pb, int maxlen, @Cast("char*") BytePointer buf, int buflen);
@NoException public static native int avio_get_str16le(AVIOContext pb, int maxlen, @Cast("char*") ByteBuffer buf, int buflen);
@NoException public static native int avio_get_str16le(AVIOContext pb, int maxlen, @Cast("char*") byte[] buf, int buflen);
@NoException public static native int avio_get_str16be(AVIOContext pb, int maxlen, @Cast("char*") BytePointer buf, int buflen);
@NoException public static native int avio_get_str16be(AVIOContext pb, int maxlen, @Cast("char*") ByteBuffer buf, int buflen);
@NoException public static native int avio_get_str16be(AVIOContext pb, int maxlen, @Cast("char*") byte[] buf, int buflen);


/**
 * \name URL open modes
 * The flags argument to avio_open must be one of the following
 * constants, optionally ORed with other flags.
 * \{
 */
/** read-only */
public static final int AVIO_FLAG_READ =  1;
/** write-only */
public static final int AVIO_FLAG_WRITE = 2;
/** read-write pseudo flag */
public static final int AVIO_FLAG_READ_WRITE = (AVIO_FLAG_READ|AVIO_FLAG_WRITE);
/**
 * \}
 */

/**
 * Use non-blocking mode.
 * If this flag is set, operations on the context will return
 * AVERROR(EAGAIN) if they can not be performed immediately.
 * If this flag is not set, operations on the context will never return
 * AVERROR(EAGAIN).
 * Note that this flag does not affect the opening/connecting of the
 * context. Connecting a protocol will always block if necessary (e.g. on
 * network protocols) but never hang (e.g. on busy devices).
 * Warning: non-blocking protocols is work-in-progress; this flag may be
 * silently ignored.
 */
public static final int AVIO_FLAG_NONBLOCK = 8;

/**
 * Use direct mode.
 * avio_read and avio_write should if possible be satisfied directly
 * instead of going through a buffer, and avio_seek will always
 * call the underlying seek function directly.
 */
public static final int AVIO_FLAG_DIRECT = 0x8000;

/**
 * Create and initialize a AVIOContext for accessing the
 * resource indicated by url.
 * \note When the resource indicated by url has been opened in
 * read+write mode, the AVIOContext can be used only for writing.
 *
 * @param s Used to return the pointer to the created AVIOContext.
 * In case of failure the pointed to value is set to NULL.
 * @param url resource to access
 * @param flags flags which control how the resource indicated by url
 * is to be opened
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code in case of failure
 */
@NoException public static native int avio_open(@Cast("AVIOContext**") PointerPointer s, @Cast("const char*") BytePointer url, int flags);
@NoException public static native int avio_open(@ByPtrPtr AVIOContext s, @Cast("const char*") BytePointer url, int flags);
@NoException public static native int avio_open(@ByPtrPtr AVIOContext s, String url, int flags);

/**
 * Create and initialize a AVIOContext for accessing the
 * resource indicated by url.
 * \note When the resource indicated by url has been opened in
 * read+write mode, the AVIOContext can be used only for writing.
 *
 * @param s Used to return the pointer to the created AVIOContext.
 * In case of failure the pointed to value is set to NULL.
 * @param url resource to access
 * @param flags flags which control how the resource indicated by url
 * is to be opened
 * @param int_cb an interrupt callback to be used at the protocols level
 * @param options  A dictionary filled with protocol-private options. On return
 * this parameter will be destroyed and replaced with a dict containing options
 * that were not found. May be NULL.
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code in case of failure
 */
@NoException public static native int avio_open2(@Cast("AVIOContext**") PointerPointer s, @Cast("const char*") BytePointer url, int flags,
               @Const AVIOInterruptCB int_cb, @Cast("AVDictionary**") PointerPointer options);
@NoException public static native int avio_open2(@ByPtrPtr AVIOContext s, @Cast("const char*") BytePointer url, int flags,
               @Const AVIOInterruptCB int_cb, @ByPtrPtr AVDictionary options);
@NoException public static native int avio_open2(@ByPtrPtr AVIOContext s, String url, int flags,
               @Const AVIOInterruptCB int_cb, @ByPtrPtr AVDictionary options);

/**
 * Close the resource accessed by the AVIOContext s and free it.
 * This function can only be used if s was opened by avio_open().
 *
 * The internal buffer is automatically flushed before closing the
 * resource.
 *
 * @return 0 on success, an AVERROR < 0 on error.
 * @see avio_closep
 */
@NoException public static native int avio_close(AVIOContext s);

/**
 * Close the resource accessed by the AVIOContext *s, free it
 * and set the pointer pointing to it to NULL.
 * This function can only be used if s was opened by avio_open().
 *
 * The internal buffer is automatically flushed before closing the
 * resource.
 *
 * @return 0 on success, an AVERROR < 0 on error.
 * @see avio_close
 */
@NoException public static native int avio_closep(@Cast("AVIOContext**") PointerPointer s);
@NoException public static native int avio_closep(@ByPtrPtr AVIOContext s);


/**
 * Open a write only memory stream.
 *
 * @param s new IO context
 * @return zero if no error.
 */
@NoException public static native int avio_open_dyn_buf(@Cast("AVIOContext**") PointerPointer s);
@NoException public static native int avio_open_dyn_buf(@ByPtrPtr AVIOContext s);

/**
 * Return the written size and a pointer to the buffer.
 * The AVIOContext stream is left intact.
 * The buffer must NOT be freed.
 * No padding is added to the buffer.
 *
 * @param s IO context
 * @param pbuffer pointer to a byte buffer
 * @return the length of the byte buffer
 */
@NoException public static native int avio_get_dyn_buf(AVIOContext s, @Cast("uint8_t**") PointerPointer pbuffer);
@NoException public static native int avio_get_dyn_buf(AVIOContext s, @Cast("uint8_t**") @ByPtrPtr BytePointer pbuffer);
@NoException public static native int avio_get_dyn_buf(AVIOContext s, @Cast("uint8_t**") @ByPtrPtr ByteBuffer pbuffer);
@NoException public static native int avio_get_dyn_buf(AVIOContext s, @Cast("uint8_t**") @ByPtrPtr byte[] pbuffer);

/**
 * Return the written size and a pointer to the buffer. The buffer
 * must be freed with av_free().
 * Padding of AV_INPUT_BUFFER_PADDING_SIZE is added to the buffer.
 *
 * @param s IO context
 * @param pbuffer pointer to a byte buffer
 * @return the length of the byte buffer
 */
@NoException public static native int avio_close_dyn_buf(AVIOContext s, @Cast("uint8_t**") PointerPointer pbuffer);
@NoException public static native int avio_close_dyn_buf(AVIOContext s, @Cast("uint8_t**") @ByPtrPtr BytePointer pbuffer);
@NoException public static native int avio_close_dyn_buf(AVIOContext s, @Cast("uint8_t**") @ByPtrPtr ByteBuffer pbuffer);
@NoException public static native int avio_close_dyn_buf(AVIOContext s, @Cast("uint8_t**") @ByPtrPtr byte[] pbuffer);

/**
 * Iterate through names of available protocols.
 *
 * @param opaque A private pointer representing current protocol.
 *        It must be a pointer to NULL on first iteration and will
 *        be updated by successive calls to avio_enum_protocols.
 * @param output If set to 1, iterate over output protocols,
 *               otherwise over input protocols.
 *
 * @return A static string containing the name of current protocol or NULL
 */
@NoException public static native @Cast("const char*") BytePointer avio_enum_protocols(@Cast("void**") PointerPointer opaque, int output);
@NoException public static native @Cast("const char*") BytePointer avio_enum_protocols(@Cast("void**") @ByPtrPtr Pointer opaque, int output);

/**
 * Get AVClass by names of available protocols.
 *
 * @return A AVClass of input protocol name or NULL
 */
@NoException public static native @Const AVClass avio_protocol_get_class(@Cast("const char*") BytePointer name);
@NoException public static native @Const AVClass avio_protocol_get_class(String name);

/**
 * Pause and resume playing - only meaningful if using a network streaming
 * protocol (e.g. MMS).
 *
 * @param h     IO context from which to call the read_pause function pointer
 * @param pause 1 for pause, 0 for resume
 */
@NoException public static native int avio_pause(AVIOContext h, int pause);

/**
 * Seek to a given timestamp relative to some component stream.
 * Only meaningful if using a network streaming protocol (e.g. MMS.).
 *
 * @param h IO context from which to call the seek function pointers
 * @param stream_index The stream index that the timestamp is relative to.
 *        If stream_index is (-1) the timestamp should be in AV_TIME_BASE
 *        units from the beginning of the presentation.
 *        If a stream_index >= 0 is used and the protocol does not support
 *        seeking based on component streams, the call will fail.
 * @param timestamp timestamp in AVStream.time_base units
 *        or if there is no stream specified then in AV_TIME_BASE units.
 * @param flags Optional combination of AVSEEK_FLAG_BACKWARD, AVSEEK_FLAG_BYTE
 *        and AVSEEK_FLAG_ANY. The protocol may silently ignore
 *        AVSEEK_FLAG_BACKWARD and AVSEEK_FLAG_ANY, but AVSEEK_FLAG_BYTE will
 *        fail if used and not supported.
 * @return >= 0 on success
 * @see AVInputFormat::read_seek
 */
@NoException public static native @Cast("int64_t") long avio_seek_time(AVIOContext h, int stream_index,
                       @Cast("int64_t") long timestamp, int flags);

/* Avoid a warning. The header can not be included because it breaks c++. */

/**
 * Read contents of h into print buffer, up to max_size bytes, or up to EOF.
 *
 * @return 0 for success (max_size bytes read or EOF reached), negative error
 * code otherwise
 */
@NoException public static native int avio_read_to_bprint(AVIOContext h, @Cast("AVBPrint*") Pointer pb, @Cast("size_t") long max_size);

/**
 * Accept and allocate a client context on a server context.
 * @param  s the server context
 * @param  c the client context, must be unallocated
 * @return   >= 0 on success or a negative value corresponding
 *           to an AVERROR on failure
 */
@NoException public static native int avio_accept(AVIOContext s, @Cast("AVIOContext**") PointerPointer c);
@NoException public static native int avio_accept(AVIOContext s, @ByPtrPtr AVIOContext c);

/**
 * Perform one step of the protocol handshake to accept a new client.
 * This function must be called on a client returned by avio_accept() before
 * using it as a read/write context.
 * It is separate from avio_accept() because it may block.
 * A step of the handshake is defined by places where the application may
 * decide to change the proceedings.
 * For example, on a protocol with a request header and a reply header, each
 * one can constitute a step because the application may use the parameters
 * from the request to change parameters in the reply; or each individual
 * chunk of the request can constitute a step.
 * If the handshake is already finished, avio_handshake() does nothing and
 * returns 0 immediately.
 *
 * @param  c the client context to perform the handshake on
 * @return   0   on a complete and successful handshake
 *           > 0 if the handshake progressed, but is not complete
 *           < 0 for an AVERROR code
 */
@NoException public static native int avio_handshake(AVIOContext c);
// #endif /* AVFORMAT_AVIO_H */


// Parsed from <libavformat/avformat.h>

/*
 * copyright (c) 2001 Fabrice Bellard
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVFORMAT_AVFORMAT_H
// #define AVFORMAT_AVFORMAT_H

/**
 * \file
 * \ingroup libavf
 * Main libavformat public API header
 */

/**
 * \defgroup libavf libavformat
 * I/O and Muxing/Demuxing Library
 *
 * Libavformat (lavf) is a library for dealing with various media container
 * formats. Its main two purposes are demuxing - i.e. splitting a media file
 * into component streams, and the reverse process of muxing - writing supplied
 * data in a specified container format. It also has an \ref lavf_io
 * "I/O module" which supports a number of protocols for accessing the data (e.g.
 * file, tcp, http and others).
 * Unless you are absolutely sure you won't use libavformat's network
 * capabilities, you should also call avformat_network_init().
 *
 * A supported input format is described by an AVInputFormat struct, conversely
 * an output format is described by AVOutputFormat. You can iterate over all
 * input/output formats using the  av_demuxer_iterate / av_muxer_iterate() functions.
 * The protocols layer is not part of the public API, so you can only get the names
 * of supported protocols with the avio_enum_protocols() function.
 *
 * Main lavf structure used for both muxing and demuxing is AVFormatContext,
 * which exports all information about the file being read or written. As with
 * most Libavformat structures, its size is not part of public ABI, so it cannot be
 * allocated on stack or directly with av_malloc(). To create an
 * AVFormatContext, use avformat_alloc_context() (some functions, like
 * avformat_open_input() might do that for you).
 *
 * Most importantly an AVFormatContext contains:
 * \li the \ref AVFormatContext.iformat "input" or \ref AVFormatContext.oformat
 * "output" format. It is either autodetected or set by user for input;
 * always set by user for output.
 * \li an \ref AVFormatContext.streams "array" of AVStreams, which describe all
 * elementary streams stored in the file. AVStreams are typically referred to
 * using their index in this array.
 * \li an \ref AVFormatContext.pb "I/O context". It is either opened by lavf or
 * set by user for input, always set by user for output (unless you are dealing
 * with an AVFMT_NOFILE format).
 *
 * \section lavf_options Passing options to (de)muxers
 * It is possible to configure lavf muxers and demuxers using the \ref avoptions
 * mechanism. Generic (format-independent) libavformat options are provided by
 * AVFormatContext, they can be examined from a user program by calling
 * av_opt_next() / av_opt_find() on an allocated AVFormatContext (or its AVClass
 * from avformat_get_class()). Private (format-specific) options are provided by
 * AVFormatContext.priv_data if and only if AVInputFormat.priv_class /
 * AVOutputFormat.priv_class of the corresponding format struct is non-NULL.
 * Further options may be provided by the \ref AVFormatContext.pb "I/O context",
 * if its AVClass is non-NULL, and the protocols layer. See the discussion on
 * nesting in \ref avoptions documentation to learn how to access those.
 *
 * \section urls
 * URL strings in libavformat are made of a scheme/protocol, a ':', and a
 * scheme specific string. URLs without a scheme and ':' used for local files
 * are supported but deprecated. "file:" should be used for local files.
 *
 * It is important that the scheme string is not taken from untrusted
 * sources without checks.
 *
 * Note that some schemes/protocols are quite powerful, allowing access to
 * both local and remote files, parts of them, concatenations of them, local
 * audio and video devices and so on.
 *
 * \{
 *
 * \defgroup lavf_decoding Demuxing
 * \{
 * Demuxers read a media file and split it into chunks of data (\em packets). A
 * \ref AVPacket "packet" contains one or more encoded frames which belongs to a
 * single elementary stream. In the lavf API this process is represented by the
 * avformat_open_input() function for opening a file, av_read_frame() for
 * reading a single packet and finally avformat_close_input(), which does the
 * cleanup.
 *
 * \section lavf_decoding_open Opening a media file
 * The minimum information required to open a file is its URL, which
 * is passed to avformat_open_input(), as in the following code:
 * <pre>{@code
 * const char    *url = "file:in.mp3";
 * AVFormatContext *s = NULL;
 * int ret = avformat_open_input(&s, url, NULL, NULL);
 * if (ret < 0)
 *     abort();
 * }</pre>
 * The above code attempts to allocate an AVFormatContext, open the
 * specified file (autodetecting the format) and read the header, exporting the
 * information stored there into s. Some formats do not have a header or do not
 * store enough information there, so it is recommended that you call the
 * avformat_find_stream_info() function which tries to read and decode a few
 * frames to find missing information.
 *
 * In some cases you might want to preallocate an AVFormatContext yourself with
 * avformat_alloc_context() and do some tweaking on it before passing it to
 * avformat_open_input(). One such case is when you want to use custom functions
 * for reading input data instead of lavf internal I/O layer.
 * To do that, create your own AVIOContext with avio_alloc_context(), passing
 * your reading callbacks to it. Then set the \em pb field of your
 * AVFormatContext to newly created AVIOContext.
 *
 * Since the format of the opened file is in general not known until after
 * avformat_open_input() has returned, it is not possible to set demuxer private
 * options on a preallocated context. Instead, the options should be passed to
 * avformat_open_input() wrapped in an AVDictionary:
 * <pre>{@code
 * AVDictionary *options = NULL;
 * av_dict_set(&options, "video_size", "640x480", 0);
 * av_dict_set(&options, "pixel_format", "rgb24", 0);
 *
 * if (avformat_open_input(&s, url, NULL, &options) < 0)
 *     abort();
 * av_dict_free(&options);
 * }</pre>
 * This code passes the private options 'video_size' and 'pixel_format' to the
 * demuxer. They would be necessary for e.g. the rawvideo demuxer, since it
 * cannot know how to interpret raw video data otherwise. If the format turns
 * out to be something different than raw video, those options will not be
 * recognized by the demuxer and therefore will not be applied. Such unrecognized
 * options are then returned in the options dictionary (recognized options are
 * consumed). The calling program can handle such unrecognized options as it
 * wishes, e.g.
 * <pre>{@code
 * AVDictionaryEntry *e;
 * if (e = av_dict_get(options, "", NULL, AV_DICT_IGNORE_SUFFIX)) {
 *     fprintf(stderr, "Option %s not recognized by the demuxer.\n", e->key);
 *     abort();
 * }
 * }</pre>
 *
 * After you have finished reading the file, you must close it with
 * avformat_close_input(). It will free everything associated with the file.
 *
 * \section lavf_decoding_read Reading from an opened file
 * Reading data from an opened AVFormatContext is done by repeatedly calling
 * av_read_frame() on it. Each call, if successful, will return an AVPacket
 * containing encoded data for one AVStream, identified by
 * AVPacket.stream_index. This packet may be passed straight into the libavcodec
 * decoding functions avcodec_send_packet() or avcodec_decode_subtitle2() if the
 * caller wishes to decode the data.
 *
 * AVPacket.pts, AVPacket.dts and AVPacket.duration timing information will be
 * set if known. They may also be unset (i.e. AV_NOPTS_VALUE for
 * pts/dts, 0 for duration) if the stream does not provide them. The timing
 * information will be in AVStream.time_base units, i.e. it has to be
 * multiplied by the timebase to convert them to seconds.
 *
 * A packet returned by av_read_frame() is always reference-counted,
 * i.e. AVPacket.buf is set and the user may keep it indefinitely.
 * The packet must be freed with av_packet_unref() when it is no
 * longer needed.
 *
 * \section lavf_decoding_seek Seeking
 * \}
 *
 * \defgroup lavf_encoding Muxing
 * \{
 * Muxers take encoded data in the form of \ref AVPacket "AVPackets" and write
 * it into files or other output bytestreams in the specified container format.
 *
 * The main API functions for muxing are avformat_write_header() for writing the
 * file header, av_write_frame() / av_interleaved_write_frame() for writing the
 * packets and av_write_trailer() for finalizing the file.
 *
 * At the beginning of the muxing process, the caller must first call
 * avformat_alloc_context() to create a muxing context. The caller then sets up
 * the muxer by filling the various fields in this context:
 *
 * - The \ref AVFormatContext.oformat "oformat" field must be set to select the
 *   muxer that will be used.
 * - Unless the format is of the AVFMT_NOFILE type, the \ref AVFormatContext.pb
 *   "pb" field must be set to an opened IO context, either returned from
 *   avio_open2() or a custom one.
 * - Unless the format is of the AVFMT_NOSTREAMS type, at least one stream must
 *   be created with the avformat_new_stream() function. The caller should fill
 *   the \ref AVStream.codecpar "stream codec parameters" information, such as the
 *   codec \ref AVCodecParameters.codec_type "type", \ref AVCodecParameters.codec_id
 *   "id" and other parameters (e.g. width / height, the pixel or sample format,
 *   etc.) as known. The \ref AVStream.time_base "stream timebase" should
 *   be set to the timebase that the caller desires to use for this stream (note
 *   that the timebase actually used by the muxer can be different, as will be
 *   described later).
 * - It is advised to manually initialize only the relevant fields in
 *   AVCodecParameters, rather than using \ref avcodec_parameters_copy() during
 *   remuxing: there is no guarantee that the codec context values remain valid
 *   for both input and output format contexts.
 * - The caller may fill in additional information, such as \ref
 *   AVFormatContext.metadata "global" or \ref AVStream.metadata "per-stream"
 *   metadata, \ref AVFormatContext.chapters "chapters", \ref
 *   AVFormatContext.programs "programs", etc. as described in the
 *   AVFormatContext documentation. Whether such information will actually be
 *   stored in the output depends on what the container format and the muxer
 *   support.
 *
 * When the muxing context is fully set up, the caller must call
 * avformat_write_header() to initialize the muxer internals and write the file
 * header. Whether anything actually is written to the IO context at this step
 * depends on the muxer, but this function must always be called. Any muxer
 * private options must be passed in the options parameter to this function.
 *
 * The data is then sent to the muxer by repeatedly calling av_write_frame() or
 * av_interleaved_write_frame() (consult those functions' documentation for
 * discussion on the difference between them; only one of them may be used with
 * a single muxing context, they should not be mixed). Do note that the timing
 * information on the packets sent to the muxer must be in the corresponding
 * AVStream's timebase. That timebase is set by the muxer (in the
 * avformat_write_header() step) and may be different from the timebase
 * requested by the caller.
 *
 * Once all the data has been written, the caller must call av_write_trailer()
 * to flush any buffered packets and finalize the output file, then close the IO
 * context (if any) and finally free the muxing context with
 * avformat_free_context().
 * \}
 *
 * \defgroup lavf_io I/O Read/Write
 * \{
 * \section lavf_io_dirlist Directory listing
 * The directory listing API makes it possible to list files on remote servers.
 *
 * Some of possible use cases:
 * - an "open file" dialog to choose files from a remote location,
 * - a recursive media finder providing a player with an ability to play all
 * files from a given directory.
 *
 * \subsection lavf_io_dirlist_open Opening a directory
 * At first, a directory needs to be opened by calling avio_open_dir()
 * supplied with a URL and, optionally, ::AVDictionary containing
 * protocol-specific parameters. The function returns zero or positive
 * integer and allocates AVIODirContext on success.
 *
 * <pre>{@code
 * AVIODirContext *ctx = NULL;
 * if (avio_open_dir(&ctx, "smb://example.com/some_dir", NULL) < 0) {
 *     fprintf(stderr, "Cannot open directory.\n");
 *     abort();
 * }
 * }</pre>
 *
 * This code tries to open a sample directory using smb protocol without
 * any additional parameters.
 *
 * \subsection lavf_io_dirlist_read Reading entries
 * Each directory's entry (i.e. file, another directory, anything else
 * within ::AVIODirEntryType) is represented by AVIODirEntry.
 * Reading consecutive entries from an opened AVIODirContext is done by
 * repeatedly calling avio_read_dir() on it. Each call returns zero or
 * positive integer if successful. Reading can be stopped right after the
 * NULL entry has been read -- it means there are no entries left to be
 * read. The following code reads all entries from a directory associated
 * with ctx and prints their names to standard output.
 * <pre>{@code
 * AVIODirEntry *entry = NULL;
 * for (;;) {
 *     if (avio_read_dir(ctx, &entry) < 0) {
 *         fprintf(stderr, "Cannot list directory.\n");
 *         abort();
 *     }
 *     if (!entry)
 *         break;
 *     printf("%s\n", entry->name);
 *     avio_free_directory_entry(&entry);
 * }
 * }</pre>
 * \}
 *
 * \defgroup lavf_codec Demuxers
 * \{
 * \defgroup lavf_codec_native Native Demuxers
 * \{
 * \}
 * \defgroup lavf_codec_wrappers External library wrappers
 * \{
 * \}
 * \}
 * \defgroup lavf_protos I/O Protocols
 * \{
 * \}
 * \defgroup lavf_internal Internal
 * \{
 * \}
 * \}
 */

// #include <time.h>
// #include <stdio.h>  /* FILE */

// #include "libavcodec/codec.h"
// #include "libavcodec/codec_par.h"
// #include "libavcodec/defs.h"
// #include "libavcodec/packet.h"

// #include "libavutil/dict.h"
// #include "libavutil/log.h"

// #include "avio.h"
// #include "libavformat/version_major.h"
// #ifndef HAVE_AV_CONFIG_H
/* When included as part of the ffmpeg build, only include the major version
 * to avoid unnecessary rebuilds. When included externally, keep including
 * the full version information. */
// #include "libavformat/version.h"
// #endif

/**
 * \defgroup metadata_api Public Metadata API
 * \{
 * \ingroup libavf
 * The metadata API allows libavformat to export metadata tags to a client
 * application when demuxing. Conversely it allows a client application to
 * set metadata when muxing.
 *
 * Metadata is exported or set as pairs of key/value strings in the 'metadata'
 * fields of the AVFormatContext, AVStream, AVChapter and AVProgram structs
 * using the \ref lavu_dict "AVDictionary" API. Like all strings in FFmpeg,
 * metadata is assumed to be UTF-8 encoded Unicode. Note that metadata
 * exported by demuxers isn't checked to be valid UTF-8 in most cases.
 *
 * Important concepts to keep in mind:
 * -  Keys are unique; there can never be 2 tags with the same key. This is
 *    also meant semantically, i.e., a demuxer should not knowingly produce
 *    several keys that are literally different but semantically identical.
 *    E.g., key=Author5, key=Author6. In this example, all authors must be
 *    placed in the same tag.
 * -  Metadata is flat, not hierarchical; there are no subtags. If you
 *    want to store, e.g., the email address of the child of producer Alice
 *    and actor Bob, that could have key=alice_and_bobs_childs_email_address.
 * -  Several modifiers can be applied to the tag name. This is done by
 *    appending a dash character ('-') and the modifier name in the order
 *    they appear in the list below -- e.g. foo-eng-sort, not foo-sort-eng.
 *    -  language -- a tag whose value is localized for a particular language
 *       is appended with the ISO 639-2/B 3-letter language code.
 *       For example: Author-ger=Michael, Author-eng=Mike
 *       The original/default language is in the unqualified "Author" tag.
 *       A demuxer should set a default if it sets any translated tag.
 *    -  sorting  -- a modified version of a tag that should be used for
 *       sorting will have '-sort' appended. E.g. artist="The Beatles",
 *       artist-sort="Beatles, The".
 * - Some protocols and demuxers support metadata updates. After a successful
 *   call to av_read_frame(), AVFormatContext.event_flags or AVStream.event_flags
 *   will be updated to indicate if metadata changed. In order to detect metadata
 *   changes on a stream, you need to loop through all streams in the AVFormatContext
 *   and check their individual event_flags.
 *
 * -  Demuxers attempt to export metadata in a generic format, however tags
 *    with no generic equivalents are left as they are stored in the container.
 *    Follows a list of generic tag names:
 *
 <pre>{@literal
 album        -- name of the set this work belongs to
 album_artist -- main creator of the set/album, if different from artist.
                 e.g. "Various Artists" for compilation albums.
 artist       -- main creator of the work
 comment      -- any additional description of the file.
 composer     -- who composed the work, if different from artist.
 copyright    -- name of copyright holder.
 creation_time-- date when the file was created, preferably in ISO 8601.
 date         -- date when the work was created, preferably in ISO 8601.
 disc         -- number of a subset, e.g. disc in a multi-disc collection.
 encoder      -- name/settings of the software/hardware that produced the file.
 encoded_by   -- person/group who created the file.
 filename     -- original name of the file.
 genre        -- <self-evident>.
 language     -- main language in which the work is performed, preferably
                 in ISO 639-2 format. Multiple languages can be specified by
                 separating them with commas.
 performer    -- artist who performed the work, if different from artist.
                 E.g for "Also sprach Zarathustra", artist would be "Richard
                 Strauss" and performer "London Philharmonic Orchestra".
 publisher    -- name of the label/publisher.
 service_name     -- name of the service in broadcasting (channel name).
 service_provider -- name of the service provider in broadcasting.
 title        -- name of the work.
 track        -- number of this work in the set, can be in form current/total.
 variant_bitrate -- the total bitrate of the bitrate variant that the current stream is part of
 }</pre>
 *
 * Look in the examples section for an application example how to use the Metadata API.
 *
 * \}
 */

/* packet functions */


/**
 * Allocate and read the payload of a packet and initialize its
 * fields with default values.
 *
 * @param s    associated IO context
 * @param pkt packet
 * @param size desired payload size
 * @return >0 (read size) if OK, AVERROR_xxx otherwise
 */
@NoException public static native int av_get_packet(AVIOContext s, AVPacket pkt, int size);


/**
 * Read data and append it to the current content of the AVPacket.
 * If pkt->size is 0 this is identical to av_get_packet.
 * Note that this uses av_grow_packet and thus involves a realloc
 * which is inefficient. Thus this function should only be used
 * when there is no reasonable way to know (an upper bound of)
 * the final size.
 *
 * @param s    associated IO context
 * @param pkt packet
 * @param size amount of data to read
 * @return >0 (read size) if OK, AVERROR_xxx otherwise, previous data
 *         will not be lost even if an error occurs.
 */
@NoException public static native int av_append_packet(AVIOContext s, AVPacket pkt, int size);
// Targeting ..\avformat\AVCodecTag.java


// Targeting ..\avformat\AVProbeData.java



public static native @MemberGetter int AVPROBE_SCORE_RETRY();
public static final int AVPROBE_SCORE_RETRY = AVPROBE_SCORE_RETRY();
public static native @MemberGetter int AVPROBE_SCORE_STREAM_RETRY();
public static final int AVPROBE_SCORE_STREAM_RETRY = AVPROBE_SCORE_STREAM_RETRY();

/** score for file extension */
public static final int AVPROBE_SCORE_EXTENSION =  50;
/** score for file mime type */
public static final int AVPROBE_SCORE_MIME =       75;
/** maximum score */
public static final int AVPROBE_SCORE_MAX =       100;

/** extra allocated bytes at the end of the probe buffer */
public static final int AVPROBE_PADDING_SIZE = 32;

/** Demuxer will use avio_open, no opened file should be provided by the caller. */
public static final int AVFMT_NOFILE =        0x0001;
/** Needs '%d' in filename. */
public static final int AVFMT_NEEDNUMBER =    0x0002;
/**
 * The muxer/demuxer is experimental and should be used with caution.
 *
 * - demuxers: will not be selected automatically by probing, must be specified
 *             explicitly.
 */
public static final int AVFMT_EXPERIMENTAL =  0x0004;
/** Show format stream IDs numbers. */
public static final int AVFMT_SHOW_IDS =      0x0008;
/** Format wants global header. */
public static final int AVFMT_GLOBALHEADER =  0x0040;
/** Format does not need / have any timestamps. */
public static final int AVFMT_NOTIMESTAMPS =  0x0080;
/** Use generic index building code. */
public static final int AVFMT_GENERIC_INDEX = 0x0100;
/** Format allows timestamp discontinuities. Note, muxers always require valid (monotone) timestamps */
public static final int AVFMT_TS_DISCONT =    0x0200;
/** Format allows variable fps. */
public static final int AVFMT_VARIABLE_FPS =  0x0400;
/** Format does not need width/height */
public static final int AVFMT_NODIMENSIONS =  0x0800;
/** Format does not require any streams */
public static final int AVFMT_NOSTREAMS =     0x1000;
/** Format does not allow to fall back on binary search via read_timestamp */
public static final int AVFMT_NOBINSEARCH =   0x2000;
/** Format does not allow to fall back on generic search */
public static final int AVFMT_NOGENSEARCH =   0x4000;
/** Format does not allow seeking by bytes */
public static final int AVFMT_NO_BYTE_SEEK =  0x8000;
/** Format allows flushing. If not set, the muxer will not receive a NULL packet in the write_packet function. */
public static final int AVFMT_ALLOW_FLUSH =  0x10000;
/** Format does not require strictly
                                        increasing timestamps, but they must
                                        still be monotonic */
public static final int AVFMT_TS_NONSTRICT = 0x20000;
/** Format allows muxing negative
                                        timestamps. If not set the timestamp
                                        will be shifted in av_write_frame and
                                        av_interleaved_write_frame so they
                                        start from 0.
                                        The user or muxer can override this through
                                        AVFormatContext.avoid_negative_ts
                                        */
public static final int AVFMT_TS_NEGATIVE =  0x40000;

/** Seeking is based on PTS */
public static final int AVFMT_SEEK_TO_PTS =   0x4000000;
// Targeting ..\avformat\AVOutputFormat.java


// Targeting ..\avformat\AVInputFormat.java


/**
 * \}
 */

/** enum AVStreamParseType */
public static final int
    AVSTREAM_PARSE_NONE = 0,
    /** full parsing and repack */
    AVSTREAM_PARSE_FULL = 1,
    /** Only parse headers, do not repack. */
    AVSTREAM_PARSE_HEADERS = 2,
    /** full parsing and interpolation of timestamps for frames not starting on a packet boundary */
    AVSTREAM_PARSE_TIMESTAMPS = 3,
    /** full parsing and repack of the first frame only, only implemented for H.264 currently */
    AVSTREAM_PARSE_FULL_ONCE = 4,
    /** full parsing and repack with timestamp and position generation by parser for raw
                                    this assumes that each packet in the file contains no demuxer level headers and
                                    just codec level data, otherwise position generation would fail */
    AVSTREAM_PARSE_FULL_RAW = 5;
// Targeting ..\avformat\AVIndexEntry.java



/**
 * The stream should be chosen by default among other streams of the same type,
 * unless the user has explicitly specified otherwise.
 */
public static final int AV_DISPOSITION_DEFAULT =              (1 << 0);
/**
 * The stream is not in original language.
 *
 * \note AV_DISPOSITION_ORIGINAL is the inverse of this disposition. At most
 *       one of them should be set in properly tagged streams.
 * \note This disposition may apply to any stream type, not just audio.
 */
public static final int AV_DISPOSITION_DUB =                  (1 << 1);
/**
 * The stream is in original language.
 *
 * @see the notes for AV_DISPOSITION_DUB
 */
public static final int AV_DISPOSITION_ORIGINAL =             (1 << 2);
/**
 * The stream is a commentary track.
 */
public static final int AV_DISPOSITION_COMMENT =              (1 << 3);
/**
 * The stream contains song lyrics.
 */
public static final int AV_DISPOSITION_LYRICS =               (1 << 4);
/**
 * The stream contains karaoke audio.
 */
public static final int AV_DISPOSITION_KARAOKE =              (1 << 5);

/**
 * Track should be used during playback by default.
 * Useful for subtitle track that should be displayed
 * even when user did not explicitly ask for subtitles.
 */
public static final int AV_DISPOSITION_FORCED =               (1 << 6);
/**
 * The stream is intended for hearing impaired audiences.
 */
public static final int AV_DISPOSITION_HEARING_IMPAIRED =     (1 << 7);
/**
 * The stream is intended for visually impaired audiences.
 */
public static final int AV_DISPOSITION_VISUAL_IMPAIRED =      (1 << 8);
/**
 * The audio stream contains music and sound effects without voice.
 */
public static final int AV_DISPOSITION_CLEAN_EFFECTS =        (1 << 9);
/**
 * The stream is stored in the file as an attached picture/"cover art" (e.g.
 * APIC frame in ID3v2). The first (usually only) packet associated with it
 * will be returned among the first few packets read from the file unless
 * seeking takes place. It can also be accessed at any time in
 * AVStream.attached_pic.
 */
public static final int AV_DISPOSITION_ATTACHED_PIC =         (1 << 10);
/**
 * The stream is sparse, and contains thumbnail images, often corresponding
 * to chapter markers. Only ever used with AV_DISPOSITION_ATTACHED_PIC.
 */
public static final int AV_DISPOSITION_TIMED_THUMBNAILS =     (1 << 11);

/**
 * The stream is intended to be mixed with a spatial audio track. For example,
 * it could be used for narration or stereo music, and may remain unchanged by
 * listener head rotation.
 */
public static final int AV_DISPOSITION_NON_DIEGETIC =         (1 << 12);

/**
 * The subtitle stream contains captions, providing a transcription and possibly
 * a translation of audio. Typically intended for hearing-impaired audiences.
 */
public static final int AV_DISPOSITION_CAPTIONS =             (1 << 16);
/**
 * The subtitle stream contains a textual description of the video content.
 * Typically intended for visually-impaired audiences or for the cases where the
 * video cannot be seen.
 */
public static final int AV_DISPOSITION_DESCRIPTIONS =         (1 << 17);
/**
 * The subtitle stream contains time-aligned metadata that is not intended to be
 * directly presented to the user.
 */
public static final int AV_DISPOSITION_METADATA =             (1 << 18);
/**
 * The audio stream is intended to be mixed with another stream before
 * presentation.
 * Corresponds to mix_type=0 in mpegts.
 */
public static final int AV_DISPOSITION_DEPENDENT =            (1 << 19);
/**
 * The video stream contains still images.
 */
public static final int AV_DISPOSITION_STILL_IMAGE =          (1 << 20);

/**
 * @return The AV_DISPOSITION_* flag corresponding to disp or a negative error
 *         code if disp does not correspond to a known stream disposition.
 */
@NoException public static native int av_disposition_from_string(@Cast("const char*") BytePointer disp);
@NoException public static native int av_disposition_from_string(String disp);

/**
 * @param disposition a combination of AV_DISPOSITION_* values
 * @return The string description corresponding to the lowest set bit in
 *         disposition. NULL when the lowest set bit does not correspond
 *         to a known disposition or when disposition is 0.
 */
@NoException public static native @Cast("const char*") BytePointer av_disposition_to_string(int disposition);

/**
 * Options for behavior on timestamp wrap detection.
 */
/** ignore the wrap */
public static final int AV_PTS_WRAP_IGNORE =      0;
/** add the format specific offset on wrap detection */
public static final int AV_PTS_WRAP_ADD_OFFSET =  1;
/** subtract the format specific offset on wrap detection */
public static final int AV_PTS_WRAP_SUB_OFFSET =  -1;
// Targeting ..\avformat\AVStream.java



@NoException public static native AVCodecParserContext av_stream_get_parser(@Const AVStream s);

// #if FF_API_GET_END_PTS
/**
 * Returns the pts of the last muxed packet + its duration
 *
 * the retuned value is undefined when used with a demuxer.
 */
@NoException public static native @Cast("int64_t") @Deprecated long av_stream_get_end_pts(@Const AVStream st);
// #endif

public static final int AV_PROGRAM_RUNNING = 1;
// Targeting ..\avformat\AVProgram.java



/** signal that no header is present
                                         (streams are added dynamically) */
public static final int AVFMTCTX_NOHEADER =      0x0001;
/** signal that the stream is definitely
                                         not seekable, and attempts to call the
                                         seek function will fail. For some
                                         network protocols (e.g. HLS), this can
                                         change dynamically at runtime. */
public static final int AVFMTCTX_UNSEEKABLE =    0x0002;
// Targeting ..\avformat\AVChapter.java


// Targeting ..\avformat\av_format_control_message.java


// Targeting ..\avformat\AVOpenCallback.java



/**
 * The duration of a video can be estimated through various ways, and this enum can be used
 * to know how the duration was estimated.
 */
/** enum AVDurationEstimationMethod */
public static final int
    /** Duration accurately estimated from PTSes */
    AVFMT_DURATION_FROM_PTS = 0,
    /** Duration estimated from a stream with a known duration */
    AVFMT_DURATION_FROM_STREAM = 1,
    /** Duration estimated from bitrate (less accurate) */
    AVFMT_DURATION_FROM_BITRATE = 2;
// Targeting ..\avformat\AVFormatContext.java



/**
 * This function will cause global side data to be injected in the next packet
 * of each stream as well as after any subsequent seek.
 */
@NoException public static native void av_format_inject_global_side_data(AVFormatContext s);

/**
 * Returns the method used to set ctx->duration.
 *
 * @return AVFMT_DURATION_FROM_PTS, AVFMT_DURATION_FROM_STREAM, or AVFMT_DURATION_FROM_BITRATE.
 */
@NoException public static native @Cast("AVDurationEstimationMethod") int av_fmt_ctx_get_duration_estimation_method(@Const AVFormatContext ctx);

/**
 * \defgroup lavf_core Core functions
 * \ingroup libavf
 *
 * Functions for querying libavformat capabilities, allocating core structures,
 * etc.
 * \{
 */

/**
 * Return the LIBAVFORMAT_VERSION_INT constant.
 */
@NoException public static native @Cast("unsigned") int avformat_version();

/**
 * Return the libavformat build-time configuration.
 */
@NoException public static native @Cast("const char*") BytePointer avformat_configuration();

/**
 * Return the libavformat license.
 */
@NoException public static native @Cast("const char*") BytePointer avformat_license();

/**
 * Do global initialization of network libraries. This is optional,
 * and not recommended anymore.
 *
 * This functions only exists to work around thread-safety issues
 * with older GnuTLS or OpenSSL libraries. If libavformat is linked
 * to newer versions of those libraries, or if you do not use them,
 * calling this function is unnecessary. Otherwise, you need to call
 * this function before any other threads using them are started.
 *
 * This function will be deprecated once support for older GnuTLS and
 * OpenSSL libraries is removed, and this function has no purpose
 * anymore.
 */
@NoException public static native int avformat_network_init();

/**
 * Undo the initialization done by avformat_network_init. Call it only
 * once for each time you called avformat_network_init.
 */
@NoException public static native int avformat_network_deinit();

/**
 * Iterate over all registered muxers.
 *
 * @param opaque a pointer where libavformat will store the iteration state. Must
 *               point to NULL to start the iteration.
 *
 * @return the next registered muxer or NULL when the iteration is
 *         finished
 */
@NoException public static native @Const AVOutputFormat av_muxer_iterate(@Cast("void**") PointerPointer opaque);
@NoException public static native @Const AVOutputFormat av_muxer_iterate(@Cast("void**") @ByPtrPtr Pointer opaque);

/**
 * Iterate over all registered demuxers.
 *
 * @param opaque a pointer where libavformat will store the iteration state.
 *               Must point to NULL to start the iteration.
 *
 * @return the next registered demuxer or NULL when the iteration is
 *         finished
 */
@NoException public static native @Const AVInputFormat av_demuxer_iterate(@Cast("void**") PointerPointer opaque);
@NoException public static native @Const AVInputFormat av_demuxer_iterate(@Cast("void**") @ByPtrPtr Pointer opaque);

/**
 * Allocate an AVFormatContext.
 * avformat_free_context() can be used to free the context and everything
 * allocated by the framework within it.
 */
@NoException public static native AVFormatContext avformat_alloc_context();

/**
 * Free an AVFormatContext and all its streams.
 * @param s context to free
 */
@NoException public static native void avformat_free_context(AVFormatContext s);

/**
 * Get the AVClass for AVFormatContext. It can be used in combination with
 * AV_OPT_SEARCH_FAKE_OBJ for examining options.
 *
 * @see av_opt_find().
 */
@NoException public static native @Const AVClass avformat_get_class();

/**
 * Get the AVClass for AVStream. It can be used in combination with
 * AV_OPT_SEARCH_FAKE_OBJ for examining options.
 *
 * @see av_opt_find().
 */
@NoException public static native @Const AVClass av_stream_get_class();

/**
 * Add a new stream to a media file.
 *
 * When demuxing, it is called by the demuxer in read_header(). If the
 * flag AVFMTCTX_NOHEADER is set in s.ctx_flags, then it may also
 * be called in read_packet().
 *
 * When muxing, should be called by the user before avformat_write_header().
 *
 * User is required to call avformat_free_context() to clean up the allocation
 * by avformat_new_stream().
 *
 * @param s media file handle
 * @param c unused, does nothing
 *
 * @return newly created stream or NULL on error.
 */
@NoException public static native AVStream avformat_new_stream(AVFormatContext s, @Const AVCodec c);

/**
 * Wrap an existing array as stream side data.
 *
 * @param st   stream
 * @param type side information type
 * @param data the side data array. It must be allocated with the av_malloc()
 *             family of functions. The ownership of the data is transferred to
 *             st.
 * @param size side information size
 *
 * @return zero on success, a negative AVERROR code on failure. On failure,
 *         the stream is unchanged and the data remains owned by the caller.
 */
@NoException public static native int av_stream_add_side_data(AVStream st, @Cast("AVPacketSideDataType") int type,
                            @Cast("uint8_t*") BytePointer data, @Cast("size_t") long size);
@NoException public static native int av_stream_add_side_data(AVStream st, @Cast("AVPacketSideDataType") int type,
                            @Cast("uint8_t*") ByteBuffer data, @Cast("size_t") long size);
@NoException public static native int av_stream_add_side_data(AVStream st, @Cast("AVPacketSideDataType") int type,
                            @Cast("uint8_t*") byte[] data, @Cast("size_t") long size);

/**
 * Allocate new information from stream.
 *
 * @param stream stream
 * @param type   desired side information type
 * @param size   side information size
 *
 * @return pointer to fresh allocated data or NULL otherwise
 */
@NoException public static native @Cast("uint8_t*") BytePointer av_stream_new_side_data(AVStream stream,
                                 @Cast("AVPacketSideDataType") int type, @Cast("size_t") long size);
/**
 * Get side information from stream.
 *
 * @param stream stream
 * @param type   desired side information type
 * @param size   If supplied, *size will be set to the size of the side data
 *               or to zero if the desired side data is not present.
 *
 * @return pointer to data if present or NULL otherwise
 */
@NoException public static native @Cast("uint8_t*") BytePointer av_stream_get_side_data(@Const AVStream stream,
                                 @Cast("AVPacketSideDataType") int type, @Cast("size_t*") SizeTPointer size);

@NoException public static native AVProgram av_new_program(AVFormatContext s, int id);

/**
 * \}
 */


/**
 * Allocate an AVFormatContext for an output format.
 * avformat_free_context() can be used to free the context and
 * everything allocated by the framework within it.
 *
 * @param ctx           pointee is set to the created format context,
 *                      or to NULL in case of failure
 * @param oformat       format to use for allocating the context, if NULL
 *                      format_name and filename are used instead
 * @param format_name   the name of output format to use for allocating the
 *                      context, if NULL filename is used instead
 * @param filename      the name of the filename to use for allocating the
 *                      context, may be NULL
 *
 * @return  >= 0 in case of success, a negative AVERROR code in case of
 *          failure
 */
@NoException public static native int avformat_alloc_output_context2(@Cast("AVFormatContext**") PointerPointer ctx, @Const AVOutputFormat oformat,
                                   @Cast("const char*") BytePointer format_name, @Cast("const char*") BytePointer filename);
@NoException public static native int avformat_alloc_output_context2(@ByPtrPtr AVFormatContext ctx, @Const AVOutputFormat oformat,
                                   @Cast("const char*") BytePointer format_name, @Cast("const char*") BytePointer filename);
@NoException public static native int avformat_alloc_output_context2(@ByPtrPtr AVFormatContext ctx, @Const AVOutputFormat oformat,
                                   String format_name, String filename);

/**
 * \addtogroup lavf_decoding
 * \{
 */

/**
 * Find AVInputFormat based on the short name of the input format.
 */
@NoException public static native @Const AVInputFormat av_find_input_format(@Cast("const char*") BytePointer short_name);
@NoException public static native @Const AVInputFormat av_find_input_format(String short_name);

/**
 * Guess the file format.
 *
 * @param pd        data to be probed
 * @param is_opened Whether the file is already opened; determines whether
 *                  demuxers with or without AVFMT_NOFILE are probed.
 */
@NoException public static native @Const AVInputFormat av_probe_input_format(@Const AVProbeData pd, int is_opened);

/**
 * Guess the file format.
 *
 * @param pd        data to be probed
 * @param is_opened Whether the file is already opened; determines whether
 *                  demuxers with or without AVFMT_NOFILE are probed.
 * @param score_max A probe score larger that this is required to accept a
 *                  detection, the variable is set to the actual detection
 *                  score afterwards.
 *                  If the score is <= AVPROBE_SCORE_MAX / 4 it is recommended
 *                  to retry with a larger probe buffer.
 */
@NoException public static native @Const AVInputFormat av_probe_input_format2(@Const AVProbeData pd,
                                            int is_opened, IntPointer score_max);
@NoException public static native @Const AVInputFormat av_probe_input_format2(@Const AVProbeData pd,
                                            int is_opened, IntBuffer score_max);
@NoException public static native @Const AVInputFormat av_probe_input_format2(@Const AVProbeData pd,
                                            int is_opened, int[] score_max);

/**
 * Guess the file format.
 *
 * @param is_opened Whether the file is already opened; determines whether
 *                  demuxers with or without AVFMT_NOFILE are probed.
 * @param score_ret The score of the best detection.
 */
@NoException public static native @Const AVInputFormat av_probe_input_format3(@Const AVProbeData pd,
                                            int is_opened, IntPointer score_ret);
@NoException public static native @Const AVInputFormat av_probe_input_format3(@Const AVProbeData pd,
                                            int is_opened, IntBuffer score_ret);
@NoException public static native @Const AVInputFormat av_probe_input_format3(@Const AVProbeData pd,
                                            int is_opened, int[] score_ret);

/**
 * Probe a bytestream to determine the input format. Each time a probe returns
 * with a score that is too low, the probe buffer size is increased and another
 * attempt is made. When the maximum probe size is reached, the input format
 * with the highest score is returned.
 *
 * @param pb             the bytestream to probe
 * @param fmt            the input format is put here
 * @param url            the url of the stream
 * @param logctx         the log context
 * @param offset         the offset within the bytestream to probe from
 * @param max_probe_size the maximum probe buffer size (zero for default)
 *
 * @return the score in case of success, a negative value corresponding to an
 *         the maximal score is AVPROBE_SCORE_MAX
 *         AVERROR code otherwise
 */
@NoException public static native int av_probe_input_buffer2(AVIOContext pb, @Cast("const AVInputFormat**") PointerPointer fmt,
                           @Cast("const char*") BytePointer url, Pointer logctx,
                           @Cast("unsigned int") int offset, @Cast("unsigned int") int max_probe_size);
@NoException public static native int av_probe_input_buffer2(AVIOContext pb, @Const @ByPtrPtr AVInputFormat fmt,
                           @Cast("const char*") BytePointer url, Pointer logctx,
                           @Cast("unsigned int") int offset, @Cast("unsigned int") int max_probe_size);
@NoException public static native int av_probe_input_buffer2(AVIOContext pb, @Const @ByPtrPtr AVInputFormat fmt,
                           String url, Pointer logctx,
                           @Cast("unsigned int") int offset, @Cast("unsigned int") int max_probe_size);

/**
 * Like av_probe_input_buffer2() but returns 0 on success
 */
@NoException public static native int av_probe_input_buffer(AVIOContext pb, @Cast("const AVInputFormat**") PointerPointer fmt,
                          @Cast("const char*") BytePointer url, Pointer logctx,
                          @Cast("unsigned int") int offset, @Cast("unsigned int") int max_probe_size);
@NoException public static native int av_probe_input_buffer(AVIOContext pb, @Const @ByPtrPtr AVInputFormat fmt,
                          @Cast("const char*") BytePointer url, Pointer logctx,
                          @Cast("unsigned int") int offset, @Cast("unsigned int") int max_probe_size);
@NoException public static native int av_probe_input_buffer(AVIOContext pb, @Const @ByPtrPtr AVInputFormat fmt,
                          String url, Pointer logctx,
                          @Cast("unsigned int") int offset, @Cast("unsigned int") int max_probe_size);

/**
 * Open an input stream and read the header. The codecs are not opened.
 * The stream must be closed with avformat_close_input().
 *
 * @param ps       Pointer to user-supplied AVFormatContext (allocated by
 *                 avformat_alloc_context). May be a pointer to NULL, in
 *                 which case an AVFormatContext is allocated by this
 *                 function and written into ps.
 *                 Note that a user-supplied AVFormatContext will be freed
 *                 on failure.
 * @param url      URL of the stream to open.
 * @param fmt      If non-NULL, this parameter forces a specific input format.
 *                 Otherwise the format is autodetected.
 * @param options  A dictionary filled with AVFormatContext and demuxer-private
 *                 options.
 *                 On return this parameter will be destroyed and replaced with
 *                 a dict containing options that were not found. May be NULL.
 *
 * @return 0 on success, a negative AVERROR on failure.
 *
 * \note If you want to use custom IO, preallocate the format context and set its pb field.
 */
@NoException public static native int avformat_open_input(@Cast("AVFormatContext**") PointerPointer ps, @Cast("const char*") BytePointer url,
                        @Const AVInputFormat fmt, @Cast("AVDictionary**") PointerPointer options);
@NoException public static native int avformat_open_input(@ByPtrPtr AVFormatContext ps, @Cast("const char*") BytePointer url,
                        @Const AVInputFormat fmt, @ByPtrPtr AVDictionary options);
@NoException public static native int avformat_open_input(@ByPtrPtr AVFormatContext ps, String url,
                        @Const AVInputFormat fmt, @ByPtrPtr AVDictionary options);

/**
 * Read packets of a media file to get stream information. This
 * is useful for file formats with no headers such as MPEG. This
 * function also computes the real framerate in case of MPEG-2 repeat
 * frame mode.
 * The logical file position is not changed by this function;
 * examined packets may be buffered for later processing.
 *
 * @param ic media file handle
 * @param options  If non-NULL, an ic.nb_streams long array of pointers to
 *                 dictionaries, where i-th member contains options for
 *                 codec corresponding to i-th stream.
 *                 On return each dictionary will be filled with options that were not found.
 * @return >=0 if OK, AVERROR_xxx on error
 *
 * \note this function isn't guaranteed to open all the codecs, so
 *       options being non-empty at return is a perfectly normal behavior.
 *
 * \todo Let the user decide somehow what information is needed so that
 *       we do not waste time getting stuff the user does not need.
 */
@NoException public static native int avformat_find_stream_info(AVFormatContext ic, @Cast("AVDictionary**") PointerPointer options);
@NoException public static native int avformat_find_stream_info(AVFormatContext ic, @ByPtrPtr AVDictionary options);

/**
 * Find the programs which belong to a given stream.
 *
 * @param ic    media file handle
 * @param last  the last found program, the search will start after this
 *              program, or from the beginning if it is NULL
 * @param s     stream index
 *
 * @return the next program which belongs to s, NULL if no program is found or
 *         the last program is not among the programs of ic.
 */
@NoException public static native AVProgram av_find_program_from_stream(AVFormatContext ic, AVProgram last, int s);

@NoException public static native void av_program_add_stream_index(AVFormatContext ac, int progid, @Cast("unsigned int") int idx);

/**
 * Find the "best" stream in the file.
 * The best stream is determined according to various heuristics as the most
 * likely to be what the user expects.
 * If the decoder parameter is non-NULL, av_find_best_stream will find the
 * default decoder for the stream's codec; streams for which no decoder can
 * be found are ignored.
 *
 * @param ic                media file handle
 * @param type              stream type: video, audio, subtitles, etc.
 * @param wanted_stream_nb  user-requested stream number,
 *                          or -1 for automatic selection
 * @param related_stream    try to find a stream related (eg. in the same
 *                          program) to this one, or -1 if none
 * @param decoder_ret       if non-NULL, returns the decoder for the
 *                          selected stream
 * @param flags             flags; none are currently defined
 *
 * @return  the non-negative stream number in case of success,
 *          AVERROR_STREAM_NOT_FOUND if no stream with the requested type
 *          could be found,
 *          AVERROR_DECODER_NOT_FOUND if streams were found but no decoder
 *
 * \note  If av_find_best_stream returns successfully and decoder_ret is not
 *        NULL, then *decoder_ret is guaranteed to be set to a valid AVCodec.
 */
@NoException public static native int av_find_best_stream(AVFormatContext ic,
                        @Cast("AVMediaType") int type,
                        int wanted_stream_nb,
                        int related_stream,
                        @Cast("const AVCodec**") PointerPointer decoder_ret,
                        int flags);
@NoException public static native int av_find_best_stream(AVFormatContext ic,
                        @Cast("AVMediaType") int type,
                        int wanted_stream_nb,
                        int related_stream,
                        @Const @ByPtrPtr AVCodec decoder_ret,
                        int flags);

/**
 * Return the next frame of a stream.
 * This function returns what is stored in the file, and does not validate
 * that what is there are valid frames for the decoder. It will split what is
 * stored in the file into frames and return one for each call. It will not
 * omit invalid data between valid frames so as to give the decoder the maximum
 * information possible for decoding.
 *
 * On success, the returned packet is reference-counted (pkt->buf is set) and
 * valid indefinitely. The packet must be freed with av_packet_unref() when
 * it is no longer needed. For video, the packet contains exactly one frame.
 * For audio, it contains an integer number of frames if each frame has
 * a known fixed size (e.g. PCM or ADPCM data). If the audio frames have
 * a variable size (e.g. MPEG audio), then it contains one frame.
 *
 * pkt->pts, pkt->dts and pkt->duration are always set to correct
 * values in AVStream.time_base units (and guessed if the format cannot
 * provide them). pkt->pts can be AV_NOPTS_VALUE if the video format
 * has B-frames, so it is better to rely on pkt->dts if you do not
 * decompress the payload.
 *
 * @return 0 if OK, < 0 on error or end of file. On error, pkt will be blank
 *         (as if it came from av_packet_alloc()).
 *
 * \note pkt will be initialized, so it may be uninitialized, but it must not
 *       contain data that needs to be freed.
 */
@NoException public static native int av_read_frame(AVFormatContext s, AVPacket pkt);

/**
 * Seek to the keyframe at timestamp.
 * 'timestamp' in 'stream_index'.
 *
 * @param s            media file handle
 * @param stream_index If stream_index is (-1), a default stream is selected,
 *                     and timestamp is automatically converted from
 *                     AV_TIME_BASE units to the stream specific time_base.
 * @param timestamp    Timestamp in AVStream.time_base units or, if no stream
 *                     is specified, in AV_TIME_BASE units.
 * @param flags        flags which select direction and seeking mode
 *
 * @return >= 0 on success
 */
@NoException public static native int av_seek_frame(AVFormatContext s, int stream_index, @Cast("int64_t") long timestamp,
                  int flags);

/**
 * Seek to timestamp ts.
 * Seeking will be done so that the point from which all active streams
 * can be presented successfully will be closest to ts and within min/max_ts.
 * Active streams are all streams that have AVStream.discard < AVDISCARD_ALL.
 *
 * If flags contain AVSEEK_FLAG_BYTE, then all timestamps are in bytes and
 * are the file position (this may not be supported by all demuxers).
 * If flags contain AVSEEK_FLAG_FRAME, then all timestamps are in frames
 * in the stream with stream_index (this may not be supported by all demuxers).
 * Otherwise all timestamps are in units of the stream selected by stream_index
 * or if stream_index is -1, in AV_TIME_BASE units.
 * If flags contain AVSEEK_FLAG_ANY, then non-keyframes are treated as
 * keyframes (this may not be supported by all demuxers).
 * If flags contain AVSEEK_FLAG_BACKWARD, it is ignored.
 *
 * @param s            media file handle
 * @param stream_index index of the stream which is used as time base reference
 * @param min_ts       smallest acceptable timestamp
 * @param ts           target timestamp
 * @param max_ts       largest acceptable timestamp
 * @param flags        flags
 * @return >=0 on success, error code otherwise
 *
 * \note This is part of the new seek API which is still under construction.
 */
@NoException public static native int avformat_seek_file(AVFormatContext s, int stream_index, @Cast("int64_t") long min_ts, @Cast("int64_t") long ts, @Cast("int64_t") long max_ts, int flags);

/**
 * Discard all internally buffered data. This can be useful when dealing with
 * discontinuities in the byte stream. Generally works only with formats that
 * can resync. This includes headerless formats like MPEG-TS/TS but should also
 * work with NUT, Ogg and in a limited way AVI for example.
 *
 * The set of streams, the detected duration, stream parameters and codecs do
 * not change when calling this function. If you want a complete reset, it's
 * better to open a new AVFormatContext.
 *
 * This does not flush the AVIOContext (s->pb). If necessary, call
 * avio_flush(s->pb) before calling this function.
 *
 * @param s media file handle
 * @return >=0 on success, error code otherwise
 */
@NoException public static native int avformat_flush(AVFormatContext s);

/**
 * Start playing a network-based stream (e.g. RTSP stream) at the
 * current position.
 */
@NoException public static native int av_read_play(AVFormatContext s);

/**
 * Pause a network-based stream (e.g. RTSP stream).
 *
 * Use av_read_play() to resume it.
 */
@NoException public static native int av_read_pause(AVFormatContext s);

/**
 * Close an opened input AVFormatContext. Free it and all its contents
 * and set *s to NULL.
 */
@NoException public static native void avformat_close_input(@Cast("AVFormatContext**") PointerPointer s);
@NoException public static native void avformat_close_input(@ByPtrPtr AVFormatContext s);
/**
 * \}
 */

/** seek backward */
public static final int AVSEEK_FLAG_BACKWARD = 1;
/** seeking based on position in bytes */
public static final int AVSEEK_FLAG_BYTE =     2;
/** seek to any frame, even non-keyframes */
public static final int AVSEEK_FLAG_ANY =      4;
/** seeking based on frame number */
public static final int AVSEEK_FLAG_FRAME =    8;

/**
 * \addtogroup lavf_encoding
 * \{
 */

/** stream parameters initialized in avformat_write_header */
public static final int AVSTREAM_INIT_IN_WRITE_HEADER = 0;
/** stream parameters initialized in avformat_init_output */
public static final int AVSTREAM_INIT_IN_INIT_OUTPUT =  1;

/**
 * Allocate the stream private data and write the stream header to
 * an output media file.
 *
 * @param s        Media file handle, must be allocated with
 *                 avformat_alloc_context().
 *                 Its \ref AVFormatContext.oformat "oformat" field must be set
 *                 to the desired output format;
 *                 Its \ref AVFormatContext.pb "pb" field must be set to an
 *                 already opened ::AVIOContext.
 * @param options  An ::AVDictionary filled with AVFormatContext and
 *                 muxer-private options.
 *                 On return this parameter will be destroyed and replaced with
 *                 a dict containing options that were not found. May be NULL.
 *
 * \retval AVSTREAM_INIT_IN_WRITE_HEADER On success, if the codec had not already been
 *                                       fully initialized in avformat_init_output().
 * \retval AVSTREAM_INIT_IN_INIT_OUTPUT  On success, if the codec had already been fully
 *                                       initialized in avformat_init_output().
 * \retval AVERROR                       A negative AVERROR on failure.
 *
 * @see av_opt_find, av_dict_set, avio_open, av_oformat_next, avformat_init_output.
 */
@NoException public static native int avformat_write_header(AVFormatContext s, @Cast("AVDictionary**") PointerPointer options);
@NoException public static native int avformat_write_header(AVFormatContext s, @ByPtrPtr AVDictionary options);

/**
 * Allocate the stream private data and initialize the codec, but do not write the header.
 * May optionally be used before avformat_write_header() to initialize stream parameters
 * before actually writing the header.
 * If using this function, do not pass the same options to avformat_write_header().
 *
 * @param s        Media file handle, must be allocated with
 *                 avformat_alloc_context().
 *                 Its \ref AVFormatContext.oformat "oformat" field must be set
 *                 to the desired output format;
 *                 Its \ref AVFormatContext.pb "pb" field must be set to an
 *                 already opened ::AVIOContext.
 * @param options  An ::AVDictionary filled with AVFormatContext and
 *                 muxer-private options.
 *                 On return this parameter will be destroyed and replaced with
 *                 a dict containing options that were not found. May be NULL.
 *
 * \retval AVSTREAM_INIT_IN_WRITE_HEADER On success, if the codec requires
 *                                       avformat_write_header to fully initialize.
 * \retval AVSTREAM_INIT_IN_INIT_OUTPUT  On success, if the codec has been fully
 *                                       initialized.
 * \retval AVERROR                       Anegative AVERROR on failure.
 *
 * @see av_opt_find, av_dict_set, avio_open, av_oformat_next, avformat_write_header.
 */
@NoException public static native int avformat_init_output(AVFormatContext s, @Cast("AVDictionary**") PointerPointer options);
@NoException public static native int avformat_init_output(AVFormatContext s, @ByPtrPtr AVDictionary options);

/**
 * Write a packet to an output media file.
 *
 * This function passes the packet directly to the muxer, without any buffering
 * or reordering. The caller is responsible for correctly interleaving the
 * packets if the format requires it. Callers that want libavformat to handle
 * the interleaving should call av_interleaved_write_frame() instead of this
 * function.
 *
 * @param s media file handle
 * @param pkt The packet containing the data to be written. Note that unlike
 *            av_interleaved_write_frame(), this function does not take
 *            ownership of the packet passed to it (though some muxers may make
 *            an internal reference to the input packet).
 *            <br>
 *            This parameter can be NULL (at any time, not just at the end), in
 *            order to immediately flush data buffered within the muxer, for
 *            muxers that buffer up data internally before writing it to the
 *            output.
 *            <br>
 *            Packet's \ref AVPacket.stream_index "stream_index" field must be
 *            set to the index of the corresponding stream in \ref
 *            AVFormatContext.streams "s->streams".
 *            <br>
 *            The timestamps (\ref AVPacket.pts "pts", \ref AVPacket.dts "dts")
 *            must be set to correct values in the stream's timebase (unless the
 *            output format is flagged with the AVFMT_NOTIMESTAMPS flag, then
 *            they can be set to AV_NOPTS_VALUE).
 *            The dts for subsequent packets passed to this function must be strictly
 *            increasing when compared in their respective timebases (unless the
 *            output format is flagged with the AVFMT_TS_NONSTRICT, then they
 *            merely have to be nondecreasing).  \ref AVPacket.duration
 *            "duration") should also be set if known.
 * @return < 0 on error, = 0 if OK, 1 if flushed and there is no more data to flush
 *
 * @see av_interleaved_write_frame()
 */
@NoException public static native int av_write_frame(AVFormatContext s, AVPacket pkt);

/**
 * Write a packet to an output media file ensuring correct interleaving.
 *
 * This function will buffer the packets internally as needed to make sure the
 * packets in the output file are properly interleaved, usually ordered by
 * increasing dts. Callers doing their own interleaving should call
 * av_write_frame() instead of this function.
 *
 * Using this function instead of av_write_frame() can give muxers advance
 * knowledge of future packets, improving e.g. the behaviour of the mp4
 * muxer for VFR content in fragmenting mode.
 *
 * @param s media file handle
 * @param pkt The packet containing the data to be written.
 *            <br>
 *            If the packet is reference-counted, this function will take
 *            ownership of this reference and unreference it later when it sees
 *            fit. If the packet is not reference-counted, libavformat will
 *            make a copy.
 *            The returned packet will be blank (as if returned from
 *            av_packet_alloc()), even on error.
 *            <br>
 *            This parameter can be NULL (at any time, not just at the end), to
 *            flush the interleaving queues.
 *            <br>
 *            Packet's \ref AVPacket.stream_index "stream_index" field must be
 *            set to the index of the corresponding stream in \ref
 *            AVFormatContext.streams "s->streams".
 *            <br>
 *            The timestamps (\ref AVPacket.pts "pts", \ref AVPacket.dts "dts")
 *            must be set to correct values in the stream's timebase (unless the
 *            output format is flagged with the AVFMT_NOTIMESTAMPS flag, then
 *            they can be set to AV_NOPTS_VALUE).
 *            The dts for subsequent packets in one stream must be strictly
 *            increasing (unless the output format is flagged with the
 *            AVFMT_TS_NONSTRICT, then they merely have to be nondecreasing).
 *            \ref AVPacket.duration "duration" should also be set if known.
 *
 * @return 0 on success, a negative AVERROR on error.
 *
 * @see av_write_frame(), AVFormatContext.max_interleave_delta
 */
@NoException public static native int av_interleaved_write_frame(AVFormatContext s, AVPacket pkt);

/**
 * Write an uncoded frame to an output media file.
 *
 * The frame must be correctly interleaved according to the container
 * specification; if not, av_interleaved_write_uncoded_frame() must be used.
 *
 * See av_interleaved_write_uncoded_frame() for details.
 */
@NoException public static native int av_write_uncoded_frame(AVFormatContext s, int stream_index,
                           AVFrame frame);

/**
 * Write an uncoded frame to an output media file.
 *
 * If the muxer supports it, this function makes it possible to write an AVFrame
 * structure directly, without encoding it into a packet.
 * It is mostly useful for devices and similar special muxers that use raw
 * video or PCM data and will not serialize it into a byte stream.
 *
 * To test whether it is possible to use it with a given muxer and stream,
 * use av_write_uncoded_frame_query().
 *
 * The caller gives up ownership of the frame and must not access it
 * afterwards.
 *
 * @return  >=0 for success, a negative code on error
 */
@NoException public static native int av_interleaved_write_uncoded_frame(AVFormatContext s, int stream_index,
                                       AVFrame frame);

/**
 * Test whether a muxer supports uncoded frame.
 *
 * @return  >=0 if an uncoded frame can be written to that muxer and stream,
 *          <0 if not
 */
@NoException public static native int av_write_uncoded_frame_query(AVFormatContext s, int stream_index);

/**
 * Write the stream trailer to an output media file and free the
 * file private data.
 *
 * May only be called after a successful call to avformat_write_header.
 *
 * @param s media file handle
 * @return 0 if OK, AVERROR_xxx on error
 */
@NoException public static native int av_write_trailer(AVFormatContext s);

/**
 * Return the output format in the list of registered output formats
 * which best matches the provided parameters, or return NULL if
 * there is no match.
 *
 * @param short_name if non-NULL checks if short_name matches with the
 *                   names of the registered formats
 * @param filename   if non-NULL checks if filename terminates with the
 *                   extensions of the registered formats
 * @param mime_type  if non-NULL checks if mime_type matches with the
 *                   MIME type of the registered formats
 */
@NoException public static native @Const AVOutputFormat av_guess_format(@Cast("const char*") BytePointer short_name,
                                      @Cast("const char*") BytePointer filename,
                                      @Cast("const char*") BytePointer mime_type);
@NoException public static native @Const AVOutputFormat av_guess_format(String short_name,
                                      String filename,
                                      String mime_type);

/**
 * Guess the codec ID based upon muxer and filename.
 */
@NoException public static native @Cast("AVCodecID") int av_guess_codec(@Const AVOutputFormat fmt, @Cast("const char*") BytePointer short_name,
                              @Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer mime_type,
                              @Cast("AVMediaType") int type);
@NoException public static native @Cast("AVCodecID") int av_guess_codec(@Const AVOutputFormat fmt, String short_name,
                              String filename, String mime_type,
                              @Cast("AVMediaType") int type);

/**
 * Get timing information for the data currently output.
 * The exact meaning of "currently output" depends on the format.
 * It is mostly relevant for devices that have an internal buffer and/or
 * work in real time.
 * @param s          media file handle
 * @param stream     stream in the media file
 * @param dts [out]   DTS of the last packet output for the stream, in stream
 *                   time_base units
 * @param wall [out]  absolute time when that packet whas output,
 *                   in microsecond
 * \retval  0               Success
 * \retval  AVERROR(ENOSYS) The format does not support it
 *
 * \note Some formats or devices may not allow to measure dts and wall
 *       atomically.
 */
@NoException public static native int av_get_output_timestamp(AVFormatContext s, int stream,
                            @Cast("int64_t*") LongPointer dts, @Cast("int64_t*") LongPointer wall);
@NoException public static native int av_get_output_timestamp(AVFormatContext s, int stream,
                            @Cast("int64_t*") LongBuffer dts, @Cast("int64_t*") LongBuffer wall);
@NoException public static native int av_get_output_timestamp(AVFormatContext s, int stream,
                            @Cast("int64_t*") long[] dts, @Cast("int64_t*") long[] wall);


/**
 * \}
 */


/**
 * \defgroup lavf_misc Utility functions
 * \ingroup libavf
 * \{
 *
 * Miscellaneous utility functions related to both muxing and demuxing
 * (or neither).
 */

/**
 * Send a nice hexadecimal dump of a buffer to the specified file stream.
 *
 * @param f The file stream pointer where the dump should be sent to.
 * @param buf buffer
 * @param size buffer size
 *
 * @see av_hex_dump_log, av_pkt_dump2, av_pkt_dump_log2
 */
@NoException public static native void av_hex_dump(@Cast("FILE*") Pointer f, @Cast("const uint8_t*") BytePointer buf, int size);
@NoException public static native void av_hex_dump(@Cast("FILE*") Pointer f, @Cast("const uint8_t*") ByteBuffer buf, int size);
@NoException public static native void av_hex_dump(@Cast("FILE*") Pointer f, @Cast("const uint8_t*") byte[] buf, int size);

/**
 * Send a nice hexadecimal dump of a buffer to the log.
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 * pointer to an AVClass struct.
 * @param level The importance level of the message, lower values signifying
 * higher importance.
 * @param buf buffer
 * @param size buffer size
 *
 * @see av_hex_dump, av_pkt_dump2, av_pkt_dump_log2
 */
@NoException public static native void av_hex_dump_log(Pointer avcl, int level, @Cast("const uint8_t*") BytePointer buf, int size);
@NoException public static native void av_hex_dump_log(Pointer avcl, int level, @Cast("const uint8_t*") ByteBuffer buf, int size);
@NoException public static native void av_hex_dump_log(Pointer avcl, int level, @Cast("const uint8_t*") byte[] buf, int size);

/**
 * Send a nice dump of a packet to the specified file stream.
 *
 * @param f The file stream pointer where the dump should be sent to.
 * @param pkt packet to dump
 * @param dump_payload True if the payload must be displayed, too.
 * @param st AVStream that the packet belongs to
 */
@NoException public static native void av_pkt_dump2(@Cast("FILE*") Pointer f, @Const AVPacket pkt, int dump_payload, @Const AVStream st);


/**
 * Send a nice dump of a packet to the log.
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 * pointer to an AVClass struct.
 * @param level The importance level of the message, lower values signifying
 * higher importance.
 * @param pkt packet to dump
 * @param dump_payload True if the payload must be displayed, too.
 * @param st AVStream that the packet belongs to
 */
@NoException public static native void av_pkt_dump_log2(Pointer avcl, int level, @Const AVPacket pkt, int dump_payload,
                      @Const AVStream st);

/**
 * Get the AVCodecID for the given codec tag tag.
 * If no codec id is found returns AV_CODEC_ID_NONE.
 *
 * @param tags list of supported codec_id-codec_tag pairs, as stored
 * in AVInputFormat.codec_tag and AVOutputFormat.codec_tag
 * @param tag  codec tag to match to a codec ID
 */
@NoException public static native @Cast("AVCodecID") int av_codec_get_id(@Cast("const AVCodecTag*const*") PointerPointer tags, @Cast("unsigned int") int tag);
@NoException public static native @Cast("AVCodecID") int av_codec_get_id(@Const @ByPtrPtr AVCodecTag tags, @Cast("unsigned int") int tag);

/**
 * Get the codec tag for the given codec id id.
 * If no codec tag is found returns 0.
 *
 * @param tags list of supported codec_id-codec_tag pairs, as stored
 * in AVInputFormat.codec_tag and AVOutputFormat.codec_tag
 * @param id   codec ID to match to a codec tag
 */
@NoException public static native @Cast("unsigned int") int av_codec_get_tag(@Cast("const AVCodecTag*const*") PointerPointer tags, @Cast("AVCodecID") int id);
@NoException public static native @Cast("unsigned int") int av_codec_get_tag(@Const @ByPtrPtr AVCodecTag tags, @Cast("AVCodecID") int id);

/**
 * Get the codec tag for the given codec id.
 *
 * @param tags list of supported codec_id - codec_tag pairs, as stored
 * in AVInputFormat.codec_tag and AVOutputFormat.codec_tag
 * @param id codec id that should be searched for in the list
 * @param tag A pointer to the found tag
 * @return 0 if id was not found in tags, > 0 if it was found
 */
@NoException public static native int av_codec_get_tag2(@Cast("const AVCodecTag*const*") PointerPointer tags, @Cast("AVCodecID") int id,
                      @Cast("unsigned int*") IntPointer tag);
@NoException public static native int av_codec_get_tag2(@Const @ByPtrPtr AVCodecTag tags, @Cast("AVCodecID") int id,
                      @Cast("unsigned int*") IntPointer tag);
@NoException public static native int av_codec_get_tag2(@Const @ByPtrPtr AVCodecTag tags, @Cast("AVCodecID") int id,
                      @Cast("unsigned int*") IntBuffer tag);
@NoException public static native int av_codec_get_tag2(@Const @ByPtrPtr AVCodecTag tags, @Cast("AVCodecID") int id,
                      @Cast("unsigned int*") int[] tag);

@NoException public static native int av_find_default_stream_index(AVFormatContext s);

/**
 * Get the index for a specific timestamp.
 *
 * @param st        stream that the timestamp belongs to
 * @param timestamp timestamp to retrieve the index for
 * @param flags if AVSEEK_FLAG_BACKWARD then the returned index will correspond
 *                 to the timestamp which is <= the requested one, if backward
 *                 is 0, then it will be >=
 *              if AVSEEK_FLAG_ANY seek to any frame, only keyframes otherwise
 * @return < 0 if no such timestamp could be found
 */
@NoException public static native int av_index_search_timestamp(AVStream st, @Cast("int64_t") long timestamp, int flags);

/**
 * Get the index entry count for the given AVStream.
 *
 * @param st stream
 * @return the number of index entries in the stream
 */
@NoException public static native int avformat_index_get_entries_count(@Const AVStream st);

/**
 * Get the AVIndexEntry corresponding to the given index.
 *
 * @param st          Stream containing the requested AVIndexEntry.
 * @param idx         The desired index.
 * @return A pointer to the requested AVIndexEntry if it exists, NULL otherwise.
 *
 * \note The pointer returned by this function is only guaranteed to be valid
 *       until any function that takes the stream or the parent AVFormatContext
 *       as input argument is called.
 */
@NoException public static native @Const AVIndexEntry avformat_index_get_entry(AVStream st, int idx);

/**
 * Get the AVIndexEntry corresponding to the given timestamp.
 *
 * @param st          Stream containing the requested AVIndexEntry.
 * @param wanted_timestamp   Timestamp to retrieve the index entry for.
 * @param flags       If AVSEEK_FLAG_BACKWARD then the returned entry will correspond
 *                    to the timestamp which is <= the requested one, if backward
 *                    is 0, then it will be >=
 *                    if AVSEEK_FLAG_ANY seek to any frame, only keyframes otherwise.
 * @return A pointer to the requested AVIndexEntry if it exists, NULL otherwise.
 *
 * \note The pointer returned by this function is only guaranteed to be valid
 *       until any function that takes the stream or the parent AVFormatContext
 *       as input argument is called.
 */
@NoException public static native @Const AVIndexEntry avformat_index_get_entry_from_timestamp(AVStream st,
                                                            @Cast("int64_t") long wanted_timestamp,
                                                            int flags);
/**
 * Add an index entry into a sorted list. Update the entry if the list
 * already contains it.
 *
 * @param timestamp timestamp in the time base of the given stream
 */
@NoException public static native int av_add_index_entry(AVStream st, @Cast("int64_t") long pos, @Cast("int64_t") long timestamp,
                       int size, int distance, int flags);


/**
 * Split a URL string into components.
 *
 * The pointers to buffers for storing individual components may be null,
 * in order to ignore that component. Buffers for components not found are
 * set to empty strings. If the port is not found, it is set to a negative
 * value.
 *
 * @param proto the buffer for the protocol
 * @param proto_size the size of the proto buffer
 * @param authorization the buffer for the authorization
 * @param authorization_size the size of the authorization buffer
 * @param hostname the buffer for the host name
 * @param hostname_size the size of the hostname buffer
 * @param port_ptr a pointer to store the port number in
 * @param path the buffer for the path
 * @param path_size the size of the path buffer
 * @param url the URL to split
 */
@NoException public static native void av_url_split(@Cast("char*") BytePointer proto,         int proto_size,
                  @Cast("char*") BytePointer authorization, int authorization_size,
                  @Cast("char*") BytePointer hostname,      int hostname_size,
                  IntPointer port_ptr,
                  @Cast("char*") BytePointer path,          int path_size,
                  @Cast("const char*") BytePointer url);
@NoException public static native void av_url_split(@Cast("char*") ByteBuffer proto,         int proto_size,
                  @Cast("char*") ByteBuffer authorization, int authorization_size,
                  @Cast("char*") ByteBuffer hostname,      int hostname_size,
                  IntBuffer port_ptr,
                  @Cast("char*") ByteBuffer path,          int path_size,
                  String url);
@NoException public static native void av_url_split(@Cast("char*") byte[] proto,         int proto_size,
                  @Cast("char*") byte[] authorization, int authorization_size,
                  @Cast("char*") byte[] hostname,      int hostname_size,
                  int[] port_ptr,
                  @Cast("char*") byte[] path,          int path_size,
                  @Cast("const char*") BytePointer url);
@NoException public static native void av_url_split(@Cast("char*") BytePointer proto,         int proto_size,
                  @Cast("char*") BytePointer authorization, int authorization_size,
                  @Cast("char*") BytePointer hostname,      int hostname_size,
                  IntPointer port_ptr,
                  @Cast("char*") BytePointer path,          int path_size,
                  String url);
@NoException public static native void av_url_split(@Cast("char*") ByteBuffer proto,         int proto_size,
                  @Cast("char*") ByteBuffer authorization, int authorization_size,
                  @Cast("char*") ByteBuffer hostname,      int hostname_size,
                  IntBuffer port_ptr,
                  @Cast("char*") ByteBuffer path,          int path_size,
                  @Cast("const char*") BytePointer url);
@NoException public static native void av_url_split(@Cast("char*") byte[] proto,         int proto_size,
                  @Cast("char*") byte[] authorization, int authorization_size,
                  @Cast("char*") byte[] hostname,      int hostname_size,
                  int[] port_ptr,
                  @Cast("char*") byte[] path,          int path_size,
                  String url);


/**
 * Print detailed information about the input or output format, such as
 * duration, bitrate, streams, container, programs, metadata, side data,
 * codec and time base.
 *
 * @param ic        the context to analyze
 * @param index     index of the stream to dump information about
 * @param url       the URL to print, such as source or destination file
 * @param is_output Select whether the specified context is an input(0) or output(1)
 */
@NoException public static native void av_dump_format(AVFormatContext ic,
                    int index,
                    @Cast("const char*") BytePointer url,
                    int is_output);
@NoException public static native void av_dump_format(AVFormatContext ic,
                    int index,
                    String url,
                    int is_output);


/** Allow multiple %d */
public static final int AV_FRAME_FILENAME_FLAGS_MULTIPLE = 1;

/**
 * Return in 'buf' the path with '%d' replaced by a number.
 *
 * Also handles the '%0nd' format where 'n' is the total number
 * of digits and '%%'.
 *
 * @param buf destination buffer
 * @param buf_size destination buffer size
 * @param path numbered sequence string
 * @param number frame number
 * @param flags AV_FRAME_FILENAME_FLAGS_*
 * @return 0 if OK, -1 on format error
 */
@NoException public static native int av_get_frame_filename2(@Cast("char*") BytePointer buf, int buf_size,
                          @Cast("const char*") BytePointer path, int number, int flags);
@NoException public static native int av_get_frame_filename2(@Cast("char*") ByteBuffer buf, int buf_size,
                          String path, int number, int flags);
@NoException public static native int av_get_frame_filename2(@Cast("char*") byte[] buf, int buf_size,
                          @Cast("const char*") BytePointer path, int number, int flags);
@NoException public static native int av_get_frame_filename2(@Cast("char*") BytePointer buf, int buf_size,
                          String path, int number, int flags);
@NoException public static native int av_get_frame_filename2(@Cast("char*") ByteBuffer buf, int buf_size,
                          @Cast("const char*") BytePointer path, int number, int flags);
@NoException public static native int av_get_frame_filename2(@Cast("char*") byte[] buf, int buf_size,
                          String path, int number, int flags);

@NoException public static native int av_get_frame_filename(@Cast("char*") BytePointer buf, int buf_size,
                          @Cast("const char*") BytePointer path, int number);
@NoException public static native int av_get_frame_filename(@Cast("char*") ByteBuffer buf, int buf_size,
                          String path, int number);
@NoException public static native int av_get_frame_filename(@Cast("char*") byte[] buf, int buf_size,
                          @Cast("const char*") BytePointer path, int number);
@NoException public static native int av_get_frame_filename(@Cast("char*") BytePointer buf, int buf_size,
                          String path, int number);
@NoException public static native int av_get_frame_filename(@Cast("char*") ByteBuffer buf, int buf_size,
                          @Cast("const char*") BytePointer path, int number);
@NoException public static native int av_get_frame_filename(@Cast("char*") byte[] buf, int buf_size,
                          String path, int number);

/**
 * Check whether filename actually is a numbered sequence generator.
 *
 * @param filename possible numbered sequence string
 * @return 1 if a valid numbered sequence string, 0 otherwise
 */
@NoException public static native int av_filename_number_test(@Cast("const char*") BytePointer filename);
@NoException public static native int av_filename_number_test(String filename);

/**
 * Generate an SDP for an RTP session.
 *
 * Note, this overwrites the id values of AVStreams in the muxer contexts
 * for getting unique dynamic payload types.
 *
 * @param ac array of AVFormatContexts describing the RTP streams. If the
 *           array is composed by only one context, such context can contain
 *           multiple AVStreams (one AVStream per RTP stream). Otherwise,
 *           all the contexts in the array (an AVCodecContext per RTP stream)
 *           must contain only one AVStream.
 * @param n_files number of AVCodecContexts contained in ac
 * @param buf buffer where the SDP will be stored (must be allocated by
 *            the caller)
 * @param size the size of the buffer
 * @return 0 if OK, AVERROR_xxx on error
 */
@NoException public static native int av_sdp_create(@Cast("AVFormatContext**") PointerPointer ac, int n_files, @Cast("char*") BytePointer buf, int size);
@NoException public static native int av_sdp_create(@ByPtrPtr AVFormatContext ac, int n_files, @Cast("char*") BytePointer buf, int size);
@NoException public static native int av_sdp_create(@ByPtrPtr AVFormatContext ac, int n_files, @Cast("char*") ByteBuffer buf, int size);
@NoException public static native int av_sdp_create(@ByPtrPtr AVFormatContext ac, int n_files, @Cast("char*") byte[] buf, int size);

/**
 * Return a positive value if the given filename has one of the given
 * extensions, 0 otherwise.
 *
 * @param filename   file name to check against the given extensions
 * @param extensions a comma-separated list of filename extensions
 */
@NoException public static native int av_match_ext(@Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer extensions);
@NoException public static native int av_match_ext(String filename, String extensions);

/**
 * Test if the given container can store a codec.
 *
 * @param ofmt           container to check for compatibility
 * @param codec_id       codec to potentially store in container
 * @param std_compliance standards compliance level, one of FF_COMPLIANCE_*
 *
 * @return 1 if codec with ID codec_id can be stored in ofmt, 0 if it cannot.
 *         A negative number if this information is not available.
 */
@NoException public static native int avformat_query_codec(@Const AVOutputFormat ofmt, @Cast("AVCodecID") int codec_id,
                         int std_compliance);

/**
 * \defgroup riff_fourcc RIFF FourCCs
 * \{
 * Get the tables mapping RIFF FourCCs to libavcodec AVCodecIDs. The tables are
 * meant to be passed to av_codec_get_id()/av_codec_get_tag() as in the
 * following code:
 * <pre>{@code
 * uint32_t tag = MKTAG('H', '2', '6', '4');
 * const struct AVCodecTag *table[] = { avformat_get_riff_video_tags(), 0 };
 * enum AVCodecID id = av_codec_get_id(table, tag);
 * }</pre>
 */
/**
 * @return the table mapping RIFF FourCCs for video to libavcodec AVCodecID.
 */
@NoException public static native @Const AVCodecTag avformat_get_riff_video_tags();
/**
 * @return the table mapping RIFF FourCCs for audio to AVCodecID.
 */
@NoException public static native @Const AVCodecTag avformat_get_riff_audio_tags();
/**
 * @return the table mapping MOV FourCCs for video to libavcodec AVCodecID.
 */
@NoException public static native @Const AVCodecTag avformat_get_mov_video_tags();
/**
 * @return the table mapping MOV FourCCs for audio to AVCodecID.
 */
@NoException public static native @Const AVCodecTag avformat_get_mov_audio_tags();

/**
 * \}
 */

/**
 * Guess the sample aspect ratio of a frame, based on both the stream and the
 * frame aspect ratio.
 *
 * Since the frame aspect ratio is set by the codec but the stream aspect ratio
 * is set by the demuxer, these two may not be equal. This function tries to
 * return the value that you should use if you would like to display the frame.
 *
 * Basic logic is to use the stream aspect ratio if it is set to something sane
 * otherwise use the frame aspect ratio. This way a container setting, which is
 * usually easy to modify can override the coded value in the frames.
 *
 * @param format the format context which the stream is part of
 * @param stream the stream which the frame is part of
 * @param frame the frame with the aspect ratio to be determined
 * @return the guessed (valid) sample_aspect_ratio, 0/1 if no idea
 */
@NoException public static native @ByVal AVRational av_guess_sample_aspect_ratio(AVFormatContext format, AVStream stream, AVFrame frame);

/**
 * Guess the frame rate, based on both the container and codec information.
 *
 * @param ctx the format context which the stream is part of
 * @param stream the stream which the frame is part of
 * @param frame the frame for which the frame rate should be determined, may be NULL
 * @return the guessed (valid) frame rate, 0/1 if no idea
 */
@NoException public static native @ByVal AVRational av_guess_frame_rate(AVFormatContext ctx, AVStream stream, AVFrame frame);

/**
 * Check if the stream st contained in s is matched by the stream specifier
 * spec.
 *
 * See the "stream specifiers" chapter in the documentation for the syntax
 * of spec.
 *
 * @return  >0 if st is matched by spec;
 *          0  if st is not matched by spec;
 *          AVERROR code if spec is invalid
 *
 * \note  A stream specifier can match several streams in the format.
 */
@NoException public static native int avformat_match_stream_specifier(AVFormatContext s, AVStream st,
                                    @Cast("const char*") BytePointer spec);
@NoException public static native int avformat_match_stream_specifier(AVFormatContext s, AVStream st,
                                    String spec);

@NoException public static native int avformat_queue_attached_pictures(AVFormatContext s);

/** enum AVTimebaseSource */
public static final int
    AVFMT_TBCF_AUTO = -1,
    AVFMT_TBCF_DECODER = 0,
    AVFMT_TBCF_DEMUXER = 1,
// #if FF_API_R_FRAME_RATE
    AVFMT_TBCF_R_FRAMERATE = 2;
// #endif

/**
 * Transfer internal timing information from one stream to another.
 *
 * This function is useful when doing stream copy.
 *
 * @param ofmt     target output format for ost
 * @param ost      output stream which needs timings copy and adjustments
 * @param ist      reference input stream to copy timings from
 * @param copy_tb  define from where the stream codec timebase needs to be imported
 */
@NoException public static native int avformat_transfer_internal_stream_timing_info(@Const AVOutputFormat ofmt,
                                                  AVStream ost, @Const AVStream ist,
                                                  @Cast("AVTimebaseSource") int copy_tb);

/**
 * Get the internal codec timebase from a stream.
 *
 * @param st  input stream to extract the timebase from
 */
@NoException public static native @ByVal AVRational av_stream_get_codec_timebase(@Const AVStream st);

/**
 * \}
 */

// #endif /* AVFORMAT_AVFORMAT_H */


// Parsed from <libavformat/version_major.h>

/*
 * Version macros.
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVFORMAT_VERSION_MAJOR_H
// #define AVFORMAT_VERSION_MAJOR_H

/**
 * \file
 * \ingroup libavf
 * Libavformat version macros
 */

// Major bumping may affect Ticket5467, 5421, 5451(compatibility with Chromium)
// Also please add any ticket numbers that you believe might be affected here
public static final int LIBAVFORMAT_VERSION_MAJOR =  60;

/**
 * FF_API_* defines may be placed below to indicate public API that will be
 * dropped at a future version bump. The defines themselves are not part of
 * the public API and may change, break or disappear at any time.
 *
 * \note, when bumping the major version it is recommended to manually
 * disable each FF_API_* in its own commit instead of disabling them all
 * at once through the bump. This improves the git bisect-ability of the change.
 *
 */
public static final boolean FF_API_COMPUTE_PKT_FIELDS2 =      (LIBAVFORMAT_VERSION_MAJOR < 61);
public static final boolean FF_API_GET_END_PTS =              (LIBAVFORMAT_VERSION_MAJOR < 61);
public static final boolean FF_API_AVIODIRCONTEXT =           (LIBAVFORMAT_VERSION_MAJOR < 61);
public static final boolean FF_API_AVFORMAT_IO_CLOSE =        (LIBAVFORMAT_VERSION_MAJOR < 61);


public static final int FF_API_R_FRAME_RATE =            1;

// #endif /* AVFORMAT_VERSION_MAJOR_H */


// Parsed from <libavformat/version.h>

/*
 * Version macros.
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

// #ifndef AVFORMAT_VERSION_H
// #define AVFORMAT_VERSION_H

/**
 * \file
 * \ingroup libavf
 * Libavformat version macros
 */

// #include "libavutil/version.h"

// #include "version_major.h"

public static final int LIBAVFORMAT_VERSION_MINOR =   3;
public static final int LIBAVFORMAT_VERSION_MICRO = 100;

public static native @MemberGetter int LIBAVFORMAT_VERSION_INT();
public static final int LIBAVFORMAT_VERSION_INT = LIBAVFORMAT_VERSION_INT();
// #define LIBAVFORMAT_VERSION     AV_VERSION(LIBAVFORMAT_VERSION_MAJOR,
//                                            LIBAVFORMAT_VERSION_MINOR,
//                                            LIBAVFORMAT_VERSION_MICRO)
public static final int LIBAVFORMAT_BUILD =       LIBAVFORMAT_VERSION_INT;

public static native @MemberGetter String LIBAVFORMAT_IDENT();
public static final String LIBAVFORMAT_IDENT = LIBAVFORMAT_IDENT();

// #endif /* AVFORMAT_VERSION_H */


}
