// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.librealsense;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.librealsense.global.RealSense.*;

    /** \brief Provides convenience methods relating to devices */
    @Namespace("rs") @Properties(inherit = org.bytedeco.librealsense.presets.RealSense.class)
public class device extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public device(Pointer p) { super(p); }
    
        /** \brief Retrieves human-readable device model string
         *  @return  Model string, such as "Intel RealSense F200" or "Intel RealSense R200" */
        public native @Cast("const char*") BytePointer get_name();

        /** \brief Retrieves unique serial number of device
         *  @return  Serial number, in a format specific to the device model */
        public native @Cast("const char*") BytePointer get_serial();

        /** \brief Retrieves USB port number of device
         *  @return  USB port number, in a format that is specific to device model */
        public native @Cast("const char*") BytePointer get_usb_port_id();

        /** \brief Retrieves version of firmware currently installed on device
         *  @return  Firmware version string, in a format that is specific to device model */
        public native @Cast("const char*") BytePointer get_firmware_version();

        /** \brief Retrieves camera-specific information such as versions of various components
         *  @return  Camera info string, in a format that is specific to device model */
        public native @Cast("const char*") BytePointer get_info(@Cast("rs::camera_info") int info);

        /** \brief Retrieves extrinsic transformation between viewpoints of two different streams
         *  @param from_stream [in]  Stream whose coordinate space to transform from
         *  @param to_stream [in]    Stream whose coordinate space to transform to
         *  @return                 Transformation between two streams */
        public native @ByVal extrinsics get_extrinsics(@Cast("rs::stream") int from_stream, @Cast("rs::stream") int to_stream);

        /** \brief Retrieves extrinsic transformation between viewpoints of specific stream and motion module
         *  @param from_stream [in]  Stream whose coordinate space to transform from
         *  @return                 Transformation between specific stream and motion module */
        public native @ByVal extrinsics get_motion_extrinsics_from(@Cast("rs::stream") int from_stream);

        /** \brief Retrieves mapping between units of depth image and meters
         *  @return  Depth in meters corresponding to a depth value of 1 */
        public native float get_depth_scale();

        /** \brief Determines if device allows specific option to be queried and set
         *  @param option [in]  Option to check
         *  @return            true if the option can be queried and set */
        public native @Cast("bool") boolean supports_option(@Cast("rs::option") int option);

        /** \brief Determines number of streaming modes available for given stream
         *  @param stream [in]  Stream whose modes will be enumerated
         *  @return            Count of available modes */
        public native int get_stream_mode_count(@Cast("rs::stream") int stream);

        /** \brief Determines properties of specific streaming mode
         *  @param stream [in]      Stream whose mode will be queried
         *  @param index [in]       Zero-based index of streaming mode
         *  @param width [out]      Width of a frame image in pixels
         *  @param height [out]     Height of a frame image in pixels
         *  @param format [out]     Pixel format of a frame image
         *  @param framerate [out]  Number of frames that will be streamed per second */
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef IntPointer width, @ByRef IntPointer height, @Cast("rs::format*") @ByRef IntPointer format, @ByRef IntPointer framerate);
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef IntBuffer width, @ByRef IntBuffer height, @Cast("rs::format*") @ByRef IntBuffer format, @ByRef IntBuffer framerate);
        public native void get_stream_mode(@Cast("rs::stream") int stream, int index, @ByRef int[] width, @ByRef int[] height, @Cast("rs::format*") @ByRef int[] format, @ByRef int[] framerate);

        /** \brief Enables specific stream and requests specific properties
         *  @param stream [in]                   Stream
         *  @param width [in]                    Desired width of frame image in pixels, or 0 if any width is acceptable
         *  @param height [in]                   Desired height of frame image in pixels, or 0 if any height is acceptable
         *  @param format [in]                   Pixel format of frame image, or ANY if any format is acceptable
         *  @param framerate [in]                Number of frames that will be streamed per second, or 0 if any frame rate is acceptable
         *  @param output_buffer_type [in]       output buffer format (continous in memory / native with pitch) */
        public native void enable_stream(@Cast("rs::stream") int stream, int width, int height, @Cast("rs::format") int format, int framerate, @Cast("rs::output_buffer_format") int output_buffer_type/*=rs::output_buffer_format::continous*/);
        public native void enable_stream(@Cast("rs::stream") int stream, int width, int height, @Cast("rs::format") int format, int framerate);

        /** \brief Enables specific stream and requests properties using preset
         *  @param stream [in]  Stream to enable
         *  @param preset [in]  Preset to use to enable the stream */
        public native void enable_stream(@Cast("rs::stream") int stream, @Cast("rs::preset") int preset);

        /** \brief Disables specific stream
         *  @param stream [in]  Stream */
        public native void disable_stream(@Cast("rs::stream") int stream);

        /** \brief Determines if specific stream is enabled
         *  @param stream [in]  Stream to check
         *  @return            true if the stream is currently enabled */
        public native @Cast("bool") boolean is_stream_enabled(@Cast("rs::stream") int stream);

        /**  \brief Retrieves width, in pixels, of a specific stream, equivalent to the width field from the stream's intrinsic
         *  @param stream [in]  Stream 
         *  @return            Width, in pixels of images from this stream */
        public native int get_stream_width(@Cast("rs::stream") int stream);

        /** \brief Retrieves height, in pixels, of a specific stream, equivalent to the height field from the stream's intrinsic
         *  @param stream [in]  Stream
         *  @return            Height, in pixels of images from this stream */
        public native int get_stream_height(@Cast("rs::stream") int stream);

        /** \brief Retrieves pixel format for specific stream
         *  @param stream [in]  Stream
         *  @return            Pixel format of the stream */
        public native @Cast("rs::format") int get_stream_format(@Cast("rs::stream") int stream);

        /** \brief Retrieves frame rate for specific stream
         *  @param stream [in]  Stream
         *  @return            Frame rate of the stream, in frames per second */
        public native int get_stream_framerate(@Cast("rs::stream") int stream);

        /** \brief Retrieves intrinsic camera parameters for specific stream
         *  @param stream [in]  Stream
         *  @return            Intrinsic parameters of the stream */
        public native @ByVal intrinsics get_stream_intrinsics(@Cast("rs::stream") int stream);

        /** \brief Retrieves intrinsic camera parameters for motion module
         *  @return            Intrinsic parameters */
        public native @ByVal motion_intrinsics get_motion_intrinsics();

        /** \brief Sets callback for frame arrival event. 
		 *  
		 *  The provided callback will be called the instant new frame of given stream becomes available
         *  once callback is set on certain stream type, frames of this type will no longer be available throuhg wait/poll methods (those two approaches are mutually exclusive) 
         *  while wait/poll methods provide consistent set of syncronized frames at the expense of extra latency,
         *  set frame callbacks provides low latency solution with no syncronization
         *  @param stream [in]         Stream 
         *  @param frame_handler [in]  Frame callback to be invoked on every new frame
         *  @return                   Frame rate of the stream, in frames per second */
        
        ///
        public native void set_frame_callback(@Cast("rs::stream") int stream, @ByVal FrameFunction frame_handler);

        /**  \brief Sets callback for motion module event. 
		 *  
		 *   The provided callback will be called the instant new motion or timestamp event is available. 
         *   <b>Note</b>: 
         *  
         *   The \c rs_enable_motion_tracking_cpp() method is responsible for activating the motion module on-board the device. 
         *   One of the services it provides is to produce shared and high-resolution timestamps for all components that are connected to it. 
         *   For Depth, IR, Color and Fisheye sensors, librealsense takes care of that and copies the timestamps on the relevant frames.
         * 
         *   However, when you have an external device (such as a compass, magnetometer, light sensor, or other) and wish to synchronize it precisely with image and 
         *   motion streams, you can connect that sensor to a GPIO that is available on some devices. Every time the sensor signals, you 
         *   get a timestamp callback with a frame number, source ID, and a timestamp.
         *   This timestamp callback allows advanced users to synchronize compass events (presumably coming though I2C or some other method) with RealSense data.        
         <p>
         *  @param motion_handler [in]     Frame callback to be invoke on every new motion event
         *  @param timestamp_handler [in]  Frame callback to be invoke on every new timestamp event (can be left-out)
         *  @return                       Frame rate of the stream, in frames per second */
        
        ///
        public native void enable_motion_tracking(@ByVal MotionFunction motion_handler, @ByVal TimestampFunction timestamp_handler);

        /** \brief Sets the callback for motion module event. 
		 * 
		 *  The provided callback will be called the instant new motion event is available. 
         *  @param motion_handler [in]     Frame callback to be invokes on every new motion event
         *  @return                       Frame rate of the stream, in frames per second */
        public native void enable_motion_tracking(@ByVal MotionFunction motion_handler);

        /** \brief Disables events polling */
        public native void disable_motion_tracking();

        /** \brief Checks if data acquisition is active         */
        public native int is_motion_tracking_active();


        /** \brief Begins streaming on all enabled streams for this device */
        public native void start(@Cast("rs::source") byte source/*=rs::source::video*/);
        public native void start();

        /** \brief Ends streaming on all streams for this device */
        public native void stop(@Cast("rs::source") byte source/*=rs::source::video*/);
        public native void stop();

        /** \brief Determines if device is currently streaming
         *  @return  true if device is currently streaming */
        public native @Cast("bool") boolean is_streaming();

        /** \brief Retrieves available range of values of supported option
         *  @param option [in]  Option
         *  @param min [out]    Minimum value that is acceptable for this option
         *  @param max [out]    Maximum value that is acceptable for this option
         *  @param step [out]   Granularity of options that accept discrete values, or zero if the option accepts continuous values         */
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoublePointer min, @ByRef DoublePointer max, @ByRef DoublePointer step);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoubleBuffer min, @ByRef DoubleBuffer max, @ByRef DoubleBuffer step);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef double[] min, @ByRef double[] max, @ByRef double[] step);

        /** \brief Retrieves available range of values of supported option
         *  @param option [in]  Option
         *  @param min [out]    Minimum value that is acceptable for this option
         *  @param max [out]    Maximum value that is acceptable for this option
         *  @param step [out]   Granularity of options that accept discrete values, or zero if the option accepts continuous values
         *  @param def [out]    Default value of the option */
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoublePointer min, @ByRef DoublePointer max, @ByRef DoublePointer step, @ByRef DoublePointer def);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef DoubleBuffer min, @ByRef DoubleBuffer max, @ByRef DoubleBuffer step, @ByRef DoubleBuffer def);
        public native void get_option_range(@Cast("rs::option") int option, @ByRef double[] min, @ByRef double[] max, @ByRef double[] step, @ByRef double[] def);

        /** \brief Efficiently retrieves value of arbitrary number of options, using minimal hardware IO
         *  @param options [in]  Array of options that should be queried
         *  @param count [in]    Length of options and values arrays
         *  @param values [out]  Array that receives the values of the queried options */
        public native void get_options(@Cast("const rs::option*") IntPointer options, @Cast("size_t") long count, DoublePointer values);
        public native void get_options(@Cast("const rs::option*") IntBuffer options, @Cast("size_t") long count, DoubleBuffer values);
        public native void get_options(@Cast("const rs::option*") int[] options, @Cast("size_t") long count, double[] values);

        /** \brief Efficiently sets value of arbitrary number of options, using minimal hardware IO
         *  @param options [in]  Array of options that should be set
         *  @param count [in]    Length of options and values arrays
         *  @param values [in]   Array of values to which the options should be set */
        public native void set_options(@Cast("const rs::option*") IntPointer options, @Cast("size_t") long count, @Const DoublePointer values);
        public native void set_options(@Cast("const rs::option*") IntBuffer options, @Cast("size_t") long count, @Const DoubleBuffer values);
        public native void set_options(@Cast("const rs::option*") int[] options, @Cast("size_t") long count, @Const double[] values);

        /** \brief Retrieves current value of single option
         *  @param option [in]  Option
         *  @return            Option value */
        public native double get_option(@Cast("rs::option") int option);
        
        /** \brief Retrieves device-specific option description
         *  @param option [in]  Option
         *  @return            Option value */
        public native @Cast("const char*") BytePointer get_option_description(@Cast("rs::option") int option);

        /** \brief Sets current value of single option
         *  @param option [in]  Option
         *  @param value [in]   Option value */
        
        ///
        public native void set_option(@Cast("rs::option") int option, double value);

        /** \brief Blocks until new frames are available
         *  */
        public native void wait_for_frames();

        /** \brief Checks if new frames are available, without blocking
         *  @return  true if new frames are available; false if no new frames have arrived. */
        public native @Cast("bool") boolean poll_for_frames();

        /** \brief Determines device capabilities
         *  @param capability [in]  Capability to check
         *  @return                true if device has this capability */
        public native @Cast("bool") boolean supports(@Cast("rs::capabilities") int capability);


        /** \brief Determines device capabilities
         *  @param info_param [in]  Capability to check for support
         *  @return                true if device has this capability */

        /** \brief Retrieves time at which the latest frame on a stream was captured
         *  @param stream [in]  Stream of interest
         *  @return            Timestamp of frame, in milliseconds since the device was started */
        public native double get_frame_timestamp(@Cast("rs::stream") int stream);

        /** \brief Retrieves frame number
         *  @param stream [in]  Stream of interest
         *  @return            Number of frame since device was started */
        public native @Cast("unsigned long long") long get_frame_number(@Cast("rs::stream") int stream);

        /** \brief Retrieves contents of latest frame on a stream
         *  @param stream [in]  Stream
         *  @return            Pointer to start of frame data */
        public native @Const Pointer get_frame_data(@Cast("rs::stream") int stream);

        /** \brief Sends device-specific data to device
         *  @param type [in]  Type of raw data to send to the device
         *  @param data [in]  Raw data pointer to send
         *  @param size [in]  Size, in bytes of the raw data to send */
        public native void send_blob_to_device(@Cast("rs::blob_type") int type, Pointer data, int size);
    }
