// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_core;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.opencv.global.opencv_core.*;


/** \example samples/cpp/cout_mat.cpp
An example demonstrating the serial out capabilities of cv::Mat
*/

 /** \brief n-dimensional dense array class \anchor CVMat_Details
<p>
The class Mat represents an n-dimensional dense numerical single-channel or multi-channel array. It
can be used to store real or complex-valued vectors and matrices, grayscale or color images, voxel
volumes, vector fields, point clouds, tensors, histograms (though, very high-dimensional histograms
may be better stored in a SparseMat ). The data layout of the array {@code M} is defined by the array
{@code M.step[]}, so that the address of element {@code (i_0,...,i_{M.dims-1})}, where {@code 0\leq i_k<M.size[k]}, is
computed as:
<pre>{@code \[addr(M_{i_0,...,i_{M.dims-1}}) = M.data + M.step[0]*i_0 + M.step[1]*i_1 + ... + M.step[M.dims-1]*i_{M.dims-1}\]}</pre>
In case of a 2-dimensional array, the above formula is reduced to:
<pre>{@code \[addr(M_{i,j}) = M.data + M.step[0]*i + M.step[1]*j\]}</pre>
Note that {@code M.step[i] >= M.step[i+1]} (in fact, {@code M.step[i] >= M.step[i+1]*M.size[i+1]} ). This means
that 2-dimensional matrices are stored row-by-row, 3-dimensional matrices are stored plane-by-plane,
and so on. M.step[M.dims-1] is minimal and always equal to the element size M.elemSize() .
<p>
So, the data layout in Mat is compatible with the majority of dense array types from the standard
toolkits and SDKs, such as Numpy (ndarray), Win32 (independent device bitmaps), and others,
that is, with any array that uses *steps* (or *strides*) to compute the position of a pixel.
Due to this compatibility, it is possible to make a Mat header for user-allocated data and process
it in-place using OpenCV functions.
<p>
There are many different ways to create a Mat object. The most popular options are listed below:
<p>
- Use the create(nrows, ncols, type) method or the similar Mat(nrows, ncols, type[, fillValue])
constructor. A new array of the specified size and type is allocated. type has the same meaning as
in the cvCreateMat method. For example, CV_8UC1 means a 8-bit single-channel array, CV_32FC2
means a 2-channel (complex) floating-point array, and so on.
<pre>{@code
    // make a 7x7 complex matrix filled with 1+3j.
    Mat M(7,7,CV_32FC2,Scalar(1,3));
    // and now turn M to a 100x60 15-channel 8-bit matrix.
    // The old content will be deallocated
    M.create(100,60,CV_8UC(15));
}</pre>
As noted in the introduction to this chapter, create() allocates only a new array when the shape
or type of the current array are different from the specified ones.
<p>
- Create a multi-dimensional array:
<pre>{@code
    // create a 100x100x100 8-bit array
    int sz[] = {100, 100, 100};
    Mat bigCube(3, sz, CV_8U, Scalar::all(0));
}</pre>
It passes the number of dimensions =1 to the Mat constructor but the created array will be
2-dimensional with the number of columns set to 1. So, Mat::dims is always \>= 2 (can also be 0
when the array is empty).
<p>
- Use a copy constructor or assignment operator where there can be an array or expression on the
right side (see below). As noted in the introduction, the array assignment is an O(1) operation
because it only copies the header and increases the reference counter. The Mat::clone() method can
be used to get a full (deep) copy of the array when you need it.
<p>
- Construct a header for a part of another array. It can be a single row, single column, several
rows, several columns, rectangular region in the array (called a *minor* in algebra) or a
diagonal. Such operations are also O(1) because the new header references the same data. You can
actually modify a part of the array using this feature, for example:
<pre>{@code
    // add the 5-th row, multiplied by 3 to the 3rd row
    M.row(3) = M.row(3) + M.row(5)*3;
    // now copy the 7-th column to the 1-st column
    // M.col(1) = M.col(7); // this will not work
    Mat M1 = M.col(1);
    M.col(7).copyTo(M1);
    // create a new 320x240 image
    Mat img(Size(320,240),CV_8UC3);
    // select a ROI
    Mat roi(img, Rect(10,10,100,100));
    // fill the ROI with (0,255,0) (which is green in RGB space);
    // the original 320x240 image will be modified
    roi = Scalar(0,255,0);
}</pre>
Due to the additional datastart and dataend members, it is possible to compute a relative
sub-array position in the main *container* array using locateROI():
<pre>{@code
    Mat A = Mat::eye(10, 10, CV_32S);
    // extracts A columns, 1 (inclusive) to 3 (exclusive).
    Mat B = A(Range::all(), Range(1, 3));
    // extracts B rows, 5 (inclusive) to 9 (exclusive).
    // that is, C \~ A(Range(5, 9), Range(1, 3))
    Mat C = B(Range(5, 9), Range::all());
    Size size; Point ofs;
    C.locateROI(size, ofs);
    // size will be (width=10,height=10) and the ofs will be (x=1, y=5)
}</pre>
As in case of whole matrices, if you need a deep copy, use the {@code clone()} method of the extracted
sub-matrices.
<p>
- Make a header for user-allocated data. It can be useful to do the following:
    -# Process "foreign" data using OpenCV (for example, when you implement a DirectShow\* filter or
    a processing module for gstreamer, and so on). For example:
    <pre>{@code
        Mat process_video_frame(const unsigned char* pixels,
                                int width, int height, int step)
        {
            // wrap input buffer
            Mat img(height, width, CV_8UC3, (unsigned char*)pixels, step);

            Mat result;
            GaussianBlur(img, result, Size(7, 7), 1.5, 1.5);

            return result;
        }
    }</pre>
    -# Quickly initialize small matrices and/or get a super-fast element access.
    <pre>{@code
        double m[3][3] = {{a, b, c}, {d, e, f}, {g, h, i}};
        Mat M = Mat(3, 3, CV_64F, m).inv();
    }</pre>
    .
<p>
- Use MATLAB-style array initializers, zeros(), ones(), eye(), for example:
<pre>{@code
    // create a double-precision identity matrix and add it to M.
    M += Mat::eye(M.rows, M.cols, CV_64F);
}</pre>
<p>
- Use a comma-separated initializer:
<pre>{@code
    // create a 3x3 double-precision identity matrix
    Mat M = (Mat_<double>(3,3) << 1, 0, 0, 0, 1, 0, 0, 0, 1);
}</pre>
With this approach, you first call a constructor of the Mat class with the proper parameters, and
then you just put {@code << operator} followed by comma-separated values that can be constants,
variables, expressions, and so on. Also, note the extra parentheses required to avoid compilation
errors.
<p>
Once the array is created, it is automatically managed via a reference-counting mechanism. If the
array header is built on top of user-allocated data, you should handle the data by yourself. The
array data is deallocated when no one points to it. If you want to release the data pointed by a
array header before the array destructor is called, use Mat::release().
<p>
The next important thing to learn about the array class is element access. This manual already
described how to compute an address of each array element. Normally, you are not required to use the
formula directly in the code. If you know the array element type (which can be retrieved using the
method Mat::type() ), you can access the element {@code M_{ij}} of a 2-dimensional array as:
<pre>{@code
    M.at<double>(i,j) += 1.f;
}</pre>
assuming that {@code M} is a double-precision floating-point array. There are several variants of the method
at for a different number of dimensions.
<p>
If you need to process a whole row of a 2D array, the most efficient way is to get the pointer to
the row first, and then just use the plain C operator [] :
<pre>{@code
    // compute sum of positive matrix elements
    // (assuming that M is a double-precision matrix)
    double sum=0;
    for(int i = 0; i < M.rows; i++)
    {
        const double* Mi = M.ptr<double>(i);
        for(int j = 0; j < M.cols; j++)
            sum += std::max(Mi[j], 0.);
    }
}</pre>
Some operations, like the one above, do not actually depend on the array shape. They just process
elements of an array one by one (or elements from multiple arrays that have the same coordinates,
for example, array addition). Such operations are called *element-wise*. It makes sense to check
whether all the input/output arrays are continuous, namely, have no gaps at the end of each row. If
yes, process them as a long single row:
<pre>{@code
    // compute the sum of positive matrix elements, optimized variant
    double sum=0;
    int cols = M.cols, rows = M.rows;
    if(M.isContinuous())
    {
        cols *= rows;
        rows = 1;
    }
    for(int i = 0; i < rows; i++)
    {
        const double* Mi = M.ptr<double>(i);
        for(int j = 0; j < cols; j++)
            sum += std::max(Mi[j], 0.);
    }
}</pre>
In case of the continuous matrix, the outer loop body is executed just once. So, the overhead is
smaller, which is especially noticeable in case of small matrices.
<p>
Finally, there are STL-style iterators that are smart enough to skip gaps between successive rows:
<pre>{@code
    // compute sum of positive matrix elements, iterator-based variant
    double sum=0;
    MatConstIterator_<double> it = M.begin<double>(), it_end = M.end<double>();
    for(; it != it_end; ++it)
        sum += std::max(*it, 0.);
}</pre>
The matrix iterators are random-access iterators, so they can be passed to any STL algorithm,
including std::sort().
<p>
\note Matrix Expressions and arithmetic see MatExpr
*/
@Namespace("cv") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_core.class)
public class Mat extends AbstractMat {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Mat(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Mat(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Mat position(long position) {
        return (Mat)super.position(position);
    }
    @Override public Mat getPointer(long i) {
        return new Mat((Pointer)this).offsetAddress(i);
    }

    /**
    These are various constructors that form a matrix. As noted in the AutomaticAllocation, often
    the default constructor is enough, and the proper matrix will be allocated by an OpenCV function.
    The constructed matrix can further be assigned to another matrix or matrix expression or can be
    allocated with Mat::create . In the former case, the old content is de-referenced.
     */
    public Mat() { super((Pointer)null); allocate(); }
    @NoException private native void allocate();

    /** \overload
    @param rows Number of rows in a 2D array.
    @param cols Number of columns in a 2D array.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    */
    public Mat(int rows, int cols, int type) { super((Pointer)null); allocate(rows, cols, type); }
    private native void allocate(int rows, int cols, int type);

    /** \overload
    @param size 2D array size: Size(cols, rows) . In the Size() constructor, the number of rows and the
    number of columns go in the reverse order.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
      */
    public Mat(@ByVal Size size, int type) { super((Pointer)null); allocate(size, type); }
    private native void allocate(@ByVal Size size, int type);

    /** \overload
    @param rows Number of rows in a 2D array.
    @param cols Number of columns in a 2D array.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param s An optional value to initialize each matrix element with. To set all the matrix elements to
    the particular value after the construction, use the assignment operator
    Mat::operator=(const Scalar& value) .
    */
    public Mat(int rows, int cols, int type, @Const @ByRef Scalar s) { super((Pointer)null); allocate(rows, cols, type, s); }
    private native void allocate(int rows, int cols, int type, @Const @ByRef Scalar s);

    /** \overload
    @param size 2D array size: Size(cols, rows) . In the Size() constructor, the number of rows and the
    number of columns go in the reverse order.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param s An optional value to initialize each matrix element with. To set all the matrix elements to
    the particular value after the construction, use the assignment operator
    Mat::operator=(const Scalar& value) .
      */
    public Mat(@ByVal Size size, int type, @Const @ByRef Scalar s) { super((Pointer)null); allocate(size, type, s); }
    private native void allocate(@ByVal Size size, int type, @Const @ByRef Scalar s);

    /** \overload
    @param ndims Array dimensionality.
    @param sizes Array of integers specifying an n-dimensional array shape.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    */
    public Mat(int ndims, @Const IntPointer sizes, int type) { super((Pointer)null); allocate(ndims, sizes, type); }
    private native void allocate(int ndims, @Const IntPointer sizes, int type);
    public Mat(int ndims, @Const IntBuffer sizes, int type) { super((Pointer)null); allocate(ndims, sizes, type); }
    private native void allocate(int ndims, @Const IntBuffer sizes, int type);
    public Mat(int ndims, @Const int[] sizes, int type) { super((Pointer)null); allocate(ndims, sizes, type); }
    private native void allocate(int ndims, @Const int[] sizes, int type);

    /** \overload
    @param sizes Array of integers specifying an n-dimensional array shape.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    */
    public Mat(@StdVector IntPointer sizes, int type) { super((Pointer)null); allocate(sizes, type); }
    private native void allocate(@StdVector IntPointer sizes, int type);
    public Mat(@StdVector IntBuffer sizes, int type) { super((Pointer)null); allocate(sizes, type); }
    private native void allocate(@StdVector IntBuffer sizes, int type);
    public Mat(@StdVector int[] sizes, int type) { super((Pointer)null); allocate(sizes, type); }
    private native void allocate(@StdVector int[] sizes, int type);

    /** \overload
    @param ndims Array dimensionality.
    @param sizes Array of integers specifying an n-dimensional array shape.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param s An optional value to initialize each matrix element with. To set all the matrix elements to
    the particular value after the construction, use the assignment operator
    Mat::operator=(const Scalar& value) .
    */
    public Mat(int ndims, @Const IntPointer sizes, int type, @Const @ByRef Scalar s) { super((Pointer)null); allocate(ndims, sizes, type, s); }
    private native void allocate(int ndims, @Const IntPointer sizes, int type, @Const @ByRef Scalar s);
    public Mat(int ndims, @Const IntBuffer sizes, int type, @Const @ByRef Scalar s) { super((Pointer)null); allocate(ndims, sizes, type, s); }
    private native void allocate(int ndims, @Const IntBuffer sizes, int type, @Const @ByRef Scalar s);
    public Mat(int ndims, @Const int[] sizes, int type, @Const @ByRef Scalar s) { super((Pointer)null); allocate(ndims, sizes, type, s); }
    private native void allocate(int ndims, @Const int[] sizes, int type, @Const @ByRef Scalar s);

    /** \overload
    @param sizes Array of integers specifying an n-dimensional array shape.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param s An optional value to initialize each matrix element with. To set all the matrix elements to
    the particular value after the construction, use the assignment operator
    Mat::operator=(const Scalar& value) .
    */
    public Mat(@StdVector IntPointer sizes, int type, @Const @ByRef Scalar s) { super((Pointer)null); allocate(sizes, type, s); }
    private native void allocate(@StdVector IntPointer sizes, int type, @Const @ByRef Scalar s);
    public Mat(@StdVector IntBuffer sizes, int type, @Const @ByRef Scalar s) { super((Pointer)null); allocate(sizes, type, s); }
    private native void allocate(@StdVector IntBuffer sizes, int type, @Const @ByRef Scalar s);
    public Mat(@StdVector int[] sizes, int type, @Const @ByRef Scalar s) { super((Pointer)null); allocate(sizes, type, s); }
    private native void allocate(@StdVector int[] sizes, int type, @Const @ByRef Scalar s);


    /** \overload
    @param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied
    by these constructors. Instead, the header pointing to m data or its sub-array is constructed and
    associated with it. The reference counter, if any, is incremented. So, when you modify the matrix
    formed using such a constructor, you also modify the corresponding elements of m . If you want to
    have an independent copy of the sub-array, use Mat::clone() .
    */
    public Mat(@Const @ByRef Mat m) { super((Pointer)null); allocate(m); }
    private native void allocate(@Const @ByRef Mat m);

    /** \overload
    @param rows Number of rows in a 2D array.
    @param cols Number of columns in a 2D array.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param data Pointer to the user data. Matrix constructors that take data and step parameters do not
    allocate matrix data. Instead, they just initialize the matrix header that points to the specified
    data, which means that no data is copied. This operation is very efficient and can be used to
    process external data using OpenCV functions. The external data is not automatically deallocated, so
    you should take care of it.
    @param step Number of bytes each matrix row occupies. The value should include the padding bytes at
    the end of each row, if any. If the parameter is missing (set to AUTO_STEP ), no padding is assumed
    and the actual step is calculated as cols*elemSize(). See Mat::elemSize.
    */
    public Mat(int rows, int cols, int type, Pointer data, @Cast("size_t") long step/*=AUTO_STEP*/) { super((Pointer)null); allocate(rows, cols, type, data, step); this.pointer = data; }
    private native void allocate(int rows, int cols, int type, Pointer data, @Cast("size_t") long step/*=AUTO_STEP*/);
    private Pointer pointer; // a reference to prevent deallocation
    /** Calls {@link #Mat(int, int, int, Pointer, long) Mat(rows, cols, type, data, AUTO_STEP)} as with {@link #Mat(int, int, int, Pointer, boolean) Mat(rows, cols, type, data, false)}. */
    public Mat(int rows, int cols, int type, Pointer data) { this(rows, cols, type, data, AUTO_STEP); }
    public Mat(CvArr arr) { super(cvarrToMat(arr)); this.pointer = arr; }
    /** Warning: If {@code copyData} is false, the data of the OpenCV Mat returned by this constructor is externally allocated from OpenCV point of view,
     *  and will not benefit from OpenCV reference counting feature. One must ensure that the data does not get implicitly or explicitly deallocated when
     *  another Mat has been created pointing to the same data with, e.g., reshape(), rowRange(), etc... */
    public Mat(int rows, int cols, int type, Pointer data, boolean copyData) { super((Pointer)null);
        if (copyData) { allocate(rows, cols, type); data().put(data); } else { allocate(rows, cols, type, data, AUTO_STEP); this.pointer = data; }
    }
    /** Calls {@link #Mat(int, int, int, Pointer, boolean) Mat((int)Math.min(data.limit() - data.position(), Integer.MAX_VALUE), 1, type, data, copyData)}. */
    public Mat(int type, Pointer data, boolean copyData) { this((int)Math.min(data.limit() - data.position(), Integer.MAX_VALUE), 1, type, data, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32SC2, points, copyData)}. */ public Mat(Point points, boolean copyData) { this(CV_32SC2, points, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32FC2, points, copyData)}. */ public Mat(Point2f points, boolean copyData) { this(CV_32FC2, points, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_64FC2, points, copyData)}. */ public Mat(Point2d points, boolean copyData) { this(CV_64FC2, points, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32SC3, points, copyData)}. */ public Mat(Point3i points, boolean copyData) { this(CV_32SC3, points, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32FC3, points, copyData)}. */ public Mat(Point3f points, boolean copyData) { this(CV_32FC3, points, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_64FC3, points, copyData)}. */ public Mat(Point3d points, boolean copyData) { this(CV_64FC3, points, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_64FC4, scalar, copyData)}. */ public Mat(Scalar scalar, boolean copyData) { this(CV_64FC4, scalar, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32SC4, scalar, copyData)}. */ public Mat(Scalar4i scalar, boolean copyData) { this(CV_32SC4, scalar, copyData); }
    /** Calls {@link #Mat(Point, boolean) Mat(points, false)}. */    public Mat(Point points)    { this(points, false); }
    /** Calls {@link #Mat(Point2f, boolean) Mat(points, false)}. */  public Mat(Point2f points)  { this(points, false); }
    /** Calls {@link #Mat(Point2d, boolean) Mat(points, false)}. */  public Mat(Point2d points)  { this(points, false); }
    /** Calls {@link #Mat(Point3i, boolean) Mat(points, false)}. */  public Mat(Point3i points)  { this(points, false); }
    /** Calls {@link #Mat(Point3f, boolean) Mat(points, false)}. */  public Mat(Point3f points)  { this(points, false); }
    /** Calls {@link #Mat(Point3d, boolean) Mat(points, false)}. */  public Mat(Point3d points)  { this(points, false); }
    /** Calls {@link #Mat(Scalar, boolean) Mat(scalar, false)}. */   public Mat(Scalar scalar)   { this(scalar, false); }
    /** Calls {@link #Mat(Scalar4i, boolean) Mat(scalar, false)}. */ public Mat(Scalar4i scalar) { this(scalar, false); }
    public Mat(byte ... b) { this(b, false); }
    public Mat(short ... s) { this(s, false); }
    public Mat(byte[] b, boolean signed) { this(b.length, 1, signed ? CV_8SC1 : CV_8UC1); data().put(b); }
    public Mat(short[] s, boolean signed) { this(s.length, 1, signed ? CV_16SC1 : CV_16UC1); new ShortPointer(data()).put(s); }
    public Mat(int ... n) { this(n.length, 1, CV_32SC1); new IntPointer(data()).put(n); }
    public Mat(double ... d) { this(d.length, 1, CV_64FC1); new DoublePointer(data()).put(d); }
    public Mat(float ... f) { this(f.length, 1, CV_32FC1); new FloatPointer(data()).put(f); }
    /** Calls {@link #Mat(BytePointer, boolean) Mat(p, false)}. */   public Mat(BytePointer p) { this(p, false); }
    /** Calls {@link #Mat(ShortPointer, boolean) Mat(p, false)}. */  public Mat(ShortPointer p) { this(p, false); }
    /** Calls {@link #Mat(BytePointer, boolean, boolean) Mat(p, signed, false)}. */  public Mat(BytePointer p, boolean signed) { this(p, signed, false); }
    /** Calls {@link #Mat(ShortPointer, boolean, boolean) Mat(p, signed, false)}. */ public Mat(ShortPointer p, boolean signed) { this(p, signed, false); }
    /** Calls {@link #Mat(IntPointer, boolean) Mat(p, false)}. */    public Mat(IntPointer p) { this(p, false); }
    /** Calls {@link #Mat(FloatPointer, boolean) Mat(p, false)}. */  public Mat(FloatPointer p) { this(p, false); }
    /** Calls {@link #Mat(DoublePointer, boolean) Mat(p, false)}. */ public Mat(DoublePointer p) { this(p, false); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(signed ? CV_8SC1 : CV_8UC1, p, copyData)}. */   public Mat(BytePointer p, boolean signed, boolean copyData) { this(signed ? CV_8SC1 : CV_8UC1, p, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(signed ? CV_16SC1 : CV_16UC1, p, copyData)}. */ public Mat(ShortPointer p, boolean signed, boolean copyData) { this(signed ? CV_16SC1 : CV_16UC1, p, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32SC1, p, copyData)}. */ public Mat(IntPointer p, boolean copyData) { this(CV_32SC1, p, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_32FC1, p, copyData)}. */ public Mat(FloatPointer p, boolean copyData) { this(CV_32FC1, p, copyData); }
    /** Calls {@link #Mat(int, Pointer, boolean) Mat(CV_64FC1, p, copyData)}. */ public Mat(DoublePointer p, boolean copyData) { this(CV_64FC1, p, copyData); }

    /** \overload
    @param size 2D array size: Size(cols, rows) . In the Size() constructor, the number of rows and the
    number of columns go in the reverse order.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param data Pointer to the user data. Matrix constructors that take data and step parameters do not
    allocate matrix data. Instead, they just initialize the matrix header that points to the specified
    data, which means that no data is copied. This operation is very efficient and can be used to
    process external data using OpenCV functions. The external data is not automatically deallocated, so
    you should take care of it.
    @param step Number of bytes each matrix row occupies. The value should include the padding bytes at
    the end of each row, if any. If the parameter is missing (set to AUTO_STEP ), no padding is assumed
    and the actual step is calculated as cols*elemSize(). See Mat::elemSize.
    */
    public Mat(@ByVal Size size, int type, Pointer data, @Cast("size_t") long step/*=AUTO_STEP*/) { super((Pointer)null); allocate(size, type, data, step); }
    private native void allocate(@ByVal Size size, int type, Pointer data, @Cast("size_t") long step/*=AUTO_STEP*/);
    public Mat(@ByVal Size size, int type, Pointer data) { super((Pointer)null); allocate(size, type, data); }
    private native void allocate(@ByVal Size size, int type, Pointer data);

    /** \overload
    @param ndims Array dimensionality.
    @param sizes Array of integers specifying an n-dimensional array shape.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param data Pointer to the user data. Matrix constructors that take data and step parameters do not
    allocate matrix data. Instead, they just initialize the matrix header that points to the specified
    data, which means that no data is copied. This operation is very efficient and can be used to
    process external data using OpenCV functions. The external data is not automatically deallocated, so
    you should take care of it.
    @param steps Array of ndims-1 steps in case of a multi-dimensional array (the last step is always
    set to the element size). If not specified, the matrix is assumed to be continuous.
    */
    public Mat(int ndims, @Const IntPointer sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/) { super((Pointer)null); allocate(ndims, sizes, type, data, steps); }
    private native void allocate(int ndims, @Const IntPointer sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/);
    public Mat(int ndims, @Const IntPointer sizes, int type, Pointer data) { super((Pointer)null); allocate(ndims, sizes, type, data); }
    private native void allocate(int ndims, @Const IntPointer sizes, int type, Pointer data);
    public Mat(int ndims, @Const IntBuffer sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/) { super((Pointer)null); allocate(ndims, sizes, type, data, steps); }
    private native void allocate(int ndims, @Const IntBuffer sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/);
    public Mat(int ndims, @Const IntBuffer sizes, int type, Pointer data) { super((Pointer)null); allocate(ndims, sizes, type, data); }
    private native void allocate(int ndims, @Const IntBuffer sizes, int type, Pointer data);
    public Mat(int ndims, @Const int[] sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/) { super((Pointer)null); allocate(ndims, sizes, type, data, steps); }
    private native void allocate(int ndims, @Const int[] sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/);
    public Mat(int ndims, @Const int[] sizes, int type, Pointer data) { super((Pointer)null); allocate(ndims, sizes, type, data); }
    private native void allocate(int ndims, @Const int[] sizes, int type, Pointer data);

    /** \overload
    @param sizes Array of integers specifying an n-dimensional array shape.
    @param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or
    CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices.
    @param data Pointer to the user data. Matrix constructors that take data and step parameters do not
    allocate matrix data. Instead, they just initialize the matrix header that points to the specified
    data, which means that no data is copied. This operation is very efficient and can be used to
    process external data using OpenCV functions. The external data is not automatically deallocated, so
    you should take care of it.
    @param steps Array of ndims-1 steps in case of a multi-dimensional array (the last step is always
    set to the element size). If not specified, the matrix is assumed to be continuous.
    */
    public Mat(@StdVector IntPointer sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/) { super((Pointer)null); allocate(sizes, type, data, steps); }
    private native void allocate(@StdVector IntPointer sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/);
    public Mat(@StdVector IntPointer sizes, int type, Pointer data) { super((Pointer)null); allocate(sizes, type, data); }
    private native void allocate(@StdVector IntPointer sizes, int type, Pointer data);
    public Mat(@StdVector IntBuffer sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/) { super((Pointer)null); allocate(sizes, type, data, steps); }
    private native void allocate(@StdVector IntBuffer sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/);
    public Mat(@StdVector IntBuffer sizes, int type, Pointer data) { super((Pointer)null); allocate(sizes, type, data); }
    private native void allocate(@StdVector IntBuffer sizes, int type, Pointer data);
    public Mat(@StdVector int[] sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/) { super((Pointer)null); allocate(sizes, type, data, steps); }
    private native void allocate(@StdVector int[] sizes, int type, Pointer data, @Cast("const size_t*") SizeTPointer steps/*=0*/);
    public Mat(@StdVector int[] sizes, int type, Pointer data) { super((Pointer)null); allocate(sizes, type, data); }
    private native void allocate(@StdVector int[] sizes, int type, Pointer data);

    /** \overload
    @param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied
    by these constructors. Instead, the header pointing to m data or its sub-array is constructed and
    associated with it. The reference counter, if any, is incremented. So, when you modify the matrix
    formed using such a constructor, you also modify the corresponding elements of m . If you want to
    have an independent copy of the sub-array, use Mat::clone() .
    @param rowRange Range of the m rows to take. As usual, the range start is inclusive and the range
    end is exclusive. Use Range::all() to take all the rows.
    @param colRange Range of the m columns to take. Use Range::all() to take all the columns.
    */
    public Mat(@Const @ByRef Mat m, @Const @ByRef Range rowRange, @Const @ByRef(nullValue = "cv::Range::all()") Range colRange) { super((Pointer)null); allocate(m, rowRange, colRange); }
    private native void allocate(@Const @ByRef Mat m, @Const @ByRef Range rowRange, @Const @ByRef(nullValue = "cv::Range::all()") Range colRange);
    public Mat(@Const @ByRef Mat m, @Const @ByRef Range rowRange) { super((Pointer)null); allocate(m, rowRange); }
    private native void allocate(@Const @ByRef Mat m, @Const @ByRef Range rowRange);

    /** \overload
    @param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied
    by these constructors. Instead, the header pointing to m data or its sub-array is constructed and
    associated with it. The reference counter, if any, is incremented. So, when you modify the matrix
    formed using such a constructor, you also modify the corresponding elements of m . If you want to
    have an independent copy of the sub-array, use Mat::clone() .
    @param roi Region of interest.
    */
    public Mat(@Const @ByRef Mat m, @Const @ByRef Rect roi) { super((Pointer)null); allocate(m, roi); }
    private native void allocate(@Const @ByRef Mat m, @Const @ByRef Rect roi);

    /** \overload
    @param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied
    by these constructors. Instead, the header pointing to m data or its sub-array is constructed and
    associated with it. The reference counter, if any, is incremented. So, when you modify the matrix
    formed using such a constructor, you also modify the corresponding elements of m . If you want to
    have an independent copy of the sub-array, use Mat::clone() .
    @param ranges Array of selected ranges of m along each dimensionality.
    */

    /** \overload
    @param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied
    by these constructors. Instead, the header pointing to m data or its sub-array is constructed and
    associated with it. The reference counter, if any, is incremented. So, when you modify the matrix
    formed using such a constructor, you also modify the corresponding elements of m . If you want to
    have an independent copy of the sub-array, use Mat::clone() .
    @param ranges Array of selected ranges of m along each dimensionality.
    */
    public Mat(@Const @ByRef Mat m, @Const @ByRef RangeVector ranges) { super((Pointer)null); allocate(m, ranges); }
    private native void allocate(@Const @ByRef Mat m, @Const @ByRef RangeVector ranges);

    /** \overload
    @param vec STL vector whose elements form the matrix. The matrix has a single column and the number
    of rows equal to the number of vector elements. Type of the matrix matches the type of vector
    elements. The constructor can handle arbitrary types, for which there is a properly declared
    DataType . This means that the vector elements must be primitive numbers or uni-type numerical
    tuples of numbers. Mixed-type structures are not supported. The corresponding constructor is
    explicit. Since STL vectors are not automatically converted to Mat instances, you should write
    Mat(vec) explicitly. Unless you copy the data into the matrix ( copyData=true ), no new elements
    will be added to the vector because it can potentially yield vector data reallocation, and, thus,
    the matrix data pointer will be invalid.
    @param copyData Flag to specify whether the underlying data of the STL vector should be copied
    to (true) or shared with (false) the newly constructed matrix. When the data is copied, the
    allocated buffer is managed using Mat reference counting mechanism. While the data is shared,
    the reference counter is NULL, and you should not deallocate the data until the matrix is
    destructed.
    */

    /** \overload
    */

    /** \overload
    */

    /** \overload
    */

    /** \overload
    */

    /** \overload
    */

    /** \overload
    */

    /** \overload
    */

    /** \overload
    */

    /** download data from GpuMat */
    public Mat(@Const @ByRef GpuMat m) { super((Pointer)null); allocate(m); }
    private native void allocate(@Const @ByRef GpuMat m);

    /** destructor - calls release() */

    /** \brief assignment operators
    <p>
    These are available assignment operators. Since they all are very different, make sure to read the
    operator parameters description.
    @param m Assigned, right-hand-side matrix. Matrix assignment is an O(1) operation. This means that
    no data is copied but the data is shared and the reference counter, if any, is incremented. Before
    assigning new data, the old data is de-referenced via Mat::release .
     */
    public native @ByRef @Name("operator =") Mat put(@Const @ByRef Mat m);

    /** \overload
    @param expr Assigned matrix expression object. As opposite to the first form of the assignment
    operation, the second form can reuse already allocated matrix if it has the right size and type to
    fit the matrix expression result. It is automatically handled by the real function that the matrix
    expressions is expanded to. For example, C=A+B is expanded to add(A, B, C), and add takes care of
    automatic C reallocation.
    */
    public native @ByRef @Name("operator =") Mat put(@Const @ByRef MatExpr expr);

    /** retrieve UMat from Mat */
    public native @ByVal UMat getUMat(@Cast("cv::AccessFlag") int accessFlags, @Cast("cv::UMatUsageFlags") int usageFlags/*=cv::USAGE_DEFAULT*/);
    public native @ByVal UMat getUMat(@Cast("cv::AccessFlag") int accessFlags);

    /** \brief Creates a matrix header for the specified matrix row.
    <p>
    The method makes a new header for the specified matrix row and returns it. This is an O(1)
    operation, regardless of the matrix size. The underlying data of the new matrix is shared with the
    original matrix. Here is the example of one of the classical basic matrix processing operations,
    axpy, used by LU and many other algorithms:
    <pre>{@code
        inline void matrix_axpy(Mat& A, int i, int j, double alpha)
        {
            A.row(i) += A.row(j)*alpha;
        }
    }</pre>
    \note In the current implementation, the following code does not work as expected:
    <pre>{@code
        Mat A;
        ...
        A.row(i) = A.row(j); // will not work
    }</pre>
    This happens because A.row(i) forms a temporary header that is further assigned to another header.
    Remember that each of these operations is O(1), that is, no data is copied. Thus, the above
    assignment is not true if you may have expected the j-th row to be copied to the i-th row. To
    achieve that, you should either turn this simple assignment into an expression or use the
    Mat::copyTo method:
    <pre>{@code
        Mat A;
        ...
        // works, but looks a bit obscure.
        A.row(i) = A.row(j) + 0;
        // this is a bit longer, but the recommended method.
        A.row(j).copyTo(A.row(i));
    }</pre>
    @param y A 0-based row index.
     */
    public native @ByVal Mat row(int y);

    /** \brief Creates a matrix header for the specified matrix column.
    <p>
    The method makes a new header for the specified matrix column and returns it. This is an O(1)
    operation, regardless of the matrix size. The underlying data of the new matrix is shared with the
    original matrix. See also the Mat::row description.
    @param x A 0-based column index.
     */
    public native @ByVal Mat col(int x);

    /** \brief Creates a matrix header for the specified row span.
    <p>
    The method makes a new header for the specified row span of the matrix. Similarly to Mat::row and
    Mat::col , this is an O(1) operation.
    @param startrow An inclusive 0-based start index of the row span.
    @param endrow An exclusive 0-based ending index of the row span.
     */
    public native @ByVal Mat rowRange(int startrow, int endrow);

    /** \overload
    @param r Range structure containing both the start and the end indices.
    */
    public native @ByVal Mat rowRange(@Const @ByRef Range r);

    /** \brief Creates a matrix header for the specified column span.
    <p>
    The method makes a new header for the specified column span of the matrix. Similarly to Mat::row and
    Mat::col , this is an O(1) operation.
    @param startcol An inclusive 0-based start index of the column span.
    @param endcol An exclusive 0-based ending index of the column span.
     */
    public native @ByVal Mat colRange(int startcol, int endcol);

    /** \overload
    @param r Range structure containing both the start and the end indices.
    */
    public native @ByVal Mat colRange(@Const @ByRef Range r);

    /** \brief Extracts a diagonal from a matrix
    <p>
    The method makes a new header for the specified matrix diagonal. The new matrix is represented as a
    single-column matrix. Similarly to Mat::row and Mat::col, this is an O(1) operation.
    @param d index of the diagonal, with the following values:
    - {@code d=0} is the main diagonal.
    - {@code d<0} is a diagonal from the lower half. For example, d=-1 means the diagonal is set
      immediately below the main one.
    - {@code d>0} is a diagonal from the upper half. For example, d=1 means the diagonal is set
      immediately above the main one.
    For example:
    <pre>{@code
        Mat m = (Mat_<int>(3,3) <<
                    1,2,3,
                    4,5,6,
                    7,8,9);
        Mat d0 = m.diag(0);
        Mat d1 = m.diag(1);
        Mat d_1 = m.diag(-1);
    }</pre>
    The resulting matrices are
    <pre>{@code
     d0 =
       [1;
        5;
        9]
     d1 =
       [2;
        6]
     d_1 =
       [4;
        8]
    }</pre>
     */
    public native @ByVal Mat diag(int d/*=0*/);
    public native @ByVal Mat diag();

    /** \brief creates a diagonal matrix
    <p>
    The method creates a square diagonal matrix from specified main diagonal.
    @param d One-dimensional matrix that represents the main diagonal.
     */
    /* nothing by default */ public static native @ByVal Mat diag(@Const @ByRef Mat d);

    /** \brief Creates a full copy of the array and the underlying data.
    <p>
    The method creates a full copy of the array. The original step[] is not taken into account. So, the
    array copy is a continuous array occupying total()*elemSize() bytes.
     */
    /* nothing by default */ public native @ByVal Mat clone();

    /** \brief Copies the matrix to another one.
    <p>
    The method copies the matrix data to another matrix. Before copying the data, the method invokes :
    <pre>{@code
        m.create(this->size(), this->type());
    }</pre>
    so that the destination matrix is reallocated if needed. While m.copyTo(m); works flawlessly, the
    function does not handle the case of a partial overlap between the source and the destination
    matrices.
    <p>
    When the operation mask is specified, if the Mat::create call shown above reallocates the matrix,
    the newly allocated matrix is initialized with all zeros before copying the data.
    @param m Destination matrix. If it does not have a proper size or type before the operation, it is
    reallocated.
     */
    public native void copyTo( @ByVal Mat m );
    public native void copyTo( @ByVal UMat m );
    public native void copyTo( @ByVal GpuMat m );

    /** \overload
    @param m Destination matrix. If it does not have a proper size or type before the operation, it is
    reallocated.
    @param mask Operation mask of the same size as \*this. Its non-zero elements indicate which matrix
    elements need to be copied. The mask has to be of type CV_8U and can have 1 or multiple channels.
    */
    public native void copyTo( @ByVal Mat m, @ByVal Mat mask );
    public native void copyTo( @ByVal UMat m, @ByVal UMat mask );
    public native void copyTo( @ByVal GpuMat m, @ByVal GpuMat mask );

    /** \brief Converts an array to another data type with optional scaling.
    <p>
    The method converts source pixel values to the target data type. saturate_cast\<\> is applied at
    the end to avoid possible overflows:
    <p>
    <pre>{@code \[m(x,y) = saturate \_ cast<rType>( \alpha (*this)(x,y) +  \beta )\]}</pre>
    @param m output matrix; if it does not have a proper size or type before the operation, it is
    reallocated.
    @param rtype desired output matrix type or, rather, the depth since the number of channels are the
    same as the input has; if rtype is negative, the output matrix will have the same type as the input.
    @param alpha optional scale factor.
    @param beta optional delta added to the scaled values.
     */
    public native void convertTo( @ByVal Mat m, int rtype, double alpha/*=1*/, double beta/*=0*/ );
    public native void convertTo( @ByVal Mat m, int rtype );
    public native void convertTo( @ByVal UMat m, int rtype, double alpha/*=1*/, double beta/*=0*/ );
    public native void convertTo( @ByVal UMat m, int rtype );
    public native void convertTo( @ByVal GpuMat m, int rtype, double alpha/*=1*/, double beta/*=0*/ );
    public native void convertTo( @ByVal GpuMat m, int rtype );

    /** \brief Provides a functional form of convertTo.
    <p>
    This is an internally used method called by the \ref MatrixExpressions engine.
    @param m Destination array.
    @param type Desired destination array depth (or -1 if it should be the same as the source type).
     */
    public native void assignTo( @ByRef Mat m, int type/*=-1*/ );
    public native void assignTo( @ByRef Mat m );

    /** \brief Sets all or some of the array elements to the specified value.
    @param s Assigned scalar converted to the actual array type.
    */
    public native @ByRef @Name("operator =") Mat put(@Const @ByRef Scalar s);

    /** \brief Sets all or some of the array elements to the specified value.
    <p>
    This is an advanced variant of the Mat::operator=(const Scalar& s) operator.
    @param value Assigned scalar converted to the actual array type.
    @param mask Operation mask of the same size as \*this. Its non-zero elements indicate which matrix
    elements need to be copied. The mask has to be of type CV_8U and can have 1 or multiple channels
     */
    public native @ByRef Mat setTo(@ByVal Mat value, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
    public native @ByRef Mat setTo(@ByVal Mat value);
    public native @ByRef Mat setTo(@ByVal UMat value, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
    public native @ByRef Mat setTo(@ByVal UMat value);
    public native @ByRef Mat setTo(@ByVal GpuMat value, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
    public native @ByRef Mat setTo(@ByVal GpuMat value);

    /** \brief Changes the shape and/or the number of channels of a 2D matrix without copying the data.
    <p>
    The method makes a new matrix header for \*this elements. The new matrix may have a different size
    and/or different number of channels. Any combination is possible if:
    -   No extra elements are included into the new matrix and no elements are excluded. Consequently,
        the product rows\*cols\*channels() must stay the same after the transformation.
    -   No data is copied. That is, this is an O(1) operation. Consequently, if you change the number of
        rows, or the operation changes the indices of elements row in some other way, the matrix must be
        continuous. See Mat::isContinuous .
    <p>
    For example, if there is a set of 3D points stored as an STL vector, and you want to represent the
    points as a 3xN matrix, do the following:
    <pre>{@code
        std::vector<Point3f> vec;
        ...
        Mat pointMat = Mat(vec). // convert vector to Mat, O(1) operation
                          reshape(1). // make Nx3 1-channel matrix out of Nx1 3-channel.
                                      // Also, an O(1) operation
                             t(); // finally, transpose the Nx3 matrix.
                                  // This involves copying all the elements
    }</pre>
    @param cn New number of channels. If the parameter is 0, the number of channels remains the same.
    @param rows New number of rows. If the parameter is 0, the number of rows remains the same.
     */
    public native @ByVal Mat reshape(int cn, int rows/*=0*/);
    public native @ByVal Mat reshape(int cn);

    /** \overload */
    public native @ByVal Mat reshape(int cn, int newndims, @Const IntPointer newsz);
    public native @ByVal Mat reshape(int cn, int newndims, @Const IntBuffer newsz);
    public native @ByVal Mat reshape(int cn, int newndims, @Const int[] newsz);

    /** \overload */
    public native @ByVal Mat reshape(int cn, @StdVector IntPointer newshape);
    public native @ByVal Mat reshape(int cn, @StdVector IntBuffer newshape);
    public native @ByVal Mat reshape(int cn, @StdVector int[] newshape);

    /** \brief Transposes a matrix.
    <p>
    The method performs matrix transposition by means of matrix expressions. It does not perform the
    actual transposition but returns a temporary matrix transposition object that can be further used as
    a part of more complex matrix expressions or can be assigned to a matrix:
    <pre>{@code
        Mat A1 = A + Mat::eye(A.size(), A.type())*lambda;
        Mat C = A1.t()*A1; // compute (A + lambda*I)^t * (A + lamda*I)
    }</pre>
     */
    public native @ByVal MatExpr t();

    /** \brief Inverses a matrix.
    <p>
    The method performs a matrix inversion by means of matrix expressions. This means that a temporary
    matrix inversion object is returned by the method and can be used further as a part of more complex
    matrix expressions or can be assigned to a matrix.
    @param method Matrix inversion method. One of cv::DecompTypes
     */
    public native @ByVal MatExpr inv(int method/*=cv::DECOMP_LU*/);
    public native @ByVal MatExpr inv();

    /** \brief Performs an element-wise multiplication or division of the two matrices.
    <p>
    The method returns a temporary object encoding per-element array multiplication, with optional
    scale. Note that this is not a matrix multiplication that corresponds to a simpler "\*" operator.
    <p>
    Example:
    <pre>{@code
        Mat C = A.mul(5/B); // equivalent to divide(A, B, C, 5)
    }</pre>
    @param m Another array of the same type and the same size as \*this, or a matrix expression.
    @param scale Optional scale factor.
     */
    public native @ByVal MatExpr mul(@ByVal Mat m, double scale/*=1*/);
    public native @ByVal MatExpr mul(@ByVal Mat m);
    public native @ByVal MatExpr mul(@ByVal UMat m, double scale/*=1*/);
    public native @ByVal MatExpr mul(@ByVal UMat m);
    public native @ByVal MatExpr mul(@ByVal GpuMat m, double scale/*=1*/);
    public native @ByVal MatExpr mul(@ByVal GpuMat m);

    /** \brief Computes a cross-product of two 3-element vectors.
    <p>
    The method computes a cross-product of two 3-element vectors. The vectors must be 3-element
    floating-point vectors of the same shape and size. The result is another 3-element vector of the
    same shape and type as operands.
    @param m Another cross-product operand.
     */
    public native @ByVal Mat cross(@ByVal Mat m);
    public native @ByVal Mat cross(@ByVal UMat m);
    public native @ByVal Mat cross(@ByVal GpuMat m);

    /** \brief Computes a dot-product of two vectors.
    <p>
    The method computes a dot-product of two matrices. If the matrices are not single-column or
    single-row vectors, the top-to-bottom left-to-right scan ordering is used to treat them as 1D
    vectors. The vectors must have the same size and type. If the matrices have more than one channel,
    the dot products from all the channels are summed together.
    @param m another dot-product operand.
     */
    public native double dot(@ByVal Mat m);
    public native double dot(@ByVal UMat m);
    public native double dot(@ByVal GpuMat m);

    /** \brief Returns a zero array of the specified size and type.
    <p>
    The method returns a Matlab-style zero array initializer. It can be used to quickly form a constant
    array as a function parameter, part of a matrix expression, or as a matrix initializer:
    <pre>{@code
        Mat A;
        A = Mat::zeros(3, 3, CV_32F);
    }</pre>
    In the example above, a new matrix is allocated only if A is not a 3x3 floating-point matrix.
    Otherwise, the existing matrix A is filled with zeros.
    @param rows Number of rows.
    @param cols Number of columns.
    @param type Created matrix type.
     */
    /* nothing by default */ public static native @ByVal MatExpr zeros(int rows, int cols, int type);

    /** \overload
    @param size Alternative to the matrix size specification Size(cols, rows) .
    @param type Created matrix type.
    */
    /* nothing by default */ public static native @ByVal MatExpr zeros(@ByVal Size size, int type);

    /** \overload
    @param ndims Array dimensionality.
    @param sz Array of integers specifying the array shape.
    @param type Created matrix type.
    */
    /* nothing by default */ 

    /** \brief Returns an array of all 1's of the specified size and type.
    <p>
    The method returns a Matlab-style 1's array initializer, similarly to Mat::zeros. Note that using
    this method you can initialize an array with an arbitrary value, using the following Matlab idiom:
    <pre>{@code
        Mat A = Mat::ones(100, 100, CV_8U)*3; // make 100x100 matrix filled with 3.
    }</pre>
    The above operation does not form a 100x100 matrix of 1's and then multiply it by 3. Instead, it
    just remembers the scale factor (3 in this case) and use it when actually invoking the matrix
    initializer.
    \note In case of multi-channels type, only the first channel will be initialized with 1's, the
    others will be set to 0's.
    @param rows Number of rows.
    @param cols Number of columns.
    @param type Created matrix type.
     */
    /* nothing by default */ public static native @ByVal MatExpr ones(int rows, int cols, int type);

    /** \overload
    @param size Alternative to the matrix size specification Size(cols, rows) .
    @param type Created matrix type.
    */
    /* nothing by default */ public static native @ByVal MatExpr ones(@ByVal Size size, int type);

    /** \overload
    @param ndims Array dimensionality.
    @param sz Array of integers specifying the array shape.
    @param type Created matrix type.
    */
    /* nothing by default */ 

    /** \brief Returns an identity matrix of the specified size and type.
    <p>
    The method returns a Matlab-style identity matrix initializer, similarly to Mat::zeros. Similarly to
    Mat::ones, you can use a scale operation to create a scaled identity matrix efficiently:
    <pre>{@code
        // make a 4x4 diagonal matrix with 0.1's on the diagonal.
        Mat A = Mat::eye(4, 4, CV_32F)*0.1;
    }</pre>
    \note In case of multi-channels type, identity matrix will be initialized only for the first channel,
    the others will be set to 0's
    @param rows Number of rows.
    @param cols Number of columns.
    @param type Created matrix type.
     */
    /* nothing by default */ public static native @ByVal MatExpr eye(int rows, int cols, int type);

    /** \overload
    @param size Alternative matrix size specification as Size(cols, rows) .
    @param type Created matrix type.
    */
    /* nothing by default */ public static native @ByVal MatExpr eye(@ByVal Size size, int type);

    /** \brief Allocates new array data if needed.
    <p>
    This is one of the key Mat methods. Most new-style OpenCV functions and methods that produce arrays
    call this method for each output array. The method uses the following algorithm:
    <p>
    -# If the current array shape and the type match the new ones, return immediately. Otherwise,
       de-reference the previous data by calling Mat::release.
    -# Initialize the new header.
    -# Allocate the new data of total()\*elemSize() bytes.
    -# Allocate the new, associated with the data, reference counter and set it to 1.
    <p>
    Such a scheme makes the memory management robust and efficient at the same time and helps avoid
    extra typing for you. This means that usually there is no need to explicitly allocate output arrays.
    That is, instead of writing:
    <pre>{@code
        Mat color;
        ...
        Mat gray(color.rows, color.cols, color.depth());
        cvtColor(color, gray, COLOR_BGR2GRAY);
    }</pre>
    you can simply write:
    <pre>{@code
        Mat color;
        ...
        Mat gray;
        cvtColor(color, gray, COLOR_BGR2GRAY);
    }</pre>
    because cvtColor, as well as the most of OpenCV functions, calls Mat::create() for the output array
    internally.
    @param rows New number of rows.
    @param cols New number of columns.
    @param type New matrix type.
     */
    public native void create(int rows, int cols, int type);

    /** \overload
    @param size Alternative new matrix size specification: Size(cols, rows)
    @param type New matrix type.
    */
    public native void create(@ByVal Size size, int type);

    /** \overload
    @param ndims New array dimensionality.
    @param sizes Array of integers specifying a new array shape.
    @param type New matrix type.
    */
    public native void create(int ndims, @Const IntPointer sizes, int type);
    public native void create(int ndims, @Const IntBuffer sizes, int type);
    public native void create(int ndims, @Const int[] sizes, int type);

    /** \overload
    @param sizes Array of integers specifying a new array shape.
    @param type New matrix type.
    */
    public native void create(@StdVector IntPointer sizes, int type);
    public native void create(@StdVector IntBuffer sizes, int type);
    public native void create(@StdVector int[] sizes, int type);

    /** \brief Increments the reference counter.
    <p>
    The method increments the reference counter associated with the matrix data. If the matrix header
    points to an external data set (see Mat::Mat ), the reference counter is NULL, and the method has no
    effect in this case. Normally, to avoid memory leaks, the method should not be called explicitly. It
    is called implicitly by the matrix assignment operator. The reference counter increment is an atomic
    operation on the platforms that support it. Thus, it is safe to operate on the same matrices
    asynchronously in different threads.
     */
    public native void addref();

    /** \brief Decrements the reference counter and deallocates the matrix if needed.
    <p>
    The method decrements the reference counter associated with the matrix data. When the reference
    counter reaches 0, the matrix data is deallocated and the data and the reference counter pointers
    are set to NULL's. If the matrix header points to an external data set (see Mat::Mat ), the
    reference counter is NULL, and the method has no effect in this case.
    <p>
    This method can be called manually to force the matrix data deallocation. But since this method is
    automatically called in the destructor, or by any other method that changes the data pointer, it is
    usually not needed. The reference counter decrement and check for 0 is an atomic operation on the
    platforms that support it. Thus, it is safe to operate on the same matrices asynchronously in
    different threads.
     */
    public native void release();

    /** internal use function, consider to use 'release' method instead; deallocates the matrix data */
    public native @Name("deallocate") void _deallocate();
    /** internal use function; properly re-allocates _size, _step arrays */
    public native void copySize(@Const @ByRef Mat m);

    /** \brief Reserves space for the certain number of rows.
    <p>
    The method reserves space for sz rows. If the matrix already has enough space to store sz rows,
    nothing happens. If the matrix is reallocated, the first Mat::rows rows are preserved. The method
    emulates the corresponding method of the STL vector class.
    @param sz Number of rows.
     */
    public native void reserve(@Cast("size_t") long sz);

    /** \brief Reserves space for the certain number of bytes.
    <p>
    The method reserves space for sz bytes. If the matrix already has enough space to store sz bytes,
    nothing happens. If matrix has to be reallocated its previous content could be lost.
    @param sz Number of bytes.
    */
    public native void reserveBuffer(@Cast("size_t") long sz);

    /** \brief Changes the number of matrix rows.
    <p>
    The methods change the number of matrix rows. If the matrix is reallocated, the first
    min(Mat::rows, sz) rows are preserved. The methods emulate the corresponding methods of the STL
    vector class.
    @param sz New number of rows.
     */
    public native void resize(@Cast("size_t") long sz);

    /** \overload
    @param sz New number of rows.
    @param s Value assigned to the newly added elements.
     */
    public native void resize(@Cast("size_t") long sz, @Const @ByRef Scalar s);

    /** internal function */
    public native void push_back_(@Const Pointer elem);

    /** \brief Adds elements to the bottom of the matrix.
    <p>
    The methods add one or more elements to the bottom of the matrix. They emulate the corresponding
    method of the STL vector class. When elem is Mat , its type and the number of columns must be the
    same as in the container matrix.
    @param elem Added element(s).
     */

    /** \overload
    @param elem Added element(s).
    */

    /** \overload
    @param elem Added element(s).
    */

    /** \overload
    @param m Added line(s).
    */
    public native void push_back(@Const @ByRef Mat m);

    /** \brief Removes elements from the bottom of the matrix.
    <p>
    The method removes one or more rows from the bottom of the matrix.
    @param nelems Number of removed rows. If it is greater than the total number of rows, an exception
    is thrown.
     */
    public native void pop_back(@Cast("size_t") long nelems/*=1*/);
    public native void pop_back();

    /** \brief Locates the matrix header within a parent matrix.
    <p>
    After you extracted a submatrix from a matrix using Mat::row, Mat::col, Mat::rowRange,
    Mat::colRange, and others, the resultant submatrix points just to the part of the original big
    matrix. However, each submatrix contains information (represented by datastart and dataend
    fields) that helps reconstruct the original matrix size and the position of the extracted
    submatrix within the original matrix. The method locateROI does exactly that.
    @param wholeSize Output parameter that contains the size of the whole matrix containing *this*
    as a part.
    @param ofs Output parameter that contains an offset of *this* inside the whole matrix.
     */
    public native void locateROI( @ByRef Size wholeSize, @ByRef Point ofs );

    /** \brief Adjusts a submatrix size and position within the parent matrix.
    <p>
    The method is complimentary to Mat::locateROI . The typical use of these functions is to determine
    the submatrix position within the parent matrix and then shift the position somehow. Typically, it
    can be required for filtering operations when pixels outside of the ROI should be taken into
    account. When all the method parameters are positive, the ROI needs to grow in all directions by the
    specified amount, for example:
    <pre>{@code
        A.adjustROI(2, 2, 2, 2);
    }</pre>
    In this example, the matrix size is increased by 4 elements in each direction. The matrix is shifted
    by 2 elements to the left and 2 elements up, which brings in all the necessary pixels for the
    filtering with the 5x5 kernel.
    <p>
    adjustROI forces the adjusted ROI to be inside of the parent matrix that is boundaries of the
    adjusted ROI are constrained by boundaries of the parent matrix. For example, if the submatrix A is
    located in the first row of a parent matrix and you called A.adjustROI(2, 2, 2, 2) then A will not
    be increased in the upward direction.
    <p>
    The function is used internally by the OpenCV filtering functions, like filter2D , morphological
    operations, and so on.
    @param dtop Shift of the top submatrix boundary upwards.
    @param dbottom Shift of the bottom submatrix boundary downwards.
    @param dleft Shift of the left submatrix boundary to the left.
    @param dright Shift of the right submatrix boundary to the right.
    @see copyMakeBorder
     */
    public native @ByRef Mat adjustROI( int dtop, int dbottom, int dleft, int dright );

    /** \brief Extracts a rectangular submatrix.
    <p>
    The operators make a new header for the specified sub-array of \*this . They are the most
    generalized forms of Mat::row, Mat::col, Mat::rowRange, and Mat::colRange . For example,
    {@code A(Range(0, 10), Range::all())} is equivalent to {@code A.rowRange(0, 10)}. Similarly to all of the above,
    the operators are O(1) operations, that is, no matrix data is copied.
    @param rowRange Start and end row of the extracted submatrix. The upper boundary is not included. To
    select all the rows, use Range::all().
    @param colRange Start and end column of the extracted submatrix. The upper boundary is not included.
    To select all the columns, use Range::all().
     */
    public native @ByVal @Name("operator ()") Mat apply( @ByVal Range rowRange, @ByVal Range colRange );

    /** \overload
    @param roi Extracted submatrix specified as a rectangle.
    */
    public native @ByVal @Name("operator ()") Mat apply( @Const @ByRef Rect roi );

    /** \overload
    @param ranges Array of selected ranges along each array dimension.
    */
    public native @ByVal @Name("operator ()") Mat apply( @Const Range ranges );

    /** \overload
    @param ranges Array of selected ranges along each array dimension.
    */
    public native @ByVal @Name("operator ()") Mat apply(@Const @ByRef RangeVector ranges);

    /** \brief Reports whether the matrix is continuous or not.
    <p>
    The method returns true if the matrix elements are stored continuously without gaps at the end of
    each row. Otherwise, it returns false. Obviously, 1x1 or 1xN matrices are always continuous.
    Matrices created with Mat::create are always continuous. But if you extract a part of the matrix
    using Mat::col, Mat::diag, and so on, or constructed a matrix header for externally allocated data,
    such matrices may no longer have this property.
    <p>
    The continuity flag is stored as a bit in the Mat::flags field and is computed automatically when
    you construct a matrix header. Thus, the continuity check is a very fast operation, though
    theoretically it could be done as follows:
    <pre>{@code
        // alternative implementation of Mat::isContinuous()
        bool myCheckMatContinuity(const Mat& m)
        {
            //return (m.flags & Mat::CONTINUOUS_FLAG) != 0;
            return m.rows == 1 || m.step == m.cols*m.elemSize();
        }
    }</pre>
    The method is used in quite a few of OpenCV functions. The point is that element-wise operations
    (such as arithmetic and logical operations, math functions, alpha blending, color space
    transformations, and others) do not depend on the image geometry. Thus, if all the input and output
    arrays are continuous, the functions can process them as very long single-row vectors. The example
    below illustrates how an alpha-blending function can be implemented:
    <pre>{@code
        template<typename T>
        void alphaBlendRGBA(const Mat& src1, const Mat& src2, Mat& dst)
        {
            const float alpha_scale = (float)std::numeric_limits<T>::max(),
                        inv_scale = 1.f/alpha_scale;

            CV_Assert( src1.type() == src2.type() &&
                       src1.type() == CV_MAKETYPE(traits::Depth<T>::value, 4) &&
                       src1.size() == src2.size());
            Size size = src1.size();
            dst.create(size, src1.type());

            // here is the idiom: check the arrays for continuity and,
            // if this is the case,
            // treat the arrays as 1D vectors
            if( src1.isContinuous() && src2.isContinuous() && dst.isContinuous() )
            {
                size.width *= size.height;
                size.height = 1;
            }
            size.width *= 4;

            for( int i = 0; i < size.height; i++ )
            {
                // when the arrays are continuous,
                // the outer loop is executed only once
                const T* ptr1 = src1.ptr<T>(i);
                const T* ptr2 = src2.ptr<T>(i);
                T* dptr = dst.ptr<T>(i);

                for( int j = 0; j < size.width; j += 4 )
                {
                    float alpha = ptr1[j+3]*inv_scale, beta = ptr2[j+3]*inv_scale;
                    dptr[j] = saturate_cast<T>(ptr1[j]*alpha + ptr2[j]*beta);
                    dptr[j+1] = saturate_cast<T>(ptr1[j+1]*alpha + ptr2[j+1]*beta);
                    dptr[j+2] = saturate_cast<T>(ptr1[j+2]*alpha + ptr2[j+2]*beta);
                    dptr[j+3] = saturate_cast<T>((1 - (1-alpha)*(1-beta))*alpha_scale);
                }
            }
        }
    }</pre>
    This approach, while being very simple, can boost the performance of a simple element-operation by
    10-20 percents, especially if the image is rather small and the operation is quite simple.
    <p>
    Another OpenCV idiom in this function, a call of Mat::create for the destination array, that
    allocates the destination array unless it already has the proper size and type. And while the newly
    allocated arrays are always continuous, you still need to check the destination array because
    Mat::create does not always allocate a new matrix.
     */
    public native @Cast("bool") boolean isContinuous();

    /** returns true if the matrix is a submatrix of another matrix */
    public native @Cast("bool") boolean isSubmatrix();

    /** \brief Returns the matrix element size in bytes.
    <p>
    The method returns the matrix element size in bytes. For example, if the matrix type is CV_16SC3 ,
    the method returns 3\*sizeof(short) or 6.
     */
    public native @Cast("size_t") long elemSize();

    /** \brief Returns the size of each matrix element channel in bytes.
    <p>
    The method returns the matrix element channel size in bytes, that is, it ignores the number of
    channels. For example, if the matrix type is CV_16SC3 , the method returns sizeof(short) or 2.
     */
    public native @Cast("size_t") long elemSize1();

    /** \brief Returns the type of a matrix element.
    <p>
    The method returns a matrix element type. This is an identifier compatible with the CvMat type
    system, like CV_16SC3 or 16-bit signed 3-channel array, and so on.
     */
    public native int type();

    /** \brief Returns the depth of a matrix element.
    <p>
    The method returns the identifier of the matrix element depth (the type of each individual channel).
    For example, for a 16-bit signed element array, the method returns CV_16S . A complete list of
    matrix types contains the following values:
    -   CV_8U - 8-bit unsigned integers ( 0..255 )
    -   CV_8S - 8-bit signed integers ( -128..127 )
    -   CV_16U - 16-bit unsigned integers ( 0..65535 )
    -   CV_16S - 16-bit signed integers ( -32768..32767 )
    -   CV_32S - 32-bit signed integers ( -2147483648..2147483647 )
    -   CV_32F - 32-bit floating-point numbers ( -FLT_MAX..FLT_MAX, INF, NAN )
    -   CV_64F - 64-bit floating-point numbers ( -DBL_MAX..DBL_MAX, INF, NAN )
     */
    public native int depth();

    /** \brief Returns the number of matrix channels.
    <p>
    The method returns the number of matrix channels.
     */
    public native int channels();

    /** \brief Returns a normalized step.
    <p>
    The method returns a matrix step divided by Mat::elemSize1() . It can be useful to quickly access an
    arbitrary matrix element.
     */
    public native @Cast("size_t") long step1(int i/*=0*/);
    public native @Cast("size_t") long step1();

    /** \brief Returns true if the array has no elements.
    <p>
    The method returns true if Mat::total() is 0 or if Mat::data is NULL. Because of pop_back() and
    resize() methods {@code M.total() == 0} does not imply that {@code M.data == NULL}.
     */
    public native @Cast("bool") boolean empty();

    /** \brief Returns the total number of array elements.
    <p>
    The method returns the number of array elements (a number of pixels if the array represents an
    image).
     */
    public native @Cast("size_t") long total();

    /** \brief Returns the total number of array elements.
     <p>
     The method returns the number of elements within a certain sub-array slice with startDim <= dim < endDim
     */
    public native @Cast("size_t") long total(int startDim, int endDim/*=INT_MAX*/);
    public native @Cast("size_t") long total(int startDim);

    /**
     * @param elemChannels Number of channels or number of columns the matrix should have.
     *                     For a 2-D matrix, when the matrix has only 1 column, then it should have
     *                     elemChannels channels; When the matrix has only 1 channel,
     *                     then it should have elemChannels columns.
     *                     For a 3-D matrix, it should have only one channel. Furthermore,
     *                     if the number of planes is not one, then the number of rows
     *                     within every plane has to be 1; if the number of rows within
     *                     every plane is not 1, then the number of planes has to be 1.
     * @param depth The depth the matrix should have. Set it to -1 when any depth is fine.
     * @param requireContinuous Set it to true to require the matrix to be continuous
     * @return -1 if the requirement is not satisfied.
     *         Otherwise, it returns the number of elements in the matrix. Note
     *         that an element may have multiple channels.
     *
     * The following code demonstrates its usage for a 2-d matrix:
     * \snippet snippets/core_mat_checkVector.cpp example-2d
     *
     * The following code demonstrates its usage for a 3-d matrix:
     * \snippet snippets/core_mat_checkVector.cpp example-3d
     */
    public native int checkVector(int elemChannels, int depth/*=-1*/, @Cast("bool") boolean requireContinuous/*=true*/);
    public native int checkVector(int elemChannels);

    /** \brief Returns a pointer to the specified matrix row.
    <p>
    The methods return {@code uchar*} or typed pointer to the specified matrix row. See the sample in
    Mat::isContinuous to know how to use these methods.
    @param i0 A 0-based row index.
     */
    public native @Cast("uchar*") BytePointer ptr(int i0/*=0*/);
    public native @Cast("uchar*") BytePointer ptr();
    /** \overload */

    /** \overload
    @param row Index along the dimension 0
    @param col Index along the dimension 1
    */
    public native @Cast("uchar*") BytePointer ptr(int row, int col);
    /** \overload
    @param row Index along the dimension 0
    @param col Index along the dimension 1
    */

    /** \overload */
    public native @Cast("uchar*") BytePointer ptr(int i0, int i1, int i2);
    /** \overload */

    /** \overload */
    public native @Cast("uchar*") BytePointer ptr(@Const IntPointer idx);
    public native @Cast("uchar*") ByteBuffer ptr(@Const IntBuffer idx);
    public native @Cast("uchar*") byte[] ptr(@Const int[] idx);
    /** \overload */
    /** \overload */
    /** \overload */

    /** \overload */
    /** \overload */
    /** \overload
    @param row Index along the dimension 0
    @param col Index along the dimension 1
    */
    /** \overload
    @param row Index along the dimension 0
    @param col Index along the dimension 1
    */
    /** \overload */
    /** \overload */
    /** \overload */
    /** \overload */
    /** \overload */
    /** \overload */

    /** \brief Returns a reference to the specified array element.
    <p>
    The template methods return a reference to the specified array element. For the sake of higher
    performance, the index range checks are only performed in the Debug configuration.
    <p>
    Note that the variants with a single index (i) can be used to access elements of single-row or
    single-column 2-dimensional arrays. That is, if, for example, A is a 1 x N floating-point matrix and
    B is an M x 1 integer matrix, you can simply write {@code A.at<float>(k+4)} and {@code B.at<int>(2*i+1)}
    instead of {@code A.at<float>(0,k+4)} and {@code B.at<int>(2*i+1,0)}, respectively.
    <p>
    The example below initializes a Hilbert matrix:
    <pre>{@code
        Mat H(100, 100, CV_64F);
        for(int i = 0; i < H.rows; i++)
            for(int j = 0; j < H.cols; j++)
                H.at<double>(i,j)=1./(i+j+1);
    }</pre>
    <p>
    Keep in mind that the size identifier used in the at operator cannot be chosen at random. It depends
    on the image from which you are trying to retrieve the data. The table below gives a better insight in this:
     - If matrix is of type {@code CV_8U} then use {@code Mat.at<uchar>(y,x)}.
     - If matrix is of type {@code CV_8S} then use {@code Mat.at<schar>(y,x)}.
     - If matrix is of type {@code CV_16U} then use {@code Mat.at<ushort>(y,x)}.
     - If matrix is of type {@code CV_16S} then use {@code Mat.at<short>(y,x)}.
     - If matrix is of type {@code CV_32S}  then use {@code Mat.at<int>(y,x)}.
     - If matrix is of type {@code CV_32F}  then use {@code Mat.at<float>(y,x)}.
     - If matrix is of type {@code CV_64F} then use {@code Mat.at<double>(y,x)}.
    <p>
    @param i0 Index along the dimension 0
     */
    /** \overload
    @param i0 Index along the dimension 0
    */
    /** \overload
    @param row Index along the dimension 0
    @param col Index along the dimension 1
    */
    /** \overload
    @param row Index along the dimension 0
    @param col Index along the dimension 1
    */

    /** \overload
    @param i0 Index along the dimension 0
    @param i1 Index along the dimension 1
    @param i2 Index along the dimension 2
    */
    /** \overload
    @param i0 Index along the dimension 0
    @param i1 Index along the dimension 1
    @param i2 Index along the dimension 2
    */

    /** \overload
    @param idx Array of Mat::dims indices.
    */
    /** \overload
    @param idx Array of Mat::dims indices.
    */

    /** \overload */
    /** \overload */

    /** \overload
    special versions for 2D arrays (especially convenient for referencing image pixels)
    @param pt Element position specified as Point(j,i) .
    */
    /** \overload
    special versions for 2D arrays (especially convenient for referencing image pixels)
    @param pt Element position specified as Point(j,i) .
    */

    /** \brief Returns the matrix iterator and sets it to the first matrix element.
    <p>
    The methods return the matrix read-only or read-write iterators. The use of matrix iterators is very
    similar to the use of bi-directional STL iterators. In the example below, the alpha blending
    function is rewritten using the matrix iterators:
    <pre>{@code
        template<typename T>
        void alphaBlendRGBA(const Mat& src1, const Mat& src2, Mat& dst)
        {
            typedef Vec<T, 4> VT;

            const float alpha_scale = (float)std::numeric_limits<T>::max(),
                        inv_scale = 1.f/alpha_scale;

            CV_Assert( src1.type() == src2.type() &&
                       src1.type() == traits::Type<VT>::value &&
                       src1.size() == src2.size());
            Size size = src1.size();
            dst.create(size, src1.type());

            MatConstIterator_<VT> it1 = src1.begin<VT>(), it1_end = src1.end<VT>();
            MatConstIterator_<VT> it2 = src2.begin<VT>();
            MatIterator_<VT> dst_it = dst.begin<VT>();

            for( ; it1 != it1_end; ++it1, ++it2, ++dst_it )
            {
                VT pix1 = *it1, pix2 = *it2;
                float alpha = pix1[3]*inv_scale, beta = pix2[3]*inv_scale;
                *dst_it = VT(saturate_cast<T>(pix1[0]*alpha + pix2[0]*beta),
                             saturate_cast<T>(pix1[1]*alpha + pix2[1]*beta),
                             saturate_cast<T>(pix1[2]*alpha + pix2[2]*beta),
                             saturate_cast<T>((1 - (1-alpha)*(1-beta))*alpha_scale));
            }
        }
    }</pre>
     */

    /** \brief Same as begin() but for inverse traversal
     */

    /** \brief Returns the matrix iterator and sets it to the after-last matrix element.
    <p>
    The methods return the matrix read-only or read-write iterators, set to the point following the last
    matrix element.
     */

    /** \brief Same as end() but for inverse traversal
     */


    /** \brief Runs the given functor over all matrix elements in parallel.
    <p>
    The operation passed as argument has to be a function pointer, a function object or a lambda(C++11).
    <p>
    Example 1. All of the operations below put 0xFF the first channel of all matrix elements:
    <pre>{@code
        Mat image(1920, 1080, CV_8UC3);
        typedef cv::Point3_<uint8_t> Pixel;

        // first. raw pointer access.
        for (int r = 0; r < image.rows; ++r) {
            Pixel* ptr = image.ptr<Pixel>(r, 0);
            const Pixel* ptr_end = ptr + image.cols;
            for (; ptr != ptr_end; ++ptr) {
                ptr->x = 255;
            }
        }

        // Using MatIterator. (Simple but there are a Iterator's overhead)
        for (Pixel &p : cv::Mat_<Pixel>(image)) {
            p.x = 255;
        }

        // Parallel execution with function object.
        struct Operator {
            void operator ()(Pixel &pixel, const int * position) {
                pixel.x = 255;
            }
        };
        image.forEach<Pixel>(Operator());

        // Parallel execution using C++11 lambda.
        image.forEach<Pixel>([](Pixel &p, const int * position) -> void {
            p.x = 255;
        });
    }</pre>
    Example 2. Using the pixel's position:
    <pre>{@code
        // Creating 3D matrix (255 x 255 x 255) typed uint8_t
        // and initialize all elements by the value which equals elements position.
        // i.e. pixels (x,y,z) = (1,2,3) is (b,g,r) = (1,2,3).

        int sizes[] = { 255, 255, 255 };
        typedef cv::Point3_<uint8_t> Pixel;

        Mat_<Pixel> image = Mat::zeros(3, sizes, CV_8UC3);

        image.forEach<Pixel>([](Pixel& pixel, const int position[]) -> void {
            pixel.x = position[0];
            pixel.y = position[1];
            pixel.z = position[2];
        });
    }</pre>
     */
    /** \overload */

    /** enum cv::Mat:: */
    public static final int MAGIC_VAL  = 0x42FF0000, AUTO_STEP = 0, CONTINUOUS_FLAG = CV_MAT_CONT_FLAG, SUBMATRIX_FLAG = CV_SUBMAT_FLAG;
    /** enum cv::Mat:: */
    public static final int MAGIC_MASK = 0xFFFF0000, TYPE_MASK = 0x00000FFF, DEPTH_MASK = 7;

    /** includes several bit-fields:
         - the magic signature
         - continuity flag
         - depth
         - number of channels
     */
    public native int flags(); public native Mat flags(int setter);
    /** the matrix dimensionality, >= 2 */
    public native int dims(); public native Mat dims(int setter);
    /** the number of rows and columns or (-1, -1) when the matrix has more than 2 dimensions */
    public native int rows(); public native Mat rows(int setter);
    public native int cols(); public native Mat cols(int setter);
    /** pointer to the data */
    public native @Cast("uchar*") BytePointer data(); public native Mat data(BytePointer setter);

    /** helper fields used in locateROI and adjustROI */
    public native @Cast("const uchar*") BytePointer datastart(); public native Mat datastart(BytePointer setter);
    public native @Cast("const uchar*") BytePointer dataend(); public native Mat dataend(BytePointer setter);
    public native @Cast("const uchar*") BytePointer datalimit(); public native Mat datalimit(BytePointer setter);

    /** custom allocator */
    public native MatAllocator allocator(); public native Mat allocator(MatAllocator setter);
    /** and the standard allocator */
    public static native MatAllocator getStdAllocator();
    public static native MatAllocator getDefaultAllocator();
    public static native void setDefaultAllocator(MatAllocator allocator);

    /** internal use method: updates the continuity flag */
    public native void updateContinuityFlag();

    /** interaction with UMat */
    public native UMatData u(); public native Mat u(UMatData setter);

    public native @ByVal Size size();
    @MemberGetter public native int size(int i);
    @MemberGetter public native long step();
    @MemberGetter public native long step(int i);
}
