/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static Map<String, Object> singletonMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(key, value);
        return map;
    }

    public static Map<String, Object> map(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new FlowableIllegalArgumentException("The input should always be even since we expect a list of key-value pairs!");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            map.put((String)objects[i], objects[i + 1]);
        }
        return map;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static <T> List<List<T>> partition(Collection<T> values, int partitionSize) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> valuesList = values instanceof List ? (ArrayList<T>)values : new ArrayList<T>(values);
        int valuesSize = values.size();
        if (valuesSize <= partitionSize) {
            return Collections.singletonList(valuesList);
        }
        ArrayList<List<T>> safeValuesList = new ArrayList<List<T>>();
        CollectionUtil.consumePartitions(values, partitionSize, safeValuesList::add);
        return safeValuesList;
    }

    public static <T> void consumePartitions(Collection<T> values, int partitionSize, Consumer<List<T>> partitionConsumer) {
        int valuesSize = values.size();
        ArrayList<T> valuesList = values instanceof List ? (ArrayList<T>)values : new ArrayList<T>(values);
        if (valuesSize <= partitionSize) {
            partitionConsumer.accept(valuesList);
        } else {
            for (int startIndex = 0; startIndex < valuesSize; startIndex += partitionSize) {
                int endIndex = startIndex + partitionSize;
                if (endIndex > valuesSize) {
                    endIndex = valuesSize;
                }
                List subList = valuesList.subList(startIndex, endIndex);
                partitionConsumer.accept(subList);
            }
        }
    }
}

