/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTimerJobCmd
implements Command<Object>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteTimerJobCmd.class);
    private static final long serialVersionUID = 1L;
    protected String timerJobId;
    protected JobServiceConfiguration jobServiceConfiguration;

    public DeleteTimerJobCmd(String timerJobId, JobServiceConfiguration jobServiceConfiguration) {
        this.timerJobId = timerJobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Object execute(CommandContext commandContext) {
        TimerJobEntity jobToDelete = this.getJobToDelete(commandContext);
        this.sendCancelEvent(commandContext, jobToDelete);
        this.jobServiceConfiguration.getTimerJobEntityManager().delete(jobToDelete);
        return null;
    }

    protected void sendCancelEvent(CommandContext commandContext, TimerJobEntity jobToDelete) {
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, jobToDelete), this.jobServiceConfiguration.getEngineName());
        }
    }

    protected TimerJobEntity getJobToDelete(CommandContext commandContext) {
        TimerJobEntity job;
        if (this.timerJobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting job {}", (Object)this.timerJobId);
        }
        if ((job = (TimerJobEntity)this.jobServiceConfiguration.getTimerJobEntityManager().findById(this.timerJobId)) == null) {
            throw new FlowableObjectNotFoundException("No timer job found with id '" + this.timerJobId + "'", Job.class);
        }
        if (job.getLockOwner() != null) {
            throw new FlowableException("Cannot delete " + job + " when the job is being executed. Try again later.");
        }
        return job;
    }
}

