/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.Markdown;
import org.gitlab4j.api.models.MarkdownRequest;

public class MarkdownApi
extends AbstractApi {
    public MarkdownApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public Markdown getMarkdown(String text) throws GitLabApiException {
        if (!this.isApiVersion(GitLabApi.ApiVersion.V4)) {
            throw new GitLabApiException("Api version must be v4");
        }
        return this.getMarkdown(new MarkdownRequest(text, true));
    }

    public Markdown getMarkdown(MarkdownRequest markdownRequest) throws GitLabApiException {
        if (!this.isApiVersion(GitLabApi.ApiVersion.V4)) {
            throw new GitLabApiException("Api version must be v4");
        }
        Response response = this.post(Response.Status.OK, markdownRequest, "markdown");
        return (Markdown)response.readEntity(Markdown.class);
    }
}

