/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Topic;
import org.gitlab4j.api.models.TopicParams;

public class TopicsApi
extends AbstractApi {
    public TopicsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Topic> getTopics() throws GitLabApiException {
        return this.getTopics(this.getDefaultPerPage()).all();
    }

    public List<Topic> getTopics(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "topics");
        return (List)response.readEntity((GenericType)new GenericType<List<Topic>>(){});
    }

    public Pager<Topic> getTopics(int itemsPerPage) throws GitLabApiException {
        return new Pager<Topic>(this, Topic.class, itemsPerPage, null, "topics");
    }

    public Stream<Topic> getTopicsStream() throws GitLabApiException {
        return this.getTopics(this.getDefaultPerPage()).stream();
    }

    public Topic getTopic(Integer id) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "topics", id);
        return (Topic)response.readEntity(Topic.class);
    }

    public Optional<Topic> getOptionalTopic(Integer id) {
        try {
            return Optional.ofNullable(this.getTopic(id));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Topic createTopic(TopicParams params) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, params.getForm(true), "topics");
        return (Topic)response.readEntity(Topic.class);
    }

    public Topic updateTopic(Integer id, TopicParams params) throws GitLabApiException {
        Response response = this.putWithFormData(Response.Status.OK, params.getForm(false), "topics", id);
        return (Topic)response.readEntity(Topic.class);
    }

    public Topic updateTopicAvatar(Integer id, File avatarFile) throws GitLabApiException {
        Response response = this.putUpload(Response.Status.OK, "avatar", avatarFile, "topics", id);
        return (Topic)response.readEntity(Topic.class);
    }

    public Topic deleteTopicAvatar(Integer id) throws GitLabApiException {
        Response response = this.putUpload(Response.Status.OK, "avatar", null, "topics", id);
        return (Topic)response.readEntity(Topic.class);
    }

    public void deleteTopic(Integer id) throws GitLabApiException {
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            throw new GitLabApiException("Topics need api v4+");
        }
        this.delete(Response.Status.NO_CONTENT, null, "topics", id);
    }

    public Topic mergeTopics(Integer sourceTopicId, Integer targetTopicId) throws GitLabApiException {
        Response response = this.post(Response.Status.OK, (Form)new GitLabApiForm().withParam("source_topic_id", sourceTopicId).withParam("target_topic_id", targetTopicId), new Object[]{"topics/merge"});
        return (Topic)response.readEntity(Topic.class);
    }
}

